/*
   This file is provided under the LGPL license ver 2.1.
   Written by K.Tanaka
   http://www.ze.em-net.ne.jp/~kenken/index.html
*/

#include <xc.h>
#include "api.h"
#include "editor.h"
#include "interface/keyinput.h"
#include "compiler.h"
#include "main.h"

struct _TBUF{
//Nt̃eLXgobt@
	struct _TBUF *prev;//Oւ̃NBNULL̏ꍇ擪܂͋
	struct _TBUF *next;//ւ̃NBNULL̏ꍇŌ
	unsigned short n;//݂̎gpoCg
	unsigned char Buf[TBUFSIZE];//obt@
} ;
typedef struct _TBUF _tbuf;

//_tbuf TextBuffer[TBUFMAXLINE]; //eLXgobt@
_tbuf *TextBuffer; //͔̂zRAM[]̒Ɋmۂ

_tbuf *TBufstart; //eLXgobt@̐擪ʒu
_tbuf *cursorbp; //݂̃J[\ʒũeLXgobt@
unsigned short cursorix; //݂̃J[\ʒũeLXgobt@擪̈ʒu
_tbuf *disptopbp; //ݕ\ʍ̃eLXgobt@
unsigned short disptopix; //ݕ\ʍ̃eLXgobt@擪̈ʒu
int num; //݃obt@Ɋi[Ă镶
int cx,cy; //J[\W
int cx2; //㉺ړ̉J[\XW
_tbuf *cursorbp1; //͈͑ĨJ[\X^[gʒũeLXgobt@A͈͑I[hłȂꍇNULL
unsigned short cursorix1; //͈͑ĨJ[\X^[gʒũeLXgobt@擪̈ʒu
int cx1,cy1; //͈͑ĨJ[\X^[gW
int line_no; //݂̃J[\ʒu̍s
int line_no1; //͈͑ĨJ[\X^[gʒu̍s

// J[\֘Aʒüꎞp
_tbuf *cursorbp_t;
unsigned short cursorix_t;
_tbuf *disptopbp_t;
unsigned short disptopix_t;
int cx_t,cy_t,line_no_t;

//unsigned char clipboard[WIDTH_XMAX*EDITWIDTHY]; //Nbv{[hAőTCY͕ҏWʗ̈Ɠ
unsigned char *clipboard; //͔̂zRAM[]̒Ɋmۂ

int clipsize; //݃Nbv{[hɊi[Ă镶
int edited; //ۑɕύXꂽ\tO

//zRAM[]ɃImۂ邽߂̃|C^
char *editormallocp;

//unsigned char filebuf[FILEBUFSIZE]; //t@CANZXpobt@
unsigned char *filebuf; //͔̂zRAM[]̒Ɋmۂ

//unsigned char cwdpath[PATHNAMEMAX]; //݂̃fBNg̃pX
unsigned char *cwdpath; //͔̂zRAM[]̒Ɋmۂ

unsigned char currentfile[13],tempfile[13]; //ҏW̃t@CAꎞt@C

//unsigned char filenames[MAXFILENUM][13]; //[h̃t@Cꗗobt@
unsigned char (*filenames)[13]; //͔̂zRAM[]̒Ɋmۂ

//unsigned char undobuf[UNDOBUFSIZE]; //AhDpobt@
unsigned char *undobuf; //͔̂zRAM[]̒Ɋmۂ
unsigned char *undobuf_top; //AhDpobt@̐擪w|C^
int undobuf_used; //AhDpobt@gp

const unsigned char Message1[]="Hit Any Key\n";
const unsigned char Message2[]="File System Error\n";
const unsigned char Message3[]="Retry:[Enter] / Quit:[ESC]\n";
const unsigned char ROOTDIR[]="\\";

unsigned char * editormalloc(int size){
//zRAM[]ɃTCYsizë̗mۂA擪AhXԂ
//mۂłȂꍇ́AG[\~
	unsigned char *p;
	if(editormallocp+size>RAM+RAMSIZE){
		printstr("Cannot allocate memory");
		while(1) asm("wait");
	}
	p=editormallocp;
	editormallocp+=size;
	return p;
}

void wait60thsec(unsigned short n){
#ifndef __DEBUG
	// 60nbEFCgirfIʂ̍ŉsMo͏I܂ő҂j
	n+=drawcount;
	while(drawcount!=n) asm(WAIT);
#else
	// DEBUG[hł́A҂Ԗ
	drawcount+=n;
#endif
}

unsigned int bpixtopos(_tbuf *bp,unsigned int ix){
// eLXgobt@̈ʒueLXgŜ̐擪牽ڂԂ
// bp:eLXgobt@|C^
// ix:bp->Buf̐擪̕
	unsigned int pos;
	_tbuf *sbp;
	pos=0;
	sbp=TBufstart;
	while(sbp!=bp){
		pos+=sbp->n;
		sbp=sbp->next;
		if(sbp==NULL) return 0; //G[
	}
	return pos+ix;
}
_tbuf * postobpix(int pos,unsigned short *pix){
// eLXgŜ̐擪posڂ̃eLXgobt@̈ʒuԂ
// ߂l@eLXgobt@|C^
// *pixi߂ljF߂leLXgobt@̐擪̈ʒui|C^nj
	_tbuf *bp;
	bp=TBufstart;
	while(pos >= bp->n){
		if(bp->next==NULL) break; //S̍Ō̏ꍇ
		pos-=bp->n;
		bp=bp->next;
	}
	if(pos > bp->n){
		// I[o[G[̏ꍇ擪Ԃ
		*pix=0;
		return TBufstart;
	}
	*pix=pos;
	return bp;
}
_tbuf * linetobpix(int line,unsigned short *pix){
// eLXgŜ̐擪linesڂ̃eLXgobt@̈ʒuԂ
// ߂l@eLXgobt@|C^
// *pixi߂ljF߂leLXgobt@̐擪̈ʒui|C^nj
	_tbuf *bp,*bp2;
	int ix,ix2;
	bp=TBufstart;
	bp2=TBufstart;
	ix=0;
	ix2=0;
	while(line>1){
		while(1){
			if(ix>=bp->n){
				if(bp->next==NULL) break;
				bp=bp->next;
				ix=0;
				continue;
			}
			if(bp->Buf[ix++] == '\n'){
				bp2=bp;
				ix2=ix;
				break;
			}
		}
		line--;
	}
	*pix=ix2;
	return bp2;
}

_tbuf * newTBuf(_tbuf *prev){
// VeLXgobt@1s𐶐
// prev:}̍siprev̌ɒǉj
// ߂l@obt@ւ̃|C^AłȂꍇNULL
	_tbuf *bp,*next;

	//obt@̐擪󂫂T[`
	bp=TextBuffer;
	while(1){
		if(bp->prev==NULL && bp!=TBufstart) break;
		bp++;
		if(bp>=TextBuffer+TBUFMAXLINE) return NULL;//Ō܂ŋ󂫂Ȃ
	}
	next=prev->next;
	//s}
	bp->prev=prev;
	bp->next=next;
	prev->next=bp;
	if(next!=NULL) next->prev=bp;
	bp->n=0;
	return bp;
}

_tbuf * deleteTBuf(_tbuf *bp){
// eLXgobt@̍폜
// bp:폜s̃|C^
// ߂l@폜O̎̃obt@ւ̃|C^AȂꍇNULL
	unsigned short a,b;
	_tbuf *prev,*next;
	prev=bp->prev;
	next=bp->next;
	if(prev==NULL){
		//擪s̏ꍇ
		if(next==NULL) return next; //Ō1s̏ꍇ͍폜Ȃ
		TBufstart=next; //̍s擪sݒ
	}
	else prev->next=next; //OɃNiŏIsȂNULLRs[j
	if(next!=NULL) next->prev=prev; //ΎOɃN
	bp->prev=NULL; //󂫃tOݒ
	return next;
}

// AhDobt@
/*
UNDOBUFSIZEoCg̊obt@BeLXgobt@ɑ΂ύXƂɁA
ύXeAύXꏊobt@̐擪ɋL^A擪ʒui߂B
AhDsĂяoƁAobt@擪ǂݏoAeLXgobt@ɑ΂
ɖ߂ύXsB
obt@ςɂȂƁAŌi㏑jĂB

obt@dl
@JnʒuFeLXgobt@gbv牽oCgڂi2oCgBʁAʂ̏j
@JԂFȀꍇ̉񐔁i2oCgBʁAʂ̏j
@obt@̑O납폜ł悤A擪ƍŌɖ߂BA
@̖߃R[h10ȏ̏ꍇ͍폜ꂽ̂̂ӖB
1}
@UNDO_INSERT,Jnʒu,UNDO_INSERT
1㏑
@UNDO_OVERWRITE,Jnʒu, [,0?9̏ꍇ0t]
1폜iDeletej
@UNDO_DELETE,Jnʒu, [,0?9̏ꍇ0t]
1폜iBackSpacej
@UNDO_BACKSPACE,Jnʒu, [,0?9̏ꍇ0t]
A}iCtrl+Vœ\tj
@UNDO_CONTINS,Jnʒu,JԂ,UNDO_CONTINS
A폜ïIč폜j
@UNDO_CONTDEL,JԂ,,Jnʒu,JԂ,UNDO_CONTDEL
*/

void pushundomem(unsigned char c){
// AhDp̐擪1oCg𒙂߂
// 󂫂ȂȂꍇAŌ1ߕ𖳌
	unsigned char *p;
	int n;

	if(undobuf_used>=UNDOBUFSIZE){
	//󂫂ȂꍇAŌ̃ubÑoCgobt@pςݗʂ猸炷
		p=undobuf_top-undobuf_used; //Ō
		if(p<undobuf) p+=UNDOBUFSIZE;
		switch(*p){
			case UNDO_INSERT: //1}
				undobuf_used-=4;
				break;
			case UNDO_OVERWRITE: //1㏑
			case UNDO_DELETE: //1폜
			case UNDO_BACKSPACE: //1폜iBSj
				undobuf_used-=4;
				p+=3;
				if(p>=undobuf+UNDOBUFSIZE) p-=UNDOBUFSIZE;
				if(*p<10) undobuf_used--; //R[h0?9̏ꍇ0tĂ
				break;
			case UNDO_CONTINS: //A}
				undobuf_used-=6;
				break;
			case UNDO_CONTDEL: //A폜
				//JԂ̓ǂݏo
				p++;
				if(p>=undobuf+UNDOBUFSIZE) p-=UNDOBUFSIZE;
				n=*p++;
				if(p>=undobuf+UNDOBUFSIZE) p-=UNDOBUFSIZE;
				n+=*p<<8;
				undobuf_used-=n+8;
				break;
		}
	}
	//AhDobt@擪1oCg}A擪ʒu1i߂
	*undobuf_top++=c;
	if(undobuf_top>=undobuf+UNDOBUFSIZE) undobuf_top-=UNDOBUFSIZE;
	undobuf_used++;
}
void pushundomem2(unsigned short w){
// AhDobt@2oCg߂AʁAʂ̏
	pushundomem((unsigned char)w);
	pushundomem(w>>8);
}
unsigned char popundomem(){
// AhDobt@1oCgǂݏoA擪1߂
// ߂lFǂݏoR[h
	undobuf_top--;
	if(undobuf_top<undobuf) undobuf_top+=UNDOBUFSIZE;
	undobuf_used--;
	return *undobuf_top;
}
unsigned short popundomem2(){
// AhDobt@2oCgǂݏo
// ߂lFǂݏo2oCgR[h
	unsigned short w;
	w=popundomem()<<8;
	w+=popundomem();
	return w;
}
void setundobuf(int com,_tbuf *bp,unsigned short ix,unsigned char c,unsigned short n){
//AhDobt@Ƀf[^Zbg
//com:R}h@1:1폜A2:1㏑A3:1}A4:A폜A5:A}Jn
//bp,ix:obt@̎sꏊiJ[\ʒuj
//c:i㏑A}̏ꍇ̂ݎgpj
//n:AiȀꍇ̂ݎgpj
	unsigned short pos;

	pos=bpixtopos(bp,ix); //eLXgobt@擪牽oCgڂ߂
	switch(com){
		case UNDO_INSERT: //1}
			pushundomem(com);
			pushundomem2(pos);
			pushundomem(com);
			break;
		case UNDO_OVERWRITE: //1㏑
		case UNDO_DELETE: //1폜iDeletej
		case UNDO_BACKSPACE: //1폜iBackSpacej
			pushundomem(com);
			pushundomem2(pos);
			pushundomem(c);
			if(c<10) pushundomem(0); //10̃R[h̏ꍇ0t
			break;
		case UNDO_CONTINS: //A}
			pushundomem(com);
			pushundomem2(pos);
			pushundomem2(n);
			pushundomem(com);
			break;
		case UNDO_CONTDEL: //A폜
			pushundomem(com);
			pushundomem2(n);
			break;
	}
}

int insertchar(_tbuf *bp,unsigned int ix,unsigned char c,int undo){
//eLXgobt@bp̐擪ixoCg̈ʒuc}
//undo 0:ʏiAhDobt@Ɋi[jA1:A}A2:AhD
//߂l@F0As܂͗eʃI[o[F-1A󂫂͂Ȃ̂ɎsF1
	unsigned char *p;

	if(ix > bp->n) return -1; //sw
	if(num >= TBUFMAXSIZE) return -1; //obt@eʃI[o[
	if(bp->n < TBUFSIZE){
		//C1oCg}\//
		for(p=bp->Buf + bp->n ; p > bp->Buf+ix ; p--) *p=*(p-1);
		*p=c;
		if(!undo) setundobuf(UNDO_INSERT,bp,ix,0,0); //AhDobt@ݒ
		bp->n++;
		num++; //obt@gp
//		if(bp->n >= TBUFSIZE && bp->next==NULL) newTBuf(bp); //obt@ςɂȂVɃobt@
		return 0;
	}
	//Cӂꍇ
	if(bp->next==NULL || bp->next->n >=TBUFSIZE){
		// ŏIs܂͎̃Cobt@ςs}
		if(newTBuf(bp)==NULL){
			// Cobt@}s
			return 1;
		}
	}
	if(ix==TBUFSIZE){
		insertchar(bp->next,0,c,undo);
		return 0;
	}
	p=bp->Buf + TBUFSIZE-1;
	insertchar(bp->next,0,*p,1); //̍s̐擪1}iK󂫂j
	for( ; p > bp->Buf+ix ; p--) *p=*(p-1);
	*p=c;
	if(!undo) setundobuf(UNDO_INSERT,bp,ix,0,0); //AhDobt@ݒ
	return 0;
}

int overwritechar(_tbuf *bp,unsigned int ix,unsigned char c,int undo){
//eLXgobt@bp̐擪ixoCg̈ʒucŏ㏑
//undo 0:ʏiAhDobt@Ɋi[jA1:AA2:AhD
//߂l@F0As܂͗eʃI[o[F-1A󂫂͂Ȃ̂ɎsF1

	//݂̃obt@ʒu̕I[܂͉s̏ꍇA}[h
	if(ix > bp->n) return -1; //sw
	while(ix >= bp->n){
		if(bp->next==NULL){
			//eLXgS̍Ō̏ꍇ͑}
			return insertchar(bp,ix,c,undo);
		}
		bp=bp->next;
		ix=0;
	}
	if(bp->Buf[ix]=='\n') return insertchar(bp,ix,c,undo);
	if(!undo) setundobuf(UNDO_OVERWRITE,bp,ix,bp->Buf[ix],0); //AhDobt@ݒ
	bp->Buf[ix]=c;
	return 0;
}

void deletechar(_tbuf *bp,unsigned int ix,int undo){
//eLXgobt@bp̐擪ixoCg̈ʒu1oCg폜
//undo -1:ʏBackSpaceiAhDobt@Ɋi[j
//      0:ʏDELETEiAhDobt@Ɋi[jA1:AA2:AhD
	unsigned char *p;

	if(ix > bp->n) return; //sw
	if(ix !=bp->n){
		//obt@̍Ō̕łȂꍇ

		//AhDobt@ݒ
		if(undo==1) pushundomem(bp->Buf[ix]); //A폜
		else if(undo==-1) setundobuf(UNDO_BACKSPACE,bp,ix,bp->Buf[ix],0); //1폜(backspace)
		else if(undo==0) setundobuf(UNDO_DELETE,bp,ix,bp->Buf[ix],0); //1폜

		for(p=bp->Buf+ix ; p< bp->Buf + bp->n-1 ; p++) *p=*(p+1);
		bp->n--;
		num--; //obt@gp
		return;
	}
	//sobt@݂̌̍Ō̏ꍇi폜镶Ȃꍇj
	if(bp->next==NULL) return; //Ŝ̍Ō̏ꍇAȂ
	deletechar(bp->next,0,undo); //̍s̐擪폜
}
int gabagecollect1(void){
//fЉꂽeLXgobt@̌Ԃ𖄂߂Kx[WRNV
//J[\̑Oƌ낻ꂼTčŏ1oCĝݎ{
//߂l 1oCgłړꍇF1AȂꍇF0

	_tbuf *bp;
	int f=0;
	unsigned char *p,*p2;

	//J[\obt@̐擪ɂꍇAÕobt@̍ŌɕύX
	//iOɋ󂫂ȂꍇƐ擪obt@̏ꍇj
	while(cursorix==0 && cursorbp->prev!=NULL && cursorbp->prev->n <TBUFSIZE){
		cursorbp=cursorbp->prev;
		cursorix=cursorbp->n;
	}
	//ʍʒuobt@̐擪ɂꍇAÕobt@̍ŌɕύX
	//i擪obt@̏ꍇj
	while(disptopix==0 && disptopbp->prev!=NULL){
		disptopbp=disptopbp->prev;
		disptopix=disptopbp->n;
	}
	//J[\̂obt@ȊŐobt@Sč폜
	bp=TBufstart;
	while(bp!=NULL){
		if(bp->n == 0 && bp!=cursorbp){
			if(bp==disptopbp) disptopbp=bp->next; //ʍʒuobt@擪̏ꍇAɂ炷
			bp=deleteTBuf(bp); //󂫃obt@폜
		}
		else bp=bp->next;
	}

	//J[\ʒuO̖܂ĂȂobt@擪T[`
	bp=TBufstart;
	while(bp->n >= TBUFSIZE){
		if(bp==cursorbp) break;
		bp=bp->next;
	}
	if(bp!=cursorbp){
		//ŏɌ󂫏ꏊɎ̃obt@1oCgړ
		bp->Buf[bp->n++] = bp->next->Buf[0];
		bp=bp->next;
		p=bp->Buf;
		p2=p+bp->n-1;
		for( ; p<p2 ; p++) *p=*(p+1);
		bp->n--;
		f=1;
		if(bp == disptopbp) disptopix--;
		if(bp == cursorbp) cursorix--;
//		else if(bp->n == 0) deleteTBuf(bp);
	}
	if(cursorbp->next ==NULL) return f; //J[\ʒuŏIobt@ȂI
	//J[\ʒu̎̃obt@疄܂ĂȂobt@T[`
	bp=cursorbp;
	do{
		bp=bp->next;
		if(bp->next ==NULL) return f; //ŏIobt@ɓBȂI
	} while(bp->n >=TBUFSIZE);

	//ŏɌ󂫏ꏊɎ̃obt@1oCgړ
	bp->Buf[bp->n++] = bp->next->Buf[0];
	bp=bp->next;
	p=bp->Buf;
	p2=p+bp->n-1;
	for( ; p<p2 ; p++) *p=*(p+1);
	bp->n--;
	f=1;
	if(bp->n == 0) deleteTBuf(bp);
	return f;
}
void gabagecollect2(void){
// ωȂȂ܂1oCg̃Kx[WRNVĂяo
	while(gabagecollect1()) ;
}
void inittextbuf(void){
// eLXgobt@̏
	_tbuf *bp;
	for(bp=TextBuffer;bp<TextBuffer+TBUFMAXLINE;bp++) bp->prev=NULL; //gpobt@
	TBufstart=TextBuffer; //N̐擪ݒ
	TBufstart->next=NULL;
	TBufstart->n=0;
	num=0; //obt@gp
	edited=0; //ҏWς݃tONA
	undobuf_top=undobuf;
	undobuf_used=0;
}
void redraw(){
//ʂ̍ĕ`
	unsigned char *vp;
	_tbuf *bp,*bp1,*bp2;
	int ix,ix1,ix2;
	int x,y;
	unsigned char ch,cl;

	vp=TVRAM;
	bp=disptopbp;
	ix=disptopix;
	cl=COLOR_NORMALTEXT;
	if(cursorbp1==NULL){
		//͈͑I[hłȂꍇ
		bp1=NULL;
		bp2=NULL;
	}
	else{
		//͈͑I[h̏ꍇAJnʒuƏȊO㔻f
		//bp1,ix1JnʒuAbp2,ix2Iʒuɐݒ
		if(cy<cy1 || (cy==cy1 && cx<cx1)){
			bp1=cursorbp;
			ix1=cursorix;
			bp2=cursorbp1;
			ix2=cursorix1;
		}
		else{
			bp1=cursorbp1;
			ix1=cursorix1;
			bp2=cursorbp;
			ix2=cursorix;
		}
	}
	for(y=0;y<EDITWIDTHY;y++){
		if(bp==NULL) break;
		for(x=0;x<twidth;x++){
			//ʒu܂ŃT[`
			while(ix>=bp->n){
				if(bp==bp1 && ix==ix1){
					if(textmode!=TMODE_MONOTEXT){
						cl=COLOR_AREASELECTTEXT;
					}
					else{
						cl=COLOR_INV;
					}
				}
				if(bp==bp2 && ix==ix2) cl=COLOR_NORMALTEXT;
				bp=bp->next;
				ix=0;
				if(bp==NULL) break;
			}
			if(bp==NULL) break; //obt@ŏI
			if(bp==bp1 && ix==ix1){
					if(textmode!=TMODE_MONOTEXT){
						cl=COLOR_AREASELECTTEXT;
					}
					else{
						cl=COLOR_INV;
					}
			}
			if(bp==bp2 && ix==ix2) cl=COLOR_NORMALTEXT;
			ch=bp->Buf[ix++];
			if(ch=='\n') break;
			*(vp+attroffset)=cl;
			*vp++=ch;
		}
		//sуobt@ŏIȍ~̉E\
		for(;x<twidth;x++){
			*(vp+attroffset)=0;
			*vp++=0;
		}
	}
	//obt@ŏIȍ~̉\
	for(;y<EDITWIDTHY;y++){
		for(x=0;x<twidth;x++){
			*(vp+attroffset)=0;
			*vp++=0;
		}
	}
}

void cursor_left(void){
//J[\1OɈړ
//óFLϐړ̒lɕύX
//cursorbp,cursorix obt@̃J[\ʒu
//cx,cy ʏ̃J[\ʒu
//cx2 cxƓ
//disptopbp,disptopix ʍ̃obt@̈ʒu

	_tbuf *bp;
	int ix;
	int i;
	int x;

	//obt@̃J[\ʒu1OɈړ
	if(cursorix!=0) cursorix--;
	else while(1) {
		//1Õobt@̍ŌɈړAobt@͔΂
		if(cursorbp->prev==NULL) return; //eLXgS̐擪Ȃ̂ňړȂ
		cursorbp=cursorbp->prev;
		if(cursorbp->n >0){
			cursorix=cursorbp->n-1;//obt@Ō
			break;
		}
	}

	//J[\щʍʒu̍XV
	if(cx>0){
		//[łȂ΃J[\P1ɈړďI
		cx--;
		cx2=cx;
		return;
	}
	if(cy>0){
		//[[ł͂Ȃꍇ
		if(cursorbp->Buf[cursorix]!='\n'){
			// ړ悪sR[hłȂꍇAJ[\1̍s̉E[Ɉړ
			cx=twidth-1;
			cx2=cx;
			cy--;
			return;
		}
		//ʍʒuŌXWT[`
		bp=disptopbp;
		ix=disptopix;
		x=0;
		while(ix!=cursorix || bp!=cursorbp){
			if(bp->n==0){
				//obt@̏ꍇ
				bp=bp->next;
				ix=0;
				continue;
			}
			if(bp->Buf[ix++]=='\n' || x>=twidth-1) x=0;
			else x++;
			if(ix >= bp->n){
				bp=bp->next;
				ix=0;
			}
		}
		cx=x;
		cx2=cx;
		cy--;
		line_no--;
		return;
	}

	//[[̏ꍇ
	if(cursorbp->Buf[cursorix]!='\n'){
		// ړ悪sR[hłȂꍇAJ[\͉E[Ɉړ
		// ʍʒu͉ʉOɈړ
		cx=twidth-1;
		cx2=cx;
	}
	else{
		//ړ悪sR[h̏ꍇ
		//sis̎̕܂̓obt@擪jƌ݈ʒu̕
		//ʉŊ]肪J[\XW
		bp=cursorbp;
		ix=cursorix;
		i=0;
		while(1){
			if(ix==0){
				if(bp->prev==NULL) break;
				bp=bp->prev;
				ix=bp->n;
				continue;
			}
			ix--;
			if(bp->Buf[ix]=='\n') break;
			i++;
		}
		cx=i % twidth;
		cx2=cx;
		line_no--;
	}
	//ʍʒu݈͌ʒuXWƂ
	bp=cursorbp;
	ix=cursorix;
	x=cx;
	while(x>0){
		if(ix==0){
			bp=bp->prev;
			ix=bp->n;
			continue;
		}
		ix--;
		x--;
	}
	disptopbp=bp;
	disptopix=ix;
}
void cursor_right(void){
//J[\1Ɉړ
//óFLϐړ̒lɕύX
//cursorbp,cursorix obt@̃J[\ʒu
//cx,cy ʏ̃J[\ʒu
//cx2 cxƓ
//disptopbp,disptopix ʍ̃obt@̈ʒu

	_tbuf *bp;
	int ix;
	int i;
	int x;
	unsigned char c;

	if(cursorix >= cursorbp->n){
		//obt@Ō̏ꍇA̐擪Ɉړ
		bp=cursorbp;
		while(1) {
			//obt@͔΂
			if(bp->next==NULL) return; //eLXgS̍ŌȂ̂ňړȂ
			bp=bp->next;
			if(bp->n >0) break;
		}
		cursorbp=bp;
		cursorix=0;//obt@擪
	}
	c=cursorbp->Buf[cursorix++]; //obt@̃J[\ʒũR[hǂ1Ɉړ
	if(c!='\n' && cx<twidth-1){
		//J[\ʒusłE[łȂꍇP1EɈړďI
		cx++;
		cx2=cx;
		return;
	}
	cx=0; //J[\[Ɉړ
	cx2=cx;
	if(c=='\n') line_no++;
	if(cy<EDITWIDTHY-1){
		//[łȂ΃J[\sɈړďI
		cy++;
		return;
	}
	//[̏ꍇ
	//ʍʒuXV
	//sR[h܂͉ʉ܂ŃT[`
	bp=disptopbp;
	ix=disptopix;
	x=0;
	while(x<twidth){
		if(ix >= bp->n){
			bp=bp->next;
			ix=0;
			continue;
		}
		if(bp->Buf[ix++]=='\n') break;
		x++;
	}
	disptopbp=bp;
	disptopix=ix;
}
void cursor_up(void){
//J[\1Ɉړ
//óFLϐړ̒lɕύX
//cursorbp,cursorix obt@̃J[\ʒu
//cx,cy ʏ̃J[\ʒu
//cx2 ړOcxƓ
//disptopbp,disptopix ʍ̃obt@̈ʒu

	_tbuf *bp;
	int ix;
	int i;
	int x;
	unsigned char c;

	//ʕOɖ߂Ƃ낪obt@J[\̈ړ
	//rŉsR[hΕʂ̎iŌ
	bp=cursorbp;
	ix=cursorix;
	i=cx2-cx;
	while(i<twidth){
		if(ix==0){
			if(bp->prev==NULL) return; //obt@擪܂ŃT[`ړȂ
			bp=bp->prev;
			ix=bp->n;
			continue;
		}
		ix--;
		if(bp->Buf[ix]=='\n') break;
		i++;
	}
	cursorbp=bp;
	cursorix=ix;
	//ʕ̊ԂɉsR[hȂꍇ
	if(i==twidth){
		cx=cx2;
		//ʏ[łȂ΃J[\1ɈړďI
		if(cy>0){
			cy--;
			return;
		}
		//ʏ[̏ꍇAJ[\ʒuXW߂Ƃ낪ʍʒu
		x=cx;
		while(x>0){
			if(ix==0){
				bp=bp->prev;
				ix=bp->n;
				continue;
			}
			ix--;
			x--;
		}
		disptopbp=bp;
		disptopix=ix;
		return;
	}
	//sꍇ
	//sis̎̕܂̓obt@擪jƌ݈ʒu̕
	//ʉŊ]߂
	line_no--;
	i=0;
	while(1){
		if(ix==0){
			if(bp->prev==NULL) break;
			bp=bp->prev;
			ix=bp->n;
			continue;
		}
		ix--;
		if(bp->Buf[ix]=='\n') break;
		i++;
	}
	x=i % twidth; //subN̍ŏIs̉E[
	bp=cursorbp;
	ix=cursorix;
	//obt@̃J[\ʒu͉subN̍ŏIsE[J[\XW߂
	//ŏIsE[̂قꍇȀꏊobt@̃J[\ʒuƂ
	while(x>cx2){
		if(ix==0){
			bp=bp->prev;
			ix=bp->n;
			continue;
		}
		ix--;
		x--;
	}
	cursorbp=bp;
	cursorix=ix;
	cx=x; //cx2܂͉subNŏIsE[
	if(cy>0){
		//ʏ[łȂ΃J[\1ɈړďI
		cy--;
		return;
	}
	//ʏ[̏ꍇ
	//ʍʒu݈͌ʒuXWƂ
	while(x>0){
		if(ix==0){
			bp=bp->prev;
			ix=bp->n;
			continue;
		}
		ix--;
		x--;
	}
	disptopbp=bp;
	disptopix=ix;
}
void cursor_down(void){
//J[\1Ɉړ
//óFLϐړ̒lɕύX
//cursorbp,cursorix obt@̃J[\ʒu
//cx,cy ʏ̃J[\ʒu
//cx2 ړOcxƓ
//disptopbp,disptopix ʍ̃obt@̈ʒu

	_tbuf *bp;
	int ix;
	int x;
	unsigned char c;

	//s̐擪T[`
	//J[\ʒuʉE[܂ł̊ԂɉsR[hΎ̕擪
	bp=cursorbp;
	ix=cursorix;
	x=cx;
	while(x<twidth){
		if(ix>=bp->n){
			if(bp->next==NULL) return; //obt@Ō܂ŃT[`ړȂ
			bp=bp->next;
			ix=0;
			continue;
		}
		c=bp->Buf[ix];
		ix++;
		x++;
		if(c=='\n'){
			line_no++;
			break;
		}
	}
	//s擪cx2ɃT[`
	x=0;
	while(x<cx2){
		if(ix>=bp->n){
			if(bp->next==NULL) break; //obt@Ō̏ꍇɈړ
			bp=bp->next;
			ix=0;
			continue;
		}
		if(bp->Buf[ix]=='\n') break; //sR[h̏ꍇɈړ
		ix++;
		x++;
	}
	cursorbp=bp;
	cursorix=ix;
	cx=x;
	//ʉ[łȂ΃J[\1ɈړďI
	if(cy<EDITWIDTHY-1){
		cy++;
		return;
	}
	//[̏ꍇ
	//ʍʒuXV
	//sR[h܂͉ʉ܂ŃT[`
	bp=disptopbp;
	ix=disptopix;
	x=0;
	while(x<twidth){
		if(ix >= bp->n){
			bp=bp->next;
			ix=0;
			continue;
		}
		if(bp->Buf[ix++]=='\n') break;
		x++;
	}
	disptopbp=bp;
	disptopix=ix;
}
void cursor_home(void){
//J[\s擪Ɉړ
//óFLϐړ̒lɕύX
//cursorbp,cursorix obt@̃J[\ʒu
//cx,cx2 0
//cy ύXȂ
//disptopbp,disptopix ʍ̃obt@̈ʒuiύXȂj

	//J[\XWOɈړ
	while(cx>0){
		if(cursorix==0){
			//obt@͔΂
			cursorbp=cursorbp->prev;
			cursorix=cursorbp->n;
			continue;
		}
		cursorix--;
		cx--;
	}
	cx2=0;
}
void cursor_end(void){
//J[\sɈړ
//óFLϐړ̒lɕύX
//cursorbp,cursorix obt@̃J[\ʒu
//cx,cx2 s
//cy ύXȂ
//disptopbp,disptopix ʍ̃obt@̈ʒuiύXȂj

	//J[\XWʕɈړ
	//sR[h܂̓obt@ŏI΂Ɉړ
	while(cx<twidth-1){
		if(cursorix>=cursorbp->n){
			//obt@͔΂
			if(cursorbp->next==NULL) break;
			cursorbp=cursorbp->next;
			cursorix=0;
			continue;
		}
		if(cursorbp->Buf[cursorix]=='\n') break;
		cursorix++;
		cx++;
	}
	cx2=cx;
}
void cursor_pageup(void){
//PageUpL[
//ŏsŉsɂȂ܂ŃXN[
//óFLϐړ̒lɕύX
//cursorbp,cursorix obt@̃J[\ʒu
//cx,cx2
//cy
//disptopbp,disptopix ʍ̃obt@̈ʒu

	_tbuf *bp;
	int ix;
	int i;
	int cy_old;

	cy_old=cy;
	while(cy>0) cursor_up(); // cy==0ɂȂ܂ŃJ[\Ɉړ
	for(i=0;i<EDITWIDTHY-1;i++){
		//ʍs-1sJ[\Ɉړ
		bp=disptopbp;
		ix=disptopix;
		cursor_up();
		if(bp==disptopbp && ix==disptopix) break; //ŏsňړłȂꍇ
	}
	//YW܂ŃJ[\ɈړA1sȂꍇ͍ŏsɗ܂
	if(i>0) while(cy<cy_old) cursor_down();
}
void cursor_pagedown(void){
//PageDownL[
//ŉsŏsɂȂ܂ŃXN[
//óFLϐړ̒lɕύX
//cursorbp,cursorix obt@̃J[\ʒu
//cx,cx2
//cy
//disptopbp,disptopix ʍ̃obt@̈ʒu

	_tbuf *bp;
	int ix;
	int i;
	int y;
	int cy_old;

	cy_old=cy;
	while(cy<EDITWIDTHY-1){
		// cy==EDITWIDTH-1ɂȂ܂ŃJ[\Ɉړ
		y=cy;
		cursor_down();
		if(y==cy) break;// obt@ŉsňړłȂꍇ
	}
	for(i=0;i<EDITWIDTHY-1;i++){
		//ʍs-1sJ[\Ɉړ
		bp=disptopbp;
		ix=disptopix;
		cursor_down();
		if(bp==disptopbp && ix==disptopix) break; //ŉsňړłȂꍇ
	}
	//[炳ɈړsAJ[\ɈړA1sȂꍇ͍ŉsɗ܂
	if(i>0) while(cy>cy_old) cursor_up();
}
void cursor_top(void){
//J[\eLXgobt@̐擪Ɉړ
	cursorbp=TBufstart;
	cursorix=0;
	cursorbp1=NULL; //͈͑I[h
	disptopbp=cursorbp;
	disptopix=cursorix;
	cx=0;
	cx2=0;
	cy=0;
	line_no=1;
}

int countarea(void){
//eLXgobt@̎w͈͂̕JEg
//͈͂(cursorbp,cursorix)(cursorbp1,cursorix1)Ŏw
//둤̈O̕܂łJEg
	_tbuf *bp1,*bp2;
	int ix1,ix2;
	int n;

	//͈͑I[h̏ꍇAJnʒuƏȊO㔻f
	//bp1,ix1JnʒuAbp2,ix2Iʒuɐݒ
	if(cy<cy1 || (cy==cy1 && cx<cx1)){
		bp1=cursorbp;
		ix1=cursorix;
		bp2=cursorbp1;
		ix2=cursorix1;
	}
	else{
		bp1=cursorbp1;
		ix1=cursorix1;
		bp2=cursorbp;
		ix2=cursorix;
	}
	n=0;
	while(1){
		if(bp1==bp2 && ix1==ix2) return n;
		if(ix1 < bp1->n){
			n++;
			ix1++;
		}
		else{
			bp1=bp1->next;
			ix1=0;
		}
	}
}
void deletearea_len(_tbuf *bp,unsigned int ix,int n,int undo){
//eLXgobt@̎wʒu畡폜
//bp,ix:폜Jnʒu
//n:폜镶
//undo:0:ʏA2:AhD
	unsigned char *p;
	int i;

	//I͈͂ŏ̃obt@̍Ō܂łꍇ
	if(n>=(bp->n - ix)){
		if(!undo){
			p=bp->Buf+ix;
			for(i=ix;i < bp->n;i++) pushundomem(*p++); //AhDobt@Ɋi[
		}
		n -= bp->n - ix; //폜
		num-=bp->n - ix; //obt@gpʂ
		bp->n=ix; //ixȍ~폜
		bp=bp->next;
		if(bp==NULL) return;
		ix=0;
	}
	//̃obt@ȍ~AI͈͂̏Iʒu܂܂Ȃobt@͍폜
	while(n>=bp->n){
		if(!undo){
			p=bp->Buf;
			for(i=0;i < bp->n;i++) pushundomem(*p++); //AhDobt@Ɋi[
		}
		n-=bp->n; //폜
		num-=bp->n; //obt@gpʂ
		bp=deleteTBuf(bp); //obt@폜Ď̃obt@ɐi
		if(bp==NULL) return;
	}
	//I͈͂̏Iʒu܂ޏꍇA1폜
	if(!undo) undo=1;
	while(n>0){
		deletechar(bp,ix,undo); //obt@1폜inum͊֐1j
		n--;
	}
}
void deletearea(void){
//eLXgobt@̎w͈͂폜
//͈͂(cursorbp,cursorix)(cursorbp1,cursorix1)Ŏw
//둤̈O̕܂ł폜
//폜̃J[\ʒu͑I͈͂̐擪ɂA͈͑I[h

	_tbuf *bp;
	int ix;
	int n;

	n=countarea(); //I͈͂̕JEg
	if(n==0) return;

	//͈͑I̊JnʒuƏIʒȗO𔻒făJ[\Jnʒuɐݒ
	if(cy>cy1 || (cy==cy1 && cx>cx1)){
		cursorbp=cursorbp1;
		cursorix=cursorix1;
		cx=cx1;
		cy=cy1;
		line_no=line_no1;
	}
	cx2=cx;
	cursorbp1=NULL; //͈͑I[h

	//bp,ixJnʒuɐݒ
	bp=cursorbp;
	ix=cursorix;

	setundobuf(UNDO_CONTDEL,bp,ix,0,n); //AhDobt@ݒiA폜Jnj
	deletearea_len(bp,ix,n,0); //n폜
	//AhDobt@ɘA폜Iݒ
	pushundomem2(bpixtopos(bp,ix));
	pushundomem2(n);
	pushundomem(UNDO_CONTDEL);
}
void clipcopy(void){
// I͈͂Nbv{[hɃRs[
	_tbuf *bp1,*bp2;
	int ix1,ix2;
	char *ps,*pd;

	//͈͑I[h̏ꍇAJnʒuƏȊO㔻f
	//bp1,ix1JnʒuAbp2,ix2Iʒuɐݒ
	if(cy<cy1 || (cy==cy1 && cx<cx1)){
		bp1=cursorbp;
		ix1=cursorix;
		bp2=cursorbp1;
		ix2=cursorix1;
	}
	else{
		bp1=cursorbp1;
		ix1=cursorix1;
		bp2=cursorbp;
		ix2=cursorix;
	}
	ps=bp1->Buf+ix1;
	pd=clipboard;
	clipsize=0;
	while(bp1!=bp2 || ix1!=ix2){
		if(ix1 < bp1->n){
			*pd++=*ps++;
			clipsize++;
			ix1++;
		}
		else{
			bp1=bp1->next;
			ps=bp1->Buf;
			ix1=0;
		}
	}
}
void clippaste(void){
// Nbv{[h\t
	int n,i;
	unsigned char *p;

	if(clipsize==0 || num+clipsize>TBUFMAXSIZE) return;
	setundobuf(UNDO_CONTINS,cursorbp,cursorix,0,clipsize); //AhDobt@ݒ
	p=clipboard;
	for(n=clipsize;n>0;n--){
		i=insertchar(cursorbp,cursorix,*p,1);
		if(i>0){
			//obt@󂫂̂ɑ}s̏ꍇ
			gabagecollect2(); //S̃Kx[WRNV
			i=insertchar(cursorbp,cursorix,*p,1);//eLXgobt@ɂP}
		}
		if(i!=0) break;//}s
		cursor_right();//ʏAobt@̃J[\ʒu1Ɉړ
		p++;
	}
}
void movecursor(int pos){
// J[\݂̈ʒuCӂ̈ʒuɈړ
// posFړeLXgobt@擪̃oCgʒu
	int pos2,d;
	pos2=bpixtopos(cursorbp,cursorix);
	d=pos-pos2;
	if(d==0) return;
	if(d>0){
		while(d>0){
			cursor_right();
			d--;
		}
	}
	else{
		while(d<0){
			cursor_left();
			d++;
		}
	}
}
void undoexec(){
//AhDs
	unsigned char c,c1;
	_tbuf *bp;
	unsigned short n,ix;
	int pos;

	if(undobuf_used==0) return; //AhDobt@
	cursorbp1=NULL; //͈͑I
	c=popundomem(); //AhDobt@擪̖ߓǂݏo
	switch(c){
		case UNDO_INSERT: //1}
			//J[\ړ1폜
			pos=popundomem2();
			movecursor(pos);
			bp=postobpix(pos,&ix);
			deletechar(bp,ix,2);
			popundomem(); //dummy read
			break;
		case UNDO_CONTINS: //A}
			//J[\ړA폜
			n=popundomem2();
			pos=popundomem2();
			movecursor(pos);
			bp=postobpix(pos,&ix);
			deletearea_len(bp,ix,n,2);
			popundomem(); //dummy read
			break;
		case UNDO_CONTDEL: //A폜
			//J[\ړAAR[hǂݏođ}
			n=popundomem2();
			pos=popundomem2();
			movecursor(pos);
			bp=postobpix(pos,&ix);
			while(n>0){
				insertchar(bp,ix,popundomem(),2);
				n--;
			}
			popundomem2(); //dummy read
			popundomem(); //dummy read
			break;
		case 0: //0̏ꍇA1oCgۂ̗LȃR[h
			c=popundomem();
		default: //1폜iDELABSjA1㏑
			//J[\ړ1}i܂͏㏑j
			pos=popundomem2();
			movecursor(pos);
			bp=postobpix(pos,&ix);
			c1=popundomem();
			if(c1==UNDO_OVERWRITE){
				overwritechar(bp,ix,c,2);
			}
			else{
				insertchar(bp,ix,c,2);
				if(c1==UNDO_BACKSPACE) cursor_right();
			}
			break;
	}
}

void set_areamode(){
//͈͑I[hJñJ[\JnʒuO[oϐݒ
	cursorbp1=cursorbp;
	cursorix1=cursorix;
	cx1=cx;
	cy1=cy;
	line_no1=line_no;
}
void save_cursor(void){
//J[\֘AO[oϐꎞ
	cursorbp_t=cursorbp;
	cursorix_t=cursorix;
	disptopbp_t=disptopbp;
	disptopix_t=disptopix;
	cx_t=cx;
	cy_t=cy;
	line_no_t=line_no;
}
void restore_cursor(void){
//J[\֘AO[oϐꎞꏊ߂
	cursorbp=cursorbp_t;
	cursorix=cursorix_t;
	disptopbp=disptopbp_t;
	disptopix=disptopix_t;
	cx=cx_t;
	cy=cy_t;
	line_no=line_no_t;
}

int filesystemretry(){
// SDt@CVXe̍ďmFƎ{
// SDt@Cւ̕ۑǂݍݎɃt@CG[ꍇɌĂяo
// ߂l@0FA-1F邱ƂȂEscapeŔ
	unsigned short vk;
	while(1){
		setcursorcolor(COLOR_NORMALTEXT);
		printstr((unsigned char *)Message3); //Retry / Quit
		while(1){
			inputchar(); //1͑҂
			vk=vkey & 0xff;
			if(vk==VK_RETURN || vk==VK_SEPARATOR) break;
			if(vk==VK_ESCAPE) return -1;
		}
		//t@CVXe
		if(FSInit()!=FALSE) return 0; //
		//G[̏ꍇ
		setcursorcolor(COLOR_ERRORTEXT);
		printstr((unsigned char *)Message2);//File System Error
	}
}

int sdfilecopy(char *sourcefile,char *distfile){
// SDJ[h̃t@CRs[
// soucefile:Rs[t@C
// distfile:Rs[t@C
// ߂lFI 0AG[IG[ԍ
	FSFILE *sfp,*dfp;
	int n,er,c;
	er=0;
	sfp=FSfopen(sourcefile,"r");
	if(sfp==NULL) return ERR_CANTFILEOPEN;
	dfp=FSfopen(distfile,"w");
	if(dfp==NULL){
		FSfclose(sfp);
		return ERR_CANTFILEOPEN;
	}
	c=0;
	while(1){
		if(c==0){
			printchar('.');
			c=100;
		}
		c--;
		n=FSfread(filebuf,1,FILEBUFSIZE,sfp);
		if(n==0) break;
		if(FSfwrite(filebuf,1,n,dfp)!=n){
			er=ERR_CANTWRITEFILE;
			break;
		}
	}
	FSfclose(sfp);
	FSfclose(dfp);
	return er;
}
int savetextfile(char *filename){
// eLXgobt@eLXgt@Cɏ
// ݐ0AsŃG[R[hijԂ
	FSFILE *fp;
	_tbuf *bp;
	int ix,n,i,er;
	unsigned char *ps,*pd;
	er=0;//G[R[h
	i=-1;
	fp=FSfopen(filename,"w");
	if(fp==NULL) return ERR_CANTFILEOPEN;
	bp=TBufstart;
	ix=0;
	ps=bp->Buf;
	do{
		pd=filebuf;
		n=0;
		while(n<FILEBUFSIZE-1){
		//sR[h2oCgɂȂ邱Ƃlăobt@TCY-1܂łƂ
			while(ix>=bp->n){
				bp=bp->next;
				if(bp==NULL){
					break;
				}
				ix=0;
				ps=bp->Buf;
			}
			if(bp==NULL) break;
			if(*ps=='\n'){
				*pd++='\r'; //sR[h0A0D 0Aɂ
				n++;
			}
			*pd++=*ps++;
			ix++;
			n++;
		}
		if(n>0){
			i=FSfwrite(filebuf,1,n,fp);
			if(i!=n) er=ERR_CANTWRITEFILE;
		}
	} while(bp!=NULL && er==0);
	FSfclose(fp);
	return er;
}
int loadtextfile(char *filename){
// eLXgt@CeLXgobt@ɓǂݍ
// ǂݍݐ0AsŃG[R[hijԂ
	FSFILE *fp;
	_tbuf *bp;
	int ix,n,i,er;
	unsigned char *ps,*pd;
	er=0;//G[R[h
	fp=FSfopen(filename,"r");
	if(fp==NULL) return ERR_CANTFILEOPEN;
	inittextbuf();
	bp=TextBuffer;
	ix=0;
	pd=bp->Buf;
	do{
		n=FSfread(filebuf,1,FILEBUFSIZE,fp);
		ps=filebuf;
		for(i=0;i<n;i++){
			if(ix>=TBUFSIZE){
				bp->n=TBUFSIZE;
				bp=newTBuf(bp);
				if(bp==NULL){
					er=ERR_FILETOOBIG;
					break;
				}
				ix=0;
				pd=bp->Buf;
			}
			if(*ps=='\r') ps++; //sR[h0D 0A0AɂiP0Dj
			else{
				*pd++=*ps++;
				ix++;
				num++;//obt@
				if(num>TBUFMAXSIZE){
					er=ERR_FILETOOBIG;
					break;
				}
			}
		}
	} while(n==FILEBUFSIZE && er==0);
	if(bp!=NULL) bp->n=ix;//Ō̃obt@̕
	FSfclose(fp);
	if(er){
		//G[̏ꍇobt@AJ[\ʒu
		inittextbuf();
		cursor_top();
	}
	return er;
}
int overwritecheck(char *fn){
// t@C̏㏑mF
// t@C݂̑`FbNA݂ꍇL[{[h㏑mF
// fn:t@Cւ̃|C^
// ߂l@0F݂Ȃ܂͏㏑A-1F㏑Ȃ
	SearchRec sr;
	unsigned short vk;
	if(FindFirst(fn,ATTR_READ_ONLY | ATTR_HIDDEN | ATTR_SYSTEM | ATTR_ARCHIVE,&sr)) return 0; //t@C݂Ȃ
	setcursorcolor(COLOR_ERRORTEXT);
	printstr(fn);
	printstr(": File Exists\n");
	setcursorcolor(COLOR_NORMALTEXT);
	printstr("Ovewrite:[Enter] / Stop:[ESC]\n");
	while(1){
		inputchar(); //1͑҂
		vk=vkey & 0xff;
		if(vk==VK_RETURN || vk==VK_SEPARATOR) return 0;
		if(vk==VK_ESCAPE) return -1;
	}
}
void printfilename(unsigned char x,unsigned char y,int f,int num_dir){
// x,ÿʒuɃt@C܂̓fBNg\

	if(f==-2){
		setcursor(x,y,COLOR_ERRORTEXT);
		printchar('<');
		printstr("New FILE");
		printchar('>');
	}
	else if(f==-1){
		setcursor(x,y,COLOR_ERRORTEXT);
		printchar('<');
		printstr("New Dir");
		printchar('>');
	}
	else if(f<num_dir){
		setcursor(x,y,COLOR_DIR);
		printchar('[');
		printstr(filenames[f]);
		printchar(']');
	}
	else{
		setcursor(x,y,COLOR_NORMALTEXT);
		printstr(filenames[f]);
	}
}
int select_dir_file(int filenum,int num_dir, unsigned char* msg){
// filenames[]zɓǂݍ܂ꂽt@C܂̓fBNgʕ\L[{[hőI
// filenum:t@C{fBNg
// num_dir:fBNgifilenames[]͐擪num_dir-1܂łfBNgj
// msg:ʏ㕔ɕ\郁bZ[W
// ߂l
//@filenames[]̑Iꂽt@C܂̓fBNgԍ
//@-1FVKfBNg쐬Atempfile[]ɃfBNg
//@-2FVKt@C쐬Atempfile[]Ƀt@C
//@-3FESCL[ꂽ
	int top,f;
	unsigned char *ps,*pd;
	int x,y;
	unsigned char vk;
	unsigned char vm;

	//t@Cꗗʂɕ\
	vm=videomode;
	set_videomode(VMODE_STDTEXT,0);
	cls();
	setcursor(0,0,COLOR_NORMALTEXT);
	printstr(msg);
	printstr(": ");
	setcursorcolor(4);
	printstr("Select&[Enter] / [ESC]\n");
	for(f=-2;f<filenum;f++){
		x=(f&1)*15+1;
		y=(f+2)/2+1;
		if(y>=twidthy-1) break;
		printfilename(x,y,f,num_dir);
	}
	top=-2;//ʈԐ擪̃t@Cԍ
	f=-2;//ݑI𒆂̃t@Cԍ
	while(1){
		setcursor((f&1)*15,(f-top)/2+1,5);
		printchar(0x1c);// Right Arrow
		cursor--;
		while(1){
			inputchar();
			vk=vkey & 0xff;
			if(vk) break;
		}
		printchar(' ');
		setcursor(0,twidthy-1,COLOR_NORMALTEXT);
		for(x=0;x<twidth-1;x++) printchar(' '); //ŉs̃Xe[^X\
		switch(vk){
			case VK_UP:
			case VK_NUMPAD8:
				//L[
				if(f>=0){
					f-=2;
					if(f<top){
						//ʍŏ㕔̏ꍇAɃXN[čŏ㕔Ƀt@C2\
						setcursor(twidth-1,twidthy-2,COLOR_NORMALTEXT);
						while(cursor>=TVRAM+twidth*2){
							*cursor=*(cursor-twidth);
							*(cursor+attroffset)=*(cursor+attroffset-twidth);
							cursor--;
						}
						while(cursor>=TVRAM+twidth) *cursor--=' ';
						top-=2;
						printfilename(1,1,top,num_dir);
						printfilename(16,1,top+1,num_dir);
					}
				}
				break;
			case VK_DOWN:
			case VK_NUMPAD2:
				//L[
				if(((f+2)&0xfffe)<filenum){
					f+=2;
					if(f>=filenum) f--;
					if(f-top>=(twidthy-2)*2){
						//ʍŉ̏ꍇAɃXN[čŉɃt@C1or2\
						setcursor(0,1,COLOR_NORMALTEXT);
						while(cursor<TVRAM+twidth*(twidthy-2)){
							*cursor=*(cursor+twidth);
							*(cursor+attroffset)=*(cursor+attroffset+twidth);
							cursor++;
						}
						while(cursor<TVRAM+twidth*(twidthy-1)) *cursor++=' ';
						top+=2;
						printfilename(1,twidthy-2,f&0xfffe,num_dir);
						if((f|1)<filenum){
							printfilename(16,twidthy-2,f|1,num_dir);
						}
					}
				}
				break;
			case VK_LEFT:
			case VK_NUMPAD4:
				//L[
				if(f&1) f--;
				break;
			case VK_RIGHT:
			case VK_NUMPAD6:
				//EL[
				if((f&1)==0 && f+1<filenum) f++;
				break;
			case VK_RETURN: //EnterL[
			case VK_SEPARATOR: //eL[Enter
				if(f==-2){
					//VKt@C
					setcursor(0,twidthy-1,COLOR_ERRORTEXT);
					printstr("Input File Name: ");
					setcursorcolor(COLOR_NORMALTEXT);
					//t@C
					*tempfile=0;
					if(lineinput(tempfile,8+1+3)<0) break; //ESCL[
					if(*tempfile==0) break; //t@C͂Ȃ
				}
				else if(f==-1){
					//VKfBNg
					setcursor(0,twidthy-1,COLOR_ERRORTEXT);
					printstr("Input Dir Name: ");
					setcursorcolor(COLOR_NORMALTEXT);
					//fBNg
					*tempfile=0;
					if(lineinput(tempfile,8+1+3)<0) break; //ESCL[
					if(FSmkdir(tempfile)){
						setcursor(0,twidthy-1,COLOR_ERRORTEXT);
						printstr("Cannot Make Directory        ");
						break;
					}
				}
				else{
					//t@C܂̓fBNgtempfileɃRs[
					ps=filenames[f];
					pd=tempfile;
					while(*ps) *pd++=*ps++;
					*pd=0;
				}
				set_videomode(vm,0);
				return f;
			case VK_ESCAPE:
				//ESCL[
				set_videomode(vm,0);
				return -3;
		}
	}
}
int getfilelist(int *p_num_dir){
// JgfBNgł̃fBNgA.BASA.TXTA.INIt@Cꗗǂݍ
// *p_num_dir:fBNgԂ
// filenames[]:t@CуfBNgꗗ
// ߂l@t@C{fBNg

	unsigned char *ps,*pd;
	int filenum;
	SearchRec sr;
	filenum=0;
	//fBNg̃T[`
	if(FindFirst("*",ATTR_DIRECTORY,&sr)==0){
		do{
			//filenames[]ɃfBNg̈ꗗǂݍ
			ps=sr.filename;
			pd=filenames[filenum];
			while(*ps!=0) *pd++=*ps++;
			*pd=0;
			filenum++;
		}
		while(!FindNext(&sr) && filenum<MAXFILENUM);
	}
	*p_num_dir=filenum;
	if(filenum>=MAXFILENUM) return filenum;
	//gq BASt@C̃T[`
	if(FindFirst("*.BAS",ATTR_READ_ONLY | ATTR_HIDDEN | ATTR_SYSTEM | ATTR_ARCHIVE,&sr)==0){
		do{
			//filenames[]Ƀt@C̈ꗗǂݍ
			ps=sr.filename;
			pd=filenames[filenum];
			while(*ps!=0) *pd++=*ps++;
			*pd=0;
			filenum++;
		}
		while(!FindNext(&sr) && filenum<MAXFILENUM);
	}
	if(filenum>=MAXFILENUM) return filenum;
	//gq TXTt@C̃T[`
	if(FindFirst("*.TXT",ATTR_READ_ONLY | ATTR_HIDDEN | ATTR_SYSTEM | ATTR_ARCHIVE,&sr)==0){
		do{
			//filenames[]Ƀt@C̈ꗗǂݍ
			ps=sr.filename;
			pd=filenames[filenum];
			while(*ps!=0) *pd++=*ps++;
			*pd=0;
			filenum++;
		}
		while(!FindNext(&sr) && filenum<MAXFILENUM);
	}
	if(filenum>=MAXFILENUM) return filenum;
	//gq INIt@C̃T[`
	if(FindFirst("*.INI",ATTR_READ_ONLY | ATTR_HIDDEN | ATTR_SYSTEM | ATTR_ARCHIVE,&sr)==0){
		do{
			//filenames[]Ƀt@C̈ꗗǂݍ
			ps=sr.filename;
			pd=filenames[filenum];
			while(*ps!=0) *pd++=*ps++;
			*pd=0;
			filenum++;
		}
		while(!FindNext(&sr) && filenum<MAXFILENUM);
	}
	return filenum;
}
void save_as(int ow){
// ݂̃eLXgobt@̓eSDJ[hɕۑ
// ow@0:Otĕۑ@@1:㏑ۑ
// t@C̓O[oϐcurrentfile[]
// t@C̓L[{[hύX\
// ꍇcurrentfileXV

	int er;
	int filenum,num_dir,f;
	unsigned char *ps,*pd;

	cls();
	setcursor(0,0,COLOR_NORMALTEXT);
	printstr("Save To SD Card\n");
	if(currentfile[0]==0) ow=0; //t@Cݒ肳ĂȂꍇOtĕۑ

	//currentfiletempfileɃRs[
	ps=currentfile;
	pd=tempfile;
	while(*ps!=0) *pd++=*ps++;
	*pd=0;

	//JgfBNgϐcwdpathɃRs[
	while(1){
		if(FSgetcwd(cwdpath,PATHNAMEMAX)) break;
		setcursorcolor(COLOR_ERRORTEXT);
		printstr("Cannot Get Current Dir\n");
		if(filesystemretry()) return; //t@CVXeďA߂ꍇreturn
	}
	//݂̃fBNg̃pX\
	setcursorcolor(COLOR_NORMALTEXT);
	printstr("Current Directory is\n");
	printstr(cwdpath);
	printchar('\n');
	while(1){
		if(ow==0){
			printstr("Input File Name + [Enter]\n");
			printstr("[ESC] Select File/Dir or Quit\n");
			//t@C
			if(lineinput(tempfile,8+1+3)<0){
				//ESCL[ꂽꍇAt@CIAfBNgύXʂ܂͏I
				while(1){
					filenum=getfilelist(&num_dir); //fBNgAt@Cꗗǂݍ
					f=select_dir_file(filenum,num_dir,"Save"); //t@C̑I
					cls();
					if(f==-3){
						//I
						FSchdir(cwdpath);//JgfBNgɖ߂
						return;
					}
					else if(f==-2){
						//VKt@C
						if(overwritecheck(tempfile)==0) break;//㏑`FbN
					}
					else if(f<num_dir){
						//VKfBNg܂̓fBNgύX
						FSchdir(tempfile);//fBNgύXčēxt@Cꗗ
					}
					else break;
				}
			}
			else{
				if(*tempfile==0) continue; //NULL̏ꍇ
				if(overwritecheck(tempfile)) continue;
			}
		}
		printstr("Writing...\n");
		er=savetextfile(tempfile); //t@CۑAer:G[R[h
		if(er==0){
			printstr("OK");
			FSremove(TEMPFILENAME); //sɐꎞt@C폜
			//tempfilecurrentfileɃRs[ďI
			ps=tempfile;
			pd=currentfile;
			while(*ps!=0) *pd++=*ps++;
			*pd=0;
			FSgetcwd(cwdpath,PATHNAMEMAX); //JgpXXV
			edited=0; //ҏWς݃tONA
			wait60thsec(60);//1b҂
			return;
		}
		setcursorcolor(COLOR_ERRORTEXT);
		if(er==ERR_CANTFILEOPEN) printstr("Bad File Name or File Error\n");
		else printstr("Cannot Write\n");
		if(filesystemretry()) return; //t@CVXeďA߂ꍇreturn
	}
}

void newtext(void){
// VKeLXg쐬
	unsigned char vk;
	if(edited && num){
		//ŏIۑɕҏWς݂̏ꍇAۑ̊mF
		cls();
		setcursorcolor(COLOR_NORMALTEXT);
		printstr("Save Editing File?\n");
		printstr("Save:[Enter] / Not Save:[ESC]\n");
		while(1){
			inputchar(); //1L[͑҂
			vk=vkey & 0xff;
			if(vk==VK_RETURN || vk==VK_SEPARATOR){
				save_as(0); //Otĕۑ
				break;
			}
			else if(vk==VK_ESCAPE) break;
		}
	}
	inittextbuf(); //eLXgobt@
	cursor_top(); //J[\eLXgobt@̐擪ɐݒ
	currentfile[0]=0; //ƒt@CNA
}

void msra(void){
// Make Self-Running Application iȎsAvP[V̍쐬j
// ŏɃ\[Xt@C𖼑Otĕۑ
// BASICVXeHEXt@C\[Xt@C̊gqHEXɂOŃRs[

	int er;
	unsigned char *ps,*pd;
	cls();
	setcursor(0,0,COLOR_NORMALTEXT);
	printstr("Make Self-Running Application\n\n");
	printstr("(Work on Root Directory)\n");

	//JgfBNgϐcwdpathɃRs[
	while(1){
		if(FSgetcwd(cwdpath,PATHNAMEMAX)) break;
		setcursorcolor(COLOR_ERRORTEXT);
		printstr("Cannot Get Current Dir\n");
		if(filesystemretry()) return; //t@CVXeďA߂ꍇreturn
	}
	while(1){
		//JgfBNg[gɕύX
		if(FSchdir((char *)ROOTDIR)==0) break;
		setcursorcolor(COLOR_ERRORTEXT);
		printstr("Cannot Change To Root Dir\n");
		if(filesystemretry()) return; //t@CVXeďA߂ꍇreturn
	}
	//currentfiletempfileɃRs[
	ps=currentfile;
	pd=tempfile;
	while(*ps!=0) *pd++=*ps++;
	*pd=0;

	while(1){
		setcursorcolor(COLOR_NORMALTEXT);
		printstr("Input File Name (xxx.BAS)\n");
		if(lineinput(tempfile,8+1+3)<0){
			//ESCL[ꂽ
			FSchdir(cwdpath); //JgfBNgɖ߂
			return;
		}
		ps=tempfile;
		while(*ps!='.' && *ps!=0) ps++;
		if(ps+4>=tempfile+13 ||
			*ps!='.' ||
			(*(ps+1)!='b' && *(ps+1)!='B') ||
			(*(ps+2)!='a' && *(ps+2)!='A') ||
			(*(ps+3)!='s' && *(ps+3)!='S') ||
			*(ps+4)!=0){
				setcursorcolor(COLOR_ERRORTEXT);
				printstr("File Name Must Be xxx.BAS\n");
				continue;
		}
		if(overwritecheck(tempfile)) continue;
		printstr("Writing BASIC File\n");
		er=savetextfile(tempfile); //t@CۑAer:G[R[h
		if(er==0) break;
		setcursorcolor(COLOR_ERRORTEXT);
		if(er==ERR_CANTFILEOPEN) printstr("Bad File Name or File Error\n");
		else printstr("Cannot Write\n");

		//t@CVXeďA߂ꍇreturn
		if(filesystemretry()){
			if(FSchdir(cwdpath)){
				cwdpath[0]='\\';
				cwdpath[1]=0;
			}
			return;
		}
	}
	printstr("OK\n\n");
	FSremove(TEMPFILENAME); //sɐꎞt@C폜
	//tempfilecurrentfileɃRs[ďI
	ps=tempfile;
	pd=currentfile;
	while(*ps!=0) *pd++=*ps++;
	*pd=0;
	edited=0; //ҏWς݃tONA
	// gqHEXɂBASICVXet@CRs[
	*(ps-3)='H';
	*(ps-2)='E';
	*(ps-1)='X';
	if(overwritecheck(tempfile)) return;
	printstr("Copying\n");
	printstr(HEXFILE);
	printstr(" To ");
	printstr(tempfile);
	printstr("\nWait For A While");
	er=sdfilecopy(HEXFILE,tempfile);
	if(FSchdir(cwdpath)){
		cwdpath[0]='\\';
		cwdpath[1]=0;
	}
	if(er==0){
		printstr("\nDone");
		wait60thsec(120);//2b҂
		return;
	}
	setcursorcolor(COLOR_ERRORTEXT);
	if(er==ERR_CANTFILEOPEN){
		printstr(HEXFILE);
		printstr(" Not Found\n");
	}
	else if(er==ERR_CANTWRITEFILE){
		printstr("Write Error\n");
	}
	setcursorcolor(COLOR_NORMALTEXT);
	printstr((unsigned char *)Message1);// Hit Any Key
	inputchar(); //1͑҂
	return;
}
int fileload(void){
// SDJ[ht@CIēǂݍ
// currenfile[]Ƀt@CL
// Ώۃt@Cgq BASTXT
// ߂l@0Fǂݍ݂s@-1Fǂݍ݂Ȃ
	int filenum,f,er;
	unsigned char *ps,*pd;
	unsigned char vk;
	int num_dir;//fBNg

	//t@C̈ꗗSDJ[hǂݏo
	cls();
	if(edited && num){
		//ŏIۑɕҏWς݂̏ꍇAۑ̊mF
		setcursorcolor(COLOR_NORMALTEXT);
		printstr("Save Program Before Load?\n");
		printstr("Save:[Enter] / Not Save:[ESC]\n");
		while(1){
			inputchar(); //1L[͑҂
			vk=vkey & 0xff;
			if(vk==VK_RETURN || vk==VK_SEPARATOR){
				save_as(0); //Otĕۑ
				break;
			}
			else if(vk==VK_ESCAPE) break;
		}
	}
	//JgfBNgϐcwdpathɃRs[
	while(1){
		if(FSgetcwd(cwdpath,PATHNAMEMAX)) break;
		setcursorcolor(COLOR_ERRORTEXT);
		printstr("Cannot Get Current Dir\n");
		if(filesystemretry()) return -1; //t@CVXeďA߂ꍇreturn
	}
	while(1){
		filenum=getfilelist(&num_dir); //fBNgAt@Cꗗǂݍ
		if(filenum==0){
			setcursorcolor(COLOR_ERRORTEXT);
			printstr(".BAS or .TXT File Not Found\n");
			printstr((unsigned char *)Message1);// Hit Any Key
			inputchar(); //1͑҂
			FSchdir(cwdpath);//JgfBNgɖ߂
			return -1;
		}
		//t@C̑I
		f=select_dir_file(filenum,num_dir,"Load");
		if(f==-3){
			//ǂݍ܂ɏI
			FSchdir(cwdpath);//JgfBNgɖ߂
			return -1;
		}
		else if(f==-2){
			//VKt@C܂̓t@C͂ēǂݍ
			er=loadtextfile(tempfile); //eLXgobt@Ƀt@Cǂݍ
			if(er==ERR_CANTFILEOPEN){
				//t@C݂ȂꍇAVKeLXg
				edited=0;
				newtext();
			}
			else if(er==ERR_FILETOOBIG){
				//t@CTCYG[̏ꍇAIʂɖ߂
				setcursor(0,twidthy-1,COLOR_ERRORTEXT);
				printstr("File Too Big                 ");
				wait60thsec(60);//1b҂
				continue;
			}
			//currenfile[]Ƀt@CRs[
			ps=tempfile;
			pd=currentfile;
			while(*ps) *pd++=*ps++;
			*pd=0;
			FSgetcwd(cwdpath,PATHNAMEMAX);//cwdpathJgfBNg̃pXɕύX
			return 0;
		}
		else if(f<num_dir){
			//VKfBNg܂̓fBNgύXāAēxt@Cꗗʂ
			FSchdir(tempfile);
		}
		else{
			er=loadtextfile(filenames[f]); //eLXgobt@Ƀt@Cǂݍ
			if(er==0){
				//cwdpath[]Acurrenfile[]ɃpXAt@CRs[ďI
				FSgetcwd(cwdpath,PATHNAMEMAX);
				ps=filenames[f];
				pd=currentfile;
				while(*ps!=0) *pd++=*ps++;
				*pd=0;
				return 0;
			}
			setcursor(0,twidthy-1,COLOR_ERRORTEXT);
			if(er==ERR_CANTFILEOPEN) printstr("Cannot Open File             ");
			else if(er=ERR_FILETOOBIG) printstr("File Too Big                 ");
			wait60thsec(60);//1b҂
		}
	}
}
void changewidth(void){
// ʕ̐؂ւ
	if(videomode==VMODE_STDTEXT) set_videomode(VMODE_WIDETEXT,0);
	else if(videomode==VMODE_WIDETEXT) set_videomode(VMODE_MONOTEXT,0);
	else set_videomode(VMODE_STDTEXT,0);
	cursor_top(); //J[\eLXgobt@̐擪ɐݒ
	redraw(); //ĕ`
}
void run(int test){
//KM-BASICRpCs
// test 0:RpCƎsA0ȊO:RpĈ݂ŏI
	int er,er2;
	FSFILE *fp;
	unsigned int disptoppos,cursorpos;
	unsigned char widthmode;
	int i,edited1;
	_tbuf *bp;
	unsigned short ix;
	unsigned char *p;

	cls();
	setcursor(0,0,COLOR_NORMALTEXT);
	while(1){
		//JgfBNg[gɕύX
		if(FSchdir((char *)ROOTDIR)){
			setcursorcolor(COLOR_ERRORTEXT);
			printstr("Cannot Change To Root Dir\n");
			if(filesystemretry()) return; //t@CVXeďA߂ꍇreturn
			continue;
		}
		//[gfBNg̃pXۑt@CɎspXۑ
		fp=FSfopen(WORKDIRFILE,"w");
		if(fp==NULL){
			setcursorcolor(COLOR_ERRORTEXT);
			printstr("Cannot Open Work Dir File\n");
			if(filesystemretry()){
				//t@CVXeďA߂ꍇ̓JgfBNg߂return
				FSchdir(cwdpath);
				return;
			}
			continue;
		}
		for(p=cwdpath;*p;p++) ;
		er=FSfwrite(cwdpath,1,p-cwdpath+1,fp);
		FSfclose(fp);
		if(er!=p-cwdpath+1){
			FSremove(WORKDIRFILE);
			setcursorcolor(COLOR_ERRORTEXT);
			printstr("Cannot Write Work Dir File\n");
			if(filesystemretry()){
				//t@CVXeďA߂ꍇ̓JgfBNg߂return
				FSchdir(cwdpath);
				return;
			}
			continue;
		}
		break;
	}
	while(1){
		//JgfBNgɖ߂
		if(FSchdir(cwdpath)){
			setcursorcolor(COLOR_ERRORTEXT);
			printstr("Cannot Change To CWD\n");
			if(filesystemretry()) return; //t@CVXeďA߂ꍇreturn
			continue;
		}
		//spnt@Cɕۑ
		if(savetextfile(TEMPFILENAME)){
			setcursorcolor(COLOR_ERRORTEXT);
			printstr("Cannot Write To SD Card\n");
			if(filesystemretry()) return; //t@CVXeďA߂ꍇreturn
			continue;
		}
		break;
	}

	//J[\ʒuAʕ\ʒuAʃ[h̕ۑ
	disptoppos=bpixtopos(disptopbp,disptopix);
	cursorpos=bpixtopos(cursorbp,cursorix);
	widthmode=videomode;
	edited1=edited; //ҏWς݃tÖꎞޔ
	set_videomode(VMODE_T30,0);//30[hɐݒ

	// Enable Break key
	g_disable_break=0;
	//KM-BASICs
	er2=runbasic(TEMPFILENAME,test);

	stopPCG();//VXetHgɖ߂
	setcursorcolor(COLOR_NORMALTEXT);
	printchar('\n');
	printstr((unsigned char *)Message1);// Hit Any Key
	do ps2readkey(); //L[obt@ɂȂ܂œǂݏo
	while(vkey!=0);
	inputchar(); //1͑҂
	stop_music(); //yĐ~
	init_composite(); //pbĝ߉ʏ

	//ʃ[h߂
	set_videomode(widthmode,0);

	FSgetcwd(cwdpath,PATHNAMEMAX);//JgfBNgpXϐ߂
	while(1){
		//JgfBNg[gɕύX
		if(FSchdir((char *)ROOTDIR)){
			setcursorcolor(COLOR_ERRORTEXT);
			printstr("Cannot Change To Root Dir\n");
			filesystemretry(); //t@CVXeď
			continue;
		}
		//[gfBNg̃pXۑt@CpXǂݏo
		fp=FSfopen(WORKDIRFILE,"r");
		if(fp==NULL){
			setcursorcolor(COLOR_ERRORTEXT);
			printstr("Cannot Open Work Dir File\n");
			filesystemretry(); //t@CVXeď
			continue;
		}
		er=FSfread(cwdpath,1,PATHNAMEMAX,fp);
		FSfclose(fp);
		if(er<=0){
			setcursorcolor(COLOR_ERRORTEXT);
			printstr("Cannot Read Work Dir File\n");
			filesystemretry(); //t@CVXeď
			continue;
		}
		FSremove(WORKDIRFILE); //pXۑt@C폜
		break;
	}
	while(1){
		//JgfBNgɖ߂
		if(FSchdir(cwdpath)){
			setcursorcolor(COLOR_ERRORTEXT);
			printstr("Cannot Change To CWD\n");
			filesystemretry(); //t@CVXeď
			continue;
		}
		//spnt@C猳ɖ߂
		if(loadtextfile(TEMPFILENAME)){
			setcursorcolor(COLOR_ERRORTEXT);
			printstr("Cannot Load From SD Card\n");
			filesystemretry(); //t@CVXeď
			continue;
		}
		break;
	}
	if(er2<=0){
		//I܂̓t@CG[܂̓NG[̏ꍇ
		//J[\̈ʒuɐݒ
		disptopbp=postobpix(disptoppos,&disptopix);
		cursorbp=postobpix(cursorpos,&cursorix);
	}
	else{
		//RpCG[̏ꍇ
		//J[\G[sŉʃgbvɈړ
		disptopbp=linetobpix(er2,&disptopix);
		cursorbp=disptopbp;
		cursorix=disptopix;
		cx=0;
		cx2=0;
		cy=0;
		line_no=er2;
		//ɂȂ悤XN[
		for(i=0;i<EDITWIDTHY/2;i++){
			//ʍsJ[\Ɉړ
			bp=disptopbp;
			ix=disptopix;
			cursor_up();
			if(bp==disptopbp && ix==disptopix) break; //ŏsňړłȂꍇ
		}
		for(;i>0;i--) cursor_down(); //YW܂ŃJ[\Ɉړ
	}
	cursorbp1=NULL; //͈͑I[h
	clipsize=0; //Nbv{[hNA
	edited=edited1;
	FSremove(TEMPFILENAME);
}
void displaybottomline(void){
//GfB^[ʍŉs̕\
	unsigned char *p;
	unsigned char c;
	int t;
	p=cursor; //J[\ʒȗޔ
	c=cursorcolor;
	if(shiftkeys() & CHK_SHIFT){
		if(videomode!=VMODE_MONOTEXT){
			setcursor(0,twidthy-1,COLOR_BOTTOMLINE);
			printstr("NEW  |MSRA |WIDTH|TEST | ");
		}
		else{
			setcursor(0,twidthy-1,COLOR_INV);
			printstr(" NEW  \x87 MSRA \x87 WIDTH\x87 TEST \x87\x87");
		}
		setcursorcolor(COLOR_ERRORTEXT);
		t=TBUFMAXSIZE-num;
		if(t==0) t=1;
		while(t<10000){
			printchar(' ');
			t*=10;
		}
		printstr("LEFT:");
		printnum(TBUFMAXSIZE-num);
	}
	else{
		if(videomode!=VMODE_MONOTEXT){
			setcursor(0,twidthy-1,COLOR_BOTTOMLINE);
			printstr("LOAD |SAVE |     |RUN  | ");
		}
		else{
			setcursor(0,twidthy-1,COLOR_INV);
			printstr(" LOAD \x87 SAVE \x87      \x87 RUN  \x87\x87");
		}
		setcursorcolor(COLOR_ERRORTEXT);
		t=line_no;
		if(t==0) t=1;
		while(t<10000){
			printchar(' ');
			t*=10;
		}
		printstr("LINE:");
		printnum(line_no);
	}
	cursor=p; //J[\ʒu߂
	cursorcolor=c;
}
void normal_code_process(unsigned char k){
// ʏ핶͏
// k:͂ꂽR[h
	int i;

	edited=1; //ҏWς݃tO
	if(insertmode || k=='\n' || cursorbp1!=NULL){ //}[h
		if(cursorbp1!=NULL) deletearea();//I͈͂폜
		i=insertchar(cursorbp,cursorix,k,0);//eLXgobt@ɂP}
		if(i>0){
			//obt@󂫂̂ɑ}s̏ꍇ
			gabagecollect2(); //S̃Kx[WRNV
			i=insertchar(cursorbp,cursorix,k,0);//eLXgobt@ɂP}
		}
		if(i==0) cursor_right();//ʏAobt@̃J[\ʒu1Ɉړ
	}
	else{ //㏑[h
		i=overwritechar(cursorbp,cursorix,k,0);//eLXgobt@ɂP㏑
		if(i>0){
			//obt@󂫂̂ɏ㏑i}js̏ꍇ
			//isobt@Ōł͑}j
			gabagecollect2(); //S̃Kx[WRNV
			i=overwritechar(cursorbp,cursorix,k,0);//eLXgobt@ɂP㏑
		}
		if(i==0) cursor_right();//ʏAobt@̃J[\ʒu1Ɉړ
	}
}
void control_code_process(unsigned char k,unsigned char sh){
// 䕶͏
// k:䕶̉zL[R[h
// sh:Vtg֘AL[

	save_cursor(); //J[\֘AϐޔiJ[\ړłȂꍇ߂߁j
	switch(k){
		case VK_LEFT:
		case VK_NUMPAD4:
			 //VtgL[ĂȂΔ͈͑I[hiNumLock{Vtg{eL[łj
			if((sh & CHK_SHIFT)==0 || (k==VK_NUMPAD4) && (sh & CHK_NUMLK)) cursorbp1=NULL;
			else if(cursorbp1==NULL) set_areamode(); //͈͑I[hłȂΔ͈͑I[hJn
			if(sh & CHK_CTRL){
				//CTRL{Home
				cursor_home();
				break;
			}
			cursor_left();
			if(cursorbp1!=NULL && (disptopbp!=disptopbp_t || disptopix!=disptopix_t)){
				//͈͑I[hŉʃXN[ꍇ
				if(cy1<EDITWIDTHY-1) cy1++; //͈̓X^[gʒuXN[
				else restore_cursor(); //J[\ʒu߂iʔ͈͊O͈̔͑I֎~j
			}
			break;
		case VK_RIGHT:
		case VK_NUMPAD6:
			 //VtgL[ĂȂΔ͈͑I[hiNumLock{Vtg{eL[łj
			if((sh & CHK_SHIFT)==0 || (k==VK_NUMPAD6) && (sh & CHK_NUMLK)) cursorbp1=NULL;
			else if(cursorbp1==NULL) set_areamode(); //͈͑I[hłȂΔ͈͑I[hJn
			if(sh & CHK_CTRL){
				//CTRL{EEnd
				cursor_end();
				break;
			}
			cursor_right();
			if(cursorbp1!=NULL && (disptopbp!=disptopbp_t || disptopix!=disptopix_t)){
				//͈͑I[hŉʃXN[ꍇ
				if(cy1>0) cy1--; //͈̓X^[gʒuXN[
				else restore_cursor(); //J[\ʒu߂iʔ͈͊O͈̔͑I֎~j
			}
			break;
		case VK_UP:
		case VK_NUMPAD8:
			 //VtgL[ĂȂΔ͈͑I[hiNumLock{Vtg{eL[łj
			if((sh & CHK_SHIFT)==0 || (k==VK_NUMPAD8) && (sh & CHK_NUMLK)) cursorbp1=NULL;
			else if(cursorbp1==NULL) set_areamode(); //͈͑I[hłȂΔ͈͑I[hJn
			cursor_up();
			if(cursorbp1!=NULL && (disptopbp!=disptopbp_t || disptopix!=disptopix_t)){
				//͈͑I[hŉʃXN[ꍇ
				if(cy1<EDITWIDTHY-1) cy1++; //͈̓X^[gʒuXN[
				else restore_cursor(); //J[\ʒu߂iʔ͈͊O͈̔͑I֎~j
			}
			break;
		case VK_DOWN:
		case VK_NUMPAD2:
			 //VtgL[ĂȂΔ͈͑I[hiNumLock{Vtg{eL[łj
			if((sh & CHK_SHIFT)==0 || (k==VK_NUMPAD2) && (sh & CHK_NUMLK)) cursorbp1=NULL;
			else if(cursorbp1==NULL) set_areamode(); //͈͑I[hłȂΔ͈͑I[hJn
			cursor_down();
			if(cursorbp1!=NULL && (disptopbp!=disptopbp_t || disptopix!=disptopix_t)){
				//͈͑I[hŉʃXN[ꍇ
				if(cy1>0) cy1--; //͈̓X^[gʒuXN[
				else restore_cursor(); //J[\ʒu߂iʔ͈͊O͈̔͑I֎~j
			}
			break;
		case VK_HOME:
		case VK_NUMPAD7:
			 //VtgL[ĂȂΔ͈͑I[hiNumLock{Vtg{eL[łj
			if((sh & CHK_SHIFT)==0 || (k==VK_NUMPAD7) && (sh & CHK_NUMLK)) cursorbp1=NULL;
			else if(cursorbp1==NULL) set_areamode(); //͈͑I[hłȂΔ͈͑I[hJn
			cursor_home();
			break;
		case VK_END:
		case VK_NUMPAD1:
			 //VtgL[ĂȂΔ͈͑I[hiNumLock{Vtg{eL[łj
			if((sh & CHK_SHIFT)==0 || (k==VK_NUMPAD1) && (sh & CHK_NUMLK)) cursorbp1=NULL;
			else if(cursorbp1==NULL) set_areamode(); //͈͑I[hłȂΔ͈͑I[hJn
			cursor_end();
			break;
		case VK_PRIOR: // PageUpL[
		case VK_NUMPAD9:
			 //Vtg{PageUp͖iNumLock{Vtg{u9vj
			if((sh & CHK_SHIFT) && ((k!=VK_NUMPAD9) || ((sh & CHK_NUMLK)==0))) break;
			cursorbp1=NULL; //͈͑I[h
			cursor_pageup();
			break;
		case VK_NEXT: // PageDownL[
		case VK_NUMPAD3:
			 //Vtg{PageDown͖iNumLock{Vtg{u3vj
			if((sh & CHK_SHIFT) && ((k!=VK_NUMPAD3) || ((sh & CHK_NUMLK)==0))) break;
			cursorbp1=NULL; //͈͑I[h
			cursor_pagedown();
			break;
		case VK_DELETE: //DeleteL[
		case VK_DECIMAL: //eL[́u.v
			edited=1; //ҏWς݃tO
			if(cursorbp1!=NULL) deletearea();//I͈͂폜
			else deletechar(cursorbp,cursorix,0);
			break;
		case VK_BACK: //BackSpaceL[
			edited=1; //ҏWς݃tO
			if(cursorbp1!=NULL){
				deletearea();//I͈͂폜
				break;
			}
			if(cursorix==0 && cursorbp->prev==NULL) break; //obt@擪ł͖
			cursor_left();
			deletechar(cursorbp,cursorix,-1);
			break;
		case VK_INSERT:
		case VK_NUMPAD0:
			insertmode^=1; //}[hA㏑[h؂ւ
			break;
		case 'C':
			//CTRL+CANbv{[hɃRs[
			if(cursorbp1!=NULL && (sh & CHK_CTRL)) clipcopy();
			break;
		case 'X':
			//CTRL+XANbv{[hɐ؂
			if(cursorbp1!=NULL && (sh & CHK_CTRL)){
				clipcopy();
				deletearea(); //I͈͂̍폜
				edited=1; //ҏWς݃tO
			}
			break;
		case 'V':
			//CTRL+VANbv{[h\t
			if((sh & CHK_CTRL)==0) break;
			if(clipsize==0) break;
			edited=1; //ҏWς݃tO
			if(cursorbp1!=NULL){
				//͈͑IĂ鎞͍폜Ă\t
				if(num-countarea()+clipsize<=TBUFMAXSIZE){ //obt@󂫗eʃ`FbN
					deletearea();//I͈͂폜
					clippaste();//Nbv{[h\t
				}
			}
			else{
				if(num+clipsize<=TBUFMAXSIZE){ //obt@󂫗eʃ`FbN
					clippaste();//Nbv{[h\t
				}
			}
			break;
		case 'S':
			//CTRL+SASDJ[hɕۑ
			if(num==0) break;
			if(sh & CHK_CTRL) save_as(1); //㏑ۑ
			break;
		case 'O':
			//CTRL+OAt@Cǂݍ
			if(sh & CHK_CTRL){
				if(fileload()==0){ //t@CIēǂݍ
					//ǂݍ݂sꍇAJ[\ʒu擪
					cursor_top();
				}
			}
			break;
		case 'N':
			//CTRL+NAVK쐬
			if(sh & CHK_CTRL) newtext();
			break;
		case VK_F1: //F1L[
			if(sh & CHK_SHIFT) newtext();//SHIFT+F1L[@VK쐬
			else{
				//t@Cǂݍ
				if(fileload()==0){ //t@CIēǂݍ
					//ǂݍ݂sꍇAJ[\ʒu擪
					cursor_top();
				}
			}
			break;
		case VK_F2: //F2L[
			if(num==0) break;
			if(sh & CHK_SHIFT) msra(); //create direct running file
			else save_as(0); //t@Ctĕۑ
			break;
		case VK_F3: //F3L[
			if(sh & CHK_SHIFT) changewidth(); //ʕ̐؂ւ
			break;
		case VK_F4: //F4L[
			if(num==0) break;
			if(sh & CHK_SHIFT) run(1); //RpCeXg
			else run(0); //RpCs
			break;
		case 'Z':
			//CTRL+ZAAhD
			if(sh & CHK_CTRL) undoexec();
			break;
	}
}
void texteditor(void){
//eLXgGfB^[{
	unsigned char k1,k2,sh;
	FSFILE *fp;

	editormallocp=RAM;
	TextBuffer=(_tbuf *)editormalloc(sizeof(_tbuf)*TBUFMAXLINE);
	clipboard=editormalloc(WIDTH_XMAX*EDITWIDTHY);
	filebuf=editormalloc(FILEBUFSIZE);
	cwdpath=editormalloc(PATHNAMEMAX);
	filenames=(unsigned char (*)[])editormalloc(MAXFILENUM*13);
	undobuf=editormalloc(UNDOBUFSIZE);

//	TextBuffer=(_tbuf *)RAM;
//	clipboard=(unsigned char *)TextBuffer+sizeof(_tbuf)*TBUFMAXLINE;
//	filebuf=clipboard+WIDTH_XMAX*EDITWIDTHY;
//	cwdpath=filebuf+FILEBUFSIZE;
//	filenames=(unsigned char (*)[])(cwdpath+PATHNAMEMAX);
//	undobuf=(unsigned char *)filenames+MAXFILENUM*13;

	inittextbuf(); //eLXgobt@
	currentfile[0]=0; //ƒt@CNA
	cwdpath[0]='\\'; //JgfBNg[gɐݒ
	cwdpath[1]=0;

	//sꎞt@Cꍇ͓ǂݍ
	fp=FSfopen(WORKDIRFILE,"r");
	if(fp!=NULL){
		FSfread(cwdpath,1,PATHNAMEMAX,fp);
		FSfclose(fp);
		FSchdir(cwdpath);
		if(loadtextfile(TEMPFILENAME)==0){
			edited=1;
			setcursorcolor(COLOR_ERRORTEXT);
			printstr("Temporary File Loaded\n");
			printstr("Current Directory is\n");
			setcursorcolor(COLOR_DIR);
			printstr(cwdpath);
			setcursorcolor(COLOR_ERRORTEXT);
			printstr("\nSave To SD Card If Necessary\n");
			setcursorcolor(COLOR_NORMALTEXT);
			printstr((unsigned char *)Message1); //Hit Any Key
			inputchar(); //1͑҂
		}
		else{
			cwdpath[0]='\\'; //JgfBNg[gɐݒ
			cwdpath[1]=0;
		}
	}
	cursor_top(); //J[\eLXgobt@̐擪Ɉړ
	insertmode=1; //0:㏑A1:}
	clipsize=0; //Nbv{[hNA
	blinktimer=0; //J[\_Ń^C}[NA

	while(1){
		redraw();//ʍĕ`
		setcursor(cx,cy,COLOR_NORMALTEXT);
		getcursorchar(); //J[\ʒu̕ޔiJ[\_ŗpj
		while(1){
			//L[͑҂[v
			wait60thsec(1);  //601bEFCg
			blinkcursorchar(); //J[\_ł
			k1=ps2readkey(); //L[obt@ǂݍ݁Ak1:ʏ핶͂̏ꍇASCIIR[h
			displaybottomline(); //ʍŉsɃt@NVL[@\\
			if(vkey) break;  //L[ꂽꍇ[v甲
			if(cursorbp1==NULL) gabagecollect1(); //1oCgKx[WRNVi͈͑I͂Ȃj
		}
		resetcursorchar(); //J[\̕\ɖ߂
		k2=(unsigned char)vkey; //k2:zL[R[h
		sh=vkey>>8;             //sh:Vtg֘AL[
		if(k2==VK_RETURN || k2==VK_SEPARATOR) k1='\n'; //Enter͒Pɉs͂Ƃ
		if(k1) normal_code_process(k1); //ʏ핶͂ꂽꍇ
		else control_code_process(k2,sh); //䕶͂ꂽꍇ
		if(cursorbp1!=NULL && cx==cx1 && cy==cy1) cursorbp1=NULL;//I͈͂̊JnƏIdȂ͈͑I[h
 	}
}
