package com.mxmobiling.kitting;
import java.awt.Container;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Pattern;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.xml.serializer.OutputPropertiesFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

class WebClipGUI_CPAVer2 extends JFrame implements ActionListener {

	private static final long serialVersionUID = 1L;

	private String displayName = ""; // プロファイル名
	private String description = ""; // プロファイルの説明
	private String identifier = ""; // プロファイルの識別子
	private Boolean deleteProfile = false; // プロファイル削除可否
	private static final String POSSIBLE_DELETE = "常に確認";
	private static final String AUTH_POSSIBLE_DELETE = "認証";
	// private static final String IMPOSSIBLE_DELETE = "しない";
	private JTextField profileExport;

	private int params = 0;// プロファイル数カウント

	private static final String APPTITLE = "CPA接続プロファイル作成ツール　Ver 2.0.0";
	private JTextField csvInputText;

	public static void main(String args[]) {
		WebClipGUI_CPAVer2 frame = new WebClipGUI_CPAVer2(APPTITLE);
		frame.setVisible(true);
		frame.setResizable(false);
		frame.setLocationRelativeTo(null);
	}

	WebClipGUI_CPAVer2(String title) {
		setTitle(title);
		setSize(560, 260);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		// アイコンファイルの読み込み
		String iconFileName = "img/icon.png";
		URL iconUrl = this.getClass().getClassLoader()
				.getResource(iconFileName);

		Image icon = (iconUrl != null) ? new ImageIcon(iconUrl).getImage()
				: new ImageIcon(iconFileName).getImage();
		setIconImage(icon);

		@SuppressWarnings("unused")
		Container contentPane = getContentPane();
		getContentPane().setLayout(null);

		/* ---------- ↓アプリタイトル名ラベル↓ ---------- */

		JLabel appTitleLabel = new JLabel(APPTITLE);
		appTitleLabel.setFont(new Font("ＭＳ Ｐゴシック", Font.BOLD, 22));
		appTitleLabel.setBounds(12, 10, 446, 42);
		getContentPane().add(appTitleLabel);

		JLabel paramLabel = new JLabel("※＝必須パラメータ");
		paramLabel.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		paramLabel.setBounds(410, 62, 122, 13);
		getContentPane().add(paramLabel);

		JLabel csvInputLabel = new JLabel("※CSV読み込み先");
		csvInputLabel.setBounds(12, 94, 136, 13);
		getContentPane().add(csvInputLabel);
		csvInputLabel.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));

		csvInputText = new JTextField(43);
		csvInputText.setBounds(185, 86, 273, 30);
		getContentPane().add(csvInputText);

		JButton csvInputButton = new JButton("参照");
		csvInputButton.setBounds(467, 85, 65, 30);
		getContentPane().add(csvInputButton);
		csvInputButton.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		csvInputButton.setActionCommand("CSV読み込み");

		JLabel profileExportLabel = new JLabel("※プロファイル保存先");
		profileExportLabel.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		profileExportLabel.setBounds(12, 126, 136, 30);
		getContentPane().add(profileExportLabel);
		profileExport = new JTextField(43);
		profileExport.setBounds(185, 127, 273, 30);
		getContentPane().add(profileExport);
		JButton profileExportBtn = new JButton("参照");
		profileExportBtn.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		profileExportBtn.setBounds(467, 126, 65, 30);
		getContentPane().add(profileExportBtn);
		profileExportBtn.setActionCommand("プロファイル保存先");

		JButton profileCreateBtn = new JButton("プロファイル作成");
		profileCreateBtn.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 15));
		profileCreateBtn.setBounds(72, 177, 400, 30);
		getContentPane().add(profileCreateBtn);
		profileCreateBtn.setActionCommand("プロファイル作成");

		/* ---------- ↑下部共通設定部分↑ ---------- */

		csvInputButton.addActionListener(this); // CSV読み込み先参照ボタン
		profileExportBtn.addActionListener(this); // プロファイル保存先フォルダ参照ボタン
		profileCreateBtn.addActionListener(this); // プロファイル作成ボタン
	}

	public void actionPerformed(ActionEvent e) {
		String str = e.getActionCommand();

		File file = null;
		JFileChooser filechooser = new JFileChooser();

		if (str.equals("CSV読み込み")) {
			FileNameExtensionFilter filter = new FileNameExtensionFilter(
					"CSVファイル(*.csv)", "csv");
			filechooser.addChoosableFileFilter(filter);
			// filechooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
			// filechooser.setAcceptAllFileFilterUsed(false);
			int selected = filechooser.showOpenDialog(this);
			file = filechooser.getSelectedFile();

			if (selected == JFileChooser.APPROVE_OPTION) {
				csvInputText.setText(file.getPath());
			}
		} else if (str.equals("プロファイル保存先")) {
			filechooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
			int selected = filechooser.showOpenDialog(this);
			file = filechooser.getSelectedFile();

			if (selected == JFileChooser.APPROVE_OPTION) {
				profileExport.setText(file.getPath());
			}
		} else if (str.equals("プロファイル作成")) {
			// エラー処理

			if (csvInputText.getText().equals("")) {
				JLabel label = new JLabel("CSV読み込み先を指定してください");
				JOptionPane.showMessageDialog(this, label);
				return;
			}

			try {
				// プロファイル作成
				wepclipProfileCreate(csvInputText.getText());

				// 完了ダイアログ
				JLabel label = new JLabel("プロファイル作成完了！！【" + params + "件】");

				// プロファイル数カウントのクリア
				params = 0;
				JOptionPane.showMessageDialog(this, label);
			} catch (ParserConfigurationException e1) {
				e1.printStackTrace();
			} catch (FileNotFoundException e1) {
				e1.printStackTrace();
				JLabel error = new JLabel("存在しないフォルダが指定されています。");
				JOptionPane.showMessageDialog(this, error);
			} catch (InterruptedException e1) {
				e1.printStackTrace();
			} catch (TransformerException e1) {
				e1.printStackTrace();
			} catch (IOException e1) {
				e1.printStackTrace();
			}
		}
	}

	// 構成プロファイル生成
	private void wepclipProfileCreate(String fileName)
			throws ParserConfigurationException, FileNotFoundException,
			IOException, InterruptedException, TransformerException {

		Pattern pattern = Pattern.compile(",");
		ArrayList<String> colmuns = new ArrayList<String>();
		File csv = new File(fileName); // CSVデータファイル
		BufferedReader br = new BufferedReader(new FileReader(csv));

		// 一行目(ヘッダ行)を読み飛ばす
		br.readLine();

		// 最終行まで読み込む
		String line = "";

		while (br.ready()) {
			// リストのクリア
			colmuns.clear();

			// 1行分データを取得
			line = br.readLine();

			// 文字列の分割(split「-1」を指定で空白も読み込む)
			String[] strs = pattern.split(line, -1);

			// リストへの代入
			for (int i = 0; i < strs.length; i++) {
				colmuns.add(strs[i]);
			}

			// 構成プロファイルの吐き出し先
			String exportFileName = profileExport.getText() + "\\"
					+ String.valueOf(colmuns.get(0)) + ".mobileconfig";

			// 構成プロファイルを生成する
			// DOM Documentのインスタンスを生成するBuilderクラスの
			// インスタンスを取得する
			DocumentBuilderFactory factory = DocumentBuilderFactory
					.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			// ビルダーからDOMを取得する
			Document document = builder.newDocument();

			// root(plist)タグ
			Element plist = document.createElement("plist");
			plist.setAttribute("version", "1.0");
			document.appendChild(plist);

			// dictタグ
			Element dict = document.createElement("dict");
			plist.appendChild(dict);

			// plistタグのパラメータ
			TransformerFactory transFactory = TransformerFactory.newInstance();
			Transformer transformer = transFactory.newTransformer();
			transformer.setOutputProperty(OutputKeys.INDENT, "yes");
			transformer.setOutputProperty(
					OutputPropertiesFactory.S_KEY_INDENT_AMOUNT, "2");
			transformer.setOutputProperty(OutputKeys.METHOD, "xml");
			transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
			transformer.setOutputProperty(OutputKeys.DOCTYPE_PUBLIC,
					"-//Apple//DTD PLIST 1.0//EN");
			transformer.setOutputProperty(OutputKeys.DOCTYPE_SYSTEM,
					"http://www.apple.com/DTDs/PropertyList-1.0.dtd");

			/* ------ 以下、構成プロファイルの中身 ------------ */

			/*
			 * PayloadContent
			 * 
			 * ペイロードされるパラメータ
			 */
			Element PayloadContentKey = document.createElement("key");
			dict.appendChild(PayloadContentKey);

			Text PayloadContentParam = document
					.createTextNode("PayloadContent");
			PayloadContentKey.appendChild(PayloadContentParam);

			Element PayloadContentArray = document.createElement("array");
			dict.appendChild(PayloadContentArray);

			Common common = new Common();

			/* ---------- CPA設定パラメータここから ---------- */

			CPA cpa = new CPA();

			if (true) {
				Element PayloadContentDict = document.createElement("dict");
				PayloadContentArray.appendChild(PayloadContentDict);

				cpa.CPAPayloadContent(PayloadContentDict, document,
						colmuns.get(6), colmuns.get(8), colmuns.get(7));

				common.PayloadDescription(PayloadContentDict, document,
						Common.STRING,
						"Provides customization of carrier Access Point Name.");

				common.PayloadDisplayName(PayloadContentDict, document,
						Common.STRING, "Advanced Settings");

				common.PayloadIdentifier(PayloadContentDict, document,
						Common.STRING, String.valueOf(colmuns.get(1)));

				common.PayloadOrganization(PayloadContentDict, document,
						Common.STRING, colmuns.get(2));

				common.PayloadType(PayloadContentDict, document, WiFi.STRING,
						"com.apple.apn.managed");

				common.PayloadUUID(PayloadContentDict, document, Common.STRING);

				common.PayloadVersion(PayloadContentDict, document,
						Common.INTEGER, "1");
			}

			/* ---------- CPA設定パラメータここまで ---------- */

			/* ---------- プロファイル削除パラメータここから ---------- */

			RemovalPassword removalPassword = new RemovalPassword();

			// プロファイル削除可否判定
			if (POSSIBLE_DELETE.equals(colmuns.get(4))) {
				deleteProfile = false;
			} else {
				deleteProfile = true;
			}

			// プロファイルのセキュリティが「認証」の場合のみ
			if (colmuns.get(4).equals(AUTH_POSSIBLE_DELETE)) {
				Element PayloadContentDict = document.createElement("dict");
				PayloadContentArray.appendChild(PayloadContentDict);

				common.PayloadDescription(PayloadContentDict, document,
						Common.STRING, "");

				common.PayloadDisplayName(PayloadContentDict, document,
						Common.STRING, "");

				// プロファイルの識別子
				identifier = colmuns.get(1);
				common.PayloadIdentifier(PayloadContentDict, document,
						Common.STRING, identifier);

				common.PayloadOrganization(PayloadContentDict, document,
						Common.STRING, colmuns.get(2));

				common.PayloadType(PayloadContentDict, document, Common.STRING,
						"com.apple.profileRemovalPassword");

				common.PayloadUUID(PayloadContentDict, document, Common.STRING);

				common.PayloadVersion(PayloadContentDict, document,
						Common.INTEGER, "1");

				removalPassword.profileRemovalPassword(PayloadContentDict,
						document, RemovalPassword.STRING, colmuns.get(5));

			}

			/* ---------- プロファイル削除パラメータここまで ---------- */

			// プロファイルの説明
			description = colmuns.get(3);
			common.PayloadDescription(dict, document, Common.STRING,
					description);

			// プロファイル名に電話番号（または指定のプロファイル名）がつく
			displayName = colmuns.get(0);
			// プロファイル名がついていない場合は自動的に名前をつける
			if (displayName.equals("")) {
				displayName = "WebClip";
			}
			common.PayloadDisplayName(dict, document, Common.STRING,
					displayName);

			// プロファイルの識別子
			identifier = colmuns.get(1);
			common.PayloadIdentifier(dict, document, Common.STRING, identifier);

			common.PayloadOrganization(dict, document, Common.STRING,
					colmuns.get(2));

			common.PayloadRemovalDisallowed(dict, document, deleteProfile);

			common.PayloadType(dict, document, Common.STRING, "Configuration");

			common.PayloadUUID(dict, document, Common.STRING);

			common.PayloadVersion(dict, document, Common.INTEGER, "1");

			/* ------ 以上、構成プロファイルの中身 ------------ */

			DOMSource source = new DOMSource(document);
			File newXML = new File(exportFileName);
			FileOutputStream os = new FileOutputStream(newXML);
			StreamResult result = new StreamResult(os);
			transformer.transform(source, result);
			os.close();

			// プロファイル数のインクリメント
			params++;

		}
		br.close();
	}
}