package com.mxmobiling.kitting;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.xml.serializer.OutputPropertiesFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
/**
 * 旧Verです。使用していません。
 */
class WebClipGUI extends JFrame implements ActionListener {

	private static final long serialVersionUID = 1L;

	private String displayName = ""; // プロファイル名
	private String description = ""; // プロファイルの説明
	private Boolean deleteProfile = false; // プロファイル削除可否

	private JTextField displayNameText;
	private JTextField descriptionText;
	private JTextField csvExport;
	private JTextField profileExport;

	private static final String APPTITLE = "入力支援Webクリップ作成ツール　Ver 1.1.0";

	public static void main(String args[]) {
		WebClipGUI frame = new WebClipGUI(APPTITLE);
		frame.setVisible(true);
		frame.setResizable(false);
		frame.setLocationRelativeTo(null);
	}

	WebClipGUI(String title) {
		setTitle(title);
		setSize(700, 300);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		// アイコンファイルの読み込み
		String iconFileName = "img/icon.png";
		URL iconUrl = this.getClass().getClassLoader()
				.getResource(iconFileName);

		Image icon = (iconUrl != null) ? new ImageIcon(iconUrl).getImage()
				: new ImageIcon(iconFileName).getImage();
		setIconImage(icon);

		setLayout(new FlowLayout());

		JPanel p1 = new JPanel();
		p1.setPreferredSize(new Dimension(650, 50));
		p1.setLayout(new BorderLayout());

		JPanel displayNamePanel = new JPanel();
		displayNamePanel.setPreferredSize(new Dimension(650, 30));
		displayNamePanel.setLayout(new BorderLayout());

		JPanel descriptionPanel = new JPanel();
		descriptionPanel.setPreferredSize(new Dimension(650, 30));
		descriptionPanel.setLayout(new BorderLayout());

		JPanel p2 = new JPanel();
		p2.setPreferredSize(new Dimension(650, 30));
		p2.setLayout(new BorderLayout());

		JPanel p3 = new JPanel();
		p3.setPreferredSize(new Dimension(650, 30));
		p3.setLayout(new BorderLayout());

		JPanel p4 = new JPanel();
		p4.setPreferredSize(new Dimension(650, 30));
		p4.setLayout(new BorderLayout());

		JLabel titleLabel = new JLabel(APPTITLE);
		titleLabel.setPreferredSize(new Dimension(40, 40));

		JLabel displayNameLabel = new JLabel("　　プロファイル名");

		JLabel descriptionLabel = new JLabel("プロファイルの説明");

		JLabel label1 = new JLabel("　ＣＳＶ読み込み先");

		JLabel label2 = new JLabel("プロファイル保存先");

		displayNameText = new JTextField(50);
		descriptionText = new JTextField(50);
		csvExport = new JTextField(43);
		profileExport = new JTextField(43);

		JButton button = new JButton("参照");
		button.setActionCommand("参照１");
		button.addActionListener(this);

		JButton button2 = new JButton("参照");
		button2.setActionCommand("参照２");
		button2.addActionListener(this);

		JButton button3 = new JButton("プロファイル作成");
		button3.setActionCommand("プロファイル作成");
		button3.addActionListener(this);

		p1.add(titleLabel, BorderLayout.CENTER);

		displayNamePanel.add(displayNameLabel, BorderLayout.WEST);
		displayNamePanel.add(displayNameText, BorderLayout.CENTER);

		descriptionPanel.add(descriptionLabel, BorderLayout.WEST);
		descriptionPanel.add(descriptionText, BorderLayout.CENTER);

		p2.add(label1, BorderLayout.WEST);
		p2.add(csvExport, BorderLayout.CENTER);
		p2.add(button, BorderLayout.EAST);

		p3.add(label2, BorderLayout.WEST);
		p3.add(profileExport, BorderLayout.CENTER);
		p3.add(button2, BorderLayout.EAST);

		p4.add(button3, BorderLayout.CENTER);

		Container contentPane = getContentPane();
		contentPane.add(p1, BorderLayout.NORTH);
		contentPane.add(displayNamePanel, BorderLayout.NORTH);
		contentPane.add(descriptionPanel, BorderLayout.NORTH);
		contentPane.add(p2, BorderLayout.CENTER);
		contentPane.add(p3, BorderLayout.SOUTH);
		contentPane.add(p4, BorderLayout.NORTH);
	}

	public WebClipGUI() {
	}

	public void actionPerformed(ActionEvent e) {
		String str = e.getActionCommand();

		File file = null;
		JFileChooser filechooser = new JFileChooser();

		if (str.equals("参照１")) {
			FileNameExtensionFilter filter = new FileNameExtensionFilter(
					"CSVファイル(*.csv)", "csv");
			filechooser.addChoosableFileFilter(filter);
			// filechooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
			// filechooser.setAcceptAllFileFilterUsed(false);
			int selected = filechooser.showOpenDialog(this);
			file = filechooser.getSelectedFile();

			if (selected == JFileChooser.APPROVE_OPTION) {
				csvExport.setText(file.getPath());
			}
		} else if (str.equals("参照２")) {
			filechooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
			int selected = filechooser.showOpenDialog(this);
			file = filechooser.getSelectedFile();

			if (selected == JFileChooser.APPROVE_OPTION) {
				profileExport.setText(file.getPath());
			}
		} else if (str.equals("プロファイル作成")) {
			try {
				wepclipProfileCreate();
				JLabel label = new JLabel("プロファイル作成完了！！");
				JOptionPane.showMessageDialog(this, label);
			} catch (ParserConfigurationException e1) {
				e1.printStackTrace();
			} catch (FileNotFoundException e1) {
				JLabel error = new JLabel("存在しないフォルダが指定されています。");
				JOptionPane.showMessageDialog(this, error);
			} catch (InterruptedException e1) {
				e1.printStackTrace();
			} catch (TransformerException e1) {
				e1.printStackTrace();
			} catch (IOException e1) {
				e1.printStackTrace();
			}
		}

	}

	// 構成プロファイル生成
	private void wepclipProfileCreate() throws ParserConfigurationException,
			IOException, InterruptedException, TransformerException {

		// CSVファイルの読み込み
		String URL = JavascriptCreate(csvExport.getText());

		// 画像ファイル1(ブランク用画像)の読み込み
		// String imgName1 = "C:\\WebClip\\img\\icon1.png";
		// String imgName1 = "./img/icon1.png";
		String imgName1 = "img/icon1.png";

		// 画像ファイル2(本体用画像)の読み込み
		// String imgName2 = "C:\\WebClip\\img\\icon2.png";
		String imgName2 = "img/icon2.png";

		// 一意のファイル名を作り出すための時間生成
		String nowTime = String.valueOf(System.currentTimeMillis());

		// 構成プロファイルの吐き出し先
		String exportFileName = profileExport.getText() + "\\" + nowTime
				+ ".mobileconfig";

		// 構成プロファイルを生成する

		// DOM Documentのインスタンスを生成するBuilderクラスの
		// インスタンスを取得する
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = factory.newDocumentBuilder();
		// ビルダーからDOMを取得する
		Document document = builder.newDocument();

		// root(plist)タグ
		Element plist = document.createElement("plist");
		plist.setAttribute("version", "1.0");
		document.appendChild(plist);

		// dictタグ
		Element dict = document.createElement("dict");
		plist.appendChild(dict);

		// plistタグのパラメータ
		TransformerFactory transFactory = TransformerFactory.newInstance();
		Transformer transformer = transFactory.newTransformer();
		transformer.setOutputProperty(OutputKeys.INDENT, "yes");
		transformer.setOutputProperty(
				OutputPropertiesFactory.S_KEY_INDENT_AMOUNT, "2");
		transformer.setOutputProperty(OutputKeys.METHOD, "xml");
		transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
		transformer.setOutputProperty(OutputKeys.DOCTYPE_PUBLIC,
				"-//Apple//DTD PLIST 1.0//EN");
		transformer.setOutputProperty(OutputKeys.DOCTYPE_SYSTEM,
				"http://www.apple.com/DTDs/PropertyList-1.0.dtd");

		/* ------ 以下、構成プロファイルの中身 ------------ */

		/*
		 * PayloadContent
		 *
		 * ペイロードされるパラメータ
		 */
		Element PayloadContentKey = document.createElement("key");
		dict.appendChild(PayloadContentKey);

		Text PayloadContentParam = document.createTextNode("PayloadContent");
		PayloadContentKey.appendChild(PayloadContentParam);

		Element PayloadContentArray = document.createElement("array");
		dict.appendChild(PayloadContentArray);

		Element PayloadContentDict = document.createElement("dict");
		PayloadContentArray.appendChild(PayloadContentDict);

		/* ---------- Webclip設定パラメータ1ここから ---------- */

		Common common = new Common();
		WebClip webClip = new WebClip();

		webClip.WebcilpIsRemovable(PayloadContentDict, document, true);

		String label = "手順１";
		webClip.WebclipLabel(PayloadContentDict, document, WebClip.STRING,
				label);

		webClip.WebclipIcon(PayloadContentDict, document, "data", imgName1);

		String webDescription = "Webclip用プロファイル1";
		common.PayloadDescription(PayloadContentDict, document, Common.STRING,
				webDescription);

		String webDisplayName = "Sample WebclipM1";
		common.PayloadDisplayName(PayloadContentDict, document, Common.STRING,
				webDisplayName);

		common.PayloadIdentifier(PayloadContentDict, document, Common.STRING,
				"jp.mobiling.auto.webclip2");

		String webCompanyName = "Nモバ";
		common.PayloadOrganization(PayloadContentDict, document, Common.STRING,
				webCompanyName);

		common.PayloadType(PayloadContentDict, document, Common.STRING,
				"com.apple.webClip.managed");

		common.PayloadUUID(PayloadContentDict, document, Common.STRING);

		common.PayloadVersion(PayloadContentDict, document, Common.INTEGER, "1");

		webClip.WebclipURL(PayloadContentDict, document, WebClip.STRING,
				"about:blank");

		/* ---------- Webclip設定パラメータ1ここまで ---------- */

		Element PayloadContentDict2 = document.createElement("dict");
		PayloadContentArray.appendChild(PayloadContentDict2);

		/* ---------- Webclip設定パラメータ2ここから ---------- */

		webClip.WebcilpIsRemovable(PayloadContentDict2, document, true);

		String label2 = "手順２";
		webClip.WebclipLabel(PayloadContentDict2, document, WebClip.STRING,
				label2);

		webClip.WebclipIcon(PayloadContentDict2, document, "data", imgName2);

		String webDescription2 = "Webclip用プロファイル2";
		common.PayloadDescription(PayloadContentDict2, document, Common.STRING,
				webDescription2);

		String webDisplayName2 = "Sample WebclipM1";
		common.PayloadDisplayName(PayloadContentDict2, document, Common.STRING,
				webDisplayName2);

		common.PayloadIdentifier(PayloadContentDict2, document, Common.STRING,
				"jp.mobiling.auto.webclip2");

		String webCompanyName2 = "Nモバ";
		common.PayloadOrganization(PayloadContentDict2, document,
				Common.STRING, webCompanyName2);

		common.PayloadType(PayloadContentDict2, document, Common.STRING,
				"com.apple.webClip.managed");

		common.PayloadUUID(PayloadContentDict2, document, Common.STRING);

		common.PayloadVersion(PayloadContentDict2, document, Common.INTEGER,
				"1");

		webClip.WebclipURL(PayloadContentDict2, document, WebClip.STRING, URL);

		/* ---------- Webclip設定パラメータ2ここまで ---------- */

		description = descriptionText.getText();
		common.PayloadDescription(dict, document, Common.STRING, description);

		displayName = displayNameText.getText();
		// プロファイル名がついていない場合は自動的に名前をつける
		if (displayName.equals("")) {
			displayName = "WebClip";
		}
		common.PayloadDisplayName(dict, document, Common.STRING, displayName);

		common.PayloadIdentifier(dict, document, Common.STRING,
				"jp.mobiling.auto");

		common.PayloadOrganization(dict, document, Common.STRING,
				"NEC Mobiling");

		common.PayloadRemovalDisallowed(dict, document, deleteProfile);

		common.PayloadType(dict, document, Common.STRING, "Configuration");

		common.PayloadUUID(dict, document, Common.STRING);

		common.PayloadVersion(dict, document, Common.INTEGER, "1");

		/* ------ 以上、構成プロファイルの中身 ------------ */

		DOMSource source = new DOMSource(document);
		File newXML = new File(exportFileName);
		FileOutputStream os = new FileOutputStream(newXML);
		StreamResult result = new StreamResult(os);
		transformer.transform(source, result);
		os.close();
	}

	// CSVファイル読み込み
	public List<String> csvRead(String fileName) {
		List<String> colmuns = new ArrayList<String>();
		try {
			File csv = new File(fileName); // CSVデータファイル

			BufferedReader br = new BufferedReader(new FileReader(csv));

			// CSV行数カウント
			int i = 0;

			// 最終行まで読み込む
			String line = "";
			while ((line = br.readLine()) != null) {

				// 1行をデータの要素に分割
				StringTokenizer st = new StringTokenizer(line, ",");
				while (st.hasMoreTokens()) {
					// 1行の各要素をArrayListに代入
					colmuns.add(st.nextToken());
				}
				i++;
			}
			br.close();

			// ヘッダ行（1行目）を削除
			i = colmuns.size() / i;
			while (i != 0) {
				colmuns.remove(0);
				i--;
			}

		} catch (FileNotFoundException e) {
			// Fileオブジェクト生成時の例外捕捉
			e.printStackTrace();
		} catch (IOException e) {
			// BufferedReaderオブジェクトのクローズ時の例外捕捉
			e.printStackTrace();
		}
		return colmuns;
	}

	// CSVを読み込み、Javascript生成
	public String JavascriptCreate(String fileName) throws IOException {
		File csv = new File(fileName); // CSVデータファイル
		// CSV行数カウント
		int csvLines = 0;

		// テキスト番号(id)振り
		int count = 1;

		// 1行のデータ数カウント
		int dataConut = 0;

		String top = "";
		String middle = "";
		String bottom = "";

		String search = "";

		String label = "";

		String html = "";

		top = "javascript:document.open();document.write('<head><meta name=\"viewport\" content=\"width=device-width, initial-scale=1, maximum-scale=1\"><title>InputWebClip</title><script type=\"text/javascript\">function search(){var searchKey = document.getElementById(\"searchText\").value;";
		middle = "}</script></head><body><form><label>%E6%A4%9C%E7%B4%A2</label><br><input type =\"text\" value =\"\" id =\"searchText\"><input type =\"button\" value =\"push\" onclick =\"search();\"><HR>";
		bottom = "</form></body>');document.close();";

		// CSVからパラメータを読み込み、javascriptへ書き込み

		BufferedReader br = new BufferedReader(new FileReader(csv));

		// 最終行まで読み込む
		String line = "";

		// 1行目をラベルに使用するため、配列に格納する準備
		List<String> header = new ArrayList<String>();

		// 1行目を読み込む
		line = br.readLine();

		// 1行をデータの要素に分割
		StringTokenizer fst = new StringTokenizer(line, ",");
		// 1列目を読み飛ばす
		fst.nextToken();

		// 2列目以降を読み込む
		while (fst.hasMoreTokens()) {
			// 1行のパラメータをjavascriptへ直接書き込む
			String ftmp = fst.nextToken();

			// 日本語対応のため、取り込む文字列をURLエンコード
			ftmp = URLEncoder.encode(ftmp, "UTF-8");

			// そのままURLエンコードをかけると、半角スペースが「+」になるため、事後に変換
			ftmp = ftmp.replace("+", " ");

			// リストにヘッダー行を格納
			header.add(ftmp);
		}

		// 1行ずつ読んでいく
		while ((line = br.readLine()) != null) {

			// 1行をデータの要素に分割
			StringTokenizer st = new StringTokenizer(line, ",");

			// 1行のパラメータをjavascriptへ直接書き込む
			String tmp1 = st.nextToken();

			// 日本語対応のため、取り込む文字列をURLエンコード
			tmp1 = URLEncoder.encode(tmp1, "UTF-8");

			// そのままURLエンコードをかけると、半角スペースが「+」になるため、事後に変換
			tmp1 = tmp1.replace("+", " ");

			// はじめに1列目を読み込んでおく（検索キー）
			if (csvLines == 0) {
				search += "if(searchKey == " + tmp1 + "){";
			} else {
				search += "else if(searchKey == " + tmp1 + "){";
			}

			// 2列目以降を読み込む
			while (st.hasMoreTokens()) {
				// 1行のパラメータをjavascriptへ直接書き込む
				String tmp2 = st.nextToken();

				// 日本語対応のため、取り込む文字列をURLエンコード
				tmp2 = URLEncoder.encode(tmp2, "UTF-8");

				// そのままURLエンコードをかけると、半角スペースが「+」になるため、事後に変換
				tmp2 = tmp2.replace("+", " ");

				search += "document.getElementById(\"text" + count
						+ "\").value=\"" + tmp2 + "\";";
				count++;
			}
			search += "}";
			// 1列完了するごとにインクリメント（行数カウント）
			csvLines++;

			// データ数算出
			dataConut = count - 1;

			// 次の行で1からカウントするためクリア
			count = 1;
		}

		// else文で検索キーに含まれないものの場合削除
		search += "else{";
		for (int i = 0; i < dataConut; i++) {
			search += "document.getElementById(\"text" + (i + 1)
					+ "\").value=\"\";";
		}
		search += "}";
		br.close();

		// ラベルの作成
		for (int i = 0; i < dataConut; i++) {
			label += "<label>"
					+ (i + 1)
					+ "%ef%bc%9a" // URLエンコードで「：」を変換したもの
					+ header.get(i)
					+ "</label><br><input type =\"text\" value =\"\" id =\"text"
					+ (i + 1) + "\"><br>";
		}

		// 生成したすべての文字列を1つの文字列とする
		html = top + search + middle + label + bottom;

		// 禁止文字の置き換え
		html = html.replace("<", "%3C");
		html = html.replace(">", "%3E");
		html = html.replace("\"", "%22");
		html = html.replace("[", "%5B");
		html = html.replace("]", "%5D");
		html = html.replace("{", "%7B");
		html = html.replace("}", "%7D");
		html = html.replace(" ", "%20");
		html = html.replace("?", "");

		return html;
	}
}