﻿Imports Microsoft.Office.Interop

Public Class Main

    Dim DtNewAppleID As New DataTable  '申し込み用AppleIDデータテーブル

    'ファイル読み込みボタン
    'すべてを初期化する  
    Private Sub btnChoiceFile_Click(sender As System.Object, e As System.EventArgs) Handles btnChoiceFile.Click
        'ファイルオープンダイアログ表示
        If OpenFileDialog1.ShowDialog() = DialogResult.OK Then
            TxtFilePath.Text = OpenFileDialog1.FileName
            BtnOutput.Enabled = True
            'BtnRun.Enabled = True
            ' BtnRun.Text = "開始"
        Else
            Exit Sub
        End If

        'ファイルをセパレートで一度全部読み込み、データセットへ展開する
        'データテーブルチェック
        If DtNewAppleID.TableName <> "NewEntryAppleID" Then
            DtNewAppleID = NewAppleIDtype()
        Else
            DtNewAppleID.Rows.Clear()  '内容全消去
        End If
        'EXCEL読込用画面ロード
        Dim FormProg As New FrmReadFileProgress
        '表示位置指定
        FormProg.Top = Me.Top + Me.Height / 2 '+ FormProg.Height / 2
        FormProg.Left = Me.Left + (Me.Width - FormProg.Width) / 2
        '公開プロパティに設定
        FormProg.ArgPath = TxtFilePath.Text
        FormProg.ArgDt = DtNewAppleID
        '画面をモーダルで表示
        FormProg.ShowDialog()
        'マルチスレッド開始
        DtNewAppleID = FormProg.ArgDt.Copy
        '画面を消す
        FormProg.Dispose()
        'ReadXLSFiles(TxtFilePath.Text, DtNewAppleID)

        If DtNewAppleID.Rows.Count > 0 Then
            '申込書データグリッド展開
            DGAppleID.DataSource = DtNewAppleID
            PnlAppleIDList.Visible = True
            'AppleID取得グリッド展開
            DGAppleIDDisp.DataSource = DtNewAppleID
            PnlDGAppleIDList.Visible = True
            PnlGetControl.Visible = True
        End If
        DGAppleID_Grid_setting()
        DGAppleIDDisp_Grid_Setting()
    End Sub

    Private Sub DGAppleIDDisp_Grid_Setting()
        '各カラムに対して幅を指定する
        For Each c As DataGridViewColumn In DGAppleIDDisp.Columns
            Select Case c.Index
                Case 0 '項番
                    c.Width = 30
                    'c.HeaderText = "項番"
                Case 1
                    c.HeaderText = "AppleID"
                    c.Width = 180
                Case 2
                    c.HeaderText = "パスワード"
                    c.Width = 180
                Case 3
                    c.HeaderText = "質問1"
                Case 4
                    c.HeaderText = "回答1"
                Case 5
                    c.HeaderText = "質問2"
                Case 6
                    c.HeaderText = "回答2"
                Case 7
                    c.HeaderText = "質問3"
                Case 8
                    c.HeaderText = "回答3"
                Case 9
                    c.HeaderText = "生年月日"
                Case 10
                    'c.HeaderText = "回答1"
                    c.Width = 75
                Case 11
                    c.HeaderText = "姓"
                Case 12
                    c.HeaderText = "名"
                Case 13
                    c.HeaderText = "せい"
                Case 14
                    c.HeaderText = "めい"
                Case 15
                    c.HeaderText = "郵便番号"
                    c.Width = 85
                Case 16
                    c.HeaderText = "都道府県"
                    c.Width = 85
                Case 17
                    c.HeaderText = "市区町村"
                Case 18
                    c.HeaderText = "住所"
                Case 19
                    c.HeaderText = "電話番号"
                Case 20
                    c.HeaderText = "終1"
                    c.Width = 55
                Case 21
                    c.HeaderText = "終2"
                    c.Width = 55
                Case 22
                    c.HeaderText = "取得時刻"
            End Select
        Next

    End Sub

    Private Sub DGAppleID_Grid_setting()
        '各カラムに対して幅を指定する
        For Each c As DataGridViewColumn In DGAppleID.Columns
            Select Case c.Index
                Case 0 '項番
                    c.Width = 30
                    'c.HeaderText = "項番"
                Case 1
                    c.HeaderText = "AppleID"
                    c.Width = 180
                Case 2
                    c.HeaderText = "パスワード"
                    c.Width = 180
                Case 3
                    c.HeaderText = "質問1"
                Case 4
                    c.HeaderText = "回答1"
                Case 5
                    c.HeaderText = "質問2"
                Case 6
                    c.HeaderText = "回答2"
                Case 7
                    c.HeaderText = "質問3"
                Case 8
                    c.HeaderText = "回答3"
                Case 9
                    c.HeaderText = "生年月日"
                Case 10
                    'c.HeaderText = "回答1"
                    c.Width = 75
                Case 11
                    c.HeaderText = "姓"
                Case 12
                    c.HeaderText = "名"
                Case 13
                    c.HeaderText = "せい"
                Case 14
                    c.HeaderText = "めい"
                Case 15
                    c.HeaderText = "郵便番号"
                Case 16
                    c.HeaderText = "都道府県"
                Case 17
                    c.HeaderText = "市区町村"
                Case 18
                    c.HeaderText = "住所"
                Case 19
                    c.HeaderText = "電話番号"
                Case 20
                    c.HeaderText = "終1"
                    c.Width = 55
                Case 21
                    c.HeaderText = "終2"
                    c.Width = 55
                Case 22
                    c.HeaderText = "取得時刻"
            End Select
        Next

    End Sub

    ''指定パスからXLSファイルを読込データセットに展開する
    'Private Sub ReadXLSFiles(ByVal ArgPath As String, ByRef ArgDt As DataTable)
    '    Const SHEET_NAME As String = "電話番号リスト"
    '    Const PHONE_NUMBER_TITLE_ROW As Integer = 5
    '    Const PHONE_NUMBER As Integer = 2
    '    Const APPLEID As Integer = 94
    '    Const APPLEID_PWD As Integer = 95
    '    Const Q1 As Integer = 96
    '    Const A1 As Integer = 97
    '    Const Q2 As Integer = 98
    '    Const A2 As Integer = 99
    '    Const Q3 As Integer = 100
    '    Const A3 As Integer = 101
    '    Const BIRTH_DAY As Integer = 102
    '    Const DM As Integer = 103
    '    Const SEI_KANJI As Integer = 104
    '    Const MEI_KANJI As Integer = 105
    '    Const SEI_FURI As Integer = 106
    '    Const MEI_FURI As Integer = 107
    '    Const POST As Integer = 108
    '    Const PROF As Integer = 109
    '    Const CITY As Integer = 110
    '    Const ADDRESS As Integer = 111
    '    Const TEL As Integer = 112

    '    Try

    '        Dim xlApplication As New Excel.Application()
    '        Dim xlBooks As Excel.Workbooks
    '        Dim xlBook As Excel.Workbook
    '        Dim xlSheet As Excel.Worksheet
    '        Dim cnt As Integer = 0
    '        Dim DrAppleID As DataRow
    '        Dim wkBirthDay As Date

    '        xlBooks = xlApplication.Workbooks
    '        xlBook = xlBooks.Open(ArgPath)

    '        '開いたか確認
    '        If IsNothing(xlBooks) Then
    '            Exit Sub
    '        End If
    '        'エクセルを表示する
    '        xlBook.Application.Visible = False
    '        'xlBook.Application.Visible = True
    '        '         xlBook.Activate()

    '        xlSheet = xlBook.Worksheets(SHEET_NAME)
    '        'ループ開始（電番が空白になるまで）
    '        cnt = PHONE_NUMBER_TITLE_ROW
    '        Do While xlSheet.Cells(cnt, PHONE_NUMBER).value <> ""
    '            'データテーブルに１行追加
    '            DrAppleID = ArgDt.NewRow
    '            '申込書の指定行の項目をデータセットに放り込む
    '            DrAppleID.Item(0) = cnt - 4
    '            DrAppleID.Item(1) = xlSheet.Cells(cnt, APPLEID).value
    '            DrAppleID.Item(2) = xlSheet.Cells(cnt, APPLEID_PWD).value
    '            DrAppleID.Item(3) = xlSheet.Cells(cnt, Q1).value
    '            DrAppleID.Item(4) = xlSheet.Cells(cnt, A1).value
    '            DrAppleID.Item(5) = xlSheet.Cells(cnt, Q2).value
    '            DrAppleID.Item(6) = xlSheet.Cells(cnt, A2).value
    '            DrAppleID.Item(7) = xlSheet.Cells(cnt, Q3).value
    '            DrAppleID.Item(8) = xlSheet.Cells(cnt, A3).value
    '            '誕生日が暗黙の型変換を行い、少々面倒になっているので、明示する
    '            wkBirthDay = xlSheet.Cells(cnt, BIRTH_DAY).value
    '            '格納する前に、データチェック
    '            If IsDate(wkBirthDay) Then
    '                DrAppleID.Item(9) = wkBirthDay.Year.ToString & "/" & wkBirthDay.Month.ToString & "/" & wkBirthDay.Day.ToString
    '            Else
    '                MessageBox.Show(DrAppleID.Item(0).ToString & "行目の誕生日を日付として認識できません。", "日付エラー", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
    '                Exit Sub
    '            End If
    '            DrAppleID.Item(10) = xlSheet.Cells(cnt, DM).value
    '            DrAppleID.Item(11) = xlSheet.Cells(cnt, SEI_KANJI).value
    '            DrAppleID.Item(12) = xlSheet.Cells(cnt, MEI_KANJI).value
    '            DrAppleID.Item(13) = xlSheet.Cells(cnt, SEI_FURI).value
    '            DrAppleID.Item(14) = xlSheet.Cells(cnt, MEI_FURI).value
    '            DrAppleID.Item(15) = xlSheet.Cells(cnt, POST).value
    '            DrAppleID.Item(16) = xlSheet.Cells(cnt, PROF).value
    '            DrAppleID.Item(17) = xlSheet.Cells(cnt, CITY).value
    '            DrAppleID.Item(18) = xlSheet.Cells(cnt, ADDRESS).value
    '            DrAppleID.Item(19) = xlSheet.Cells(cnt, TEL).value
    '            ArgDt.Rows.Add(DrAppleID)   '行追加
    '            cnt += 1
    '        Loop
    '        'データセットを確定
    '        ArgDt.AcceptChanges()
    '        Try
    '            xlBook.Close(SaveChanges:=False)
    '        Catch ex As Exception
    '            MessageBox.Show(ex.Message)
    '        End Try
    '        'EXCELプロセスを自然消滅させる
    '        xlApplication.Quit()
    '        System.Runtime.InteropServices.Marshal.ReleaseComObject(xlSheet)
    '        xlSheet = Nothing
    '        System.Runtime.InteropServices.Marshal.ReleaseComObject(xlBook)
    '        xlBook = Nothing
    '        System.Runtime.InteropServices.Marshal.ReleaseComObject(xlBooks)
    '        xlBooks = Nothing
    '        System.Runtime.InteropServices.Marshal.ReleaseComObject(xlApplication)
    '        xlApplication = Nothing
    '        '↑この時点でEXCELプロセスは消えるはず
    '    Catch ex As Exception
    '        MessageBox.Show(ex.Message, "EXCEL初期化時にエラーが発生しました", MessageBoxButtons.OK, MessageBoxIcon.Error)
    '    End Try

    'End Sub

    '申し込み用AppleIDデータテーブル定義
    Public Function NewAppleIDtype() As DataTable
        Dim dtCSV As New DataTable
        With dtCSV
            .Columns.Add("No")     '項番0
            .Columns.Add("AppleID")         'AppleID1
            .Columns.Add("AppleIDPassword") 'AppleIDパスワード2
            .Columns.Add("Q1") '質問1　3
            .Columns.Add("A1") '回答1　4
            .Columns.Add("Q2") '質問1　5
            .Columns.Add("A2") '回答1　6
            .Columns.Add("Q3") '質問1　7
            .Columns.Add("A3") '回答1　8
            .Columns.Add("BirthDay") '生年月日 9
            .Columns.Add("DM") 'DM  10
            .Columns.Add("sei") '姓 11
            .Columns.Add("mei") '名 12
            .Columns.Add("sei-huri") 'せい 13
            .Columns.Add("mei-huri") 'めい 14
            .Columns.Add("post") '郵便番号 15
            .Columns.Add("prof") '都道府県 16
            .Columns.Add("siku") '市区町村1　17
            .Columns.Add("add1") '住所1　 18
            .Columns.Add("tel") '電話番号　19
            .Columns.Add("End1").DefaultValue = 0 '終了フラグ 20 1=終了
            .Columns.Add("End2").DefaultValue = 0 '終了フラグ 21 1=終了
            .Columns.Add("time").DefaultValue = DBNull.Value '取得時刻
            .TableName = "NewEntryAppleID"
        End With
        Return dtCSV.Clone
    End Function

    Private Sub BtnOutput_Click(sender As System.Object, e As System.EventArgs) Handles BtnOutput.Click
        Dim NowDate As String
        Dim documentFolder As String
        Dim savefileName As String
        Const FILENAME As String = "NewEntry_AppleID.xml"

        If DtNewAppleID.TableName <> "NewEntryAppleID" Then
            Exit Sub
        Else
            documentFolder = System.Environment.GetFolderPath(Environment.SpecialFolder.Personal)
            NowDate = Today.Year.ToString & Today.Month.ToString & Today.Day.ToString
            savefileName = NowDate & FILENAME
            '保存ダイアログの指定
            SaveFileDialog1.InitialDirectory = documentFolder
            SaveFileDialog1.FileName = savefileName
            'ダイアログを開く
            SaveFileDialog1.ShowDialog()
            'ファイル名を再取得
            savefileName = SaveFileDialog1.FileName
            '出力
            DtNewAppleID.WriteXml(savefileName, XmlWriteMode.WriteSchema)
            'DtNewAppleID.WriteXml(documentFolder & "\" & savefileName, XmlWriteMode.WriteSchema)
            'MessageBox.Show("マイドキュメントに変換用データを保存しました" & vbCrLf & savefileName, "変換用データファイル", MessageBoxButtons.OK, MessageBoxIcon.Information)
        End If
    End Sub


    Private Sub btnChoiceFileXML_Click(sender As System.Object, e As System.EventArgs) Handles btnChoiceFileXML.Click
        'ファイルオープンダイアログ表示
        If OpenFileDialog2.ShowDialog() = DialogResult.OK Then
            txtXmlFile.Text = OpenFileDialog2.FileName
            '内容全消去
            DtNewAppleID.Clear()
            'DtNewAppleID.Rows.Clear()
            '保存ファイルを読む
            Try
                DtNewAppleID.ReadXml(txtXmlFile.Text)
                'AppleID取得グリッド展開
                DGAppleIDDisp.DataSource = DtNewAppleID
                PnlDGAppleIDList.Visible = True
                PnlGetControl.Visible = True
                PnlAppleIDList.Visible = False
                BtnOutput.Enabled = False
                DGAppleIDDisp_Grid_Setting()
                '数字コントロールの上限を読み込んだリストにする
                NUNo.Maximum = DtNewAppleID.Rows.Count
            Catch ex As Exception
                MessageBox.Show(ex.Message, "XMLファイル読込時エラーが発生しています", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Finally
                NUNo.Value = 1
                'フォーカスを指定する
                NUNo.Focus()
            End Try
        Else
            Exit Sub
        End If

    End Sub

    '申込書の都道府県が正しいかチェック
    Public Function PrefNameCheck(ByVal strPrefName As String) As Boolean

        Dim blnCheck As Boolean

        blnCheck = True

        Select Case strPrefName

            Case "北海道"
            Case "青森県"
            Case "岩手県"
            Case "宮城県"
            Case "秋田県"
            Case "山形県"
            Case "福島県"
            Case "茨城県"
            Case "栃木県"
            Case "群馬県"
            Case "埼玉県"
            Case "千葉県"
            Case "東京都"
            Case "神奈川県"
            Case "新潟県"
            Case "富山県"
            Case "石川県"
            Case "福井県"
            Case "山梨県"
            Case "長野県"
            Case "岐阜県"
            Case "静岡県"
            Case "愛知県"
            Case "三重県"
            Case "滋賀県"
            Case "京都府"
            Case "大阪府"
            Case "兵庫県"
            Case "奈良県"
            Case "和歌山県"
            Case "鳥取県"
            Case "島根県"
            Case "岡山県"
            Case "広島県"
            Case "山口県"
            Case "徳島県"
            Case "香川県"
            Case "愛媛県"
            Case "高知県"
            Case "福岡県"
            Case "佐賀県"
            Case "長崎県"
            Case "熊本県"
            Case "大分県"
            Case "宮崎県"
            Case "鹿児島県"
            Case "沖縄県"

            Case Else
                blnCheck = False
        End Select

        PrefNameCheck = blnCheck
    End Function

    Private Sub Button1_Click(sender As System.Object, e As System.EventArgs) Handles BtnEntry1.Click
        Dim drAppleID As DataRow()
        Dim Proc As ProcessClass
        '項番のデータを特定
        drAppleID = DtNewAppleID.Select("No = '" & NUNo.Value & "'")
        'データが存在
        If drAppleID.Length = 0 Then
            MessageBox.Show("項番に対応するデータが存在しません。" & vbCrLf & "確認してください", "項番エラーです", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
            Exit Sub
        ElseIf drAppleID.Length > 1 Then
            MessageBox.Show("項番に対応するデータが複数存在します" & vbCrLf & "確認してください", "項番エラーです", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
            Exit Sub
        End If
        '画面操作用プロセスクラスのインスタンス指定
        Proc = New ProcessClass
        'クラスに該当データ転送（必ず1件）
        For Each row As DataRow In drAppleID
            Proc.ProductNo = row(0)
            Proc.ID = Proc.sendkeySpecialstring(row(1))  'ID
            Proc.Password = Proc.sendkeySpecialstring(row(2)) 'パスワード
            Proc.Question1 = IIf(IsDBNull(row(3)), "", row(3))              '質問1
            Proc.Answer1 = IIf(IsDBNull(row(4)), "", row(4))                '回答1
            Proc.Question2 = IIf(IsDBNull(row(5)), "", row(5))              '質問2
            Proc.Answer2 = IIf(IsDBNull(row(6)), "", row(6))                 '回答2
            Proc.Question3 = IIf(IsDBNull(row(7)), "", row(7))              '質問3
            Proc.Answer3 = IIf(IsDBNull(row(8)), "", row(8))               '回答3
            '和暦の場合、おかしい値で取得する
            Proc.BirthDay = IIf(IsDBNull(row(9)), "", row(9))                '誕生日
            If row(10) = "受信する" Then
                Proc.MailReceiveiTunes = True     'メール受信(itune)
                Proc.MailReceiveApple = True      'メール受信(Apple)
            Else
                Proc.MailReceiveiTunes = False    'メール受信(itune)
                Proc.MailReceiveApple = False     'メール受信(Apple)
            End If
            Proc.AutoEnter = ChkAutoMove.Checked  '自動遷移フラグ
            '入力補助開始
            If Proc.InputiTunes1(NCDely.Value) Then
                '画面1終了
                row(20) = 1
                DtNewAppleID.AcceptChanges()
            End If
        Next
    End Sub

    Private Sub BtnEntry2_Click(sender As System.Object, e As System.EventArgs) Handles BtnEntry2.Click
        Dim drAppleID As DataRow()
        Dim Proc As ProcessClass

        '項番のデータを特定
        drAppleID = DtNewAppleID.Select("No = '" & NUNo.Value & "'")
        'データが存在
        If drAppleID.Length = 0 Then
            MessageBox.Show("項番に対応するデータが存在しません。" & vbCrLf & "確認してください", "項番エラーです", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
            Exit Sub
        ElseIf drAppleID.Length > 1 Then
            MessageBox.Show("項番に対応するデータが複数存在します" & vbCrLf & "確認してください", "項番エラーです", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
            Exit Sub
        End If
        '画面操作用プロセスクラスのインスタンス指定
        Proc = New ProcessClass
        'クラスに該当データ転送
        For Each row As DataRow In drAppleID
            Proc.LastName = IIf(IsDBNull(row(11)), "", row(11))              '姓
            Proc.FirstName = IIf(IsDBNull(row(12)), "", row(12))             '名
            Proc.LastNameJP = IIf(IsDBNull(row(13)), "", row(13))            '姓(ふりがな)
            Proc.FirstNameJP = IIf(IsDBNull(row(14)), "", row(14))           '名(ふりがな)
            Proc.PostCode = IIf(IsDBNull(row(15)), "", row(15))              '郵便番号
            Proc.PrefName = IIf(IsDBNull(row(16)), "", row(16))            '都道府県
            Proc.CityName = IIf(IsDBNull(row(17)), "", row(17))             '市区町村
            Proc.Address = IIf(IsDBNull(row(18)), "", row(18))              '住所
            Proc.Tel = IIf(IsDBNull(row(19)), "", row(19))                  '電話番号
            Proc.AutoEnter = ChkAutoMove.Checked  '自動遷移フラグ
            '入力補助開始
            If Proc.InputiTunes2(NCDely.Value) Then
                '画面2終了
                row(21) = 1
                row(22) = Date.Today.ToString
                DtNewAppleID.AcceptChanges()
            End If
        Next
    End Sub

    Private Sub Main_Load(sender As Object, e As System.EventArgs) Handles Me.Load
        Me.Text = Me.Text & "(Ver." & Me.ProductVersion & ")"
    End Sub

    Private Sub BtnSave_Click(sender As System.Object, e As System.EventArgs) Handles BtnSave.Click
        Try
            DtNewAppleID.WriteXml(txtXmlFile.Text, XmlWriteMode.WriteSchema)
            MessageBox.Show("上書き保存しました", "変換用データファイル", MessageBoxButtons.OK, MessageBoxIcon.Information)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub
End Class
