﻿Imports System.Threading
Imports Microsoft.Office.Interop
'マルチスレッド用
Public Class FrmReadFileProgress
    Public ArgPath As String
    Public ArgDt As DataTable

    '引数が渡せないので、プロパティとして
    Private Sub BackgroundWorker1_DoWork(sender As Object, e As System.ComponentModel.DoWorkEventArgs) Handles BackgroundWorker1.DoWork

        Const SHEET_NAME As String = "電話番号リスト"
        Const PHONE_NUMBER_TITLE_ROW As Integer = 5
        Const PHONE_NUMBER As Integer = 2
        Const APPLEID As Integer = 94
        Const APPLEID_PWD As Integer = 95
        Const Q1 As Integer = 96
        Const A1 As Integer = 97
        Const Q2 As Integer = 98
        Const A2 As Integer = 99
        Const Q3 As Integer = 100
        Const A3 As Integer = 101
        Const BIRTH_DAY As Integer = 102
        Const DM As Integer = 103
        Const SEI_KANJI As Integer = 104
        Const MEI_KANJI As Integer = 105
        Const SEI_FURI As Integer = 106
        Const MEI_FURI As Integer = 107
        Const POST As Integer = 108
        Const PROF As Integer = 109
        Const CITY As Integer = 110
        Const ADDRESS As Integer = 111
        Const TEL As Integer = 112

        Try

            Dim xlApplication As New Excel.Application()
            Dim xlBooks As Excel.Workbooks
            Dim xlBook As Excel.Workbook
            Dim xlSheet As Excel.Worksheet
            Dim cnt As Integer = 0
            Dim DrAppleID As DataRow
            Dim wkBirthDay As Date
            Dim progCnt As Integer
            Dim msg As String = "EXCELを起動中・・・"

            BackgroundWorker1.ReportProgress(progCnt, msg)

            xlBooks = xlApplication.Workbooks
            xlBook = xlBooks.Open(ArgPath)

            progCnt = 10
            msg = "EXCELファイルを読み込んでいます"
            BackgroundWorker1.ReportProgress(progCnt, msg)

            '開いたか確認
            If IsNothing(xlBooks) Then
                Exit Sub
            End If
            'エクセルを表示する
            'xlBook.Application.Visible = True
            'xlBook.Activate()

            xlSheet = xlBook.Worksheets(SHEET_NAME)
            'ループ開始（電番が空白になるまで）
            cnt = PHONE_NUMBER_TITLE_ROW

            progCnt = 20
            msg = "電話番号リストを変換中"
            BackgroundWorker1.ReportProgress(progCnt, msg)

            Do While xlSheet.Cells(cnt, PHONE_NUMBER).value <> ""
                'データテーブルに１行追加
                DrAppleID = ArgDt.NewRow
                '申込書の指定行の項目をデータセットに放り込む
                DrAppleID.Item(0) = cnt - 4
                DrAppleID.Item(1) = xlSheet.Cells(cnt, APPLEID).value
                DrAppleID.Item(2) = xlSheet.Cells(cnt, APPLEID_PWD).value
                DrAppleID.Item(3) = xlSheet.Cells(cnt, Q1).value
                DrAppleID.Item(4) = xlSheet.Cells(cnt, A1).value
                DrAppleID.Item(5) = xlSheet.Cells(cnt, Q2).value
                DrAppleID.Item(6) = xlSheet.Cells(cnt, A2).value
                DrAppleID.Item(7) = xlSheet.Cells(cnt, Q3).value
                DrAppleID.Item(8) = xlSheet.Cells(cnt, A3).value
                '誕生日が暗黙の型変換を行い、少々面倒になっているので、明示する
                wkBirthDay = xlSheet.Cells(cnt, BIRTH_DAY).value
                '格納する前に、データチェック
                If IsDate(wkBirthDay) Then
                    DrAppleID.Item(9) = wkBirthDay.Year.ToString & "/" & wkBirthDay.Month.ToString & "/" & wkBirthDay.Day.ToString
                Else
                    MessageBox.Show(DrAppleID.Item(0).ToString & "行目の誕生日を日付として認識できません。", "日付エラー", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
                    Exit Sub
                End If
                DrAppleID.Item(10) = xlSheet.Cells(cnt, DM).value
                DrAppleID.Item(11) = xlSheet.Cells(cnt, SEI_KANJI).value
                DrAppleID.Item(12) = xlSheet.Cells(cnt, MEI_KANJI).value
                DrAppleID.Item(13) = xlSheet.Cells(cnt, SEI_FURI).value
                DrAppleID.Item(14) = xlSheet.Cells(cnt, MEI_FURI).value
                DrAppleID.Item(15) = xlSheet.Cells(cnt, POST).value
                DrAppleID.Item(16) = xlSheet.Cells(cnt, PROF).value
                DrAppleID.Item(17) = xlSheet.Cells(cnt, CITY).value
                DrAppleID.Item(18) = xlSheet.Cells(cnt, ADDRESS).value
                DrAppleID.Item(19) = xlSheet.Cells(cnt, TEL).value
                ArgDt.Rows.Add(DrAppleID)   '行追加
                cnt += 1
            Loop
            progCnt = 60
            msg = "確認中・・・"
            BackgroundWorker1.ReportProgress(progCnt, msg)

            '＃データチェック
            '電番にハイフンがないと警告する。問題がなければそのまま
            If Not InStr(ArgDt.Rows(0).Item(19).ToString, "-") > 0 Then
                Dim msgboxstr As String = "電番にハイフンが含まれていないので、市外局番を判定できません" + vbCrLf + "申込書を修正して再読込してください" + vbCrLf + "(このまま続けると2ページ目の市外局番が空白になります)"
                MessageBox.Show(msgboxstr, "電番、市外局番警告", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
            End If

            progCnt = 100
            msg = "終了処理中・・・"
            BackgroundWorker1.ReportProgress(progCnt, msg)

            'データセットを確定
            ArgDt.AcceptChanges()
            Try
                xlBook.Close(SaveChanges:=False)
            Catch ex As Exception
                MessageBox.Show(ex.Message)
            End Try
            'EXCELプロセスを自然消滅させる
            xlApplication.Quit()
            System.Runtime.InteropServices.Marshal.ReleaseComObject(xlSheet)
            xlSheet = Nothing
            System.Runtime.InteropServices.Marshal.ReleaseComObject(xlBook)
            xlBook = Nothing
            System.Runtime.InteropServices.Marshal.ReleaseComObject(xlBooks)
            xlBooks = Nothing
            System.Runtime.InteropServices.Marshal.ReleaseComObject(xlApplication)
            xlApplication = Nothing
            '↑この時点でEXCELプロセスは消えるはず
        Catch ex As Exception
            MessageBox.Show(ex.Message, "EXCEL初期化時にエラーが発生しました", MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try

    End Sub

    Private Sub FrmReadFileProgress_Load(sender As Object, e As System.EventArgs) Handles Me.Load
        'コントロールを初期化する
        ProgressBar1.Minimum = 0
        ProgressBar1.Maximum = 100
        ProgressBar1.Value = 0
        TextBox1.Text = "スレッド起動中..."
    End Sub

    Private Sub BackgroundWorker1_ProgressChanged(sender As Object, e As System.ComponentModel.ProgressChangedEventArgs) Handles BackgroundWorker1.ProgressChanged
        'ProgressBar1の値を変更する
        ProgressBar1.Value = e.ProgressPercentage
        TextBox1.Text = CType(e.UserState, String) ' パラメータ２(Object型なのでキャスト)
    End Sub

    'マルチスレッドが終了したら起動する
    Private Sub BackgroundWorker1_RunWorkerCompleted(sender As Object, e As System.ComponentModel.RunWorkerCompletedEventArgs) Handles BackgroundWorker1.RunWorkerCompleted
        Application.DoEvents()
        Me.DialogResult = Windows.Forms.DialogResult.OK
        Me.Close()
    End Sub

    '画面が表示されたら（一度だけ起動されるイベント）
    Private Sub FrmReadFileProgress_Shown(sender As Object, e As System.EventArgs) Handles Me.Shown
        'マルチスレッド起動
        Me.BackgroundWorker1.RunWorkerAsync()
    End Sub
End Class