// vim: foldmethod=marker commentstring=//%s
package mn.jp.kekkouyakan.jmex.wani;

import java.io.IOException;
import com.jme3.export.OutputCapsule;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;

public class WaniParallel extends WaniList
{//{{{
	public WaniParallel()
	{//{{{
	}//}}}
	public WaniParallel( WaniItem... itemLs_ )
	{//{{{
		addSubItem( itemLs_ );
	}//}}}
	int runningCount;
	@Override
	public void start()
	{//{{{
		int sz_ = runningCount = getSubItemCount();
		for( int i_ = 0; i_ < sz_; ++i_ ){
			getSubItem(i_).start();
		}
	}//}}}
	@Override
	public void startLoop()
	{//{{{
		int sz_ = runningCount = getSubItemCount();
		for( int i_ = 0; i_ < sz_; ++i_ ){
			getSubItem(i_).startLoop();
		}
	}//}}}
	@Override
	public void notifyDone( WaniItem item_ )
	{//{{{
		assert( runningCount > 0 );
		--runningCount;
		if( runningCount == 0 ){
			if( superItem == null ){
				control.notifyDone( this );
			}
			else{
				superItem.notifyDone( this );
			}
		}
	}//}}}
	@Override
	public boolean isCompleted()
	{//{{{
		return runningCount == 0;
	}//}}}
	@Override
	public WaniItem cloneForControl( WaniControl ctrl_ )
	{//{{{
		WaniParallel clone_ = new WaniParallel();
		clone_.setSpeed( speed );
		clone_.setControl( ctrl_ );
		for( WaniItem item1_ : subList ){
			WaniItem item2_ = item1_.cloneForControl( ctrl_ );
			clone_.addSubItem( item2_ );
		}
		return clone_;
	}//}}}
}//}}}
