// vim: foldmethod=marker commentstring=//%s
package mygame;

//{{{
import mn.jp.kekkouyakan.jme3.input.RawInputAdapter;
import mn.jp.kekkouyakan.jmex.wani.WaniControl;
import mn.jp.kekkouyakan.jmex.wani.WaniItem;
import mn.jp.kekkouyakan.jmex.wani.WaniChannelManager;
import mn.jp.kekkouyakan.jmex.wani.IWaniEventListener;
import com.jme3.app.SimpleApplication;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.math.Quaternion;
import com.jme3.math.FastMath;
import com.jme3.renderer.RenderManager;
import com.jme3.scene.Spatial;
import com.jme3.scene.Node;
import com.jme3.scene.Geometry;
import com.jme3.scene.shape.Box;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeCanvasContext;
import com.jme3.asset.TextureKey;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.GridBagLayout;
import java.awt.BorderLayout;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JButton;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.tree.TreePath;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import com.jme3.math.Transform;
import com.jme3.input.event.KeyInputEvent;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.asset.AssetManager;
import com.jme3.animation.AnimControl;
import com.jme3.animation.AnimChannel;
import com.jme3.material.Material;
import static com.jme3.input.KeyInput.*;
import java.net.URI;
import com.jme3.asset.plugins.FileLocator;
import com.jme3.asset.plugins.HttpZipLocator;
import com.jme3.asset.plugins.UrlLocator;
import com.jme3.asset.plugins.ZipLocator;
import com.jme3.light.DirectionalLight;
import java.util.List;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.Callable;
import java.io.InputStream;
//}}}


class Texture
{//{{{
	String target;
	String image;
	Material material = null;
	Geometry geometry = null;

	static Texture[][] createTextureSetList( TreeData.Node modelNode_ )
	{//{{{
		assert( modelNode_ != null );
		assert( modelNode_.equalsLabel( "model" ) );

		List<TreeData.Node> nodeSetLs_ = modelNode_.getSubNodeList( "texture-set" );
		if( nodeSetLs_.isEmpty() ){
			return null;
		}
		int sz_ = nodeSetLs_.size();
		Texture[][] texSetLs_ = new Texture[sz_][];
		for( int i_ = 0; i_ < sz_; ++i_ ){
			List<TreeData.Node> nodeSet_ = nodeSetLs_.get(i_).getSubNodeList( "texture" );
			int setSz_ = nodeSet_.size();
			texSetLs_[i_] = new Texture[ setSz_ ];
			for( int j_ = 0; j_ < setSz_; ++j_ ){
				Texture tex_ = texSetLs_[i_][j_] = new Texture();
				tex_.target = nodeSet_.get(j_).getLeaf( "target" );
				tex_.image = nodeSet_.get(j_).getLeaf( "image" );
			}
		}
		return texSetLs_;
	}//}}}
	static Geometry findGeomety( Spatial src_, String name_ )
	{//{{{
		Spatial sp_ = Main.findSpatial( src_, name_ );
		if( !(sp_ instanceof Node) ){
			return null;
		}
		for( Spatial child_ : ((Node)sp_).getChildren() ){
			if( child_ instanceof Geometry ){
				return (Geometry)child_;
			}
		}
		return null;
	}//}}}

	public void update( ModelData md_, AssetManager ass_ )
	{//{{{
		if( geometry == null ){
			geometry = findGeomety( md_.spatial, target );
		}
		if( material == null ){
			material = geometry.getMaterial().clone();
			TextureKey key_ = new TextureKey(image, false);
			material.setTexture( "DiffuseMap", ass_.loadTexture(key_));
		}
		geometry.setMaterial( material );
	}//}}}
}//}}}
class ModelData
{//{{{
	ModelData( String name_, Spatial sp_ )
	{//{{{
		name = name_;
		spatial = sp_;
		transform = sp_.getLocalTransform();
		waniControl = sp_.getControl( WaniControl.class );
	}//}}}
	Texture[][] textureSetList = null;
	int textureSetIndex = 0;
	Spatial spatial;
	String name;
	String state;
	WaniControl waniControl;
	WaniUnit noAnim = new WaniUnit( this, null, null );
	WaniUnit[] animList;
	Transform transform;
	WaniUnit getSelectedAnim( String animation_ )
	{//{{{
		if( animation_ == null ){
			return null;
		}
		for( WaniUnit anim_ : animList ){
			if( animation_.equals( anim_.animId ) ){
				return anim_;
			}
		}
		return null;
	}//}}}
	@Override
	public String toString()
	{//{{{
		return name;
	}//}}}
	public void resetTransform()
	{//{{{
		spatial.setLocalTransform( transform );
	}//}}}
	public boolean equalsState( String st_ )
	{//{{{
		if( state == null ){
			return false;
		}
		return state.equals( st_ );
	}//}}}
	public void setAnimList( WaniUnit[] animLs_ )
	{//{{{
		animList = animLs_;
	}//}}}
}//}}}
class WaniUnit
{//{{{
	ModelData modelData;
	String animId;
	String label;
	boolean running = false;
	WaniUnit( ModelData modelData_, String animId_, String label_ )
	{//{{{
		modelData = modelData_;
		animId = animId_;
		label = label_;
	}//}}}
	public String toString()
	{//{{{
		if( running ){
			return "(>)" + label;
		}
		else{
			return "(-)" + label;
		}
	}//}}}
	public void changeState( WaniControl ct_, boolean loop_ )
	{//{{{
		if( running ){
			ct_.reset( animId );
		}
		else if( loop_ ){
			ct_.startLoop( animId );
		}
		else{
			ct_.start( animId );
		}
		running = !running;
	}//}}}
	public void reset()
	{//{{{
		reset( modelData.waniControl );
	}//}}}
	public void reset( WaniControl ct_ )
	{//{{{
		running = false;
		ct_.reset( animId );
	}//}}}
	public void startAnim()
	{//{{{
		modelData.waniControl.startLoop( animId );
	}//}}}
	public void stopAnim()
	{//{{{
		modelData.waniControl.reset( animId );
	}//}}}
}//}}}
class MyPanel extends JPanel implements TreeSelectionListener, ActionListener
{//{{{
	Main app;
	Canvas canvas;
	JTree tree;
	JButton textureButton;
	Callable disposer;
	DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode();

	void updateData( TreeData.Node treeData_ )
	{//{{{
		{
			String label_ = treeData_.getSubNode( "ui" ).getLeaf( "texture-button" );
			textureButton.setText( label_ );
		}

		tree.clearSelection();
		treeNode.setUserObject( treeData_.getLeaf( "name" ) );
		for( TreeData.Node node_ : treeData_.getSubNodeList( "model" ) ){
			ModelData md_ = (ModelData)node_.getUserData();
			md_.textureSetList = Texture.createTextureSetList( node_ );
			DefaultMutableTreeNode sub_ = new DefaultMutableTreeNode( md_ );
			for( WaniUnit anim_: md_.animList ){
				sub_.add( new DefaultMutableTreeNode( anim_) );
			}
			treeNode.add( sub_ );
		}
		for (int i_ = 0; i_ < treeNode.getChildCount(); i_++) {
			DefaultMutableTreeNode child_ = (DefaultMutableTreeNode)treeNode.getChildAt(i_);
			ModelData md_ = (ModelData)child_.getUserObject();
			if( !md_.equalsState( "closed" ) ){
				TreePath path_ = new TreePath( child_.getPath() );
				tree.expandPath( path_ );
			}
		}
		{
			ModelData selectedModel_ = null;
			WaniUnit selectedAnim_ = null;
			TreeData.Node selectedNode_ = Main.getSelectedSubNode( treeData_ );
			if( selectedNode_ != null ){
				selectedModel_ = (ModelData)selectedNode_.getUserData();
				if( selectedModel_.animList.length == 0 ){
					throw new Error();
				}
				selectedAnim_ = selectedModel_.getSelectedAnim( treeData_.getLeaf( "select-animation" ) );
			}
			Object key_ = selectedAnim_;
			if( key_ == null ){
				key_ = selectedModel_;
			}
			if( key_ != null ){
				Enumeration en_ = treeNode.breadthFirstEnumeration();
				while( en_.hasMoreElements() ){
					DefaultMutableTreeNode node_ = (DefaultMutableTreeNode)en_.nextElement();
					if( node_.getUserObject() == key_ ){
						TreePath tp_ = new TreePath( node_ );
						//tree.setExpandsSelectedPaths(true);
						tree.setSelectionPath( tp_ );
						//tree.getSelectionModel().setSelectionPath( tp_ );
						tree.scrollPathToVisible( tp_ );
						tree.makeVisible( tp_ );
						break;
					}
				}
			}
		}
		tree.updateUI();

	}//}}}

	public MyPanel( Main app_, Canvas canvas_, Callable disposer_ )
	{//{{{
		app = app_;
		app.panel = this;
		canvas = canvas_;
		disposer = disposer_;

		JPanel panel3d_ = new JPanel(new FlowLayout());
		{
			Dimension dim_ = new Dimension(400, 400);
			canvas_.setPreferredSize( dim_ );
			panel3d_.add( canvas_ );
		}

		JPanel panelCtrl_ = new JPanel(new BorderLayout());
		{
			tree = new JTree( treeNode );
			tree.addTreeSelectionListener(this);
			tree.getSelectionModel().setSelectionMode
				(TreeSelectionModel.SINGLE_TREE_SELECTION);
			JScrollPane scroll_ = new JScrollPane(
				JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
				//JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
				JScrollPane.HORIZONTAL_SCROLLBAR_NEVER
			);
			scroll_.getViewport().setView( tree );
			Dimension dim_ = new Dimension(200, 400);
			scroll_.setPreferredSize( dim_ );
			panelCtrl_.add( "Center", scroll_ );

			textureButton = new JButton( "Loading..." );
			textureButton.addActionListener( this );
			textureButton.setEnabled( false );
			panelCtrl_.add( "South", textureButton );
		}

		JSplitPane split_ = new JSplitPane(
			JSplitPane.HORIZONTAL_SPLIT,
			panel3d_,
			panelCtrl_
		);
		split_.setOneTouchExpandable(true);
		split_.setDividerLocation(400);
		add( split_ );
	}//}}}
	public void actionPerformed( ActionEvent ev_ )
	{//{{{
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				app.changeTexture();
			}
		});
	}//}}}
	public void valueChanged(TreeSelectionEvent ev_)
	{//{{{
		DefaultMutableTreeNode node_ =
			(DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
		if( node_ == null ){
			return;
		}
		Object userObj_ = node_.getUserObject();
		if( userObj_ instanceof ModelData ){
			ModelData md_ = (ModelData)userObj_;
			app.newAnim = md_.noAnim;
		}
		else if( userObj_ instanceof WaniUnit ){
			app.newAnim = (WaniUnit)userObj_;
		}
		textureButton.setEnabled( app.newAnim.modelData.textureSetList != null );
	}//}}}
	public void start()
	{//{{{
		app.startCanvas();
	}//}}}
	public void exit()
	{//{{{
		if( disposer != null ){
			try{
				disposer.call();
				app.stop();
			}
			catch( Exception ex_ ){
			}
		}
	}//}}}
}//}}}

public class Main extends SimpleApplication
{//{{{
	//variables
	//{{{
	String[] args;
	MyPanel panel;
	TreeData.Node treeData;

	boolean updateFlag = false;
	float distanceSpeed0 = 2.0f;
	float distanceSpeed = 0f;
	final float distance0 = 10.0f;
	float distanceMin = 1.0f;
	float distance = distance0;
	WaniUnit currentAnim = null;
	WaniUnit newAnim = null;
	int screenWidth;
	int screenHeight;
	Vector3f lookAt = new Vector3f(0,0,1);
	Vector3f lookUp = new Vector3f(0,1,0);
	//}}}
	public Main( TreeData.Node treeData_, String... args_ )
	{//{{{
		super( (com.jme3.app.state.AppState)null );
		args = args_;
		treeData = treeData_;
	}//}}}
	public static MyPanel createPanel( Callable disposer_, String... args_ ) throws Exception
	{//{{{
		AppSettings settings_ = new AppSettings(true);
		settings_.setWidth(640);
		settings_.setHeight(480);

		InputStream dataXml_ = Thread.currentThread().getContextClassLoader().getResourceAsStream( "data.xml" );
		TreeData.Node treeData_ = TreeData.readXml( dataXml_ );

		Main app_ = new Main( treeData_, args_ );

		app_.setPauseOnLostFocus(false);
		app_.setSettings(settings_);
		app_.createCanvas(); // create canvas!
		app_.setDisplayFps( false );
		app_.setDisplayStatView( false );
		JmeCanvasContext ctx_ = (JmeCanvasContext) app_.getContext();
		ctx_.setSystemListener(app_);

		Canvas canvas_ = ctx_.getCanvas();
		MyPanel panel_ = new MyPanel( app_, canvas_, disposer_ );

		app_.startCanvas();
		return panel_;
	}//}}}
	public static void main(String[] args_) throws Exception
	{//{{{
		final JFrame window_ = new JFrame("Kekkouyakan Viewer 20130722");
		window_.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		Callable disposer_ = new Callable(){
			public Object call() throws Exception{
				window_.dispose();
				return null;
			}
		};
		MyPanel panel_ = createPanel( disposer_, args_ );
		window_.add(panel_);
		window_.setPreferredSize(new Dimension( 640, 480 ));
		window_.pack();
		window_.setVisible(true);
		panel_.start();
	}//}}}
	public void setLocator( AssetManager ass_, URI root_ )
	{//{{{
		boolean envFlag_ = false;
		boolean httpFlag_ = false;
		boolean zipFlag_ = false;
		if( root_ != null ){
			String scheme_ = root_.getScheme();
			if( scheme_ == null || scheme_.equals( "file" ) ){
			}
			else if( scheme_.equals( "env" ) ){
				envFlag_ = true;
			}
			else if( scheme_.equals( "http" ) ){
				httpFlag_ = true;
			}
			else{
				throw new Error();
			}
		}
		String ssc_ = root_.getSchemeSpecificPart();
		String path_ = ssc_;
		if( envFlag_ ){
			path_ = System.getenv( ssc_ );
		}
		{
			zipFlag_ = path_.toLowerCase().endsWith( ".zip" );
		}
		if( httpFlag_ ){
			String rootStr_ = root_.toString();
			if( zipFlag_ ){
				ass_.registerLocator( rootStr_, HttpZipLocator.class );
			}
			else{
				ass_.registerLocator( rootStr_, UrlLocator.class );
			}
		}
		else{
			String rootStr_ = path_;
			if( zipFlag_ ){
				ass_.registerLocator( rootStr_, ZipLocator.class );
			}
			else{
				ass_.registerLocator( rootStr_, FileLocator.class );
			}
		}
	}//}}}
	static int abs( int v_ )
	{//{{{
		if( v_ < 0 ){
			return -v_;
		}
		return v_;
	}//}}}
	static int sign( float v_ )
	{//{{{
		if( v_ < 0 ){
			return -1;
		}
		else if( v_ > 0 ){
			return 1;
		}
		return 0;
	}//}}}
	class RawInput extends RawInputAdapter
	{//{{{
		final int mouseMin= 10;
		final float wheelDistance = 0.005f;
		boolean mousePressed = false;
		int mouseX0 = -1;
		int mouseY0 = -1;
		int lastX = -1;
		int lastY = -1;
		@Override
		public void onKeyEvent(KeyInputEvent ev_)
		{//{{{
			if( ev_.isPressed() ){
				switch( ev_.getKeyCode() ){
					case KEY_SPACE:
						break;
					case KEY_ESCAPE:
						//panel.exit();
						return;
					case KEY_W:
					case KEY_UP:
						break;
					case KEY_S:
					case KEY_DOWN:
						break;
					case KEY_D:
					case KEY_RIGHT:
						break;
					case KEY_A:
					case KEY_LEFT:
						break;
					case KEY_J:
					case KEY_PGUP:
						distanceSpeed = -distanceSpeed0;
						break;
					case KEY_K:
					case KEY_PGDN:
						distanceSpeed = distanceSpeed0;
						break;
				}
			}
			else {
				switch( ev_.getKeyCode() ){
					case KEY_W:
					case KEY_S:
					case KEY_UP:
					case KEY_DOWN:
						break;
					case KEY_D:
					case KEY_A:
					case KEY_LEFT:
					case KEY_RIGHT:
						break;
					case KEY_J:
					case KEY_K:
					case KEY_PGUP:
					case KEY_PGDN:
						distanceSpeed = 0f;
						break;
				}
			}
		}//}}}
		@Override
    	public void onMouseButtonEvent(MouseButtonEvent ev_)
		{//{{{
			mousePressed = ev_.isPressed();
			if( mousePressed ){
				lastX = mouseX0 = ev_.getX();
				lastY = mouseY0 = ev_.getY();
			}
		}//}}}
		@Override
		public void onMouseMotionEvent(MouseMotionEvent ev_)
		{//{{{
			{
				float wheel_ = ev_.getDeltaWheel();
				if( wheel_ != 0 ){
					distance -= wheel_ * wheelDistance;
					distanceSpeed = 0;
					updateFlag = true;
					return;
				}
				else{
					distanceSpeed = 0;
				}
			}
			if( mousePressed ){
				int x_ = ev_.getX();
				int y_ = ev_.getY();
				int dx_ = mouseX0 - x_;
				int dy_ = mouseY0 - y_;
				float sx_ = -(float)dx_/(float)screenWidth;
				float sy_ = (float)dy_/(float)screenHeight;
				{
					int sign0_ = sign( lastX - mouseX0 );
					int sign1_ = sign( x_ - lastX );
					if( sign0_ != 0 && sign1_ != sign0_ ){
						mouseX0 = lastX = x_;
					}
					lastX = x_;
				}
				{
					int sign0_ = sign( lastY - mouseY0 );
					int sign1_ = sign( y_ - lastY );
					if( sign0_ != 0 && sign1_ != sign0_ ){
						mouseY0 = lastY = y_;
					}
					lastY = y_;
				}
				Quaternion xq_ = new Quaternion().fromAngleAxis(
					FastMath.QUARTER_PI*sx_, Vector3f.UNIT_Y
				);
				Quaternion yq_ = new Quaternion().fromAngleAxis(
					FastMath.QUARTER_PI*sy_, Vector3f.UNIT_X
				);
				xq_.multLocal( lookAt );
				xq_.multLocal( lookUp );
				yq_.multLocal( lookAt );
				yq_.multLocal( lookUp );
			}
		}//}}}
	}//}}}
	static Spatial findSpatial( Spatial sp_, String name_ )
	{//{{{
		if( name_.equals( sp_.getName() ) ){
			return sp_;
		}
		if( sp_ instanceof Node ){
			Node node_ = (Node)sp_;
			for( Spatial child_ : node_.getChildren() ){
				Spatial find_ = findSpatial( child_, name_ );
				if( find_ != null ){
					return find_;
				}
			}
		}
		return null;
	}//}}}

	static TreeData.Node getSelectedSubNode( TreeData.Node root_ )
	{//{{{
		String id_ = root_.getLeaf( "select-model-id" );
		if( id_ == null ){
			return null;
		}
		for( TreeData.Node sub_ : root_.getSubNodeList() ){
			if( id_.equals( sub_.getLeaf( "model-id" ) ) ){
				return sub_;
			}
		}
		return null;
	}//}}}
	@Override
	public void simpleInitApp()
	{//{{{
		assert( args.length > 1 );
		try{
			screenWidth = settings.getWidth();
			screenHeight = settings.getHeight();
			String arg_ = args[0].toLowerCase();
			if( !arg_.equals( "class" ) ){
				setLocator( assetManager, new URI( args[0] ) );
			}
			for( TreeData.Node node_ : treeData.getSubNodeList( "model" ) ){
				String name_ = node_.getLeaf( "name" );
				String fileStr_ = node_.getLeaf( "j3o" );
				Spatial sp_ = assetManager.loadModel( fileStr_ );
				ArrayList<WaniUnit> animLs_ = new ArrayList<WaniUnit>();
				ModelData md_ = new ModelData( name_, sp_);
				for( TreeData.Node subNode_ : node_.getSubNodeList() ){
					if( subNode_.equalsLabel( "animation"  ) ){
						String animId_ = subNode_.getLeaf( "animation-id" );
						String label_ = subNode_.getLeaf( "label" );
						WaniUnit anim_ = new WaniUnit( md_, animId_, label_ );
						animLs_.add( anim_ );
					}
				}
				md_.setAnimList( animLs_.toArray( new WaniUnit[0] ) );
				md_.state = node_.getLeaf( "state" );
				node_.setUserData( md_ );
			}
			java.awt.EventQueue.invokeLater(new Runnable() {
				public void run() {
					panel.updateData( treeData );
				}
			});
		}
		catch( Exception ex_ ){
			assert( false );
			throw new Error( ex_ );
		}

		inputManager.addRawInputListener( new RawInput() );
	}//}}}
	@Override
	public void simpleUpdate(float tpf_)
	{//{{{
		if( newAnim != null ){
			if( updateFlag || distanceSpeed != 0f ){
				updateFlag = false;
				distance += distanceSpeed * tpf_;
				if( distance < distanceMin ){
					distance = distanceMin;
				}
				cam.setLocation( new Vector3f( 0, 0, distance ) );
				cam.lookAt( Vector3f.ZERO, Vector3f.UNIT_Y );
			}
		}
		if( newAnim != currentAnim ){
			if( currentAnim == null ){
				rootNode.attachChild( newAnim.modelData.spatial );
			}
			else{
				if( currentAnim.modelData != newAnim.modelData ){
					currentAnim.modelData.waniControl.reset();
					rootNode.detachChild( currentAnim.modelData.spatial );
					rootNode.attachChild( newAnim.modelData.spatial );
				}
				else{
					if( currentAnim.animId != null ){
						currentAnim.stopAnim();
					}
				}
			}
			currentAnim = newAnim;
			if( newAnim != null && newAnim.animId != null ){
				newAnim.startAnim();
			}
		}
		if( currentAnim != null ){
			currentAnim.modelData.spatial.lookAt( lookAt, lookUp );
		}
	}//}}}
	@Override
	public void simpleRender(RenderManager rm_)
	{//{{{
		//TODO: add render code
	}//}}}
	public void changeTexture()
	{//{{{
		if( currentAnim == null ){
			return;
		}
		ModelData md_ = currentAnim.modelData;
		if( md_.textureSetList == null ){
			return;
		}
		synchronized( this ){
			md_.textureSetIndex = (md_.textureSetIndex + 1) % md_.textureSetList.length;
			for( Texture tex_ : md_.textureSetList[ md_.textureSetIndex ] ){
				tex_.update( md_, assetManager );
			}
		}
	}//}}}
}//}}}
