// vim: foldmethod=marker commentstring=//%s
package mn.jp.kekkouyakan.jmex.wani;

import java.util.ArrayList;
import com.jme3.animation.AnimControl;
import com.jme3.animation.AnimChannel;

public class WaniChannelManager
{//{{{
	AnimControl coreControl;
	ArrayList channelStateList = new ArrayList();
	public WaniChannelManager( AnimControl coreControl_ )
	{//{{{
		coreControl = coreControl_;
	}//}}}
	public int createChannel( Object owner_ )
	{//{{{
		assert( owner_ != null );
		int sz_ = channelStateList.size();
		for( int i_ = 0; i_ < sz_; ++i_ ){
			if( channelStateList.get(i_) == null ){
				channelStateList.set( i_, owner_ );
				return i_;
			}
		}
		channelStateList.add( owner_ );
		AnimChannel ch_ = coreControl.createChannel();
		assert( sz_ + 1 == coreControl.getNumChannels() );
		assert( ch_ == coreControl.getChannel( sz_ ) );
		return sz_;
	}//}}}
	public AnimControl getCoreControl()
	{//{{{
		return coreControl;
	}//}}}
	public AnimChannel getChannel( int index_ )
	{//{{{
		return coreControl.getChannel( index_ );
	}//}}}
	public void disposeChannel( int index_ )
	{//{{{
		coreControl.getChannel( index_ ).reset( true );
		channelStateList.set( index_, null );
	}//}}}
	public void reset()
	{//{{{
		int sz_ = channelStateList.size();
		for( int i_ = 0; i_ < sz_; ++i_ ){
			if( channelStateList.get( i_ ) != null ){
				disposeChannel( i_ );
			}
		}
		channelStateList.clear();
	}//}}}
}//}}}
