// vim: foldmethod=marker commentstring=//%s
package mn.jp.kekkouyakan.devutil;

import java.io.File;

public class LinkCopy
{//{{{
	static class Dir
	{//{{{
		Dir parent = null;
		String path = "";
		String levelPath = "";
		Dir()
		{
		}
		Dir( File file_ )
		{//{{{
			if( file_.getName().equals( "." ) ){
				levelPath = "";
			}
			else{
				levelPath = "../";
			}
		}//}}}
		Dir createSubDirectory( String fileName_ )
		{
			Dir subDir_ = new Dir();
			subDir_.parent = this;
			subDir_.path = path + "/" + fileName_;
			subDir_.levelPath = levelPath + "../";
			return subDir_;
		}
	}//}}}
	static String getSuffix(String fileName)
	{//{{{
		if (fileName == null)
			return null;
		int point = fileName.lastIndexOf(".");
		if (point != -1) {
			return fileName.substring(point + 1);
		}
		return fileName;
	}//}}}
	static boolean matchFileType( File file_, String[] fileTypeLs_ )
	{//{{{
		if( fileTypeLs_ == null ){
			return true;
		}
		if( fileTypeLs_.length == 0 ){
			return true;
		}
		String suffix_ = getSuffix( file_.getName() );
		for( String fileType_ : fileTypeLs_ ){
			if( fileType_.equals( suffix_ ) ){
				return true;
			}
		}
		return false;
	}//}}}
	static void info()
	{//{{{
		System.out.println( "java LinkCopy LINK_COMMAND SOURCE_DIR TARGET_DIR [FILE_TYPE]..." );
	}//}}}

	Runtime runtime;
	String sourceDir;
	String targetDir;
	LinkCopy( File srcDir_, File tgtDir_ )
	{//{{{
		sourceDir = srcDir_.getPath();
		targetDir = tgtDir_.getName();
		runtime = Runtime.getRuntime();
	}//}}}
	void link( String srcFile_, String tgtFile_ ) throws Exception
	{//{{{
		String exe_ = "ln -s " + srcFile_ + " " + tgtFile_;
		runtime.exec( exe_ );
		System.out.println( exe_ );
	}//}}}
	void linkDir( File dir1_, File dir2_, String[] fileTypeLs_, Dir common_ ) throws Exception
	{//{{{
		assert( common_ != null );
		if( !dir1_.exists() ){
			throw new Exception();
		}
		if( !dir1_.isDirectory() ){
			throw new Exception();
		}
		if( !dir2_.exists() ){
			throw new Exception();
		}
		if( !dir2_.isDirectory() ){
			throw new Exception();
		}
		File[] subFileLs1_ = dir1_.listFiles();
		for( File subFile1_ : subFileLs1_ ){
			if( subFile1_.isHidden() ){
				continue;
			}
			String subName1_ = subFile1_.getName();
			File subFile2_ = new File( dir2_, subName1_ );
			if( subFile1_.isDirectory() ){
				Dir subDir_ = new Dir();
				subDir_ = common_.createSubDirectory( subName1_ );
				if( subFile2_.exists() ){
					if( !subFile2_.isDirectory() ){
						subFile2_.delete();
						subFile2_.mkdir();
					}
				}
				else{
					subFile2_.mkdir();
				}
				linkDir( subFile1_, subFile2_, fileTypeLs_, subDir_ );
			}
			else{
				if( matchFileType( subFile1_, fileTypeLs_ ) ){
					if( subFile2_.exists() ){
						subFile2_.delete();
					}
					if( subFile1_.isAbsolute() ){
						link( sourceDir +  common_.path + "/" + subName1_,  targetDir + common_.path + "/" + subName1_ );
					}
					else{
						link( common_.levelPath + sourceDir +  common_.path + "/" + subName1_,  targetDir + common_.path + "/" + subName1_ );
					}
				}
			}
		}
	}//}}}
	public static void main( String[] args_ ) throws Exception
	{//{{{
		//args_[0] ... source directory
		//args_[1] ... target directory
		//args_[2] ... [file type] ..
		if( args_.length < 2 ){
			System.out.println( "Option Error (RETURN -1)" );
			info();
			System.exit( -1 );
			return;
		}
		String srcDir_ = args_[0];
		String tgtDir_ = args_[1];
		String[] fileTypeLs_ = null;
		if( args_.length > 2 ){
			fileTypeLs_ = new String[ args_.length - 2 ];
			for( int i_ = 0; i_ < fileTypeLs_.length; ++i_ ){
				fileTypeLs_[ i_ ] = args_[ 2 + i_ ];
			}
		}
		File dir1_ = new File( srcDir_ ); 
		if( !dir1_.exists() ){
			System.err.println( "Error : source directory not exists" );
			info();
			System.exit( -1 );
			return;
		}
		if( !dir1_.isDirectory() ){
			System.err.println( "Error : source is not directory" );
			info();
			System.exit( -1 );
			return;
		}
		File dir2_ = new File( tgtDir_ ); 
		if( !dir2_.exists() ){
			dir2_.mkdir();
		}
		else if( !dir2_.isDirectory() ){
			System.err.println( "Error : target is not directory" );
			info();
			System.exit( -1 );
			return;
		}
		LinkCopy cp_ = new LinkCopy( dir1_, dir2_ );
		cp_.linkDir( dir1_, dir2_, fileTypeLs_, new Dir( dir2_ ) );
	}//}}}
}//}}}
