// vim: foldmethod=marker commentstring=//%s
package mn.jp.kekkouyakan.util;
import mn.jp.kekkouyakan.functional.IKyAction1;
import java.util.Iterator;

public class KyLinkedElement<Value_> implements Iterable<Value_>
{//{{{
	KyLinkedElement<Value_> next = null;
	KyLinkedElement<Value_> prev = null;
	Value_ value;

	public KyLinkedElement( Value_ value_ )
	{//{{{
		value = value_;
	}//}}}
	public KyLinkedElement<Value_> valueRefOf( Value_ value_ )
	{//{{{
		if( value == value_ ){
			return this;
		}
		else if( next == null ){
			return null;
		}
		return next.valueRefOf( value_ );
	}//}}}
	public Value_ getValue()
	{//{{{
		return value;
	}//}}}
	public KyLinkedElement<Value_> getNext()
	{//{{{
		return next;
	}//}}}
	public KyLinkedElement<Value_> getPrev()
	{//{{{
		return prev;
	}//}}}
	public Iterator<Value_> iterator()
	{//{{{
		return new Iterator<Value_>(){
			KyLinkedElement<Value_> elem = KyLinkedElement.this;
			public boolean hasNext()
			{//{{{
				return elem.next != null;
			}//}}}
			public Value_ next()
			{//{{{
				elem = elem.next;
				return elem.getValue();
			}//}}}
			public void remove()
			{//{{{
				elem.disconnect();
			}//}}}
		};
	}//}}}
	public void disconnect()
	{//{{{
		KyLinkedElement<Value_> next_ = next;
		KyLinkedElement<Value_> prev_ = prev;
		if( next != null ){
			next.prev = prev_;
		}
		if( prev != null ){
			prev.next = next_;
		}
		next = null;
		prev = null;
	}//}}}
	public void connectNext( KyLinkedElement<Value_> node_ )
	{//{{{
		node_.disconnect();
		if( next != null ){
			next.prev = node_;
		}
		node_.next = next;
		node_.prev = this;
		next = node_;
	}//}}}
	public <E_ extends KyLinkedElement<Value_>, Scan_ extends IKyAction1<E_> >
	void visitNexts( Scan_ scan_ )
	{//{{{
		for( KyLinkedElement<Value_> next_ = next; next_ != null; next_ = next_.next ){
			scan_.call( (E_)next_ );
		}
	}//}}}
	public KyLinkedElement<Value_> getHead()
	{//{{{
		KyLinkedElement<Value_> elem_ = this;
		for( ; ; elem_ = elem_.prev ){
			if( elem_.prev == null ){
				return elem_;
			}
			else if( elem_.prev == this ){
				return elem_;
			}
		}
	}//}}}
}//}}}
