// vim: foldmethod=marker commentstring=//%s
package mn.jp.kekkouyakan.util;

public class KyFloatComparator
{//{{{
	float epsilon = 0.0000001f;

	public KyFloatComparator()
	{//{{{
	}//}}}
	public KyFloatComparator( float epsilon_ )
	{//{{{
		epsilon = epsilon_;
	}//}}}

	public int compare( float lhs_, float rhs_ )
	{//{{{
		if( equals( lhs_, rhs_ ) ){
			return 0;
		}
		if( lhs_ < rhs_ ){
			return -1;
		}
		return 1;
	}//}}}
	public boolean equals( float lhs_, float rhs_ )
	{//{{{
		return (float)Math.abs( lhs_ - rhs_ ) < epsilon;
	}//}}}

	public int compare0( float lhs_ )
	{//{{{
		return compare( lhs_, 0f );
	}//}}}
	public boolean less( float lhs_, float rhs_ )
	{//{{{
		return compare(lhs_, rhs_) < 0;
	}//}}}
	public boolean lessEquals( float lhs_, float rhs_ )
	{//{{{
		return compare(lhs_, rhs_) <= 0;
	}//}}}
	public boolean more( float lhs_, float rhs_ )
	{//{{{
		return compare(lhs_, rhs_) > 0;
	}//}}}
	public boolean moreEquals( float lhs_, float rhs_ )
	{//{{{
		return compare(lhs_, rhs_) >= 0;
	}//}}}
	public boolean isPositive( float v_ )
	{//{{{
		return compare( v_, 0f ) > 0;
	}//}}}
	public boolean isNegative( float v_ )
	{//{{{
		return compare( v_, 0f ) < 0;
	}//}}}

	public boolean equals( double lhs_, double rhs_ )
	{//{{{
		return equals( (float)lhs_, (float)rhs_);
	}//}}}
	public int compare( double lhs_, double rhs_ )
	{//{{{
		return compare( (float)lhs_, (float)rhs_);
	}//}}}
	public int compare0( double lhs_ )
	{//{{{
		return compare( lhs_, 0.0 );
	}//}}}
	public boolean less( double lhs_, double rhs_ )
	{//{{{
		return less( (float)lhs_, (float)rhs_);
	}//}}}
	public boolean lessEquals( double lhs_, double rhs_ )
	{//{{{
		return lessEquals( (float)lhs_, (float)rhs_);
	}//}}}
	public boolean more( double lhs_, double rhs_ )
	{//{{{
		return more( (float)lhs_, (float)rhs_);
	}//}}}
	public boolean moreEquals( double lhs_, double rhs_ )
	{//{{{
		return moreEquals( (float)lhs_, (float)rhs_);
	}//}}}
	public boolean isPositive( double v_ )
	{//{{{
		return isPositive( (float)v_ );
	}//}}}
	public boolean isNegative( double v_ )
	{//{{{
		return isNegative( (float)v_ );
	}//}}}

	/*
	public float mod( float lhs_, float rhs_ )
	{//{{{
		int n_ = (int)(lhs_ / rhs_);
		return lhs_ - (float)n_ * rhs_;
	}//}}}
	*/
}//}}}
