// vim: foldmethod=marker commentstring=//%s
package mn.jp.kekkouyakan.test;
import java.io.PrintStream;
import java.io.File;
import java.io.FileNotFoundException;

public class HtmlWriter extends XmlWriter
{//{{{
	String height = null;
	String width = null;
	public HtmlWriter( PrintStream stream_ )
	{//{{{
		super( stream_ );
	}//}}}
	public HtmlWriter( File file_ ) throws FileNotFoundException
	{//{{{
		super( file_ );
	}//}}}
	public HtmlWriter( String filePath_ ) throws FileNotFoundException
	{//{{{
		super( filePath_ );
	}//}}}
	public HtmlWriter( XmlWriter xml_ )
	{//{{{
		super( xml_ );
	}//}}}
	public void setHeight( String value_ )
	{//{{{
		height = value_;
	}//}}}
	public void printHeight()
	{//{{{
		if( height != null ){
			out.printf( " height=\"%s\"%n", height );
		}
	}//}}}
	public void setWidth( String value_ )
	{//{{{
		width = value_;
	}//}}}
	public void printWidth()
	{//{{{
		if( height != null ){
			out.printf( " width=\"%s\"%n", width );
		}
	}//}}}

	public void beginHtmlTag()
	{//{{{
		out.println( "<html>" );
	}//}}}
	public void endHtmlTag()
	{//{{{
		out.println( "</html>" );
	}//}}}
	public void beginHeadTag()
	{//{{{
		out.println( "<head>" );
	}//}}}
	public void endHeadTag()
	{//{{{
		out.println( "</head>" );
	}//}}}
	public void printHeadTag()
	{//{{{
		out.println( "<head/>" );
	}//}}}
	public PrintStream beginCssTag()
	{//{{{
		out.println( "<style type=\"text/css\">" );
		return beginComment();
	}//}}}
	public void endCssTag()
	{//{{{
		endComment();
		out.println( "</style>" );
	}//}}}
	public void beginBodyTag()
	{//{{{
		out.println( "<body>" );
	}//}}}
	public void endBodyTag()
	{//{{{
		out.println( "</body>" );
	}//}}}
	public void beginDivTag()
	{//{{{
		out.println( "<div>" );
	}//}}}
	public void beginDivTag( String class_ )
	{//{{{
		out.printf( "<div class=\"%s\">%n", class_ );
	}//}}}
	public void endDivTag()
	{//{{{
		out.println( "</div>" );
	}//}}}
	public void printDivTag( String value_, String class_ )
	{//{{{
		out.printf( "<div class=\"%s\">%s</div>%n", class_, value_ );
	}//}}}
	public void beginSpanTag()
	{//{{{
		out.print( "<span>" );
	}//}}}
	public void beginSpanTag( String class_ )
	{//{{{
		out.printf( "<span class=\"%s\">", class_ );
	}//}}}
	public void endSpanTag()
	{//{{{
		out.println( "</span>" );
	}//}}}
	public void printSpanTag( String value_, String class_ )
	{//{{{
		out.printf( "<span class=\"%s\">%s</span>%n", class_, value_ );
	}//}}}
	public void beginATag( String href_ )
	{//{{{
		out.printf( "<a href=\"%s\">", href_ );
	}//}}}
	public void beginATag( String href_, String class_ )
	{//{{{
		out.printf( "<a class=\"%s\" href=\"%s\">%n", class_, href_ );
	}//}}}
	public void endATag()
	{//{{{
		out.println( "</a>" );
	}//}}}
	public void printATagHref( String text_, String href_, String class_ )
	{//{{{
		if( class_ == null ){
			out.printf( "<a href=\"%s\">%s</a>%n", href_, text_ );
		}
		else{
			out.printf( "<a class=\"%s\" href=\"%s\">%s</a>%n", class_, href_, text_ );
		}
	}//}}}
	public void printImgTag( String src_ )
	{//{{{
		printImgTag( src_, null );
	}//}}}
	public void printImgTag( String src_, String class_ )
	{//{{{
		if( class_ == null ){
			out.printf( "<img src=\"%s\"", src_ );
		}
		else{
			out.printf( "<img src=\"%s\" class=\"%s\"", src_, class_ );
		}
		printWidth();
		printHeight();
		out.println( "/>" );
	}//}}}
}//}}}

