// vim: foldmethod=marker commentstring=//%s
package mygame;

import com.jme3.animation.SkeletonControl;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import com.jme3.scene.Spatial;
import com.jme3.scene.Node;
import com.jme3.scene.AssetLinkNode;
import com.jme3.asset.ModelKey;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import java.util.HashMap;
import java.io.IOException;

public class DressControl extends AbstractControl implements Cloneable, Savable
{//{{{
	String targetName = null;
	SkeletonControl targetSkeleton;
	HashMap<String,Spatial> dressMap = new HashMap<String, Spatial>();
	public String getTargetName()
	{//{{{
		return targetName;
	}//}}}
	public void setTargetName( String value_ )
	{//{{{
		targetName = value_;
	}//}}}
	public void attachChild( String bone_, Spatial sp_ )
	{//{{{
		dressMap.put( bone_, sp_ );
	}//}}}
	public void attachChild( String bone_, String key_ )
	{//{{{
		dressMap.put( bone_, new AssetLinkNode( new ModelKey( key_ ) ) );
	}//}}}
	static SkeletonControl findSkeleton( Spatial sp_, String name_ )
	{//{{{
		if( name_ == null ){
			SkeletonControl ct_ = sp_.getControl( SkeletonControl.class );
			if( ct_ != null ){
				return ct_;
			}
		}
		else{
			if( name_.equals( sp_.getName() ) ){
				SkeletonControl ct_ = sp_.getControl( SkeletonControl.class );
				if( ct_ != null ){
					return ct_;
				}
			}
		}
		if( sp_ instanceof Node ){
			Node node_ = (Node)sp_;
			for( Spatial child_ : node_.getChildren() ){
				SkeletonControl ct_ = findSkeleton( child_, name_ );
				if( ct_ != null ){
					return ct_;
				}
			}
		}
		return null;
	}//}}}
	void updateSkeleton( Spatial sp_ )
	{//{{{
		if( targetSkeleton != null ){
			return;
		}
		targetSkeleton = findSkeleton( sp_, targetName );
		if( targetSkeleton == null ){
			return;
		}
		for( String bone_ : dressMap.keySet() ){
			Node node_ = targetSkeleton.getAttachmentsNode( bone_ );
			node_.attachChild( dressMap.get( bone_ ) );
		}
	}//}}}
	@Override
	public void setSpatial(Spatial sp_)
	{//{{{
		super.setSpatial(sp_);
		updateSkeleton( sp_ );
	}//}}}
	@Override
	public Control cloneForSpatial(Spatial sp_)
	{//{{{
		DressControl ctrl_ = new DressControl();
		ctrl_.spatial = sp_;
		for( String bone_ : dressMap.keySet() ){
			ctrl_.attachChild( bone_, dressMap.get( bone_ ) );
		}
		return ctrl_;
	}//}}}
	@Override
	protected void controlUpdate(float tpf)
	{//{{{
		updateSkeleton( getSpatial() );
	}//}}}
	@Override
	protected void controlRender(RenderManager rm, ViewPort vp)
	{//{{{
	}//}}}
	final static String TARGET_NAME="target-name";
	final static String DRESSES="dresses";
	@Override
	public void write(JmeExporter ex_) throws IOException
	{//{{{
		super.write(ex_);
		OutputCapsule oc_ = ex_.getCapsule(this);
		oc_.write( targetName, TARGET_NAME, null );
		oc_.writeStringSavableMap(dressMap, DRESSES, null);
	}//}}}
	@Override
	public void read(JmeImporter im_) throws IOException
	{//{{{
		super.read(im_);
		InputCapsule in_ = im_.getCapsule(this);
		{
			HashMap<String,Spatial> map_ = (HashMap<String,Spatial>)in_.readStringSavableMap(DRESSES, null);
			if( map_ != null ){
				dressMap = map_;
			}
		}
		targetName = in_.readString( TARGET_NAME, null );
		updateSkeleton( getSpatial() );
	}//}}}
}//}}}
