# import.sh
# -----------------------------------------------------------------------------
#
# Implementation of mingw-port initialization and upstream source code
# import handlers for mingw-pkg
#
# -----------------------------------------------------------------------------
#
  phase import "import package sources"
#
# $Id$
#
# Written by Keith Marshall <keith@users.osdn.me>
# Copyright (C) 2018, MinGW.org Project
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# -----------------------------------------------------------------------------
#
# Establish a default internet location for the mingw-port repository.
#
: ${MINGW_PORT_REPOSITORY="https://osdn.net/dl/mingw"}

# If the PORTSPEC variable is defined, and not empty, then we are initializing
# a source tree from a mingw-port.  In this case, PACKAGE and VERSION variables
# MUST match the PORTSPEC definition, but may have been inappropriately deduced
# from PACKAGE_ABS_SRCDIR; override any such prior deduction.
#
  test -z "$PORTSPEC" || {
    step "verify '$PORTSPEC' mingw-port properties"
    PACKAGE=`pkgspec_from_srcdir get_name $PORTSPEC`
    VERSION=`pkgspec_from_srcdir get_version $PORTSPEC`
    PACKAGE_ABS_SRCDIR=${PACKAGE_DEPOT=`pwd`}/$PACKAGE-$VERSION
    PACKAGE_SRCDIR=$PACKAGE_ABS_SRCDIR SRCDIR=$PACKAGE_SRCDIR
  }

# From this point onwards, we need PORTSPEC to be appropriately defined; it is
# also convenient to map PACKAGE_DEPOT to the parent of PACKAGE_ABS_SRCDIR.
#
  PORTSPEC=${PORTSPEC-"$PACKAGE-$VERSION"}
  PACKAGE_DEPOT=`dirname $PACKAGE_ABS_SRCDIR`

# Provide a local helper function, to dispose of temporary download files
# in the event of premature termination.
#
  import_failed(){ rm -rf ./tmp; die "$@"; }

# Check for prior existence of a package specification file, in the standard
# location for a mingw-port or mingw-pkg compliant source tree...
#
  step "checking '$PORTSPEC-$ARCH.pkgspec' availability"
  pkgspec="$PACKAGE_ABS_SRCDIR/arch/$ARCH/$PORTSPEC-$ARCH.pkgspec"
  set_download_dir(){ test -d "$1" || mkdir -p "$1"; }
  test -f "$pkgspec" || {
  # ...but, when no such specification file is present, try to find a locally
  # cached mingw-port file, from which to initialize the mingw-port components
  # of the source tree content...
  #
    PORTSPEC="$PORTSPEC-$ARCH-port.tar.xz"
    step "checking '$PORTSPEC' availability"
    for dir in . "$MINGW_PORT_DIR" "${DOWNLOAD_CACHE_DIR="./tmp"}"
      do test -f "$dir/$PORTSPEC" && { PORTSPEC="$dir/$PORTSPEC"; break; }
      done
    test -f "$PORTSPEC" || {
    # ...or, failing a locally cached mingw-port, try to download one from
    # the default internet mingw-port repository.
    #
      step "downloading $PORTSPEC"
      set_download_dir ${PORTDIR="${MINGW_PORT_DIR-"./tmp"}"}
      ( cd "$PORTDIR" && wget $MINGW_PORT_REPOSITORY/$PORTSPEC )
      test -f "$PORTDIR/$PORTSPEC" && PORTSPEC="$PORTDIR/$PORTSPEC"
    }
    # Failure to locate, or download a mingw-port archive stops the show...
    #
    test -f "$PORTSPEC" || import_failed "file '$PORTSPEC' not found"

    # ...but, if we get this far, we may now initialize the mingw-port content
    # within the package source tree, by unpacking the mingw-port archive...
    #
    ( cd "$PACKAGE_DEPOT" && tar xf "$PORTSPEC" )
  }

# By now, there should be a working package specification in place; try to load
# (or reload) it now, if present, otherwise we cannot proceed any further.
#
  test -f "$pkgspec" && action_load_package_specs "$pkgspec" \
    || import_failed "file '`basename $pkgspec`' not found"

  tarname=$PACKAGE_SOURCE_URI_NAME
  step "checking '$tarname' availability"
  for dir in . "${DOWNLOAD_CACHE_DIR="./tmp"}"
    do test -f "$dir/$tarname" && { tarname="$dir/$tarname"; break; }
    done

  test -f "$tarname" || {
    step "downloading '$tarname'"
    set_download_dir "$DOWNLOAD_CACHE_DIR"
    ( cd "$DOWNLOAD_CACHE_DIR" && wget "$PACKAGE_SOURCE_URI_PATH/$tarname" )
    tarname="`cd "$DOWNLOAD_CACHE_DIR" && pwd`/$tarname"
  }

  test -f "$tarname" || import_failed "file '`basename "$tarname"`' not found"

  dir="`dirname "$tarname"`"
  tarname="`cd "$dir" && pwd`/`basename "$tarname"`"
  ( cd "$PACKAGE_DEPOT" && tar xf "$tarname" )

  rm -rf ./tmp

  phase "done."
#
# -----------------------------------------------------------------------------
# $RCSfile$: end of file
