#!/bin/sh
# -----------------------------------------------------------------------------
#
# mingw-pkg.sh
#
  APPNAME="%PACKAGE%" APPVERSION="%VERSION%"
#
# A simple package construction tool for creation of MinGW packages.
#
# $Id$
#
# Written by Keith Marshall <keith@users.osdn.me>
# Copyright (C) 2011-2013, 2018, 2019, MinGW.org Project
#
  COPYRIGHT_YEARS="2011-2013, 2018, 2019"
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# -----------------------------------------------------------------------------
#
# Save the effective command name, for use in diagnostic messages.
#
  cmd=`basename "$0" .sh` cmd_version=${APPVERSION-"%VERSION%"}

# Establish the paths for application support files and extensions.
#
  approotdir=`dirname "$0"`
  test "x`basename "$approotdir"`" = xbin && approotdir=`dirname "$approotdir"`
  libexecdir="$approotdir/libexec/$cmd/$cmd_version"

# Implement the module/plugin loader...
#
  require(){ load "$@" || die "$1 '$2' not found"; }
  load(){ test -f "$libexecdir/${1}s/$2.sh" && . "$libexecdir/${1}s/$2.sh"; }
  die(){ echo >&2 "$error_colour$cmd: *** FATAL *** $@$unbold"; exit 1; }

# ...and load the primary application configuration module; (note that
# this is expected to provide implementations for the optchk and dispatch
# functions, which will be used for option and action handling, below).
#
  require module config

# Evaluate processing options and local variable assignments,
# as specified by the user, on the command line.
#
  while optchk "$@"
  do shift $argshift; test "x${optmatch}x" = "x--x" && break; done

# After option processing, load the package specification interpreter,
# together with any pertinent package specification...
#
  require module pkgspec

# ...and finally, evaluate any residual command line arguments as
# action requests.
#
  for request; do dispatch "$request"; done
#
# -----------------------------------------------------------------------------
# $RCSfile$: end of file
