# hg.sh
# -----------------------------------------------------------------------------
#
# mingw-pkg plug-in to facilitate the use of mercurial for tracking of changes
# made to the upstream package code, and generation of patch-sets, as required
# for building with MinGW, and for creation of MinGW source distributables.
#
# -----------------------------------------------------------------------------
#
# $Id$
#
# Written by Keith Marshall <keithmarshall@users.sourceforge.net>
# Copyright (C) 2011, 2012, 2013, MinGW.org Project
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# -----------------------------------------------------------------------------
#
  ARCH_DEFAULT=${ARCH_DEFAULT-"mingw32"}

  STAGED_PKGDIR=${STAGED_PKGDIR-"`pwd`/dist"}
  STAGED_INSTALLDIR=$STAGED_PKGDIR/staged

  HG_CMD="hg --cwd `cd $PACKAGE_SRCDIR; pwd`"

  defn_add_hook initialize plugin hg_plugin_initialize
  hg_plugin_initialize(){
    phase "initialize local mercurial repository"
    ( cd $PACKAGE_SRCDIR
      hg init
      step `hg branch origin`; echo
      cat > .hgignore <<-EOF
	syntax: glob
	.hgignore
	**.pkgspec
	**.patch
	build/
	dist/
	EOF
      hg add . > /dev/null
      hg commit -m "Initial import of upstream $PACKAGE-$VERSION."
      hg log
      step `hg branch master`; echo
      hg commit -m "Initialize master branch for upstream patches."
      hg log -l 1
      step `hg branch ${ARCH-"$ARCH_DEFAULT"}`; echo
    )
  }

  hg_plugin_load_package_specs(){
    action_prepare_package_specs
    test -f $PACKAGE_SRCDIR/arch/${ARCH="`$HG_CMD branch 2> /dev/null \
      || defn_parameter_list $ARCH_DEFAULT`"}/$PACKAGE-$VERSION-$ARCH.pkgspec && \
      . $PACKAGE_SRCDIR/arch/$ARCH/$PACKAGE-$VERSION-$ARCH.pkgspec
  }

  action_load_package_specs(){ hg_plugin_load_package_specs; }

  defn_set_hook stage_srcdist plugin hg_plugin_stage_srcdist
  hg_plugin_stage_srcdist(){
    rm -rf ${STAGED_SRCDIR="$STAGED_PKGDIR/$PACKAGE-$VERSION"}
    mkdir -p $STAGED_SRCDIR/arch/${ARCH="`$HG_CMD branch`"}
    step "replicate original source tree"
    ( cd $PACKAGE_SRCDIR
      hg archive -r origin -X '.hg*' $STAGED_SRCDIR
      for patchfile in arch/any/*
      do test -f $patchfile && {
	  tar chf - --hard-dereference arch/any | (cd $STAGED_SRCDIR && tar xf -)
	  break
	}
      done
      hg status | grep > /dev/null '^?' && {
	warning "untracked files in source tree..."
	hg status | awk >&2 '/^?/{print "'"$warning_colour"'"$0"'"$unbold"'"}'
      }
      specsfile="arch/$ARCH/$PACKAGE-$VERSION-$ARCH.pkgspec"
      test -f $specsfile && cp $specsfile $STAGED_SRCDIR/$specsfile
      patchfile="arch/$ARCH/$PACKAGE-$VERSION${RELEASE+"-$RELEASE"}-$ARCH.patch"
      echo ; step "compiling patch '$patchfile'"
      hg diff -r master -X arch/$ARCH > $STAGED_SRCDIR/$patchfile
      test -n "`grep -l . $STAGED_SRCDIR/$patchfile`" && {
	step "checking ... '$patchfile' committed for distribution"; } || {
	step "checking ... no patches required; '$patchfile' discarded"
	rm $STAGED_SRCDIR/$patchfile
      }
    )
  }
#
# -----------------------------------------------------------------------------
# $RCSfile$: end of file
