# mq-series-list.sh
# ------------------------------------------------------------------------------
#
# Common back-end implementation for all of the "git qseries", "git qapplied",
# "git qunapplied", "git qtop", "git qnext", and "git qprev" commands.
#
# ------------------------------------------------------------------------------
#
# $Id$
#
# Written by Keith Marshall <keith@users.osdn.me>
# Copyright (C) 2018, 2019, Keith Marshall
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# ------------------------------------------------------------------------------
#
# First, initialize colourized output format controls.
#
  mq_require mq-series-list-colour

# Finally, resolve the path names for the "guards", "series", and "status"
# files, then use awk to parse them, producing the appropriately formatted
# patch queue status report.
#
  mq_map_control_file_refs "$mq_patchdir" guards series status
  mq_qseries_compile_report(){
    awk "$mq_function_why_guarded
      $mq_guards $mq_series $mq_status $mq_colour END {
      ${mq_qseries_report_setup-idx0 = 0;} $mq_qseries_fw_adjustment"'
      selector = "'${mq_qseries_state_selector-"?"}'";
      for( idx = idx0; entries > idx; idx++ )
      { $0 = series[idx];
	if( (selector != "?") && (state[$1] != selector) ) continue;
	if('"${mq_qseries_append_summary-0}"')
	{ summary = "sed -n '"'/^#/d;/^$/q;/^diff /q;p;q' $mq_patchdir"'/" $1;
	  if( system( summary "> /dev/null 2>&1" ) == 0 )
	  { tmp = ""; summary | getline tmp; close( summary ); }
	  else tmp = "'"`mq_error 'patch file missing or unreadable'`"'";
	  summary = ": " tmp;
	}'"
	${mq_output=print}"' mq_apply_colour( $1 ) summary;
      }
    }' $mq_guards_file $mq_series_file $mq_status_file
  }
  ${mq_qseries_show_missing-false} && {
    ( mq_enumerate_patches "$mq_patchdir" ) | mq_qseries_compile_report
  } || {
    test "${mq_output+set}" = set && mq_qseries_fw_adjustment='
      fw = 1; if( (entries > 1) && (entries > idx0) )
	fw += int( log( entries - 1 ) / log( 10 ) );'
    mq_qseries_compile_report
  }
#
# ------------------------------------------------------------------------------
# $RCSfile$: end of file
