# mq-message-opts.sh
# ------------------------------------------------------------------------------
#
# Supplementary shell script fragment; it implements helper functions to
# collect and validate the commit log message options, which may be passed
# to the handlers for the "qnew", "qrefresh", and "qfold" subcommands.
#
# ------------------------------------------------------------------------------
#
# $Id$
#
# Written by Keith Marshall <keith@users.osdn.me>
# Copyright (C) 2019, Keith Marshall
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# ------------------------------------------------------------------------------
#
# Recognizing that neither Mercurial nor Git allow the combination of the
# "--message" option with the "--logfile" option (in Mercurial's case), or
# the "--file" option (in Git's case); we provide the following helper to
# trap any violation of this constraint, and abort the command early.
#
  mq_reject_opt_conflict() {
    local reason_for_rejection="fatal: cannot combine options '$1' and '$2'"
    test "x$3" = "x${4-$3}" || mq_abort 2 "$reason_for_rejection"
  }
# Now, we may implement the primary API entry for this module; we accept
# "--file" and "--logfile" options as aliases, and map both to the former,
# while collecting it, or any other option without modification, together
# with a mandatory argument, into the "mq_msgopt" shell variable.
#
  mq_collect_valid_msgopt() {
    local collect_option="--file"
    test "x$1" = "x--logfile" || collect_option="$1"
    mq_reject_opt_conflict "${mq_msgsrc=$1}" "$1" "$collect_option" $mq_msgopt
    mq_collect mq_msgopt "$collect_option '$2'"
  }
#
# ------------------------------------------------------------------------------
# $RCSfile$: end of file
