.nr HY 0
.TH GIT\-QUNAPPLIED 1 @DATE@ "Git-MQ @PACKAGE_VERSION@" "Git-MQ Commands"
.\" ----------------------------------------------------------------------------
.\"
.\" $Id$
.\"
.\" Written by Keith Marshall <keith@users.osdn.me>
.\" Copyright (C) 2019, Keith Marshall
.\"
.\"
.\" This man page file is part of the Git-MQ program suite.
.\"
.\" Permission is granted to copy, distribute and/or modify this document
.\" under the terms of the GNU Free Documentation Licence, Version 1.3 or any
.\" later version published by the Free Software Foundation; with no Invariant
.\" Sections, no Front-Cover Texts, and no Back-Cover Texts, but subject to
.\" the restriction that all existing author attribution, and all existing
.\" copyright notices, shall be preserved.  A copy of the licence is
.\" included in the Git-MQ source distribution.
.\"
.\" ----------------------------------------------------------------------------
.
.na
.SH NAME
git\-qunapplied \- list unapplied entries from the patch series file
.
.
.SH SYNOPSIS
.BR git\ qunapplied \ [ \-v \ |\  \-\-verbose ]\ [\c
.BR \-s \ |\  \-\-summary ]\ [ \-1 \ |\  \-\-first ]
.
.
.ad b
.SH DESCRIPTION
The
.B git\ qunapplied
command displays, in series order,
the names of all patches which have been registered
as members of the active
.B Git\-MQ
patch series,
.I and
which are currently in the
.IR unapplied ,
and
.I unguarded
state,
(i.e.\ all registered, unapplied, and unguarded patches,
in series order,
which follow the topmost applied patch,
as indicated by the
.B git\ qtop
command).
.LP
Note that,
any unapplied patches which
.I precede
the topmost applied patch,
in series order,
due to having been guarded at the time when they would
normally have been applied,
whether or not they remain guarded,
are never listed in the output from the
.B git\ unapplied
command.
.LP
If the
.B \-\-verbose
option is specified,
the displayed list of patch names is extended
to include any patches which follow the topmost applied patch,
in series order,
and which are guarded to prevent them being applied
in the current guard state,
as established by the
.B git\ qselect
command;
each patch name listed is preceded by its sequence number,
and application status flag,
as described for the
.B git\ qseries
command.
.LP
If the
.B \-\-summary
option is specified,
the commit summary line, if available in the patch header,
is displayed following each patch name.
.LP
If the
.B \-\-first
option is specified,
the output is reduced to the display of only the
.I one
patch, if any,
which is the next available patch in the series,
following the topmost applied patch.
This is effectively equivalent to the output of the
.B git\ qnext
command,
.I except
in the case when the first unapplied patch is guarded,
in which case the
.B git\ qunapplied
command identifies the guarded patch,
whereas the
.B git\ qnext
command identifies the next available
.I unguarded
patch.
.
.
.SH OPTIONS
.TP 4n
.BR \-1 ,\  \-\-first
Show only the next available patch,
which may be applied by subsequent execution of the
.B git\ qpush
command.
.TP
.BR \-s ,\  \-\-summary
Include summary lines from patch headers.
.TP
.BR \-v ,\  \-\-verbose
Show patch sequence numbers and status flags.
.
.
.SH EXIT STATUS
On successful completion,
.B git\ qunapplied
reports an exit status code of 0.
Any \%non\(hyzero exit status code indicates that an error occurred.
.
.
.SH COMPARISON WITH MERCURIAL QUEUES
Inspired by,
and for the most part based on behavioural observation of
.BR Mercurial \(aqs\  MQ
extension,
the
.B git\ qunapplied
command exhibits fundamentally the same behaviour as its
.B hg\ qunapplied
counterpart.
.
.
.SH CAVEATS AND BUGS
The
.B \-\-first
option is not particularly useful,
unless accompanied by the
.B \-\-verbose
option.
In the case when the first unapplied patch is guarded,
and without the
.B \-\-verbose
option,
the difference between the guarded and unguarded patch state
is distinguishable only if colour coding of the output is enabled.
This differs from the (also unhelpful) behaviour of the
.B hg qunapplied \-\-first
command, which suppresses
.I all
output for a guarded patch, unless the
.B \-\-verbose
option is also selected.
.
.
.SH AUTHOR
Copyright (C) 2019, by Keith Marshall
.
.LP
This man page was written by
Keith\ Marshall\ <keith@users.osdn.me>,
to accompany the
.B Git\-MQ
program suite.
It is published under the terms of the GNU Free Documentation Licence,
version\~1.3,
(or any later version published by the Free Software Foundation),
with no Invariant Sections,
no Front\(hyCover Texts, and no Back\(hyCover Texts.
.
.LP
The
.B Git\(hyMQ
program suite itself is distibruted under the terms of the
GNU General Public Licence, version\~3,
(or any later version published by the Free Software Foundation).
.
.LP
Copies of the GNU Free Documentation Licence,
and of the GNU General Public Licence,
are included within the
.B Git\(hyMQ
source distribution,
in the files
.BR FDL\-1.3 ,
and
.BR LICENCE ,
respectively.
.
.
.na
.SH SEE ALSO
.BR git\-qapplied (1),
.BR git\-qnext (1),
.BR git\-qpush (1),
.BR git\-qseries (1),
.BR git\-qtop (1)
.
.\" ----------------------------------------------------------------------------
.\" $RCSfile$: vim:set ft=groff: end of file
