.nr HY 0
.TH GIT\-QPUSH 1 @DATE@ "Git-MQ @PACKAGE_VERSION@" "Git-MQ Commands"
.\" ----------------------------------------------------------------------------
.\"
.\" $Id$
.\"
.\" Written by Keith Marshall <keith@users.osdn.me>
.\" Copyright (C) 2019, Keith Marshall
.\"
.\"
.\" This man page file is part of the Git-MQ program suite.
.\"
.\" Permission is granted to copy, distribute and/or modify this document
.\" under the terms of the GNU Free Documentation Licence, Version 1.3 or any
.\" later version published by the Free Software Foundation; with no Invariant
.\" Sections, no Front-Cover Texts, and no Back-Cover Texts, but subject to
.\" the restriction that all existing author attribution, and all existing
.\" copyright notices, shall be preserved.  A copy of the licence is
.\" included in the Git-MQ source distribution.
.\"
.\" ----------------------------------------------------------------------------
.
.na
.SH NAME
git\-qpush \- push patches on to the Git\-MQ patch stack
.
.
.SH SYNOPSIS
.B git qpush
.RB [[ \-f \ [ \-\-no-backup ]]\ |\  \-\-keep\-changes ]\ [< \fIpatch >]
.br
.B git qpush
.RB [[ \-f \ [ \-\-no-backup ]]\ |\  \-\-keep\-changes ]\ [< \fIindex >]
.br
.B git qpush
.RB [[ \-f \ [ \-\-no-backup ]]\ |\  \-\-keep\-changes ]\ [ \-a \ |\  \-\-all ]
.br
.B git qpush
.RB [[ \-f \ [ \-\-no-backup ]]\ |\  \-\-keep\-changes ]\  \-\-move \ < \fIpatch >
.br
.B git qpush
.RB [[ \-f \ [ \-\-no-backup ]]\ |\  \-\-keep\-changes ]\  \-\-move \ < \fIindex >
.
.
.ad b
.SH DESCRIPTION
The
.B git\ qpush
command will push patches on to the
.B Git\-MQ
applied patch stack,
until the patch specified by the
.RI < patch >
argument (an
.I unapplied
and
.I unguarded
patch
.IR name ),
or by the
.RI < index >
argument (an
.I unapplied
and
.I unguarded
patch
.IR sequence\~number ,
as reported by the
.B git\ qseries\ \-\-verbose
command),
becomes the topmost applied patch.
.
.LP
If the
.B \-a
.RB (or\  \-\-all )
option is selected,
then no
.RI < patch >
or
.RI < index >
argument should be specified;
this will push
.I all
\%currently\(hyunapplied and unguarded patches,
which
.I follow
the topmost \%currently\(hyapplied patch in series order,
on to the patch stack.
.
.LP
If no
.RI < patch >
or
.RI < index >
argument is specified,
and the
.B \-\-all
option is not selected,
then only one patch will be pushed;
this will be the first unapplied and unguarded patch which
follows the topmost \%currently\(hyapplied patch,
in series order,
(i.e.\ the patch, if any, which would be identified by the
.B git\ qnext
command).
.
.LP
The
.B \-\-move
option may be used to relocate any unapplied and unguarded patch,
which
.I follows
the patch identified by
.B git\ qnext
as the first pushable patch,
such that the relocated patch is pushed ahead of the
.B git\ qnext
identified patch,
which then remains as the first pushable patch.
.
.LP
If there are no patches which are both unapplied and unguarded,
.I following
the topmost \%currently\(hyapplied patch in series order,
the
.B git\ qpush
operation will fail.
.
.
.SH OPTIONS
.TP 4n
.BR \-a ,\  \-\-all
Push all available unapplied and unguarded patches,
which
.I follow
the topmost \%currently\(hyapplied patch in series order.
.
.TP
.BR \-f ,\  \-\-force
If any files,
known to and tracked by git,
have been locally modified in the working tree,
or in git\(aqs index,
and the
.B \-\-no\-backup
option has not been specified,
first make backup backup copies of all locally modified files;
discard all local modifications,
then push patches as appropriate.
.TP
\&
If the
.B \-\-force
option is not specified,
.B git\ qpush
will abort in the presence of local modifications.
.
.TP
.B \-\-no-backup
Used only in conjunction with
.BR \-\-force ,
(and silently ignored otherwise),
discard all local modifications,
.I without
making backup copies.
.
.TP
.B \-\-keep\-changes
Attempt to preserve local modifications,
while pushing patches;
if any local modification conflicts with patch content,
abort the entire
.B git\ qpush
operation.
.TP
\&
(The
.B \-\-keep\-changes
option is currently unimplemented).
.
.TP
.BR \-\-move \ < \fIpatch >,\  \-\-move \ < \fIindex >
Push only the single patch identified by the
.RI < patch >,
or the
.RI < index >
option,
(one of which
.I must
be specified),
relocating it in the patch series if necessary,
such that it is pushed ahead of the patch which would
have been identified by the
.B git\ qnext
command.
.TP
\&
The
.B \-\-move
option can only be used to move a patch which follows
the topmost \%currently\(hyapplied patch in series order; it
.I cannot
be used to push a previously skipped patch,
which precedes the current topmost patch in series order.
.
.LP
If there are local modifications to tracked files,
either in the working tree,
or staged in git\(aqs index,
and if neither the
.B \-\-force
option,
nor the
.B \-\-keep\-changes
option is specified,
then the
.B git\ qpush
operation will be aborted.
.
.
.SH EXIT STATUS
On successful completion,
.B git\ qpush
reports an exit status code of 0.
Any \%non\(hyzero exit status code indicates that an error occurred.
.
.
.SH COMPARISON WITH MERCURIAL QUEUES
Inspired by,
and for the most part based on behavioural observation of
.BR Mercurial \(aqs\  MQ
extension,
the
.B git\ qpush
command exhibits fundamentally the same behaviour as its
.B hg\ qpush
counterpart.
.
.
.SH AUTHOR
Copyright (C) 2019, by Keith Marshall
.
.LP
This man page was written by
Keith\ Marshall\ <keith@users.osdn.me>,
to accompany the
.B Git\-MQ
program suite.
It is published under the terms of the GNU Free Documentation Licence,
version\~1.3,
(or any later version published by the Free Software Foundation),
with no Invariant Sections,
no Front\(hyCover Texts, and no Back\(hyCover Texts.
.
.LP
The
.B Git\(hyMQ
program suite itself is distibruted under the terms of the
GNU General Public Licence, version\~3,
(or any later version published by the Free Software Foundation).
.
.LP
Copies of the GNU Free Documentation Licence,
and of the GNU General Public Licence,
are included within the
.B Git\(hyMQ
source distribution,
in the files
.BR FDL\-1.3 ,
and
.BR LICENCE ,
respectively.
.
.
.na
.SH SEE ALSO
.BR git\-qgoto (1),
.BR git\-qnext (1),
.BR git\-qseries (1)
.
.\" ----------------------------------------------------------------------------
.\" $RCSfile$: vim:set ft=groff: end of file
