.nr HY 0
.TH GIT\-QGOTO 1 @DATE@ "Git-MQ @PACKAGE_VERSION@" "Git-MQ Commands"
.\" ----------------------------------------------------------------------------
.\"
.\" $Id$
.\"
.\" Written by Keith Marshall <keith@users.osdn.me>
.\" Copyright (C) 2019, Keith Marshall
.\"
.\"
.\" This man page file is part of the Git-MQ program suite.
.\"
.\" Permission is granted to copy, distribute and/or modify this document
.\" under the terms of the GNU Free Documentation Licence, Version 1.3 or any
.\" later version published by the Free Software Foundation; with no Invariant
.\" Sections, no Front-Cover Texts, and no Back-Cover Texts, but subject to
.\" the restriction that all existing author attribution, and all existing
.\" copyright notices, shall be preserved.  A copy of the licence is
.\" included in the Git-MQ source distribution.
.\"
.\" ----------------------------------------------------------------------------
.
.na
.SH NAME
git\-qgoto \- push or pop patches until specified patch is topmost
.
.
.SH SYNOPSIS
.B git qgoto
.RB [[ \-f \ [ \-\-no-backup ]]\ |\  \-\-keep\-changes ]\ < \fIpatch >
.br
.B git qgoto
.RB [[ \-f \ [ \-\-no-backup ]]\ |\  \-\-keep\-changes ]\ < \fIindex >
.
.
.ad b
.SH DESCRIPTION
The
.B git\ qgoto
command will either push patches on to,
or pop patches from the
.B Git\-MQ
applied patch stack,
until the patch specified by the
.RI < patch >
argument (a patch
.IR name ),
or by the
.RI < index >
argument (a patch
.IR sequence\~number ,
as reported by the
.B git\ qseries\ \-\-verbose
command),
becomes the topmost applied patch.
.
.LP
While pushing, or popping patches,
.B git\ qgoto
will report the identity of each patch processed;
additionally,
if the
.B \-\-verbose
option (which is supported by
.I all
.B Git\-MQ
commands) is specified,
while pushing patches,
it will also report the identity of any guarded patches
which are skipped.
.
.LP
Note that,
unlike the
.B git\ qpop\ \-\-all
command,
.B git\ qgoto
is unable to pop
.I all
applied patches;
it
.I can
emulate the
.B git\ qpush\ \-\-all
operation,
but less conveniently,
since it is necessary to pass the name,
or sequence number of the last pushable patch,
as argument,
whereas
.B git\ qpush\ \-\-all
determines this implicitly.
.
.
.SH OPTIONS
.TP 4n
.BR \-f ,\  \-\-force
If any files,
known to and tracked by git,
have been locally modified in the working tree,
or in git\(aqs index,
and the
.B \-\-no\-backup
option has not been specified,
first make backup backup copies of all locally modified files;
discard all local modifications,
then push or pop patches,
as appropriate.
.TP
\&
If the
.B \-\-force
option is not specified,
.B git\ qgoto
will abort in the presence of local modifications.
.
.TP
.B \-\-no-backup
Used only in conjunction with
.BR \-\-force ,
(and silently ignored otherwise),
discard all local modifications,
.I without
making backup copies.
.
.TP
.B \-\-keep\-changes
Attempt to preserve local modifications,
while pushing or popping patches;
if any local modification conflicts with patch content,
abort the entire
.B git\ qgoto
operation.
.TP
\&
(The
.B \-\-keep\-changes
option is currently unimplemented).
.
.LP
If there are local modifications to tracked files,
either in the working tree,
or staged in git\(aqs index,
and if neither the
.B \-\-force
option,
nor the
.B \-\-keep\-changes
option is specified,
then the
.B git\ qgoto
operation will be aborted.
.
.
.SH EXIT STATUS
On successful completion,
.B git\ qgoto
reports an exit status code of 0.
Any \%non\(hyzero exit status code indicates that an error occurred.
.
.
.SH COMPARISON WITH MERCURIAL QUEUES
Inspired by,
and for the most part based on behavioural observation of
.BR Mercurial \(aqs\  MQ
extension,
the
.B git\ qgoto
command exhibits fundamentally the same behaviour as its
.B hg\ qgoto
counterpart.
.
.
.SH AUTHOR
Copyright (C) 2019, by Keith Marshall
.
.LP
This man page was written by
Keith\ Marshall\ <keith@users.osdn.me>,
to accompany the
.B Git\-MQ
program suite.
It is published under the terms of the GNU Free Documentation Licence,
version\~1.3,
(or any later version published by the Free Software Foundation),
with no Invariant Sections,
no Front\(hyCover Texts, and no Back\(hyCover Texts.
.
.LP
The
.B Git\(hyMQ
program suite itself is distibruted under the terms of the
GNU General Public Licence, version\~3,
(or any later version published by the Free Software Foundation).
.
.LP
Copies of the GNU Free Documentation Licence,
and of the GNU General Public Licence,
are included within the
.B Git\(hyMQ
source distribution,
in the files
.BR FDL\-1.3 ,
and
.BR LICENCE ,
respectively.
.
.
.na
.SH SEE ALSO
.BR git\-qpop (1),
.BR git\-qpush (1),
.BR git\-qseries (1)
.
.\" ----------------------------------------------------------------------------
.\" $RCSfile$: vim:set ft=groff: end of file
