.nr HY 0
.TH GIT\-QDIFF 1 @DATE@ "Git-MQ @PACKAGE_VERSION@" "Git-MQ Commands"
.\" ----------------------------------------------------------------------------
.\"
.\" $Id$
.\"
.\" Written by Keith Marshall <keith@users.osdn.me>
.\" Copyright (C) 2019, Keith Marshall
.\"
.\"
.\" This man page file is part of the Git-MQ program suite.
.\"
.\" Permission is granted to copy, distribute and/or modify this document
.\" under the terms of the GNU Free Documentation Licence, Version 1.3 or any
.\" later version published by the Free Software Foundation; with no Invariant
.\" Sections, no Front-Cover Texts, and no Back-Cover Texts, but subject to
.\" the restriction that all existing author attribution, and all existing
.\" copyright notices, shall be preserved.  A copy of the licence is
.\" included in the Git-MQ source distribution.
.\"
.\" ----------------------------------------------------------------------------
.
.na
.SH NAME
git\-qdiff \- show changes in topmost patch and working tree
.
.
.SH SYNOPSIS
.B git\ qdiff\c
.RI \ [< option >\ ...]\ [< path >\ ...]
.
.
.ad b
.SH DESCRIPTION
The
.B git\ qdiff
command displays a
.B diff
representing the changes introduced by the currently topmost
.B Git\-MQ
managed patch,
augmented by any additional changes which have been made within
the working tree, or staged within
.BR git 's
index, since the patch was created,
or subsequently updated by
.RB \(lq git\ qrefresh \(rq;
this effectively represents the set of changes which will become
the content of the topmost patch, following execution of
.RB \(lq git\ qrefresh\ \-\-all \(rq.
.
.LP
To see changes in the working tree,
or in git's index,
since the last refresh of the topmost patch,
use
.RB \(lq git\ diff \(rq;
to see changes within the topmost patch,
but excluding changes in the working tree,
or in the index,
use
.RB \(lq git\ diff\ qtip^..qtip \(rq,
or
.RB \(lq git\ show \(rq.
.
.LP
.B git\ qdiff
is implemented in terms of
.BR git\ diff ,
and supports a subset of
.B git\ diff
options,
as itemized below;
if specified,
these will be passed on to
.BR git\ diff ,
to control its underlying behaviour.
Additionally,
if any
.RI < path >
arguments are specified,
the
.B git\ diff
output will be filtered,
to display only the changes affecting files
referenced by the specified paths.
.
.
.SH OPTIONS
.TP 4n
.BR \-a ,\  \-\-text
Treat the content of all files as text.
.
.TP
.BR \-U\fI<num> ,\  \-\-unified [=\fI<num> ]
Generate a
.B diff
in which
.I <num>
lines of common context are displayed,
rather than the default three lines.
.
.TP
.B \-\-ignore\-blank\-lines
Ignore differences which comprise only blank lines.
.
.TP
.BR \-b ,\  \-\-ignore\-space\-change
Ignore changes in the lengths of white space sequences.
This ignores white space at \%end\(hyof\(hyline,
and considers all other sequences of one or more white space
characters to be equivalent.
.
.TP
.BR \-w ,\  \-\-ignore\-all\-space
Ignore white space when comparing lines.
This ignores differences even if one line has white space
where the other line has none.
.
.TP
.B \-\-ignore\-space\-at\-eol
Ignore changes in the lengths of sequences of zero or more
white space characters at \%end\(hyof\(hyline.
.
.TP
.B \-\-stat
Display a
.B diffstat
summary of changes.
.
.
.SH EXIT STATUS
On successful completion,
.B git\ qdiff
reports an exit status code of 0.
Any \%non\(hyzero exit status code indicates that an error occurred.
.
.
.SH COMPARISON WITH MERCURIAL QUEUES
Inspired by,
and for the most part based on behavioural observation of
.BR Mercurial \(aqs\  MQ
extension,
the
.B git\ qdiff
command exhibits fundamentally the same behaviour as its
.B hg\ qdiff
counterpart;
notable differences are:\(em
.
.IP \(bu 3n
The
.BR \-\-nodates ,
.BR \-\-reverse ,
.BR \-I \ (or\  \-\-include ),
and
.BR \-X \ (or\  \-\-exclude )
options,
supported by
.BR hg\ qdiff ,
are unimplemented in
.BR git\ qdiff .
.
.IP \(bu 3n
The
.BR \-g \ (or\  \-\-git ),
and the
.BR \-p \ (or\  \-\-show\-function )
options,
as supported by
.BR hg\ qdiff ,
are not
.I explicitly
supported by
.BR git\ qdiff ;
however,
their effects are
.I implicitly inherent
within the underlying
.B git\ diff
implementation.
It is also worthy of note that the
.BR \-p ,
and the
.BR \-W \ (or\  \-\-function-context )
options,
which
.I are
supported by
.BR git\ diff ,
exhibit
.I different
behaviour from anything which is achievable with
.BR hg\ qdiff .
.
.IP \(bu 3n
.B hg\ qdiff
accepts
.B \-B
as a
.I documented
\%short\(hyform alias for the
.B \%\-\-ignore-blank-lines
option;
although this is not formally documented above,
.B git\ qdiff
does likewise;
however,
use of this feature is discouraged,
because
.B git\ diff
attributes a
.IR different ,
(and
.IR incompatible ),
meaning to its
.B \-B
option.
.
.IP \(bu 3n
The
.B \-\-ignore\-space\-at\-eol
option is specific to
.BR git\ qdiff ;
it is not supported by
.BR hg\ qdiff .
.
.
.SH AUTHOR
Copyright (C) 2019, by Keith Marshall
.
.LP
This man page was written by
Keith\ Marshall\ <keith@users.osdn.me>,
to accompany his
.B Git\-MQ
program suite.
It is published under the terms of the GNU Free Documentation Licence,
version\~1.3,
(or any later version published by the Free Software Foundation),
with no Invariant Sections,
no Front\(hyCover Texts, and no Back\(hyCover Texts.
.
.LP
The
.B Git\(hyMQ
program suite itself is distibruted under the terms of the
GNU General Public Licence, version\~3,
(or any later version published by the Free Software Foundation).
.
.LP
Copies of the GNU Free Documentation Licence,
and of the GNU General Public Licence,
are included within the
.B Git\(hyMQ
source distribution,
in the files
.BR FDL\-1.3 ,
and
.BR LICENCE ,
respectively.
.
.
.na
.SH SEE ALSO
.BR diff (1),
.BR git\-apply (1),
.BR git\-diff (1),
.BR git\-show (1)
.
.\" ----------------------------------------------------------------------------
.\" $RCSfile$: vim:set ft=groff: end of file
