<?php

## 外部クラス読み込み
# ヘッダーandフッター
include("./class/haf.class.php");
$Head_and_Footer = new haf();
# サブメニュー
include("./class/submenu.class.php");
$submenu = new submenu();
# ページ管理の処理クラス
include("./class/page.class.php");
$page_admin = new page();
# テンプレート管理クラス
include("./class/temp.class.php");
$temp_admin = new temp();
# ログファイル関連の外部処理クラス
include("./class/relatefile.class.php");
$relatefile = new relatefile();
# アクセスカウンター関連の外部処理クラス
include("./class/counter.class.php");
$counter = new counter();
# その他の外部処理クラス
include("./class/other.class.php");
$other = new other();

if($_GET[mode] == "logout") { // ログアウト
	setcookie("petitcms");
}

## $_GETの全要素を洗う
foreach($_GET as $getName => $getItem ) {$_GET["$getName"] = htmlspecialchars($getItem);}

## ヘッダー
$Head_and_Footer->Header(page);

## 分岐
switch ($_GET[mode]) {

	### ページ一覧
	
	## トップページ(ページ一覧)
	default:
	# サブメニュー
	$submenu->page("");
	# 本文
	echo "<div id=\"title\">ページ一覧</div>";
	$page_admin->allpage("$_GET[nowdir]");
	break;

	## ページ編集
	case edit:
	# サブメニュー
	$submenu->page("");
	# タイトル
	echo "<div id=\"title\">ページ編集</div>";
	# フォーム出力
	$page_admin->edit($_GET[nowdir],$_GET[edit_id]);
	break;

	## ページ編集保存処理
	case edit_do:
	# サブメニュー
	$submenu->page("");
	# タイトル
	echo "<div id=\"title\">ページ編集</div>";
	# フォーム出力
	$page_admin->edit_do($_POST[now_dir],$_POST[new_id],$_POST[new_title],$_POST[new_not_titleb],$_POST[new_not_menu],$_POST[new_caption],$_POST[new_explain],$_POST[new_contents],$_POST[makedate]);
	break;

	## フォルダ編集
	case editdir:
	# サブメニュー
	$submenu->page("");
	# タイトル
	echo "<div id=\"title\">フォルダ編集</div>";
	# フォーム出力
	$page_admin->editdir($_GET[nowdir],$_GET[edit_id]);
	break;

	## フォルダ編集保存処理
	case editdir_do:
	# サブメニュー
	$submenu->page("");
	# タイトル
	echo "<div id=\"title\">フォルダ編集</div>";
	# フォーム出力
	$page_admin->editdir_do($_POST[now_dir],$_POST[new_id],$_POST[new_title],$_POST[new_explain]);
	break;

	## 新規フォルダ
	case newdir:
	# サブメニュー
	$submenu->page("");
	# タイトル
	echo "<div id=\"title\">新規フォルダ</div>";
	# フォーム出力
	$page_admin->newdir($_GET[nowdir]);
	break;	

	## 新規フォルダ追加処理
	case newdir_do:
	# サブメニュー
	$submenu->page("");
	# タイトル
	echo "<div id=\"title\">新規フォルダ</div>";
	# 新規作成
	$page_admin->newdir_do($_POST[now_dir],$_POST[new_id],$_POST[new_title],$_POST[new_explain]);
	break;	

	## 新規ページ
	case newpage:
	# サブメニュー
	$submenu->page("");
	# タイトル
	echo "<div id=\"title\">新規ページ</div>";
	# フォーム出力
	$page_admin->newpage($_GET[nowdir]);
	break;

	## 新規ページ追加処理
	case newpage_do:
	# サブメニュー
	$submenu->page("");
	# 本文
	echo "<div id=\"title\">新規ページ</div>";
	# 新規作成
	$page_admin->newpage_do($_POST[now_dir],$_POST[new_id],$_POST[new_title],$_POST[new_not_titleb],$_POST[new_not_menu],$_POST[new_caption],$_POST[new_explain],$_POST[new_contents]);
	break;

	## ページ削除処理
	case delpage:
	# サブメニュー
	$submenu->page("");
	# 本文
	echo "<div id=\"title\">ページ一覧</div>";
	# 削除処理
	$page_admin->delpage($_GET[nowdir],$_GET[del_id]);
	$page_admin->allpage("$_GET[nowdir]");
	break;

	## ディレクトリ削除処理
	case deldir:
	# サブメニュー
	$submenu->page("");
	# 本文
	echo "<div id=\"title\">ページ一覧</div>";
	# 削除処理
	$page_admin->deldir($_GET[nowdir],$_GET[del_id]);
	$page_admin->allpage("$_GET[nowdir]");
	break;
	
	## １つ上へ
	case row_up:
	# サブメニュー
	$submenu->page("");
	# 本文
	echo "<div id=\"title\">ページ一覧</div>";
	# 削除処理
	$page_admin->row_change(up,$_GET[nowdir],$_GET[num]);
	$page_admin->allpage("$_GET[nowdir]");
	break;

	## １つ下へ
	case row_down:
	# サブメニュー
	$submenu->page("");
	# 本文
	echo "<div id=\"title\">ページ一覧</div>";
	# 削除処理
	$page_admin->row_change(down,$_GET[nowdir],$_GET[num]);
	$page_admin->allpage("$_GET[nowdir]");
	break;

	## 公開
	case ok_disp:
	# サブメニュー
	$submenu->page("");
	# 本文
	echo "<div id=\"title\">ページ一覧</div>";
	# 削除処理
	$page_admin->disp_change("",$_GET[nowdir],$_GET[id]);
	$page_admin->allpage("$_GET[nowdir]");
	break;

	## 非公開
	case no_disp:
	# サブメニュー
	$submenu->page("");
	# 本文
	echo "<div id=\"title\">ページ一覧</div>";
	# 削除処理
	$page_admin->disp_change("no",$_GET[nowdir],$_GET[id]);
	$page_admin->allpage("$_GET[nowdir]");
	break;

	## カラーコード選択
	case color_mgr:
	echo "<div id=\"title\">カラーコード</div>";
	$other->color_mgr();
	break;	

	### テンプレート
	## テンプレート編集ページ
	case temp:
	# サブメニュー
	$submenu->page("temp");
	# 本文
	echo "<div id=\"title\">テンプレート</div>";
	$temp_admin->newtemp();
	break;

	## テンプレート編集処理
	case newtemp_do:
	# サブメニュー
	$submenu->page("temp");
	# 本文
	echo "<div id=\"title\">テンプレート</div><span style=\"color: green;\">保存しました</span>";
	$temp_admin->newtemp_do($_POST[new_temp],$_GET[open]);
	$temp_admin->newtemp();
	break;

	## 新規ファイル
	case newTempFile:
	$submenu->page("temp");
	if(file_exists("./temp/$_POST[newFname]")) {
		$cap = "<span style=\"color:red;\">そのファイル名は既に使われています</span>";
		$_POST['newFname'] = "";
	}
	echo "<div id=\"title\">新規ファイル</div>$cap";
	$temp_admin->newtemp();
	break;

	## 名前編集
	case rename:
	$submenu->page("temp");
	if(file_exists("./temp/".mb_convert_encoding($_GET['new'], "UTF-8", "auto"))) {
		echo "<div id=\"title\">テンプレート</div><span style=\"color:red\">".mb_convert_encoding($_GET['new'], "UTF-8", "auto")."は既に存在しています</span>";
	} else {
		echo "<div id=\"title\">テンプレート</div><span style=\"color:green\">ファイル名を変更しました</span>";
		$temp_admin->rename();
	}		
	$temp_admin->newtemp();
	break;

	## ファイル削除
	case delTempFile:
	# サブメニュー
	$submenu->page("temp");
	echo "<div id=\"title\">テンプレート</div>";
	# チェック
	if(!ereg("\./", $_GET['dFile'])) {
		# 本文
		echo "<span style=\"color:green;\">ファイルを削除しました(".$_GET['dFile'].")</span>";
		$relatefile->del_log("./temp/$_GET[dFile]");
	}
	$temp_admin->newtemp();
	break;

	### アクセスカウンター
	## カウンター管理トップ
	case counter:
	# サブメニュー
	$submenu->page("counter");
	# 本文
	echo "<div id=\"title\">アクセスカウンター</div>";
	$counter->allcounter();
	break;

	## カウンター新規作成画面
	case newcounter:
	# サブメニュー
	$submenu->page("counter");
	# 本文
	echo "<div id=\"title\">カウンター新規作成</div>";
	$counter->newcounter();
	break;

	## カウンター新規作成処理
	case newcounter_do:
	# サブメニュー
	$submenu->page("counter");
	# 本文
	echo "<div id=\"title\">カウンター新規作成</div>";
	$counter->newcounter_do($_POST[new_id],$_POST[new_explain],$_POST[new_initial],$_POST[new_digits],$_POST[new_noc],$_POST[new_type]);
	break;

	## カウンター編集画面
	case editcounter:
	# サブメニュー
	$submenu->page("counter");
	# 本文
	echo "<div id=\"title\">カウンター編集</div>";
	$counter->editcounter($_GET[edit_id]);
	break;

	## カウンター編集処理
	case editcounter_do:
	# サブメニュー
	$submenu->page("counter");
	# 本文
	echo "<div id=\"title\">カウンター編集</div>";
	$counter->editcounter_do($_POST[new_id],$_POST[new_explain],$_POST[new_num],$_POST[new_digits],$_POST[new_noc],$_POST[new_type]);
	break;

	## カウンター削除
	case delcounter:
	# サブメニュー
	$submenu->page("counter");
	# 削除
	$counter->delcounter($_GET[del_id]);
	# 本文
	echo "<div id=\"title\">アクセスカウンター</div>";
	$counter->allcounter();
	break;

}

## フッター
$Head_and_Footer->Footer();
