<?php

class page {

	# ページ一覧を出力
	function allpage($now_dir) {
		# ログファイル関連の外部処理クラス
		$relatefile = new relatefile();

		# 上の階層へのリンク生成
		if($now_dir) {
			list($top_dir,$not_use) = explode("/",$now_dir);
			if($not_use) {
				$updir_code = "<a href=\"?nowdir=$top_dir/\">[上の階層へ]</a>";
			} else {
				$updir_code = "<a href=\"?\">[上の階層へ]</a>";
			}
		} else {
			$updir_code = "<span style=\"color:gray;\">[上の階層へ]</span>";
		}

		# フォルダ追加リンクの生成
		if(!$now_dir) {
			$makedir_code = "<a href=\"?mode=newdir&nowdir=$now_dir\">[フォルダ追加]</a>";
		} else {
			$makedir_code = "<span style=\"gray\">[フォルダ追加]</span>";
		}

		echo <<<EOM
現在地：./{$now_dir}<br />
{$updir_code}
<a href="?mode=newpage&nowdir={$now_dir}">[ページ追加]</a>
{$makedir_code}<br />
<table width="100%" cellpadding="3" cellspacing="1">
<tr><th> </th><th>ファイル名</th><th>タイトル</th><th>簡易説明</th><th>作成日</th><th>最終更新日</th><th>処理</th></tr>
EOM;
		# ページ一覧
		$pages = $relatefile->open_log("./log/contents_log/".$now_dir."allpage.cgi");

		# ページ出力
		for($i=0;$pages[$i];$i++) {
			list($type,$id,$title,$not_titleb,$not_menu,$caption,$explain,$make_day,$last_day,$non_disp) = explode("<>",$pages[$i]);
			# 公開or非公開
			if($non_disp) {
				$dispcode = "<a href=\"?mode=ok_disp&nowdir=$now_dir&id=$id\"><img src=\"./image/lock.png\" alt=\"停止中\" width=\"16\" heigth=\"16\" /></a>";
			} else {
				$dispcode = "<a href=\"?mode=no_disp&nowdir=$now_dir&id=$id\"><img src=\"./image/unlock.png\" alt=\"公開中\" width=\"16\" heigth=\"16\" /></a>";
			}
			# 上へリンク生成
			if($i == 0) {
				$upcode = "<img src=\"./image/up.png\" alt=\"並び替え:上へ\" width=\"16\" heigth=\"16\" />";
			} else {
				$upcode = "<a href=\"?mode=row_up&nowdir=$now_dir&num=$i\"><img src=\"./image/up.png\" alt=\"並び替え:上へ\" width=\"16\" heigth=\"16\" /></a>";
			}
			# 下へリンク生成
			if($i > (count($pages) - 3)) {
				$downcode = "<img src=\"./image/down.png\" alt=\"並び替え:下へ\" width=\"16\" heigth=\"16\" />";
			} else {
				$downcode = "<a href=\"?mode=row_down&nowdir=$now_dir&num=$i\"><img src=\"./image/down.png\" alt=\"並び替え:下へ\" width=\"16\" heigth=\"16\" /></a>";
			}
			if($type == "dir") {

			## フォルダの場合
				echo <<<EOM
<tr bgcolor="#F2F2F2"><td><img src="./image/folder.png" alt="フォルダ" width="16" heigth="16" /></td><td><a href="?nowdir={$id}/">{$id}</a> <a href="?mode=editdir&edit_id={$id}">[編集]</a></td><td>{$title}</td><td>{$explain}</td><td>{$make_day}</td><td>—</td><td>{$upcode}{$downcode}{$dispcode}<a href="?mode=deldir&nowdir={$now_dir}&del_id={$id}" onclick="return confirm('本当に削除しますか？')"><img src="./image/del.png" alt="削除" width="16" heigth="16" /></a></td></tr>
EOM;
			} elseif($type == "file") {
				## ファイルの場合
				echo <<<EOM
<tr bgcolor="#ffffff"><td><img src="./image/file.png" alt="ファイル" width="16" heigth="16" /></td><td><a href="?mode=edit&nowdir={$now_dir}&edit_id={$id}">{$id}</a></td><td>{$title}</td><td>{$explain}</td><td>{$make_day}</td><td>{$last_day}</td><td>{$upcode}{$downcode}{$dispcode}<a href="?mode=delpage&nowdir={$now_dir}{&del_id}={$id}" onclick="return confirm('本当に削除しますか？')"><img src="./image/del.png" alt="削除" width="16" heigth="16" /></a></td></tr>
EOM;
			}
		}

		echo <<<EOM
</table>
EOM;
	}

	# 新規フォルダ
	function newdir($now_dir) {
		?>
<form action="?mode=newdir_do" method="post">
<table width="100%" cellpadding="3" cellspacing="1">
<tr><th>追加先</th><td>./<?php echo htmlspecialchars($now_dir) ?></td></tr>
<input type="hidden" name="now_dir" value="<?php echo htmlspecialchars($now_dir) ?>">
<tr><th>フォルダ名</th><td><input type="text" name="new_id" size="10">（半角英数字）</td></tr>
<tr><th>タイトル</th><td><input type="text" name="new_title" size="10"></td></tr>
<tr><th>簡易説明</th><td><input type="text" name="new_explain" size="50"></td></tr>
</table>
<center>
<input type="submit" value=" 追　加 ">
</center>
</form>
	<?php
	}

	# 新規フォルダ追加処理
	function newdir_do($now_dir,$new_id,$new_title,$new_explain) {
		# ログファイル関連の外部処理クラス
		$relatefile = new relatefile();
		# その他の外部処理クラス
		$other = new other();

		## 追加ライン整理
		# エラーチェック
		if($new_id == "") {
			$other->error("フォルダ名を入力して下さい");		
		} elseif (!preg_match("/^[a-zA-Z0-9]+$/", $new_id)) {
			$other->error("フォルダ名には半角英数字のみ使用できます");
		} elseif (file_exists("../$new_id")) {
			$other->error($new_id."はフォルダ名として使用できません");
		} elseif($new_title == "") {
			$other->error("タイトルを入力して下さい");		
		}
		# 日付
		$date = date("y/m/d-H:i");
		# <> -> 特殊文字
		$new_title = str_replace("<>","&lt;&gt;",$new_title);
		$new_explain = str_replace("<>","&lt;&gt;",$new_explain);
		# 整列
		$value = "dir<>$new_id<>$new_title<><><><>$new_explain<>$date<><><>\n";

		## フォルダ一覧に追加
		$relatefile->push_line("./log/contents_log/".$now_dir."allpage.cgi",$value,$new_id);

		## フォルダリパス整列
		$path = "./log/contents_log/".$now_dir.$new_id."/";

		## フォルダ作成
		mkdir($path);

		## ページ一覧を作成
		$relatefile->make_log($path."allpage.cgi","file<>index<>$new_title<><><>$new_title<><>$date<>$date<><>\n");

		## index.cgiを作成
		$relatefile->make_log($path."index.cgi","");

		## 結果出力
		echo <<<EOM
<div class="disp_box">
新規フォルダ[{$new_id}]を作成しました。<br />
./{$now_dir}{$new_id}/にindex.htmlが生成されていますので、編集を行って下さい。<br />
<a href="?nowdir={$now_dir}">[ページ一覧]</a>
<a href="?nowdir={$now_dir}{$new_id}/">[{$new_id}]</a>
</div>
EOM;
	}

	# 新規ページ
	function newpage($now_dir) {
?>
<form name="etr" action="?mode=newpage_do" method="post">
<table width="100%" cellpadding="3" cellspacing="1">
<tr><th width="10%" nowrap>追加先</th><td>./<?php echo htmlspecialchars($now_dir) ?></td></tr>
<input type="hidden" name="now_dir" value="<?php echo htmlspecialchars($now_dir) ?>">
<tr><th>ファイル名</th><td><input type="text" name="new_id" size="10">.html</td></tr>
<tr><th>タイトル</th><td><input type="text" name="new_title" size="20"><br />
<input type="checkbox" name="new_not_titleb" value="no">ブラウザのタイトルバーに表示しない<br />
<input type="checkbox" name="new_not_menu" value="no">メニューに追加しない</td></tr>
<tr><th>見出し</th><td><input type="text" name="new_caption" size="20"></td></tr>
<tr><th>簡易説明</th><td><input type="text" name="new_explain" size="50"></td></tr>
<tr><th>内容</th><td><?php echo $this->editor("",$now_dir); ?>
</td></tr>
</table>
<div style="text-align:center;">
<input type="submit" value=" 追　加 ">
</div>
</form>
<?php
	}

	# 新規ページ追加処理
	function newpage_do($now_dir,$new_id,$new_title,$new_not_titleb,$new_not_menu,$new_caption,$new_explain,$new_contents) {
		# ログファイル関連の外部処理クラス
		$relatefile = new relatefile();
		# その他の外部処理クラス
		$other = new other();

		## 追加ライン整理
		# エラーチェック
		if (!preg_match("/^[a-zA-Z0-9]+$/", $new_id)) {
			$other->error("ファイル名には半角英数字のみ使用できます");
		} elseif($new_id == "") {
			$other->error("ファイル名を入力して下さい");		
		} elseif($new_title == "") {
			$other->error("タイトルを入力して下さい");
		} elseif($new_contents == "") {
			$other->error("内容を入力して下さい");
		}
		# 日付
		$date = date("y/m/d-H:i");
		# <> -> 特殊文字
		$new_title = str_replace("<>","&lt;&gt;",$new_title);
		$new_caption = str_replace("<>","&lt;&gt;",$new_caption);
		$new_explain = str_replace("<>","&lt;&gt;",$new_explain);
		# 整列
		$value = "file<>$new_id<>$new_title<>$new_not_titleb<>$new_not_menu<>$new_caption<>$new_explain<>$date<>$date<><>\n";

		## 一覧に追加
		$relatefile->push_line("./log/contents_log/".$now_dir."allpage.cgi",$value,$new_id);

		# 改行コード
		$new_contents = str_replace("\r\n","\n",$new_contents);
		$new_contents = str_replace("\r","\n",$new_contents);
		$new_contents = stripslashes($new_contents);
		## 内容をログファイルとして保存
		$relatefile->make_log("./log/contents_log/".$now_dir."$new_id.cgi",$new_contents);

		## 結果出力
		echo <<<EOM
<div class="disp_box">
新規ページ[{$new_title}]を作成しました。<br />
WEBサイトに反映するには「変更反映」をクリックして下さい。<br />
<a href="?nowdir={$now_dir}">[ページ一覧]</a>
</div>
EOM;
	}

	# ページ編集
	function edit($now_dir,$edit_id) {
		# ログファイル関連の外部処理クラス
		$relatefile = new relatefile();
		
		# 該当IDのログ情報を取得
		$log_info = $relatefile->log_info($now_dir,$edit_id);
		
		if($log_info['not_titleb']) {
			$checked1 = " checked";
		}
		if($log_info['not_menu']) {
			$checked2 = " checked";
		}
?>
<form name="etr" action="?mode=edit_do" method="post">
<table width="100%" cellpadding="3" cellspacing="1">
<tr><th width="10%" nowrap>保存フォルダ</th><td>./<?php echo htmlspecialchars($now_dir) ?></td></tr>
<input type="hidden" name="now_dir" value="<?php echo htmlspecialchars($now_dir) ?>" />
<tr><th>ファイル名</th><td><?php echo htmlspecialchars($edit_id) ?><font color="gray">.html</font></td></tr>
<input type="hidden" name="new_id" value="<?php echo htmlspecialchars($edit_id) ?>" />
<tr><th>作成日</th><td><?php echo $log_info['makedate'] ?></td></tr>
<input type="hidden" name="makedate" value="<?php echo $log_info['makedate'] ?>" />
<tr><th>最終更新日</th><td><?php echo $log_info['lastdate'] ?></td></tr>
<tr><th>タイトル</th><td><input type="text" name="new_title" size="20" value="<?php echo $log_info['title'] ?>" /><br />
<input type="checkbox" name="new_not_titleb" value="no"<?php echo $checked1 ?> />ブラウザのタイトルバーに表示しない<br />
<input type="checkbox" name="new_not_menu" value="no"<?php echo $checked2 ?> />メニューに追加しない</td></tr>
<tr><th>見出し</th><td><input type="text" name="new_caption" size="20" value="<?php echo htmlspecialchars($log_info['caption']) ?>" /></td></tr>
<tr><th>簡易説明</th><td><input type="text" name="new_explain" size="50" value="<?php echo htmlspecialchars($log_info['explain']) ?>" /></td></tr>
<tr><th>内容</th><td><?php echo $this->editor($log_info['contents'],$now_dir); ?>
</td></tr>
</table>
<div style="text-align:center;">
<input type="submit" value=" 保　存 ">
</div>
</form>
<?php
	}

	# 編集ページ保存処理
	function edit_do($now_dir,$new_id,$new_title,$new_not_titleb,$new_not_menu,$new_caption,$new_explain,$new_contents,$make_date) {
		# ログファイル関連の外部処理クラス
		$relatefile = new relatefile();
		# その他の外部処理クラス
		$other = new other();

		## 追加ライン整理
		# エラーチェック
		if($new_title == "") {
			$other->error("タイトルを入力して下さい");
		} elseif($new_contents == "") {
			$other->error("内容を入力して下さい");
		}
		# 日付
		$date = date("y/m/d-H:i");
		# <> -> 特殊文字
		$new_title = str_replace("<>","&lt;&gt;",$new_title);
		$new_caption = str_replace("<>","&lt;&gt;",$new_caption);
		$new_explain = str_replace("<>","&lt;&gt;",$new_explain);
		# 整列
		$value = "file<>$new_id<>$new_title<>$new_not_titleb<>$new_not_menu<>$new_caption<>$new_explain<>$make_date<>$date<><>\n";
		
		## ファイル上書き
		# 改行コード
		$value = str_replace("\r\n","\n",$value);
		$value = str_replace("\r","\n",$value);
		$new_contents = str_replace("\r\n","\n",$new_contents);
		$new_contents = str_replace("\r","\n",$new_contents);
		$new_contents = stripslashes($new_contents);
		# allpage.cgi編集
		$fp = fopen("./log/contents_log/".$now_dir."allpage.cgi","r+") or die;
		flock($fp,LOCK_EX);
		$lines = array();
		while (!feof($fp)) {
			$line = fgets($fp);
			# 該当IDをはじく
			list($type,$id,$notuse) = explode("<>",$line);
			if($new_id != $id) {
				$lines[] = $line;
			} else {
				$lines[] = $value;
			}
		}
		ftruncate($fp, 0);
		rewind($fp);
		for($i=0;$lines[$i];$i++) {
			fputs($fp,$lines[$i]);
		}
		fclose($fp);
		
		# コンテンツログ編集
		$relatefile->make_log("./log/contents_log/".$now_dir."$new_id.cgi",$new_contents);
		
		## 結果出力
		echo <<<EOM
<div class="disp_box">
ページ[{$new_title}]を上書き保存しました。<br />
WEBサイトに反映するには「変更反映」をクリックして下さい。<br />
<a href="?nowdir={$now_dir}">[ページ一覧]</a>
</div>
EOM;
	}

	# フォルダ編集
	function editdir($now_dir,$edit_id) {
		# ログファイル関連の外部処理クラス
		$relatefile = new relatefile();
		
		# 該当IDのログ情報を取得
		$log_info = $relatefile->log_info($now_dir,$edit_id);
?>
<form action="?mode=editdir_do" method="post">
<table width="100%" cellpadding="3" cellspacing="1">
<tr><th>保存先</td><td>./<?php echo htmlspecialchars($now_dir) ?></td></tr>
<input type="hidden" name="now_dir" value="<?php echo htmlspecialchars($now_dir) ?>">
<tr><th>フォルダ名</th><td><?php echo htmlspecialchars($edit_id) ?></td></tr>
<input type="hidden" name="new_id" value="<?php echo htmlspecialchars($edit_id) ?>">
<tr><th>タイトル</th><td><input type="text" name="new_title" size="10" value="<?php echo htmlspecialchars($log_info['title']) ?>"></td></tr>
<tr><th>簡易説明</th><td><input type="text" name="new_explain" size="50" value="<?php echo htmlspecialchars($log_info['explain']) ?>"></td></tr>
</table>
<div style="text-align:center;">
<input type="submit" value=" 保　存 ">
</div>
</form>
<?php
	}

	# 編集フォルダ保存処理
	function editdir_do($now_dir,$new_id,$new_title,$new_explain) {
		# ログファイル関連の外部処理クラス
		$relatefile = new relatefile();
		# その他の外部処理クラス
		$other = new other();

		# エラーチェック
		if($new_title == "") {
			$other->error("タイトルを入力して下さい");		
		}

		# allpage.cgi編集
		$fp = fopen("./log/contents_log/".$now_dir."allpage.cgi","r+") or die;
		flock($fp,LOCK_EX);
		$lines = array();
		while (!feof($fp)) {
			$line = fgets($fp);
			# 該当IDをはじく
			list($type,$id,$title,$not_titleb,$not_menu,$caption,$explain,$make_day,$last_day,$non_disp) = explode("<>",$line);
			if($new_id != $id) {
				$lines[] = $line;
			} else {
				$lines[] = "dir<>$new_id<>$new_title<><><><>$new_explain<>$make_day<><>$non_disp<>\n";
			}
		}
		ftruncate($fp, 0);
		rewind($fp);
		for($i=0;$lines[$i];$i++) {
			fputs($fp,$lines[$i]);
		}
		fclose($fp);

		## 結果出力
		echo <<<EOM
<div class="disp_box">
フォルダ[{$new_title}]の変更を保存しました。<br />
<a href="?nowdir={$now_dir}">[ページ一覧]</a>
</div>
EOM;
	}


	# ページ削除処理
	function delpage($now_dir,$del_id) {
		## ログファイル関連の外部処理クラス
		$relatefile = new relatefile();

		## 一覧から削除
		$relatefile->del_line("./log/contents_log/".$now_dir."allpage.cgi",$del_id);

		## ログファイル削除	
		$flag = $relatefile->del_log("./log/contents_log/".$now_dir."$del_id.cgi");
		
		# デリートファイルに追加
		if($flag == true) {$relatefile->deleted_file("page<>$now_dir$del_id<>");}
	}

	# フォルダ削除処理
	function deldir($now_dir,$del_id) {
		## ログファイル関連の外部処理クラス
		$relatefile = new relatefile();

		## パス生成
		$path = "./log/contents_log/".$now_dir.$del_id."/";
		# 削除
		if($this->deletedir($path)) {

			## 一覧から削除
			$relatefile->del_line("./log/contents_log/".$now_dir."allpage.cgi",$del_id);

			# デリートファイルに追加
			$relatefile->deleted_file("dir<>$now_dir$del_id<>");
		}
	}

	# フォルダの削除
	function deletedir($path) {
		## 該当ディレクトリ内のファイル削除
		if(substr($path, -1) != '/') {$path .= '/';}
		# １つずつ読み込み削除
		if($handle = opendir($path)) {
			while(false !== $file = readdir($handle)) {
				@unlink($path.$file);
			}
		    closedir($handle);
		}

		## 該当ディレクトリ削除
		if(rmdir($path)) {return true;} else {return false;}
	}

	# 並び替え
	function row_change($which,$now_dir,$num) {
		# ファイルオープン
		$fp = fopen("./log/contents_log/".$now_dir."allpage.cgi","r+") or die;
		flock($fp,LOCK_EX);
		$lines = array();
		while (!feof($fp)) {
			$lines[] = fgets($fp);
		}
		if($which == "up") {
			# 上へ
			$pickup = $lines[$num];
			$lines[$num] = $lines[($num - 1)];
			$lines[($num - 1)] = $pickup;
		} else {
			# 下へ
			$pickup = $lines[$num];
			$lines[$num] = $lines[($num + 1)];
			$lines[($num + 1)] = $pickup;
		}
		ftruncate($fp, 0);
		rewind($fp);
		for($i=0;$lines[$i];$i++) {
			fputs($fp,$lines[$i]);
		}
		fclose($fp);
	}
	
	# 公開/非公開
	function disp_change($which,$now_dir,$change_id) {
		# ファイルオープン
		$fp = fopen("./log/contents_log/".$now_dir."allpage.cgi","r+") or die;
		flock($fp,LOCK_EX);
		$lines = array();
		while (!feof($fp)) {
			$lines[] = fgets($fp);
		}
		for($i=0;$lines[$i];$i++) {
			list($type,$id,$title,$not_titleb,$not_menu,$caption,$explain,$make_day,$last_day,$non_disp) = explode("<>",$lines[$i]);
			if($id == $change_id) {
				$lines[$i] = "$type<>$id<>$title<>$not_titleb<>$not_menu<>$caption<>$explain<>$make_day<>$last_day<>$which<>\n";
			}
		}
		ftruncate($fp, 0);
		rewind($fp);
		for($i=0;$lines[$i];$i++) {
			fputs($fp,$lines[$i]);
		}
		fclose($fp);
	}
	
	# タグエディタコード
	function editor($contents,$now_dir) {
		$contents = ereg_replace("&([a-zA-Z0-9]+);","&amp;\\1;", $contents);
		$contents = str_replace("<","&lt;",$contents);
		
		if($now_dir != "") {
			$flag = '1';
			$hidnum = 'un_dir';
		}
		$editor_code = <<<EOM
<script src="./insert.js" type="text/javascript"></script>
<script src="./tabtextarea.js" type="text/javascript"></script>
<select style="font-size:12px;" onChange="if(!this[this.selectedIndex].value) {return false;};enclose('<span style=&quot;font-size:' + this[this.selectedIndex].value + ';&quot;>', '</span>');">
<option style="background-color:#cccccc;" value="">Font Size</option>
<option value="80%">small</option>
<option value="100%">middle</option>
<option value="130%">large</option>
</select>

<img src="./image/palette.png" alt="色" width="16" height="16" onclick="showLAYER('showSelectColor')" />
<img src="./image/outlink.png" alt="リンク" width="16" height="16" onclick="showLAYER('showLinkMaker')" />
<img src="./image/table.png" alt="表" width="16" height="16" onclick="showLAYER('showTableMaker')" />
<img src="./image/h2.png" alt="見出し" width="16" height="16" onclick="enclose('<h2>', '</h2>');return false;" />
<img src="./image/h3.png" alt="小見出し" width="16" height="16" onclick="enclose('<h3>', '</h3>');return false;" />
<img src="./image/bold.png" alt="太字" width="16" height="16" onclick="enclose('<strong>', '</strong>');return false;" />
<img src="./image/italic.png" alt="斜体" width="16" height="16" onclick="enclose('<i>', '</i>');return false;" />
<img src="./image/strikethrough.png" alt="取り消し線" width="16" height="16" onclick="enclose('<s>', '</s>');return false;" />
<img src="./image/underline.png" alt="下線" width="16" height="16" onclick="enclose('<u>', '</u>');return false;" />
<img src="./image/blockquote.png" alt="引用" width="16" height="16" onclick="enclose('<blockquote>', '</blockquote>');return false;" />
<img src="./image/line.png" alt="ライン" width="16" height="16" onclick="enclose('<hr size=&quot;1&quot; />', '');return false;" />
<img src="./image/nocl.png" alt="自動改行なし" width="16" height="16" onclick="enclose('<!--NoCL START-->\\n', '\\n<!--NoCL END-->\\n');return false;" />
<img src="./image/map.png" alt="画像" width="16" height="16" onclick="window.open('./imgmgr.php?under=
EOM;

$editor_code .= $flag;

$editor_code .= <<<EOM
', 'image_mgr', 'scrollbars=yes'); return false;" />
<span style="position:absolute;visibility:hidden; width:100px; border: 1px #808080 solid; padding:3px; background:white; text-align:center;" id="showSelectColor">
<span style="font-size:smaller;padding-left:2px;"><a href="javascript:closeLAYER('showSelectColor');" style="color:blue;">[close]</a></span>
<input type="text" size="10" id="previewCode" />
  <table border="0" cellpadding="1" cellspacing="0" width="100%">
   <tr>
     <td class="selectColorBorder" onMouseOver="previewColor('#000000');" onClick="SetColor('#000000');"><div style="background-color: #000000;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#993300');" onClick="SetColor('#993300');"><div style="background-color: #993300;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#333300');" onClick="SetColor('#333300');"><div style="background-color: #333300;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#003300');" onClick="SetColor('#003300');"><div style="background-color: #003300;height:15px;" class="selectColorBox"></div></td> 
     <td class="selectColorBorder" onMouseOver="previewColor('#003366');" onClick="SetColor('#003366');"><div style="background-color: #003366;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#000080');" onClick="SetColor('#000080');"><div style="background-color: #000080;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#333399');" onClick="SetColor('#333399');"><div style="background-color: #333399;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#333333');" onClick="SetColor('#333333');"><div style="background-color: #333333;height:15px;" class="selectColorBox"></div></td>
   </tr>
   <tr>
     <td class="selectColorBorder" onMouseOver="previewColor('#800000');" onClick="SetColor('#800000');"><div style="background-color: #800000;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#FF6600');" onClick="SetColor('#FF6600');"><div style="background-color: #FF6600;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#808000');" onClick="SetColor('#808000');"><div style="background-color: #808000;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#008000');" onClick="SetColor('#008000');"><div style="background-color: #008000;height:15px;" class="selectColorBox"></div></td> 
     <td class="selectColorBorder" onMouseOver="previewColor('#008080');" onClick="SetColor('#008080');"><div style="background-color: #008080;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#0000ff');" onClick="SetColor('#0000ff');"><div style="background-color: #0000ff;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#666699');" onClick="SetColor('#666699');"><div style="background-color: #666699;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#808080');" onClick="SetColor('#808080');"><div style="background-color: #808080;height:15px;" class="selectColorBox"></div></td>
   </tr>
   <tr>
     <td class="selectColorBorder" onMouseOver="previewColor('#ff0000');" onClick="SetColor('#ff0000');"><div style="background-color: #ff0000;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#ff9900');" onClick="SetColor('#ff9900');"><div style="background-color: #ff9900;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#99cc00');" onClick="SetColor('#99cc00');"><div style="background-color: #99cc00;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#339966');" onClick="SetColor('#339966');"><div style="background-color: #339966;height:15px;" class="selectColorBox"></div></td> 
     <td class="selectColorBorder" onMouseOver="previewColor('#33cccc');" onClick="SetColor('#33cccc');"><div style="background-color: #33cccc;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#3366ff');" onClick="SetColor('#3366ff');"><div style="background-color: #3366ff;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#800080');" onClick="SetColor('#800080');"><div style="background-color: #800080;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#999999');" onClick="SetColor('#999999');"><div style="background-color: #999999;height:15px;" class="selectColorBox"></div></td>
   </tr>
   <tr>
     <td class="selectColorBorder" onMouseOver="previewColor('#ff00ff');" onClick="SetColor('#ff00ff');"><div style="background-color: #ff00ff;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#ffcc00');" onClick="SetColor('#ffcc00');"><div style="background-color: #ffcc00;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#ffff00');" onClick="SetColor('#ffff00');"><div style="background-color: #ffff00;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#00ff00');" onClick="SetColor('#00ff00');"><div style="background-color: #00ff00;height:15px;" class="selectColorBox"></div></td> 
     <td class="selectColorBorder" onMouseOver="previewColor('#00ffff');" onClick="SetColor('#00ffff');"><div style="background-color: #00ffff;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#00ccff');" onClick="SetColor('#00ccff');"><div style="background-color: #00ccff;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#993366');" onClick="SetColor('#993366');"><div style="background-color: #993366;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#c0c0c0');" onClick="SetColor('#c0c0c0');"><div style="background-color: #c0c0c0;height:15px;" class="selectColorBox"></div></td>
   </tr>
   <tr>
     <td class="selectColorBorder" onMouseOver="previewColor('#ff99cc');" onClick="SetColor('#ff99cc');"><div style="background-color: #ff99cc;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#ffcc99');" onClick="SetColor('#ffcc99');"><div style="background-color: #ffcc99;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#ffff99');" onClick="SetColor('#ffff99');"><div style="background-color: #ffff99;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#ccffcc');" onClick="SetColor('#ccffcc');"><div style="background-color: #ccffcc;height:15px;" class="selectColorBox"></div></td> 
     <td class="selectColorBorder" onMouseOver="previewColor('#ccffff');" onClick="SetColor('#ccffff');"><div style="background-color: #ccffff;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#99ccff');" onClick="SetColor('#99ccff');"><div style="background-color: #99ccff;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#cc99ff');" onClick="SetColor('#666699');"><div style="background-color: #cc99ff;height:15px;" class="selectColorBox"></div></td>
     <td class="selectColorBorder" onMouseOver="previewColor('#ffffff');" onClick="SetColor('#ffffff');"><div style="background-color: #ffffff;height:15px;" class="selectColorBox"></div></td>
   </tr>
</table>
</span>
<span style="position:absolute;visibility:hidden; width:400px; border: 1px #808080 solid; padding:3px; background:white; font-size:smaller;" id="showLinkMaker">
	<a href="javascript:closeLAYER('showLinkMaker');" style="color:blue;">[close]</a><br />
	URL:<input type="text" id="url" size="50" value="http://" />
	<input type="button" value=" OK " onClick="enclose('<a href=&quot;' + document.etr.url.value + '&quot;' + getRadio() + '>', '</a>');closeLAYER('showLinkMaker');" /><br />
	<label><input type="radio" name="target" id="target" value="" checked /> 同じウィンドウで開く</label><br />
	<label><input type="radio" name="target" id="target" value=" target=&quot;_blank&quot;" /> 新しいウィンドウで開く</label><br />
</span>
<span style="position:absolute;visibility:hidden;border: 1px #808080 solid; padding:3px; background:white;" id="showTableMaker">
	<a href="javascript:closeLAYER('showTableMaker');" style="color:blue;" style="font-size:smaller;">[close]</a>
	<table class="TableMaker">
	  <tr>
	  	<td>行</td>
	  	<td><input type="text" id="col" size="2" value="3" /></td>
	  	<td>横幅</td>
	  	<td><input type="text" id="width" size="2" value="200" /> <select id="widthType"><option value="">ピクセル</option><option value="%">パーセント</option></select></td>
	  </tr>
	  <tr>
	  	<td>列</td>
	  	<td><input type="text" id="row" size="2" value="2" /></td>
	  	<td>セル内余白</td>
	  	<td><input type="text" id="space" size="2" value="1" /></td>
	  </tr>
	  <tr>
	  	<td>外枠の太さ</td>
	  	<td><input type="text" id="borderSize" size="2" value="1" />px</td>
	  	<td>外枠の色</td>
	  	<td><input type="text" id="borderColor" size="8" value="#000000" /></td>
	  </tr>
	  <tr>
	  	<td><label><input type="checkbox" id="nocl" checked />自動改行なしタグを挿入</label></td>
	  	<td colspan="3" align="right"><input type="button" value=" OK " onClick="closeLAYER('showTableMaker');TableMaking();" /></td>
	  </tr>
	</table>
</span>
<textarea wrap="off" name="new_contents" style="width:100%; height:400px;" onKeydown="SetTab()" onKeypress="SetTab2(event)" id="new_contents" onfocus="get_pos(new_contents);" onmouseup="get_pos(new_contents);" onkeyup="get_pos(new_contents);preview('{$hidnum}');">{$contents}</textarea>
Preview <a href="javascript:showLAYER('PreviewDISP');preview('$hidnum');">[disp]</a>
<table style="visibility:hidden;margin:0px;" id="PreviewDISP"><tr><td>
<div id="previewArea" class="previewArea"></div>
</td></tr></table>

<script type="text/JavaScript">
if( String("jadge") ){
 bl=3;
} else if( document.getElementById ){
 bl=4;
}
if( document.getElementById("new_contents").setSelectionRange ){
  bl=2;
} else if( document.selection.createRange ){
  bl=1;
}
</script>
EOM;
	return $editor_code;
	
	}


}

