<?php

class counter {

	# トップ(カウンター一覧)
	function allcounter() {
		# ログファイル関連の外部処理クラス
		$relatefile = new relatefile();

		# カウンター一覧
		$lines = $relatefile->open_log("./log/script_log/counter/allcounter.cgi");
		# 個数
		$allrow = count($lines) - 1;
		if($allrow < 0) {$allrow = 0;}
		# 案内
		if($allrow) {$guide = "カウンターを表示したいページに表示タグを貼り付けて下さい。<br />\n";}
		# カウンタースクリプト本体
		$srcurl = "&lt;!--URL_COUNTER--&gt;";

		echo <<<EOM
現在{$allrow}個のカウンターがあります。<br />
$guide<a href="?mode=newcounter">[新規作成]</a>
<table style="font-size:13px" bgcolor="#ffffff" width="100%" cellpadding="3" cellspacing="1">
EOM;

		for($i=0;$lines[$i];$i++) {
			list($type,$id,$explain,$noc,$digits) = explode("<>",$lines[$i]);
			echo <<<EOM
<tr><th>ID</th><th>メモ</th><th>表示タグ</th><th>削除</th></tr>
<tr><td><a href="?mode=editcounter&edit_id={$id}">{$id}</a></td><td>{$explain}</td><td><textarea style="width:100%">[[counter:$id]]</textarea></td><td><a href="?mode=delcounter&del_id={$id}" onclick="return confirm('本当に削除しますか？')"><img src="./image/del.png" alt="削除" width="16" heigth="16" /></a></td></tr>
EOM;
		}

		echo "</table>\n";
	}

	# カウンター新規作成画面
	function newcounter() {
		echo <<<EOM
<form action="?mode=newcounter_do" method="post">
<table width="100%" cellpadding="3" cellspacing="1">
<tr><th width="20%">カウンターID</th><td><input type="text" name="new_id" size="10"></td>
<th rowspan="5">種類</th><td rowspan="5">
EOM;
		$this->kindDisp("");
		echo <<<EOM
</td></tr>
<tr><th>メモ</th><td><input type="text" name="new_explain" size="20"><br />
<tr><th>初期値</th><td><input type="text" name="new_initial" value="0" size="5"></td></tr>
<tr><th>桁数</th><td><input type="text" name="new_digits" value="5" size="5"></td></tr>
<tr><th>連続カウント</th><td><input type="checkbox" name="new_noc" value="no">同一IPの連続アクセスをカウントしない</td></tr>
</table>
<div style="text-align:center;">
<input type="submit" value=" 追　加 ">
</div>
</form>
EOM;
	}

	# カウンター新規作成処理
	function newcounter_do($new_id,$new_explain,$new_initial,$new_digits,$new_noc,$new_type) {
		# ログファイル関連の外部処理クラス
		$relatefile = new relatefile();
		# その他の外部処理クラス
		$other = new other();

		## 追加ライン整理
		# 初期値
		if($new_initial == "") {$new_initial = 0;}
		# 桁数
		if($new_digits == "") {$new_digits = 0;}
		# エラーチェック
		if ($new_id == "") {
			$other->error("IDを入力して下さい");		
		} elseif (!preg_match("/^[0-9]+$/", $new_initial)) {
			$other->error("初期値には半角数字のみ使用できます");
		} elseif(!preg_match("/^[0-9]+$/", $new_digits)) {
			$other->error("桁数には半角数字のみ使用できます");
		} elseif(!preg_match("/^[a-zA-Z0-9]+$/", $new_id)) {
			$other->error("IDには半角英数字のみ使用できます");
		} elseif($new_type == "") {
			$other->error("種類を選択して下さい");
		}
		# <> -> 特殊文字
		$new_explain = str_replace("<>","&lt;&gt;",$new_explain);
		# 整列
		$value = "$new_type<>$new_id<>$new_explain<>$new_noc<>$new_digits<>\n";

		## 一覧に追加
		$relatefile->push_line("./log/script_log/counter/allcounter.cgi",$value,$new_id);

		## ログファイル作成
		$relatefile->make_log("./log/script_log/counter/$new_id".".cgi","$new_initial<>$new_digits<>$new_type<>$new_noc<><>");

		## 結果出力
		echo <<<EOM
<div class="disp_box">
カウンターを新規作成しました。<br />
タグを貼り付けて使用できます<br />
<a href="?mode=counter">[カウンター一覧]</a>
</div>
EOM;
	}

	# カウンター編集画面
	function editcounter($edit_id) {
		# ログファイル関連の外部処理クラス
		$relatefile = new relatefile();

		# カウンター詳細(一覧ログ)
		$lines = $relatefile->open_log("./log/script_log/counter/allcounter.cgi");
		for($i=0;$lines[$i];$i++) {
			list($type,$id,$explain,$noc,$digits) = explode("<>",$lines[$i]);
			if($edit_id == $id) {break;}
		}
	
		# カウンター詳細(個別ログ)
		$line = $relatefile->open_log("./log/script_log/counter/$edit_id".".cgi");
		list($num,$digits,$type,$noc,$ip) = explode("<>",$line[0]);
	
		# checked
		if($noc) {$noc_checked = ' checked';}
		
		echo <<<EOM
<form action="?mode=editcounter_do" method="post">
<table width="100%" cellpadding="3" cellspacing="1">
<tr><th width="20%">カウンターID</th><td>{$edit_id}</td>
<input type="hidden" name="new_id" value="{$edit_id}">
<th rowspan="5">種類</th><td rowspan="5">
EOM;

		$this->kindDisp($type);

		echo <<<EOM
</td></tr>
<tr><th>メモ</th><td><input type="text" name="new_explain" value="{$explain}" size="20" /><br />
<tr><th>カウント数</th><td><input type="text" name="new_num" value="{$num}" size="5" /></td></tr>
<tr><th>桁数</th><td><input type="text" name="new_digits" value="{$digits}" size="5" /></td></tr>
<tr><th>連続カウント</th><td><input type="checkbox" name="new_noc" value="no"{$noc_checked}>同一IPの連続アクセスをカウントしない</td></tr>
</table>
<div style="text-align:center;">
<input type="submit" value=" 保　存 ">
</div>
</form>
EOM;
	}

	# カウンター新規作成処理
	function editcounter_do($new_id,$new_explain,$new_num,$new_digits,$new_noc,$new_type) {
		# ログファイル関連の外部処理クラス
		$relatefile = new relatefile();
		# その他の外部処理クラス
		$other = new other();

		## 追加ライン整理
		# カウント数
		if($new_num == "") {$new_num = 0;}
		# 桁数
		if($new_digits == "") {$new_digits = 0;}
		# エラーチェック
		if (!preg_match("/^[0-9]+$/", $new_num)) {
			$other->error("カウント数には半角数字のみ使用できます");
		} elseif(!preg_match("/^[0-9]+$/", $new_digits)) {
			$other->error("桁数には半角数字のみ使用できます");
		} elseif($new_type == "") {
			$other->error("種類を選択して下さい");
		}
		# <> -> 特殊文字
		$new_explain = str_replace("<>","&lt;&gt;",$new_explain);
		# 整列
		$value = "$new_type<>$new_id<>$new_explain<>$new_noc<>$new_digits<>\n";

		### ファイル上書き
		## 改行コード
		$value = str_replace("\r\n","\n",$value);
		$value = str_replace("\r","\n",$value);
		## allcounter.cgi編集
		$path = "./log/script_log/counter/allcounter.cgi";
		if(!file_exists($path)) {$this->make_log($path,"");}
		$fp = @fopen($path,"r+");
		flock($fp,LOCK_EX);
		$lines = array();
		while (!feof($fp)) {
			$line = fgets($fp);
			# 該当IDをはじく
			list($type,$id,$notuse) = explode("<>",$line);
			if($new_id != $id) {
				$lines[] = $line;
			} else {
				$lines[] = $value;
			}
		}
		ftruncate($fp, 0);
		rewind($fp);
		for($i=0;$lines[$i];$i++) {
			fputs($fp,$lines[$i]);
		}
		fclose($fp);

		## 個別ログ編集
		$path = "./log/script_log/counter/$new_id".".cgi";
		if(!file_exists($path)) {$this->make_log($path,"");}
		$fp = @fopen($path,"r+");
		flock($fp,LOCK_EX);
		ftruncate($fp, 0);
		rewind($fp);
		fputs($fp,"$new_num<>$new_digits<>$new_type<>$new_noc<><>");
		fclose($fp);

		## 結果出力
		echo <<<EOM
<div class="disp_box">
カウンターを編集しました。<br />
この変更については「変更反映」の必要はありません。<br />
<a href="?mode=counter">[カウンター一覧]</a>
</div>
EOM;
	}

	# 削除処理
	function delcounter($del_id) {
		## ログファイル関連の外部処理クラス
		$relatefile = new relatefile();

		## 一覧から削除
		$relatefile->del_line("./log/script_log/counter/allcounter.cgi",$del_id);

		## ログファイル削除
		$relatefile->del_log("./log/script_log/counter/$del_id".".cgi");
	}

	// 種類表示
	function kindDisp($now) {
		$other = new other();
		if($now != "") {$$now = " checked";}
		$kinds = $other->tree("./autoscript/numbers/");
		foreach($kinds as $tmp) {
			echo "<input type=\"radio\" name=\"new_type\" value=\"$tmp\"".$$tmp."><img src=\"./autoscript/counter.php?t=$tmp\" /><br />\n";
		}
	}
}
