<?php

class analyze {

	// 概要
	function index() {
		$forDate = $this->select("");
		global $relatefile;

		if($forDate == "") { // 指定なし
			$date = date("Ymd"); // 今日のフォルダ
			$date_d = date("Y年m月d日"); // 日付
		} else { // 指定あり
			$date = $forDate;
			$date_d = eregi_replace("([0-9]{4})([0-9]{2})([0-9]{2})","\\1年\\2月\\3日",$date);
		}

		if(file_exists("./autoscript/analyze.log/$date/total.def.cgi")) {
			$lines = $relatefile->open_log("./autoscript/analyze.log/$date/total.def.cgi");
			list($t_unique,$t_view) = explode("<>",$lines[0]);
		} else {
			$t_unique = 0;
			$t_view = 0;
		}
		
		echo <<<EOM
<div id="title">日計</div>
<div id="disp_box">
<table width="100%" cellpadding="3" cellspacing="1">
<tr><th width="10%" nowrap>日付</th><td>{$date_d}</td></tr>
<tr><th width="10%" nowrap>ユニーク人数</th><td>{$t_unique}</td></tr>
<tr><th width="10%" nowrap>ヒット回数</th><td>{$t_view}</td></tr>
</table>
</div>

<br />

<div id="title">解析方法</div>
<div id="disp_box">
テンプレートの&lt;body&gt;〜&lt;/body&gt;の間に<span style="color:green">&lt;!--ANALYZER--&gt;</span>の一行を加えるだけでアクセスログを取得します。<br />
通常はデフォルトで&lt;body&gt;の直下に記述してあります。
</div>
EOM;
	}

	// 時間別
	function hour() {
		$forDate = $this->select("");
		global $relatefile;

		if($forDate == "") { // 指定なし
			$date = date("Ymd"); // 今日のフォルダ
			$date_d = date("Y年m月d日"); // 日付
		} else { // 指定あり
			$date = $forDate;
			$date_d = eregi_replace("([0-9]{4})([0-9]{2})([0-9]{2})","\\1年\\2月\\3日",$date);
		}

		$hU_total = "0";
		$hV_total = "0";
		$h_max = "0";
		if(file_exists("./autoscript/analyze.log/$date/hour/")) {
			for($i=0;$i!=24;$i++) {
				$i = sprintf('%02d',$i);
				$lines = $relatefile->open_log_def("./autoscript/analyze.log/$date/hour/$i.cgi");
				if($lines[0]) {
					$new_h = "hU".$i;
					$new_h2 = "hV".$i;
					list($$new_h,$$new_h2) = explode("<>",$lines[0]);
				} else {
					$new_h = "hU".$i;
					$new_h2 = "hV".$i;
					$$new_h = 0;
					$$new_h2 = 0;
				}
				$hU_total = $hU_total + $$new_h;
				$hV_total = $hV_total + $$new_h2;
				if($h_max < $$new_h2) {$h_max = $$new_h2;}
			}
		} else {
			$hU_total = 0;
			$hV_total = 0;
		}

		$flag = "";
		for($w=2;($h_max / $w) > 120;$w++) {$flag = 1;}
		$graph = <<<EOM
<table>
<tr valign="bottom"><td valign="top" align="right" style="font-size:smaller;">$h_max</td>
EOM;
		for($i=0;$i!=24;$i++) {
			$i = sprintf('%02d',$i);
			$new_h = "hU$i";
			$new_hU = $$new_h;
			$new_h2 = "hV$i";
			$new_hV = $$new_h2;
			if($flag) {
				$new_hU_d = round($new_hU / $w);
				$new_hV_d = round($new_hV / $w);
			} else {
				$new_hU_d = $new_hU;
				$new_hV_d = $new_hV;
			}
			$graph .= "<td><img src=\"./image/vColor.gif\" width=\"15\" height=\"$new_hV_d\" alt=\"ヒット回数:$new_hV\" /><br /><img src=\"./image/uColor.gif\" width=\"15\" height=\"$new_hU_d\" alt=\"ユニーク人数:$new_hU\" /></td>";
		}
		$graph .= <<<EOM
</tr>
<tr align="right" style="font-size:smaller;"><td>hour</td><td>0</td><td>1</td><td>2</td><td>3</td><td>4</td><td>5</td><td>6</td><td>7</td><td>8</td><td>9</td><td>10</td><td>11</td><td>12</td>
<td>13</td><td>14</td><td>15</td><td>16</td><td>17</td><td>18</td><td>19</td><td>20</td><td>21</td><td>22</td><td>23</td></tr>
</table>
EOM;
		
		echo <<<EOM
<div id="title">時間別</div>
<div id="disp_box">
<table width="100%" cellpadding="3" cellspacing="1">
<tr><th width="10%" nowrap>日付</th><td>{$date_d}</td></tr>
<tr><th width="10%" nowrap>ユニーク人数</th><td>{$hU_total}</td></tr>
<tr><th width="10%" nowrap>ヒット回数</th><td>{$hV_total}</td></tr>
<tr><th width="10%" nowrap>グラフ</th><td align="center">{$graph}</td></tr>
<tr><th width="10%" nowrap>時間別</th><td>
<table bgcolor="#ffb555" cellpadding="3" cellspacing="1" width="100%">
	<tr bgcolor="#ffdaaa" align="right"><td align="center" width="16%">時間</td><td width="16%">ヒット回数</td><td width="16%">ユニーク人数</td><td align="center" width="16%">時間</td><td width="16%">ヒット回数</td><td width="16%">ユニーク人数</td></tr>
	<tr bgcolor="#ffffff" align="right"><td align="left" width="16%">AM 0</td><td>{$hV00}</td><td>{$hU00}</td><td align="left" width="16%">PM 0</td><td>{$hV12}</td><td>{$hU12}</td></tr>
	<tr bgcolor="#ffffff" align="right"><td align="left" width="16%">AM 1</td><td>{$hV01}</td><td>{$hU01}</td><td align="left" width="16%">PM 1</td><td>{$hV13}</td><td>{$hU13}</td></tr>
	<tr bgcolor="#ffffff" align="right"><td align="left" width="16%">AM 2</td><td>{$hV02}</td><td>{$hU02}</td><td align="left" width="16%">PM 2</td><td>{$hV14}</td><td>{$hU14}</td></tr>
	<tr bgcolor="#ffffff" align="right"><td align="left" width="16%">AM 3</td><td>{$hV03}</td><td>{$hU03}</td><td align="left" width="16%">PM 3</td><td>{$hV15}</td><td>{$hU15}</td></tr>
	<tr bgcolor="#ffffff" align="right"><td align="left" width="16%">AM 4</td><td>{$hV04}</td><td>{$hU04}</td><td align="left" width="16%">PM 4</td><td>{$hV16}</td><td>{$hU16}</td></tr>
	<tr bgcolor="#ffffff" align="right"><td align="left" width="16%">AM 5</td><td>{$hV05}</td><td>{$hU05}</td><td align="left" width="16%">PM 5</td><td>{$hV17}</td><td>{$hU17}</td></tr>
	<tr bgcolor="#ffffff" align="right"><td align="left" width="16%">AM 6</td><td>{$hV06}</td><td>{$hU06}</td><td align="left" width="16%">PM 6</td><td>{$hV18}</td><td>{$hU18}</td></tr>
	<tr bgcolor="#ffffff" align="right"><td align="left" width="16%">AM 7</td><td>{$hV07}</td><td>{$hU07}</td><td align="left" width="16%">PM 7</td><td>{$hV19}</td><td>{$hU19}</td></tr>
	<tr bgcolor="#ffffff" align="right"><td align="left" width="16%">AM 8</td><td>{$hV08}</td><td>{$hU08}</td><td align="left" width="16%">PM 8</td><td>{$hV20}</td><td>{$hU20}</td></tr>
	<tr bgcolor="#ffffff" align="right"><td align="left" width="16%">AM 9</td><td>{$hV09}</td><td>{$hU09}</td><td align="left" width="16%">PM 9</td><td>{$hV21}</td><td>{$hU21}</td></tr>
	<tr bgcolor="#ffffff" align="right"><td align="left" width="16%">AM 10</td><td>{$hV10}</td><td>{$hU10}</td><td align="left" width="16%">PM 10</td><td>{$hV22}</td><td>{$hU22}</td></tr>
	<tr bgcolor="#ffffff" align="right"><td align="left" width="16%">AM 11</td><td>{$hV11}</td><td>{$hU11}</td><td align="left" width="16%">PM 11</td><td>{$hV23}</td><td>{$hU23}</td></tr>
</table>

</td></tr>
</table>
</div>


EOM;
	}

	// 日別
	function day() {
		$forDate = $this->select("");
		global $relatefile;

		if($forDate == "") { // 指定なし
			$date = date("Ymd"); // 今日のフォルダ
			$date_d = date("Y年m月d日"); // 日付
		} else { // 指定あり
			$date = $forDate;
			$date_d = eregi_replace("([0-9]{4})([0-9]{2})([0-9]{2})","\\1年\\2月\\3日",$date);
		}
		$before_date = $this->computeDate($date,-6);
		$before_date_d = eregi_replace("([0-9]{4})([0-9]{2})([0-9]{2})","\\1年\\2月\\3日",$before_date);

		$d_max = 0;
		$week = array();
		for($i=0;$i!=7;$i++) {
			$ai_date = $this->computeDate($before_date,$i);
			$lines = $relatefile->open_log_def("./autoscript/analyze.log/$ai_date/total.def.cgi");
			if($lines[0]) {
				$new_h = "dU".$ai_date;
				$new_h2 = "dV".$ai_date;
				list($$new_h,$$new_h2) = explode("<>",$lines[0]);
			} else {
				$new_h = "dU".$ai_date;
				$new_h2 = "dV".$ai_date;
				$$new_h = 0;
				$$new_h2 = 0;
			}
			$week[] = "$ai_date<>".$$new_h."<>".$$new_h2."<>";
			$dU_total = $dU_total + $$new_h;
			$dV_total = $dV_total + $$new_h2;
			if($d_max < $$new_h2) {$d_max = $$new_h2;}
		}

		$flag = "";
		for($w=2;($d_max / $w) > 120;$w++) {$flag = 1;}
		$graph = <<<EOM
<table>
<tr valign="bottom"><td valign="top" align="right" style="font-size:smaller;">{$d_max}</td>
EOM;
		for($i=0;$i!=7;$i++) {
			list($ai_date,$notUse) = explode("<>",$week[$i]);
			$new_d = "dU$ai_date";
			$new_dU = $$new_d;
			$new_d2 = "dV$ai_date";
			$new_dV = $$new_d2;
			if($flag) {
				$new_dU_d = round($new_dU / $w);
				$new_dV_d = round($new_dV / $w);
			} else {
				$new_dU_d = $new_dU;
				$new_dV_d = $new_dV;
			}
			$graph .= "<td><img src=\"./image/vColor.gif\" width=\"25\" height=\"$new_dV_d\" alt=\"ヒット回数:$new_dV\" /><br /><img src=\"./image/uColor.gif\" width=\"25\" height=\"$new_dU_d\" alt=\"ユニーク人数:$new_dU\" /></td>";
		}
		$graph .= <<<EOM
</tr>
<tr align="right" style="font-size:smaller;"><td>day</td>
EOM;
		for($i=0;$i!=7;$i++) {
			list($ai_date,$notUse) = explode("<>",$week[$i]);
			$graph .= "<td>".substr($ai_date,4,4)."</td>";
		}
		$graph .= "</table>\n";
		
		echo <<<EOM
<div id="title">日別</div>
<div id="disp_box">
<table width="100%" cellpadding="3" cellspacing="1">
<tr><th width="10%" nowrap>日付</th><td>{$before_date_d} 〜 {$date_d}</td></tr>
<tr><th width="10%" nowrap>ユニーク人数</th><td>{$dU_total}</td></tr>
<tr><th width="10%" nowrap>ヒット回数</th><td>{$dV_total}</td></tr>
<tr><th width="10%" nowrap>グラフ</th><td align="center">{$graph}</td></tr>
<tr><th width="10%" nowrap>時間別</th><td>
<table bgcolor="#ffb555" cellpadding="3" cellspacing="1" width="100%" style="font-size:13px">
	<tr bgcolor="#ffdaaa" align="right"><td align="center" width="16%">日付</td><td width="16%">ヒット回数</td><td width="16%">ユニーク人数</td><td align="center" width="16%">日付</td><td width="16%">ヒット回数</td><td width="16%">ユニーク人数</td></tr>
EOM;

	for($i=0;$i!=4;$i++) {
		list($ai_date1,$ai_view1,$ai_unique1) = explode("<>",$week[$i]);
		list($ai_date2,$ai_view2,$ai_unique2) = explode("<>",$week[($i + 4)]);
		$ai_date1_d = eregi_replace("([0-9]{4})([0-9]{2})([0-9]{2})","\\1年\\2月\\3日",$ai_date1);
		$ai_date2_d = eregi_replace("([0-9]{4})([0-9]{2})([0-9]{2})","\\1年\\2月\\3日",$ai_date2);
		echo <<<EOM
		<tr bgcolor="#ffffff" align="right"><td align="left" width="16%">$ai_date1</td><td>$ai_unique1</td><td>$ai_view1</td><td align="left" width="16%">$ai_date2</td><td>$ai_unique2</td><td>$ai_view2</td></tr>
EOM;
	}
		echo <<<EOM
</table>

</td></tr>
</table>
</div>


EOM;
	}

	// ページ別
	function pages() {
		$forDate = $this->select("");
		global $relatefile;

		if($forDate == "") { // 指定なし
			$date = date("Ymd"); // 今日のフォルダ
			$date_d = date("Y年m月d日"); // 日付
		} else { // 指定あり
			$date = $forDate;
			$date_d = eregi_replace("([0-9]{4})([0-9]{2})([0-9]{2})","\\1年\\2月\\3日",$date);
		}

		$lines = $relatefile->open_log_def("./autoscript/analyze.log/$date/page.def.cgi");

		// 並び替え
		$pages = $this->changeRow($lines);
		$p_total = array_pop($pages);

		echo <<<EOM
<div id="title">ページ別</div>
<div id="disp_box">
<table bgcolor="#ffffff" width="100%" cellpadding="3" cellspacing="1">
<tr><th width="10%" nowrap>日付</th><td>{$date_d}</td></tr>
<tr><th width="10%" nowrap>解析対象</th><td>{$p_total} 件</td></tr>
<tr><th width="10%" nowrap>ページ別</th><td>
<table bgcolor="#ffb555" cellpadding="3" cellspacing="1" width="100%">
	<tr bgcolor="#ffdaaa"><td align="center">タイトル</td><td align="center">ID</td><td align="right">回数</td></tr>

EOM;

		$pDate_el = $relatefile->open_log_def("./log/contents_log/allpage.cgi");
		$pDate = array();
		$pDateExt = array();
		for($i=0;$pDate_el[$i];$i++) {
			list($type,$id,$name,$notUse) = explode("<>",$pDate_el[$i]);
			if($type == 'dir') {
				$pDate_el2nd = $relatefile->open_log_def("./log/contents_log/$id/allpage.cgi");
				foreach($pDate_el2nd as $tmp) {
					list($type2nd,$id2nd,$name2nd,$notUse2nd) = explode("<>",$tmp);
					$pDate[($id."-".$id2nd)] = $name2nd;
				}
			} else {
				if(ereg('bbs',$type)) {$pDateExt[$id] = "bbs";}
				$pDate[$id] = $name;
			}
		}
		
		foreach ($pages as $key => $tmp) {
			$p_name_dCopy = $p_name_d = ereg_replace("-",'/',$key);
			if($pDateExt[$key] == 'bbs') {
				if(ereg('/',$p_name_d)) {list($notUse,$p_name_d) = explode('/',$p_name_d);}
				$link = "./autoscript/bbs.php?id=$p_name_d";
			} else {
				$link = "../$p_name_d.html";
			}
			echo "<tr bgcolor=\"#ffffff\"><td><a href=\"$link\" target=\"_blank\">$pDate[$key]</a></td><td>$p_name_dCopy</td><td align=\"right\">$tmp</td></tr>\n";
		}
		
echo <<<EOM
</table>

</td></tr>
</table>
</div>
EOM;
	}

	// リンク元
	function reffer() {
		$forDate = $this->select("");
		global $relatefile,$message;

		if($forDate == "") { // 指定なし
			$date = date("Ymd"); // 今日のフォルダ
			$date_d = date("Y年m月d日"); // 日付
		} else { // 指定あり
			$date = $forDate;
			$date_d = eregi_replace("([0-9]{4})([0-9]{2})([0-9]{2})","\\1年\\2月\\3日",$date);
		}

		$group = $relatefile->open_log("./autoscript/analyze.log/groupRefferList.cgi");

		$el_ref = $relatefile->open_log_def("./autoscript/analyze.log/$date/reffer.def.cgi");

		if($group[0]) { // グループ化
			$new_ref = array();
			$y = -1;
			for($x=0;$group[$x];$x++) { // 条件評価
				list($f_url,$t_url,$title) = explode("<>",$group[$x]);
				$num = 0;
				for($i=0;$el_ref[$i];$i++) { // リファラ評価
					list($url,$hit) = explode("<>",$el_ref[$i]);
					if(ereg($f_url,$url)) {
						if($num == 0) {
							$y++;
							$new_ref[$y] = "$f_url<><!--HITS--><>\n";
						}
						$num = $num + $hit;
					}
				}
				if($num != "") {$new_ref[$y] = ereg_replace("<!--HITS-->","$num",$new_ref[$y]);}
			}
			for($i=0;$el_ref[$i];$i++) {
				$flag = 0;
				list($url,$hit) = explode("<>",$el_ref[$i]);
				for($x=0;$group[$x];$x++) {
					list($f_url,$t_url,$title) = explode("<>",$group[$x]);
					if(ereg($f_url,$url)) {$flag = 1;}
				}
			if($flag == 0) {$new_ref[] = $el_ref[$i];}
			}
			$el_ref = $new_ref;
		} // グループ化完了

		// 並び替え
		$ref = $this->changeRow($el_ref);
		$t_hit = array_pop($ref);

		$lines = $relatefile->open_log_def("./autoscript/analyze.log/$date/total.def.cgi");
		list($unique,$view) = explode("<>",$lines[0]);

		echo <<<EOM
<div id="title">リンク元</div>
<div id="disp_box">
<table bgcolor="#ffffff" width="100%" cellpadding="3" cellspacing="1">
<tr><th width="10%" nowrap>日付</th><td>{$date_d}</td></tr>
<tr><th width="10%" nowrap>解析対象</th><td>{$t_hit} 件</td></tr>
<tr><th width="10%" nowrap>リンク元</th><td>
<table bgcolor="#ffb555" cellpadding="3" cellspacing="1" width="100%">
	<tr bgcolor="#ffdaaa"><td align="center">URL</td><td align="right">回数</td></tr>
EOM;

		foreach ($ref as $key => $tmp) {
			if(ereg('http',$key)) {
				$flag = 0;
				for($i=0;$group[$i];$i++) {
					list($f_url,$t_url,$title) = explode("<>",$group[$i]);
					if(ereg($f_url,$key)) {
						$flag = 1;
						break;
					}
				}
				if($flag) {
					$jump_url = $f_url;
					$url = $title;
					$atag1 = '<b><a href="?mode=step&url=';
					$atag2 = '</a></b>';
				} else {
					$jump_url = urlencode($key);
					$url = $key;
					$atag1 = '<a href="?mode=step&url=';
					$atag2 = '</a>';
				}
				$atag3 = '" target="_blank">';
			} else {
				$jump_url = '';
				$url = $key;
				$atag1 = '[';
				$atag2 = ']';
				$atag3 = '';
			}
			echo <<<EOM
<tr bgcolor="#ffffff"><td align="left">{$atag1}{$jump_url}{$atag3}{$url}{$atag2}</td><td align="right">{$tmp}</td></tr>
EOM;
		}

		echo <<<EOM
</table>
</td></tr>
<tr><th width="10%" nowrap>グループ化</th><td>
EOM;

		if($group[0]) {
			echo <<<EOM
<table bgcolor="#ffb555" cellpadding="3" cellspacing="1" width="100%">
<tr bgcolor="#ffdaaa"><td>置換対象URL</td><td>置換後URL</td><td>タイトル</td><td>削除</td></tr>

EOM;
		}
		for($i=0;$group[$i];$i++) {
			list($f_url,$t_url,$title) = explode("<>",$group[$i]);
			echo "<tr bgcolor=\"#ffffff\"><td>$f_url</td><td>$t_url</td><td>$title</td><td><a href=\"?mode=delGroup&forDate=$forDate&f_url=".urlencode($f_url)."\">[削]</a></td></tr>\n";
		}
		if($group[0]) {echo "</table>\n";}

		echo <<<EOM
<br />
<form action="?mode=plusGroup&forDate={$forDate}" method="post">
{$message}
<input type="text" name="f_url" />を含むURLを（URL<input type="text" name="t_url" /> タイトル<input type="text" name="title" />）でグループ化 <input type="submit" value="条件を追加" />
</form>
</td></tr>

</table>
</div>
EOM;

	}

	// グループ化条件追加
	function plusGroup() {
		global $_POST,$relatefile;
		
		if($_POST[f_url] == "") {$mes = "置換対象URLを入力してください<br />\n";}
		if($_POST[t_url] == "") {$mes .= "置換後URLを入力してください<br />\n";}
		if($_POST[title] == "") {$mes .= "タイトルを入力してください<br />\n";}
		if($mes) {return $mes;}
		
		$path = "./autoscript/analyze.log/groupRefferList.cgi";
		// 追記処理
		$_POST[f_url] = str_replace("<>","&lt;&gt;",$_POST[f_url]);
		$_POST[t_url] = str_replace("<>","&lt;&gt;",$_POST[t_url]);
		$_POST[title] = str_replace("<>","&lt;&gt;",$_POST[title]);
		if(!file_exists($path)) {$this->make_log($path,"");}
		$fp = @fopen($path,"r+");
		flock($fp,LOCK_EX);
		while (!feof($fp)) {
			$line = fgets($fp);
			list($f_url,$t_url,$title) = explode("<>",$line);
			if($f_url == $_POST[f_url]) {
				fclose($fp);
				return;
			}
			$defline .= $line;
		}
		rewind ($fp);
		fputs($fp,"$_POST[f_url]<>$_POST[t_url]<>$_POST[title]<>\n".$defline);
		fclose($fp);
		return "<span style=\"color:green\">追加しました</span><br />\n";
	}

	// グループ化条件削除
	function delGroup() {
		global $relatefile,$_GET;
		
		// 削除処理
		$new_lines = array();
		$fp = @fopen("./autoscript/analyze.log/groupRefferList.cgi","r+") or die;
		flock($fp,LOCK_EX);
		while (!feof($fp)) {
			$line = fgets($fp);
			list($f_url,$t_url,$title) = explode("<>",$line);
			if($f_url != $_GET[f_url]) {$new_lines[] = $line;}
		}		
		ftruncate($fp, 0);
		rewind($fp);
		for($i=0;$new_lines[$i];$i++) {
			fputs($fp,$new_lines[$i]);
		}
		fclose($fp);
	}

	// ユーザ情報
	function user() {
		$forDate = $this->select("");
		global $relatefile;

		if($forDate == "") { // 指定なし
			$date = date("Ymd"); // 今日のフォルダ
			$date_d = date("Y年m月d日"); // 日付
		} else { // 指定あり
			$date = $forDate;
			$date_d = eregi_replace("([0-9]{4})([0-9]{2})([0-9]{2})","\\1年\\2月\\3日",$date);
		}

		$browser_el = $relatefile->open_log_def("./autoscript/analyze.log/$date/browser.def.cgi");
		$os_el = $relatefile->open_log_def("./autoscript/analyze.log/$date/os.def.cgi");
		$domain_el = $relatefile->open_log_def("./autoscript/analyze.log/$date/domain.def.cgi");

		$u_total = 0;

		// 並び替え(ブラウザ)
		$browser = $this->changeRow($browser_el);
		if($u_total < $one = array_pop($browser)) {$u_total = $one;}
		// 並び替え(OS)
		$os = $this->changeRow($os_el);
		if($u_total < $one = array_pop($os)) {$u_total = $one;}
		// 並び替え(ドメイン)
		$domain = $this->changeRow($domain_el);
		if($u_total < $one = array_pop($domain)) {$u_total = $one;}

		// タグ(ブラウザ)
		foreach ($browser as $key => $tmp) {
			$tag_browser .= "<tr bgcolor=\"#ffffff\"><td>$key</td><td align=\"right\">$tmp</td></tr>\n";
		}
		// タグ(OS)
		foreach ($os as $key => $tmp) {
			$tag_os .= "<tr bgcolor=\"#ffffff\"><td>$key</td><td align=\"right\">$tmp</td></tr>\n";
		}
		// タグ(ドメイン)
		foreach ($domain as $key => $tmp) {
			$tag_domain .= "<tr bgcolor=\"#ffffff\"><td>$key</td><td align=\"right\">$tmp</td></tr>\n";
		}
		
		echo <<<EOM
<div id="title">ユーザー情報</div>
<div id="disp_box">
<table width="100%" cellpadding="3" cellspacing="1">
<tr><th width="10%" nowrap>日付</th><td>{$date_d}</td></tr>
<tr><th width="10%" nowrap>解析対象</th><td>{$u_total} 件</td></tr>
<tr><th width="10%" nowrap>ブラウザ</th><td>
	<table bgcolor="#ffb555" cellpadding="3" cellspacing="1" width="100%">
	<tr bgcolor="#ffdaaa"><td>ブラウザ名</td><td align="right" width="10%">件数</td></tr>
{$tag_browser}
	</table>
</td></tr>
<tr><th width="10%" nowrap>OS</th><td>
	<table bgcolor="#ffb555" cellpadding="3" cellspacing="1" width="100%">
	<tr bgcolor="#ffdaaa"><td>OS名</td><td align="right" width="10%">件数</td></tr>
{$tag_os}
	</table>
</td></tr>
<tr><th width="10%" nowrap>ドメイン</th><td>
	<table bgcolor="#ffb555" cellpadding="3" cellspacing="1" width="100%">
	<tr bgcolor="#ffdaaa"><td>ドメイン名</td><td align="right" width="10%">件数</td></tr>
{$tag_domain}
	</table>
</td></tr>
</table>
</div>
EOM;
	}

	// 検索エンジン
	function engine() {
		$forDate = $this->select("");
		global $relatefile;

		if($forDate == "") { // 指定なし
			$date = date("Ymd"); // 今日のフォルダ
			$date_d = date("Y年m月d日"); // 日付
		} else { // 指定あり
			$date = $forDate;
			$date_d = eregi_replace("([0-9]{4})([0-9]{2})([0-9]{2})","\\1年\\2月\\3日",$date);
		}

		$engine_el = $relatefile->open_log_def("./autoscript/analyze.log/$date/search_engine.def.cgi");

		// 並び替え
		$engine = $this->changeRow($engine_el);
		$e_total = array_pop($engine);

		foreach ($engine as $key => $tmp) {
			if($key == 'Google') {$link = 'http://www.google.co.jp/';
			} elseif($key == 'Yahoo!') {$link = 'http://www.yahoo.co.jp/';
			} elseif($key == 'livedoor') {$link = 'http://www.livedoor.com;/';
			} elseif($key == 'goo') {$link = 'http://www.goo.ne.jp/';
			} elseif($key == 'BIGLOBE') {$link = 'http://www.biglobe.ne.jp/';
			} elseif($key == 'nifty') {$link = 'http://www.nifty.com/';
			} elseif($key == 'Mooter') {$link = 'http://www.mooter.co.jp/';
			} elseif($key == 'Fresh eye') {$link = 'http://www.fresheye.com/search/';
			} elseif($key == 'コトバノウチュウ') {$link = 'http://kotochu.fresheye.com/';
			} elseif($key == 'excite') {$link = 'http://www.excite.co.jp/';
			} elseif($key == 'Infoseek') {$link = 'http://www.infoseek.co.jp/';
			} elseif($key == 'bing') {$link = 'http://www.bing.com/';
			} elseif($key == 'msn') {$link = 'http://jp.msn.com/';
			} elseif($key == 'Baidu') {$link = 'http://www.baidu.jp/';
			} elseif($key == 'OCN') {$link = 'http://www.ocn.ne.jp/';
			} else {$link = $key;
			}
		
			$tag .= "<tr bgcolor=\"#ffffff\"><td><a href=\"$link\" target=\"_blank\">$key</a></td><td align=\"right\">$tmp</td></tr>\n";
		}
		
		echo <<<EOM
<div id="title">検索エンジン</div>
<div id="disp_box">
<table width="100%" cellpadding="3" cellspacing="1">
<tr><th width="10%" nowrap>日付</th><td>$date_d</td></tr>
<tr><th width="10%" nowrap>解析対象</th><td>$e_total 件</td></tr>
<tr><th width="10%" nowrap>検索エンジン</th><td>
	<table bgcolor="#ffb555" cellpadding="3" cellspacing="1" width="100%">
	<tr bgcolor="#ffdaaa"><td>名称</td><td align="right" width="10%">回数</td></tr>
{$tag}
	</table>
</td></tr>
</table>
</div>
EOM;
	}

	// 検索ワード
	function word() {
		$forDate = $this->select("");
		global $relatefile;

		if($forDate == "") { // 指定なし
			$date = date("Ymd"); // 今日のフォルダ
			$date_d = date("Y年m月d日"); // 日付
		} else { // 指定あり
			$date = $forDate;
			$date_d = eregi_replace("([0-9]{4})([0-9]{2})([0-9]{2})","\\1年\\2月\\3日",$date);
		}

		$word_el = $relatefile->open_log_def("./autoscript/analyze.log/$date/search_word.def.cgi");

		// 並び替え
		$word = $this->changeRow($word_el);
		$w_total = array_pop($word);

		foreach ($word as $key => $tmp) {
			$tag .= '<tr bgcolor="#ffffff"><td>'.$key.'</td><td align="right">'.$tmp.'</td></tr>'."\n";
		}
		
		echo <<<EOM
<div id="title">検索エンジン</div>
<div id="disp_box">
<table width="100%" cellpadding="3" cellspacing="1">
<tr><th width="10%" nowrap>日付</th><td>{$date_d}</td></tr>
<tr><th width="10%" nowrap>解析対象</th><td>{$w_total} 件</td></tr>
<tr><th width="10%" nowrap>検索ワード</th><td>
	<table bgcolor="#ffb555" cellpadding="3" cellspacing="1" width="100%">
	<tr bgcolor="#ffdaaa"><td>検索ワード</td><td align="right" width="10%">回数</td></tr>
{$tag}
	</table>
</td></tr>
</table>
</div>
EOM;
	}

	// ワンクッション
	function step() {
		echo <<<EOM
<html>
<head>
<title>PetitCMS - リファラ</title>
<meta http-equiv="Refresh" content="0; URL={$_GET[url]}">
</head>
<body>
</body>
</html>
EOM;
exit;
	}

	// 日付の選択
	function select($off) {
		$date = date("Ymd"); // 今日のフォルダ
		global $relatefile,$_GET;
		$forDate = $_GET[forDate];
		$mode = $_GET[mode];
		
		$lines = $relatefile->open_log("./autoscript/analyze.log/alldate.cgi");
		list($d_name,$notUse) = explode("<>",$lines[0]);
		if($d_name != $date) {@array_unshift($lines,$date);}
		if($forDate != "") {
			$new_h = "c".$forDate;
			$$new_h = " selected";
		}

		echo "\n<form action=\"?\" method=\"get\">\n";
		echo "<select name=\"forDate\">\n";
		for($i=0;$lines[$i];$i++) {
			list($d_name,$notUse) = explode("<>",$lines[$i]);
			$new_h = "c".$d_name;
			$new_h2 = $$new_h;
			$d_name_d = eregi_replace("([0-9]{4})([0-9]{2})([0-9]{2})","\\1年\\2月\\3日",$d_name);
			echo "<option value=\"$d_name\"$new_h2>$d_name_d</option>\n";
		}
		echo "<input type=\"hidden\" name=\"mode\" value=\"$mode\">\n";
		echo "<input type=\"submit\" value=\"GO\">\n";
		echo "</select>\n</form>\n<br />\n";

		return $forDate;
	}

	// 並び替え
	function changeRow($el_UNIlines) {
		$UNItotal = 0;
		$UNIlines = array();
		for($i=0;$el_UNIlines[$i];$i++) {
			list($xUNI,$yUNI) = explode("<>",$el_UNIlines[$i]);
			$UNIlines["$xUNI"] = $yUNI;
			$UNItotal = $UNItotal + $yUNI;
		}
		arsort($UNIlines);
		$UNIlines['UNI_totalGlobal'] = $UNItotal;
		return $UNIlines;
	}


	// 過去or未来の日付を求める
	function computeDate($fromDate, $addDays) {
		$year = substr($fromDate, 0, 4);
		$month = substr($fromDate, 4, 2);
		$day = substr($fromDate, 6, 2);
		$baseSec = mktime(0, 0, 0, $month, $day, $year);//基準日を秒で取得
		$addSec = $addDays * 86400;//日数×１日の秒数
		$targetSec = $baseSec + $addSec;
		return date("Ymd", $targetSec);
	}

}
