'use strict';

var gdata = ''; // eslint-disable-line

/* global $ alchemy getParam formatErrorMessage */
/**
 * XMAILペトリネット図照会画面の初期処理
 * ・ペトリネット図の描画処理呼び出し
 */
$(document).ready(function() {
	gdata = '';
	document.getElementById('navbarNavDropdown').style.visibility = 'hidden';

	/* eslint-disable no-unused-vars */
	var table = $('#datagrid').DataTable({
		paging: false,
		searching: false,
		select: true,
		columns: [
			{ data: 'nid' },
			{ data: 'parent_nid' },
			{ data: 'description' },
			{ data: 'value' },
			{ data: 'attrib' }
		],
		columnDefs: [
			{
				targets: [4],
				className: 'left-aligned-cell'
			}
		],
		order: [[0, 'asc']]
	});

	loadPetrinet();
});

/**
 * ペトリネット図の描画
 * ・ペトリネット図構成データの取得
 * ・取得したデータからペトリネット図を描画
 * @function
 * @see http://graphalchemist.github.io/Alchemy/#/
 * @returns
 * @throws {xhr error}
 */
function loadPetrinet() {
	$.ajax({
		url: '/petrinet/xmail-petrinet',
		type: 'post',
		dataType: 'json',
		data: {
			id: getParam('id')
		},
		success: function(data) {
			alchemy.begin({
				dataSource: data,
				nodeTypes: {
					nodeType: ['place', 'transition']
				},
				nodeCaption: 'label',
				nodeMouseOver: 'id',
				edgeCaption: 'edgeType',
				directedEdges: true,
				nodeCaptionsOnByDefault: true,
				edgeCaptionsOnByDefault: true,
				edgeStyle: {
					all: {
						width: 4,
						color: '#f0f8ff',
						opacity: 0.6,
						selected: {
							opacity: 1
						},
						highlighted: {
							opacity: 1
						},
						hidden: {
							opacity: 0
						}
					}
				},
				nodeStyle: {
					place: {
						color: '#f8f8ff',
						borderColor: '#f8f8ff',
						selected: {
							color: '#ff0000',
							borderColor: '#ff0000'
							//,radius: '13'
						},
						highlighted: {
							color: '#87cefa'
						}
					},
					transition: {
						color: '#4169e1',
						borderColor: '#4169e1',
						selected: {
							color: '#ff0000',
							borderColor: '#ff0000'
							//,radius: '13'
						},
						highlighted: {
							color: '#87cefa'
						}
					}
				}
			});

			getNodeDetails(getParam('id'));
		},
		error: function(jqXHR, textStatus, errorThrown) {
			var msg = 'ペトリネット図の取得に失敗しました。';
			formatErrorMessage(jqXHR, textStatus, errorThrown, msg);
		}
	});

	return;
}

/**
 * ノード詳細情報取得
 * ・XMAILに紐づくノードの詳細情報を取得する。
 * ・ここで取得した内容はメモリ上に保持され、ペトリネット図のノード選択時に参照される。
 * @param {number} node_id - UI1で取得したNIDを指定する。
 * @returns
 * @throws {xhr error}
 */
function getNodeDetails(node_id) {
	$('#txtPlaceId').val('');
	$('#txtPlaceRefId').val('');
	$('#txtTemplateTag').val('');
	$('#txtTemplateId').val('');
	$('#txtTemplateUuId').val('');
	$('#txtTemplateName').val('');
	$('#txtTemplateDescription').val('');

	$.ajax({
		url: '/node',
		type: 'post',
		dataType: 'json',
		data: {
			node_id: node_id
		},
		success: function(data) {
			//store retrived data into memory
			gdata = data;
			/*
			alert('complete!! data: ' + gdata);
			$('#txtPlaceId').val(data[0].place_id);
			$('#txtPlaceRefId').val(data[0].placeRef_id);
			$('#txtTemplateTag').val(data[0].template_tag);
			$('#txtTemplateId').val(data[0].template_id);
			$('#txtTemplateUuId').val(data[0].template_uuid);
			$('#txtTemplateName').val(data[0].template_name);
			$('#txtTemplateDescription').val(data[0].template_description);
			*/
		},
		error: function(jqXHR, textStatus, errorThrown) {
			var msg = 'ノード詳細情報の取得に失敗しました。';
			formatErrorMessage(jqXHR, textStatus, errorThrown, msg);
		}
	});

	return;
}

/**
 * ノード詳細情報取得
 * ・XMAILに紐づくノードの詳細情報を取得する。
 * ・ここで取得した内容はメモリ上に保持され、ペトリネット図のノード選択時に参照される。
 * @param {number} node_id - UI1で取得したNIDを指定する。
 * @returns
 * @throws {xhr error}
 */
function getNodeMaterial(node_id) {
	// eslint-disable-line

	$.ajax({
		url: '/node/node-material',
		type: 'post',
		dataType: 'json',
		data: {
			node_id: node_id
		},
		success: function(data) {
			$('#datagrid')
				.dataTable()
				.fnClearTable();
			if (data.length > 0) {
				$('#datagrid')
					.dataTable()
					.fnAddData(data);
			}
		},
		error: function(jqXHR, textStatus, errorThrown) {
			var msg = 'ノードマテリアル情報の取得に失敗しました。';
			formatErrorMessage(jqXHR, textStatus, errorThrown, msg);
		}
	});

	return;
}
