#!/usr/bin/env python3

import sys, codecs
import re
import xml.etree.ElementTree as ET
import os

#sys.stdout = codecs.getwriter("utf-8")(sys.stdout)

###

def subtree(e, h, n, p, r):
  tag2 = re.sub(r'^{.*}', '', e.tag)
  #print '#', h, n, e.tag, e.attrib, '=> "%s"' % tag2
  print('create (%s:XMLtag { __tag: "%s"' % (n, tag2))
  for name, value in list(e.attrib.items()):
    name2 = re.sub(r'^{.*}', '', name)
    name2 = name2.replace('.', '_')   ### attribute name may contain character '.'
    #print '#  "%s" = "%s"' % (name2, value)
    print('  , %s: "%s"' % (name2, value))
  print('  })')
  print('create (%s)-[:%s]->(%s)' % (p, r, n))

  if (e.text is not None) and (re.match('\S', e.text)):
    #print '#', h, "text: '%s'" % e.text
    print('create (%s:XMLdata { value: "%s" })' % (n + "d", e.text))
    print('create (%s)-[:XML_Data]->(%s)' % (n, n + "d"))
  if (e.tail is not None) and (re.match('\S', e.tail)):
    #print '#', h, "tail: '%s'" % e.tail
    print('create (%s:XMLdata { value: "%s" })' % (n + "d", e.text))
    print('create (%s)-[:XML_Data]->(%s)' % (n, n + "d"))
  for i, s in enumerate(e):
    subtree(s, h + "[%d]>>> " % i, n + "_%d" % i, n, 'XML_Child')

###

try:
  xmail_node = "nx"
  top_node = "n"
  fname = sys.argv[1]
  filename = os.path.basename(fname)
  tree = ET.parse(fname)

except:
  sys.stderr.write('XMAIL: XML file not found\n')
  sys.exit(-1)


try:
  print('create (%s:XMAIL { file: "%s"})' % (xmail_node, filename))

  elem = tree.getroot()
  #sys.stderr.write('top level : ' + elem.tag + '\n')
  xmail_version = elem.attrib.get('xmail.version')
  if xmail_version is None:
    sys.stderr.write('XMAIL data not found\n')
    raise Exception
  elif not re.match('1(\.)?', xmail_version):
    sys.stderr.write('xmail.version != 1.x\n')
    raise Exception

  subtree(elem, "", top_node, xmail_node, 'XML_Root')
  print("return id(nx)")
  print(";")

except:
  sys.stderr.write('XMAIL: parse error\n')
  sys.exit(-2)

else:
  sys.exit(0)


###
### end of script
###
