package jp.bcat;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;

public class RentalCatalog {
	static final String FILE_NAME = "rental.ser";
	protected Hashtable catalog = new Hashtable();
	
	public RentalCatalog(){
		load();
	}
	
	protected synchronized void load(){
		try {
			ObjectInputStream in = new ObjectInputStream(
				new FileInputStream(FILE_NAME));
			catalog = (Hashtable)in.readObject();
			in.close();
		} catch (FileNotFoundException e) {
			// ファイルがない場合は何もしない
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	protected synchronized void save(){
		try {
			ObjectOutputStream out = new ObjectOutputStream(
				new FileOutputStream(FILE_NAME));
			out.writeObject(catalog);
			out.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public RentalRecord getRentalRecord(String userId, String bookId){
		Iterator i = catalog.values().iterator();
		while(i.hasNext()){
			RentalRecord rental = (RentalRecord)i.next();
			String user = rental.getuserId();
			String book = rental.getBookId();
			String returnDate = rental.getReturnDate();
			if(userId.equals(user) && bookId.equals(book) && returnDate == null){
				return rental;
			}
		}
		return null;
	}
	
	public RentalRecord[] getRentalList(){
		RentalRecord[] resultArray = new RentalRecord[catalog.size()];
		catalog.values().toArray(resultArray);
		
		return resultArray;
	}
	
	public synchronized void addRentalRecord(RentalRecord r){
		String catalogId = createUniqueId();
		catalog.put(catalogId, r);
		save();
		
	}
	
	protected String createUniqueId() {
		Date now = new Date();
		String id;
		id = new SimpleDateFormat("yyyyMMddHH").format(now);
		while (catalog.get(id) != null) {
			int intId = Integer.parseInt(id);
			id = Integer.toString(intId + 1);
		}
		return id;
	}
	
	static RentalCatalog sharedInstance;
	static public RentalCatalog getInstance() {
		if (sharedInstance == null) {
			sharedInstance = new RentalCatalog();
		}
		return sharedInstance;
	}
	
	public static void main(String[] args){
		RentalCatalog rc = new RentalCatalog();
		RentalRecord rr= new RentalRecord("1", "1", "");
		
		rc.addRentalRecord(rr);
		rr = new RentalRecord("1", "2", "");
		rc.addRentalRecord(rr);
		System.out.println(rc.getRentalList()[0].getBookId() + rc.getRentalList()[1].getBookId());
	}
}
