package errorReachableAnalyzer;

import java.util.*;

public class State extends ModelMaterial implements Cloneable{
	private HashMap<String,Transition> toTransition;
	private List<String> toTransitionNameList;
	private List<Transition> fromTransitionList;
	private int p;
	State(String name){
		super(name);
		toTransition=new HashMap<String,Transition>();
		toTransitionNameList=new ArrayList<String>();
		fromTransitionList=new ArrayList<Transition>();
	}
	void addToTransition(Transition tr){
		toTransition.put(tr.toString(), tr);
		toTransitionNameList.add(tr.toString());
	}
	void addFromTransition(Transition tr){
		fromTransitionList.add(tr);
	}

	boolean containsToTransition(String name){
		return this.toTransitionNameList.contains(name);
	}
	State getToStateByTransition(String tr){
		return this.toTransition.get(tr).getTo();
	}
	Boolean hasToTransitions(){
		return !toTransition.isEmpty();
		
	}
	
	public int getToTransitionNum(){
		return this.toTransitionNameList.size();
	}
	public Transition getToTransition(int i){
		return this.toTransition.get(this.toTransitionNameList.get(i));
	}
	Transition getToTransition(String name){
		return this.toTransition.get(name);
	}
	public int getFromTransitionNum(){
		return this.fromTransitionList.size();
	}

	public Transition getFromTransition(int i){
		return this.fromTransitionList.get(i);
	}
	@Override
	public boolean hasNext() {
		return p< toTransition.size();
	}
	@Override
	ModelMaterial next() {
		return getToTransition(p++); 
	}
	@Override
	public void reset() {
		p=0;
		// TODO ꂽ\bhEX^u
		
	}
	public State getClone(){
		State s=null;
		try {
			s =(State) this.clone();
			s.reset();
		} catch (CloneNotSupportedException e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		}
		return s;
	}
}
