package errorReachableAnalyzer;

import java.util.ArrayList;
import java.util.List;

public class MultiConcurrentState extends State {
	String env;
	List<String> reqMoniList;
	List<Boolean> deadList;
	int updateNumber;

	private MultiConcurrentState(String name) {
		super(name);	
		reqMoniList=new ArrayList<String>();
		deadList=new ArrayList<Boolean>();
	}
	MultiConcurrentState(String name,int reqMoniNum){
		this(name);
		for(int i=0;i<reqMoniNum;i++){
			this.deadList.add(false);
		}
	}
	MultiConcurrentState(State env,List<State> initReq){
		this(env.toString());
		for(int i=0;i<initReq.size();i++){
			String tmp=initReq.get(i).toString();
			this.reqMoniList.add(tmp);
			this.name=this.name.concat(tmp);
			this.deadList.add(false);
		}
		this.env=env.toString();
	}
	MultiConcurrentState(State env,List<State> reqMoni,Transition t){
		this(env,reqMoni);
		addFromTransition(t);
	}
	MultiConcurrentState(State env,State reqMoni){
		this(env,new ArrayList<State>());
		String tmp=reqMoni.toString();
		this.reqMoniList.add(tmp);
		this.name.concat(tmp);
		this.deadList.add(false);
	}
	
	MultiConcurrentState(State env,State reqMoni,Transition t){
		this(env,reqMoni);
		addFromTransition(t);
	}
	
	void setIsDead(int i){
		if(deadList.size()>i){
		}else{
			deadList.set(i, true);
			setIsDead();
		}		
	}
	
	@Override
	public boolean isDead(){
		int i=0;
		while(i<deadList.size()){
			if(deadList.get(i))return true;
			i++;
		}
		return isDead;
	}
	
	boolean isDead(int i){
		if(deadList.size()<i){
			return deadList.get(i);
		}
		return false;
	}
	void addReqMoni(String s){
		this.name.concat(s);
		this.reqMoniList.add(s);
	}
	public String getEnv() {
		// TODO ꂽ\bhEX^u
		return env;
	}
	public List<String> getReqMoniList(){
		return reqMoniList;
	}
}
