package errorReachableAnalyzer;

import java.util.*;

public class ConcurrentSystemModelMaker {
	static HashMap<String,ConcurrentState> states=new HashMap<String,ConcurrentState>();
	static List<String> statesName =new ArrayList<String>();
	static List<Transition> updatePart=new ArrayList<Transition>();
	static List<String> controllableActions=new ArrayList<String>();
	static int updateNumber=0;
	private static ConcurrentState makeModel(State e,State m){
		ConcurrentState c=new ConcurrentState(e.toString(),m.toString(),updateNumber);
		states.put(e.toString()+m.toString(),c);
		statesName.add(e.toString()+m.toString());
		return c;
	}
	private static void makeErrorModel(){
		ConcurrentState c=new ConcurrentState("ERROR");
		states.put("ERROR", c);
		statesName.add("ERROR");
	}
	public static void setConcurrentModel(ConcurrentModel cm){
		states=cm.states;
		statesName=cm.statesName;
	}
	
	public static void setControllableAction(List<String> ca){
		controllableActions=ca;
	}

	private static void compose(State e,State m,ConcurrentState c){
		for(int i=0;i<e.getToTransitionNum();i++){
			transition(e.getToTransition(i),m,c);
		}
	}
	private static void transition(Transition te,State m,ConcurrentState c){
			Transition tm=m.getToTransition(te.toString());
			Transition tc=new Transition(te.toString());
			updatePart.add(tc);
			if(controllableActions.contains(te.toString()))tc.setIsControllable();
			ConcurrentState targetM=null;
			tc.setFrom(c);
			c.addToTransition(tc);
			if(tm!=null){
				if(tm.getTo().toString().equals("ERROR")){
					tc.setTo(states.get("ERROR"));
					states.get("ERROR").addFromTransition(tc);
				}else{
					targetM=states.get(te.getTo().toString()+tm.getTo().toString());
					if(targetM==null){
						targetM=makeModel(te.getTo(),tm.getTo());	
						targetM.addFromTransition(tc);
						tc.setTo(targetM);
						compose(te.getTo(),tm.getTo(),targetM);				
					}else{
						targetM.addFromTransition(tc);
						tc.setTo(targetM);					
					}						
				}
			}else{
				targetM=states.get(te.getTo().toString()+m.toString());
				if(targetM==null){
					targetM=makeModel(te.getTo(),m);
					targetM.addFromTransition(tc);
					tc.setTo(targetM);
					compose(te.getTo(),m,targetM);
				}else{
					targetM.addFromTransition(tc);
					tc.setTo(targetM);					
				}
			}
	}

	public static ConcurrentModel makeConccurentSystem(Model env,Model moni){
		statesName.clear();
		states.clear();

		ConcurrentState c=makeModel(env.getInitState(), moni.getInitState());
		makeErrorModel();
		compose(env.getInitState(),moni.getInitState(),c);
		return new ConcurrentModel(states,statesName);
	}
	public static Model attachTransition(Model e,String from,String t,String to){
		Transition tr= new Transition(t,e.getState(from),e.getState(to));
		e.getState(from).addToTransition(tr);
		e.getState(to).addFromTransition(tr);
		return e;
	}
	private static List<ConcurrentState> getCandidate(Transition tr,ConcurrentModel cm){
		List<ConcurrentState> l=new ArrayList<ConcurrentState>();
		for(int i=2;i<cm.getSize();i++){
			ConcurrentState cs=cm.getConcurrentState(i);
			if(cs.getEnv().equals(tr.getFrom().toString())){
				l.add(cs);
			}
		}
		return l;
	}
	
	
	public static ConcurrentModel modelUpdate(ConcurrentModel cm,Model e,Model moni,String from,String t,String to){
		updateNumber++;
		updatePart=new ArrayList<Transition>();
		e=attachTransition(e,from,t,to);
		Transition target=e.getState(from).getToTransition(t);
		setConcurrentModel(cm);
		List<ConcurrentState> lcs=getCandidate(target,cm);
		for(int i=0;i<lcs.size();i++){
			State m=moni.getState(lcs.get(i).reqMoni);
			transition(target,m,lcs.get(i));
		}		
		
		return new ConcurrentModel(states,statesName,updatePart);		
	}
	
}
