/*
 * Copyright (C) 2011 Kouichi Machida (k01-dev@live.jp)
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.gr.java_conf.k01.android.widgetpack.preference;

import jp.gr.java_conf.k01.android.widgetpack.R;
import android.content.Context;
import android.content.res.TypedArray;
import android.preference.DialogPreference;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.SeekBar;
import android.widget.TextView;

/**
 * V[No[p DialogPreference 񋟂܂B
 * 
 * @author Kouichi Machida
 */
public class SeekBarDialogPreference extends DialogPreference {

	/**
	 * ^O\܂B
	 */
	private static final String TAG = "SeekBarDialogPreference";

	/**
	 * őlێ܂B
	 */
	private int max;

	/**
	 * ŏlێ܂B
	 */
	private int min;

	/**
	 * SeekBar ̒lێ܂B
	 */
	private int progress;

	/**
	 * unitFormat ̒lێ܂B
	 */
	private String unitFormat = null;

	/**
	 * SeekBarDialogPreference NX̐VCX^X܂B
	 * 
	 * @param context
	 *            Context IuWFNgB
	 * @param attrs
	 *            AttributeSet IuWFNgB
	 */
	public SeekBarDialogPreference(Context context, AttributeSet attrs) {
		super(context, attrs);

		// LOG:
		Log.v(SeekBarDialogPreference.TAG, "SeekBarDialogPreference(Context, AttributeSet)");

		this.init(context, attrs);
	}

	/**
	 * SeekBarDialogPreference NX̐VCX^X܂B
	 * 
	 * @param context
	 *            Context IuWFNgB
	 * @param attrs
	 *            AttributeSet IuWFNgB
	 * @param defStyle
	 */
	public SeekBarDialogPreference(Context context, AttributeSet attrs, int defStyle) {
		super(context, attrs, defStyle);

		// LOG:
		Log.v(SeekBarDialogPreference.TAG, "SeekBarDialogPreference(Context, AttributeSet, int)");

		this.init(context, attrs);
	}

	/**
	 * CX^X܂B
	 * 
	 * @param context
	 *            Context IuWFNgB
	 * @param attrs
	 *            AttributeSet IuWFNgB
	 */
	private void init(Context context, AttributeSet attrs) {
		// TypedArray ܂B
		TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SeekBarDialogPreference);

		this.min = typedArray.getInteger(R.styleable.SeekBarDialogPreference_min, 0);
		this.max = typedArray.getInteger(R.styleable.SeekBarDialogPreference_max, 100);
		this.unitFormat = typedArray.getString(R.styleable.SeekBarDialogPreference_unitFormat);

		typedArray.recycle();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see android.preference.DialogPreference#onCreateDialogView()
	 */
	@Override
	protected View onCreateDialogView() {
		// LOG:
		Log.v(SeekBarDialogPreference.TAG, "View onCreateDialogView()");
		Log.v(SeekBarDialogPreference.TAG, String.format("max = %d, min = %d", this.max, this.min));

		// LayoutInflater 擾܂B
		LayoutInflater layoutInflater = (LayoutInflater) this.getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);

		// dialog_preference_seekbar ̃CAEgŃr[܂B
		View view = layoutInflater.inflate(R.layout.dialog_preference_seekbar, null);

		// eBWFbg擾܂B
		final SeekBar seekBar = (SeekBar) view.findViewById(R.id.seekbar);
		final TextView textView = (TextView) view.findViewById(R.id.progress);

		// V[No[̐ݒ܂B
		seekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see android.widget.SeekBar.OnSeekBarChangeListener#onProgressChanged(android.widget.SeekBar, int, boolean)
			 */
			@Override
			public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
				int value = SeekBarDialogPreference.this.min + progress;

				// ݂̒lێ܂B
				SeekBarDialogPreference.this.progress = value;

				// ݂̒l\܂B
				textView.setText(String.format(SeekBarDialogPreference.this.unitFormat, value));
			}

			/*
			 * (non-Javadoc)
			 * 
			 * @see android.widget.SeekBar.OnSeekBarChangeListener#onStartTrackingTouch(android.widget.SeekBar)
			 */
			@Override
			public void onStartTrackingTouch(SeekBar seekBar) {

			}

			/*
			 * (non-Javadoc)
			 * 
			 * @see android.widget.SeekBar.OnSeekBarChangeListener#onStopTrackingTouch(android.widget.SeekBar)
			 */
			@Override
			public void onStopTrackingTouch(SeekBar seekBar) {

			}

		});
		seekBar.setMax(this.max - this.min);
		seekBar.setProgress(this.progress);

		return view;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see android.preference.DialogPreference#onDialogClosed(boolean)
	 */
	@Override
	protected void onDialogClosed(boolean positiveResult) {
		// LOG:
		Log.v(SeekBarDialogPreference.TAG, "void onDialogClosed(boolean)");

		if (positiveResult) {
			// lۑ܂B
			this.persistInt(this.progress);
		}

		super.onDialogClosed(positiveResult);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see android.preference.Preference#onGetDefaultValue(android.content.res.TypedArray, int)
	 */
	@Override
	protected Object onGetDefaultValue(TypedArray a, int index) {
		// LOG:
		Log.v(SeekBarDialogPreference.TAG, "Object onGetDefaultValue(TypedArray, int)");

		return a.getInteger(index, 0);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see android.preference.Preference#onSetInitialValue(boolean, java.lang.Object)
	 */
	@Override
	protected void onSetInitialValue(boolean restorePersistedValue, Object defaultValue) {
		// LOG:
		Log.v(SeekBarDialogPreference.TAG, "void onSetInitialValue(boolean, Object)");

		if (restorePersistedValue) {
			this.progress = this.getPersistedInt(0);
		} else {
			this.progress = (Integer) defaultValue;
		}
	}

}
