#include	"xchange.h"
#include	"config.h"

extern	void	handler(int sig);
void	send_gw (unsigned char pkt[]);
int     getFifo (unsigned char pkt[]);
void	putFifo (int len, unsigned char pkt[]);


#define CRCPOLY2 0xEDB88320

unsigned int crc32(int n, unsigned char c[])
{
	int i, j;
	unsigned int r;

	r = 0xFFFFFFFFUL;
	for (i = 0; i < n; i++) {
		r ^= c[i];
		for (j = 0; j < 8 ; j++)
			if (r & 1) r = (r >> 1) ^ CRCPOLY2;
			else       r >>= 1;
	}
	return r ^ 0xFFFFFFFF;
}


void	pselectSet(void)
{
	FD_ZERO (&fd_save);
	sigemptyset (&save_sig);
	sigaddset (&save_sig, SIGUSR1);
	sigaddset (&save_sig, SIGUSR2);
	sigaddset (&save_sig, SIGTERM);
	sigaddset (&save_sig, SIGINT);
        timeout.tv_sec = 0;
        timeout.tv_nsec = 10000000;
}

struct ModuleTable *module_check (char call[])
{

	struct ModuleTable *pnt;

	if (call[16] == 0x20) return NULL;
	if (!memcmp (&call[16], "CQCQCQ", 6)) return NULL;
	if (!memcmp (&call[8], "CQCQCQ", 6)) return NULL;

	pnt = module_pnt;

	while (pnt)
	{
		//printf ("%8.8s %8.8s\n", call, pnt->ModuleName);
		if (!memcmp (call, pnt->ModuleName, 8)) return pnt;
		pnt = pnt->f_chain;
	}
	if (debug_sw)
	{
		time (&cur_time);
		fprintf (log_file, "%24.24s Module %8.8s not in Table\n", ctime(&cur_time), call);
		fflush (log_file);
	}

	return NULL;
}

struct 	ModuleTable *module_check_ex (unsigned char FrameID[])
{
	struct ModuleTable *pnt;

	pnt = module_pnt;
	while (pnt)
	{
		//printf ("debug %x %x %x %x\n", FrameID[0], FrameID[1], pnt->FrameID[0], pnt->FrameID[1]);
		if (!memcmp (FrameID, pnt->FrameID, 2)) return  pnt;
		pnt = pnt->f_chain;
	}
	return NULL;
}

struct	ModuleTable *module_send_frame_check (unsigned char FrameID[])
{
	struct	ModuleTable *pnt;

	pnt = module_pnt;
	while (pnt)
	{
		if (!memcmp (FrameID, pnt->SendFrameID, 2)) return  pnt;
		pnt = pnt->f_chain;
	}
	return NULL;
}

struct  ModuleTable *module_recv_frame_check (unsigned char FrameID[])
{
        struct  ModuleTable *pnt;

        pnt = module_pnt;
        while (pnt)
        {
                if (!memcmp (FrameID, pnt->DVRecvFrameID, 2)) return  pnt;
                pnt = pnt->f_chain;
        }
        return NULL;
}

struct  ModuleTable *module_skip_frame_check (unsigned char FrameID[])
{
        struct  ModuleTable *pnt;

        pnt = module_pnt;
        while (pnt)
        {
                if (!memcmp (FrameID, pnt->GWFrameID, 2)) return pnt;
                pnt = pnt->f_chain;
        }
        return NULL;
}


struct  ModuleTable *module_zr_frame_check (unsigned char FrameID[])
{
        struct  ModuleTable *pnt;

        pnt = module_pnt;
        while (pnt)
        {
//printf ("debug %x %x %x %x\n", FrameID[0], FrameID[1], pnt->ZrFrameID[0], pnt->ZrFrameID[1]);
                if (!memcmp (FrameID, pnt->ZrFrameID, 2)) return  pnt;
                pnt = pnt->f_chain;
        }
        return NULL;
}
void    module_init(struct ModuleTable *module, char Module[])
{
        module->AccessTime = 0;
        memcpy (module->ModuleName, Module, 8);
        memset (module->mycall, 0x20, 8);
        memset (module->mycall_ex, 0x20, 4);
        memset (module->rptcall, 0x20, 8);
	memset (module->DVRecvFrameID, 0x00, 2);
	memset (module->DDRecvFrameID, 0x00, 2);
	memset (module->SendFrameID, 0x00, 2);
	memset (module->ZrFrameID, 0x00, 2);
	memset (module->FrameID, 0x00, 2);
	memset (module->GWFrameID, 0x00, 2);
        module->ZR_on = FALSE;
        module->packet_cnt = 0;
        module->f_chain = NULL;
        module->SendSeq = 0;
        module->rpt_save_length = 0;
        module->recv_time.tv_sec = 0;
        module->recv_time.tv_usec = 0;
        module->lost_cnt = 0;
        module->block_sw = FALSE;
	module->zr_dv_in_cnt = 0;
	module->zr_dv_out_cnt = 0;
	module->gw_dv_in_cnt = 0;
	module->gw_dv_out_cnt = 0;
	module->mon_dv_in_cnt = 0;
        module->zr_dd_in_cnt = 0;
        module->zr_dd_out_cnt = 0;
        module->gw_dd_in_cnt = 0;
        module->gw_dd_out_cnt = 0;
        module->mon_dd_in_cnt = 0;
	module->ReplySW = FALSE;
}

void    forward_init (struct forward *fwd, char FullName[], int port, char mnemonic[], int gw_on_sw, char gw_pkt_type)
{
        fwd->f_chain = NULL;
        fwd->port = port;
        memcpy (fwd->fqdn, FullName, 128);
	memcpy (fwd->mnemonic, mnemonic, 16);
        fwd->in_packets = 0;
	fwd->out_packets = 0;
	fwd->alive = FALSE;
}

void	addBlockTable (char FrameID[])
{
	struct	BlockTable	*next;
	time_t	cur_time;

	next = block_pnt;
	while (next)
	{
		if (!memcmp (next->BlockID, FrameID, 2)) return;
		next = next->f_chain;
	}

	next = malloc (sizeof (struct BlockTable));
	if (next != NULL)
	{
		memcpy (next->BlockID, FrameID, 2);
		time (&next->recv_time);
		next->f_chain = NULL;
		if (block_pnt) block_last->f_chain = next;
		else block_pnt = next;
		block_last = next;
	}
	else
	{
		time(&cur_time);
		fprintf (log_file, "%24.24s Memoty not allocate block table\n", ctime(&cur_time));
		fflush (log_file);
	}
}

void	delBlockTable (char FrameID[])
{
	struct BlockTable	*next;
	struct BlockTable	*last;
	struct BlockTable	*temp;

	next = block_pnt;
	last = NULL;
	while (next)
	{
		if (!memcmp (FrameID, next->BlockID, 2))
		{
			temp = next;
			if (last)
			{
				last->f_chain = next->f_chain;
				next = last->f_chain; 
			}
			else
			{
				block_pnt = next->f_chain;
				next = block_pnt;
			}
			free (temp);
			return;
		}
		last = next;
		next = next->f_chain;
	}
}	

int	checkBlockTable (char FrameID[])
{
	struct	BlockTable	*next;

	next = block_pnt;
	while (next)
	{
		if (!memcmp (FrameID, next->BlockID, 2))
		{
			time (&next->recv_time);
			return TRUE;
		}
		next = next->f_chain;
	}
	return FALSE;
}

void    cleanBlockTable (void)
{
        struct BlockTable       *next;
        struct BlockTable       *last;
        struct BlockTable       *temp;
	time_t	a_time;

        next = block_pnt;
        last = NULL;
	time (&a_time);
        while (next)
        {
		
                if ((a_time - next->recv_time) > 5)
                {
                        temp = next;
                        if (last)
                        {
                                last->f_chain = next->f_chain;
                                next = last->f_chain;
                        }
                        else
                        {
                                block_pnt = next->f_chain;
                                next = block_pnt;
                        }
                        free (temp);

                }
                else
                {
                        last = next;
                        next = next->f_chain;
                }
        }
}

int	check_block (char pkt[], int length)
{
	struct ModuleTable *pnt;
	if (length == 58)
	{
		pnt = module_check (&pkt[20]);
		if (!pnt) return FALSE;
		if (pnt->block_sw)
		{
			addBlockTable (&pkt[14]);
			return TRUE;
		}
		return FALSE;
	}
	else if (length == 29) 
	{
		if (checkBlockTable (&pkt[14])) return TRUE;
		else return FALSE;
	}
	if ((length == 32) || (pkt[16] & 0x40))
	{
		if (checkBlockTable (&pkt[14]))
		{
			delBlockTable (&pkt[14]);
			return TRUE;
		}
	}	
	return FALSE;
}

void	block_SetReset (char pkt[])
{

	struct	ModuleTable	*pnt;

	pnt = module_pnt;

	while (pnt)
	{
		if (!memcmp (&pkt[12], pnt->ModuleName, 8))
		{
			if (pkt[10] == 0x01)
			{
				if (pkt[11] & 0x01) pnt->block_sw = TRUE;
				else	pnt->block_sw = FALSE;
			}
			return;
		}
		pnt = pnt->f_chain;
	}
	return;
}
void	gateway_init (void)
{
	unsigned char	init_pkt[10];

	memset (init_pkt, 0x00, 10);
	memcpy (init_pkt, "INIT", 4);
	init_pkt[5] = 0x01;
	init_pkt[6] = 's';

	sendto (gw_out_sd, init_pkt, 10, 0,
		gw_out_info->ai_addr, gw_out_info->ai_addrlen);
}

void	forward_keep_alive (void)
{
	struct forward	*fwd_pnt;

	unsigned char	keep_alive[10];
	time_t		c_time;

	memset (keep_alive, 0x00, 10);
	memcpy (keep_alive, "DSTR", 4);
	keep_alive[6] = 's';
	keep_alive[7] = 0x12;

	time (&c_time);
	fwd_pnt = forward_pnt;

	while (fwd_pnt)
	{
		keep_alive[4] = (fwd_pnt->send_seq >> 8) & 0xff;
		keep_alive[5] = fwd_pnt->send_seq & 0xff;
		sendto (fwd_pnt->fwd_sd, &keep_alive, 10, 0,
                	fwd_pnt->fwd_info->ai_addr, fwd_pnt->fwd_info->ai_addrlen);
		if ((c_time - fwd_pnt->alive_time) > 20) fwd_pnt->alive = FALSE;
		else fwd_pnt->alive = TRUE;
		fwd_pnt = fwd_pnt->f_chain;
		
	}
	time (&keep_alive_time);
}

int	gw_down_cnt;

void    putFifo (int len, unsigned char pkt[])
{
        struct FifoPkt  *ret;
	time_t	atime;

	if (gw_Fifo_cnt > 20)
	{
		if (gw_down_cnt < 12)
		{
			time (&atime);
			fprintf (log_file, "%24.24s dsgwd down\n", ctime(&atime));
			fflush (log_file);
			gw_down_cnt++;
		}
		//sleep (5);
		return;	/* dsgwd down */
	}
        if ((len == Wp->length) && (len != 26))
        {
               	if (!memcmp (&pkt[6], &Wp->pkt[6], len-6)) return;
        }
        ret = malloc (sizeof(struct FifoPkt) - 1024 + len);
        if (ret == NULL)
        {
                fprintf (log_file, "memory error in gw\n");
                fflush (log_file);
                return;
        }
        ret->next = NULL;
        ret->length = len;
        memcpy (ret->pkt, pkt, len);
	Wp->next = ret;
        Wp = ret;
	gw_Fifo_cnt++;
}

int     getFifo (unsigned char pkt[])
{
        struct  FifoPkt *tmp;
	int	len;

        if (Rp->next == NULL) return 0;
        tmp = Rp;
	Rp = Rp->next;
        len = Rp->length;
        memcpy (pkt, Rp->pkt, Rp->length);
        free (tmp);
	gw_Fifo_cnt--;
        return len;
}

enum
{
        SEND_PACKET = 0,
        REPLY_WAIT,
	RESEND_PACKET
} gw_send = SEND_PACKET;

unsigned char	gw_pkt[1024];

void	gw_send_check (void)
{
	int	length;
	time_t	cur_time;

	switch  (gw_send)
	{
		case  SEND_PACKET:
			length = getFifo (gw_pkt);
			if (length) 
			{
				send_gw (gw_pkt);
				gw_send = REPLY_WAIT;
				gw_reply_recv = FALSE;
				time(&gw_send_time);
			}
			break;

		case REPLY_WAIT:
			if (gw_reply_recv)
			{
				gw_reply_recv = FALSE;
				gw_send = SEND_PACKET;
				gw_down_cnt = 0;
			}
			else
			{
				time (&cur_time);
				if ((cur_time - gw_send_time) >= 1)
				{
					gw_send = RESEND_PACKET;
				}
			}
			break;

		case RESEND_PACKET:
                        send_gw (gw_pkt);
                        gw_send = REPLY_WAIT;
                        gw_reply_recv = FALSE;
                        time(&gw_send_time);
                        break;

		default:
			gw_send = SEND_PACKET;
			break;
	}

}

int *parser_result(const char *buf, int size){
        static int ret[10];
        int i, j = 0, start = 0;

        for(i=0; i<size; i++){
                char c = buf[i];
                if(c >= '0' && c <= '9'){
                        if(!start){
                                start = 1;
                                ret[j] = c-'0';
                        } else {
                                ret[j] *= 10;
                                ret[j] += c-'0';
                        }
                } else if(c == '\n'){
                        break;
                } else {
                        if(start){
                                j++;
                                start = 0;
                        }
                }
        }

        return ret;
}

char	CpuUsage[10];
int	prev_idle = 0, prev_total = 0;
void	cpu_usage (void)
{
	int size,  *nums, idle, total, i;
	char	buf[356];

	size = read(cpu_fd, buf, sizeof(buf));
        if(size <= 0) return;
               
	nums = parser_result(buf, size);
	idle=nums[3];
	for(i=0, total=0; i<10; i++){
		total += nums[i];
	}
        int diff_idle = idle-prev_idle;
        int diff_total = total-prev_total;
        float usage = (float)(((float)(1000*(diff_total-diff_idle))/(float)diff_total+5)/(float)10);
        sprintf(CpuUsage, "%6.2f%%", usage);
                
        prev_total = total;
        prev_idle = idle;
        lseek(cpu_fd, 0, SEEK_SET);
}

int    getOwnIp (void)
{
	int	fd;
        struct  ifreq   ifr;
	int	ret;

        fd = socket (AF_INET, SOCK_DGRAM, 0);
	ifr.ifr_addr.sa_family = AF_INET;
        strncpy (ifr.ifr_name, NicDevice, IFNAMSIZ);
        ret = ioctl (fd, SIOCGIFADDR, &ifr);
	close (fd);
	time (&cur_time);
	if (ret == -1)
	{
		fprintf (log_file, "%24.24s ioctl error: %s\n", ctime(&cur_time), strerror(errno));
		fflush (log_file);
		return FALSE;
		
	}
	OwnIP.s_addr = ((struct sockaddr_in *)&ifr.ifr_addr)->sin_addr.s_addr;
	if (debug_sw)
	{
        	fprintf(log_file, "%24.24s Own IP address %s\n", ctime(&cur_time),
			inet_ntoa (((struct sockaddr_in *)&ifr.ifr_addr)->sin_addr));
        	fflush (log_file);
	}
	fd = socket (AF_INET, SOCK_DGRAM, 0);
	strncpy (ifr.ifr_name, NicDevice, IFNAMSIZ);
	ret = ioctl (fd, SIOCGIFHWADDR, &ifr);
	close (fd);
if (ret < 0) printf ("debug %d %s\n", ret, strerror(errno));
	memcpy (mac_addr, (unsigned char *)&ifr.ifr_hwaddr.sa_data, 6);
	if (upnp_auto)
	{
		if ((OwnIP.s_addr & 0xff) == 0x0a)
		{
			upnp_sw = TRUE;
		}
		else if (((OwnIP.s_addr & 0xff) == 0xc0) && (((OwnIP.s_addr >> 8) & 0xff) == 0xa8)) 
		{
			upnp_sw = TRUE;
		}
		else if ((OwnIP.s_addr & 0xff) == 0xac)
		{
			if ((((OwnIP.s_addr >> 8) & 0xff) >= 0x10) && (((OwnIP.s_addr >> 8) & 0xff) <= 0x1f)) upnp_sw = TRUE;
		}
		else
		{
			fprintf (log_file, "%24.24s NIC:%s had Global IP\n", ctime(&cur_time), NicDevice);
			fflush (log_file);
			upnp_sw = FALSE;
			return FALSE;
		}
	}
	return TRUE;
}

void	module_ctrl_set (char call[])
{
	char	module_ctrl[8];
	struct ModuleTable	*module_next;

	module_next = module_pnt;

	memset (module_ctrl, 0x20, 8);
	memcpy (module_ctrl, call, 7);

	if (!module_check (module_ctrl))
	{
		module_next = malloc (sizeof (struct ModuleTable));
		module_init(module_next, module_ctrl);
		if (module_pnt) module_last->f_chain = module_next;
		else module_pnt = module_next;
		module_last = module_next;
	}

	module_ctrl[7] = 'S';
	if (module_check (module_ctrl)) return;

	module_next = malloc (sizeof (struct ModuleTable));
	module_init(module_next, module_ctrl);
	if (module_pnt) module_last->f_chain = module_next;
	else module_pnt = module_next;
	module_last = module_next;
}

void    put_zr_Fifo (int len, unsigned char pkt[])
{
        struct FifoPkt  *ret;
	time_t	atime;

	if ((len == zr_Wp->length) && (pkt[7] != 0x21))
	{
			if (!memcmp (&pkt[6], &zr_Wp->pkt[6], len-6)) return;
	}
        ret = malloc (sizeof(struct FifoPkt) - 1024 + len);
        if (ret == NULL)
        {
                fprintf (log_file, "memory error in zr\n");
                fflush (log_file);
                return;
        }
        ret->next = NULL;
        ret->length = len;
        memcpy (ret->pkt, pkt, len);
	zr_Wp->next = ret;
        zr_Wp = ret;
}

int     get_zr_Fifo (unsigned char pkt[])
{
        struct  FifoPkt *tmp;
	int	len;

        if (zr_Rp->next == NULL) return 0;
        tmp = zr_Rp;
	zr_Rp = zr_Rp->next;
        len = zr_Rp->length;
        memcpy (pkt, zr_Rp->pkt, zr_Rp->length);
        free (tmp);
        return len;
}

enum
{
        ZR_SEND_PACKET = 0,
        ZR_REPLY_WAIT,
	ZR_RESEND_PACKET
} zr_send = ZR_SEND_PACKET;

unsigned char	zr_pkt[1024];

void	zr_send_check (void)
{
	int	length;
	time_t	cur_time;

	switch  (zr_send)
	{
		case  ZR_SEND_PACKET:
			length = get_zr_Fifo (zr_pkt);
			if (length) 
			{
				send_zr (zr_pkt);
				zr_send = ZR_REPLY_WAIT;
				zr_reply_recv = FALSE;
				time(&zr_send_time);
			}
			break;

		case ZR_REPLY_WAIT:
			if (zr_reply_recv)
			{
				zr_reply_recv = FALSE;
				zr_send = ZR_SEND_PACKET;
			}
			else
			{
				time (&cur_time);
				if ((cur_time - zr_send_time) >= 1)
				{
					zr_send = ZR_RESEND_PACKET;
				}
			}
			break;

		case ZR_RESEND_PACKET:
                        send_zr (zr_pkt);
                        zr_send = ZR_REPLY_WAIT;
                        zr_reply_recv = FALSE;
                        time(&zr_send_time);
                        break;

		default:
			zr_send = ZR_SEND_PACKET;
			break;
	}

}

int	mycall2_check (unsigned char mycall2[])
{
	int 	i;
	for (i = 0 ; i < 4 ; i++)
	{
		if (mycall2[i] == 0x00) return FALSE;
	}
	return TRUE;
}

unsigned short csum(unsigned short *buf, int nwords)

{       //

        unsigned long sum;

        for(sum=0; nwords>0; nwords--)

                sum += *buf++;
        sum = (sum >> 16) + (sum &0xffff);
        sum += (sum >> 16);
        return (unsigned short)(~sum);
}

