/*
	Interface for ID-RP2C

*/


#define	RECV_PORT	21000
#define	CONFIG_FILE	"/opt/dstar/conf/xchange.conf"
#define DSGWD_CONF	"/etc/dsgwd.conf"
#define LOG_FILE	"/var/log/xchange.log"
#define	PID_FILE	"/var/run/xchange.pid"
#define CSS_FILE        "/opt/dstar/web/dstar.css"
#define LOGO_FILE       "/opt/dstar/web/logo.png"
#define JS_FILE         "/opt/dstar/web/dstar.js"
#define	TRUST_SERVER	"trust.d-star.info"

#define	TRUST_PORT	30001
#define	TRUST_SEND_PORT	30012

#define	TRUE		1
#define	FALSE		0

#include	<stdint.h>
#include	<string.h>
#include	<ctype.h>
#include	<time.h>
#include	<sys/time.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<sys/socket.h>
#include 	<sys/types.h>
#include 	<netinet/in.h>
#include 	<netdb.h>
#include	<signal.h>
#include	<sys/ioctl.h>
#include	<sys/stat.h>
#include	<net/if.h>
#include	<arpa/inet.h>
#include	<errno.h>
#include	<sys/utsname.h>
#include	<unistd.h>
#include	<fcntl.h>
#include	<net/ethernet.h>
#include	"dstar.h"
#include	"packet.h"
#include 	<netpacket/packet.h>

struct	ModuleTable
{
	struct	ModuleTable	*f_chain;
	struct	timeval	recv_time;
	unsigned char	ModuleName[8];
	time_t		AccessTime;
	long int        zr_dv_in_cnt;
	long int        zr_dv_out_cnt;
	long int        gw_dv_in_cnt;
	long int        gw_dv_out_cnt;
	long int        mon_dv_in_cnt;
        long int        zr_dd_in_cnt;
        long int        zr_dd_out_cnt;
        long int        gw_dd_in_cnt;
        long int        gw_dd_out_cnt;
        long int        mon_dd_in_cnt;	
	int		SendSeq;
	int		packet_cnt;
	int		rpt_save_length;
	int		lost_cnt;
	unsigned char   FrameID[2];
	unsigned char	SendFrameID[2];
	unsigned char	DVRecvFrameID[2];
	unsigned char   DDRecvFrameID[2];
	unsigned char	ZrFrameID[2];
	unsigned char	GWFrameID[2];
	unsigned char   mini_header;
	unsigned char   data_temp[5];
	unsigned char	mycall[8];
	unsigned char	mycall_ex[4];
	unsigned char	urcall[8];
	unsigned char	rptcall[8];
	unsigned char	ZR_on;
	unsigned char	block_sw;
	unsigned char	lost_frame_sw;
	struct	dstar_packet	rpt_save;
	unsigned char	ReplyFrameID[2];
	unsigned char	ReplySW;
};

struct	BlockTable {
	struct	BlockTable	*f_chain;
	time_t	recv_time;
	char	BlockID[2];
};

int		mon_port;
int		zr_in_port;
int		zr_out_port;
int		gw_in_port;
int		gw_out_port;
int		trust_port;
int		zr_in_sd;
int		zr_out_sd;
int		gw_in_sd;
int		gw_out_sd;
int		mon_in_sd;
int		trust_sd;
int		upnp_udp_sd;
int		upnp_http_sd;
struct  sockaddr_in     zr_in_addr;
struct  sockaddr_in     zr_out_addr;
struct  sockaddr_in     gw_in_addr;
struct  sockaddr_in     gw_out_addr;

long int	zr_in_cnt;
long int	zr_out_cnt;
long int	gw_in_cnt;
long int	gw_out_cnt;
long int	mon_in_cnt;
long int	zr_posit_in_cnt;
	
unsigned char	zr_callsign[8];

int	reload;
int	debug_sw;
int	sig_term;

FILE	*log_file;
FILE	*pid_file;

/* Monitor & Forward definition */

struct	forward
{
	struct		forward	*f_chain;
	char		fqdn[128];
	char		mnemonic[16];
	int		port;
	int		fwd_sd;
	struct	addrinfo	*fwd_info;
	long int	in_packets;
	long int	out_packets;
	unsigned int	send_seq;
	char		alive;
	time_t		alive_time;
};

#define	GW_ON		0x80
#define	ZR_ON		0x40
#define	FWD_ON		0x04
#define	XCHANGE		0x08

struct	forward		*forward_pnt, *forward_last;


fd_set          read_set;
fd_set		fd_save;

struct  ModuleTable     *module_pnt, *module_last;
struct	BlockTable	*block_pnt, *block_last;

char	ZR_NIC[16];
char	GW_NIC[16];
char	GW_CALLSIGN[8];

char	ZR_ADDR[128];
char	GW_ADDR[128];

struct	sockaddr_in    	rpt_mon_addr;

struct	tm	*gt;

struct utsname      uname_buf;

sigset_t	save_sig;
sigset_t	sigset;
struct  timespec        timeout;

struct	addrinfo	*zr_out_info;
struct	addrinfo	*gw_out_info;

time_t	keep_alive_time;

struct	timeval	tm0;

struct  FifoPkt
{
        struct  FifoPkt *next;
        int     length;
	unsigned char pkt[1024];
};

struct  FifoPkt *Rp;
struct  FifoPkt *Wp;
char	gw_reply_recv;
time_t	gw_send_time;
int	gw_Fifo_cnt;

struct  FifoPkt *zr_Rp;
struct  FifoPkt *zr_Wp;
char    zr_reply_recv;
time_t  zr_send_time;
int     zr_Fifo_cnt;


/* http */
int     http_port;
int     http_sd;
struct  sockaddr_storage        http_recv;
struct  addrinfo        *http_serv;

int	cpu_fd;

int	upnp_sw;
int	upnp_auto;
char	upnp_buf[4096];
struct	addrinfo	*upnp_sock;
struct	addrinfo	*upnp_bind_sock;

struct  sockaddr_storage        in_upnp_addr;
socklen_t       in_upnp_addr_len;
char    upnp_ip_addr[64];

struct	in_addr	OwnIP;
unsigned char	mac_addr[6];

int	upnp_buf_pnt;
int	upnp_add_sw;
time_t	upnp_send_time;

time_t	cur_time;

char    NicDevice[IFNAMSIZ];

// The IP header's structure

struct ipheader {
	unsigned char      iph_ihl:4, iph_ver:4;
	unsigned char      iph_tos;
	unsigned short int iph_len;
	unsigned short int iph_ident;
	unsigned short int iph_offset;
	unsigned char      iph_ttl;
	unsigned char      iph_protocol;
	unsigned short int iph_chksum;
	unsigned int       iph_sourceip;
	unsigned int       iph_destip;
	//unsigned char	   kind;
	//unsigned char	   length;
	unsigned char	   opt[16];
};

// UDP header's structure

struct udpheader {

	unsigned short int udph_srcport;
	unsigned short int udph_destport;
	unsigned short int udph_len;
	unsigned short int udph_chksum;
};

struct	sockaddr_in trust_addr;
time_t	dscsd_send_time;

char	trust_server[128];

