#include	"xchange.h"

void    rep_send (struct ModuleTable *pnt);
void    forward (struct dstar_packet ds_pkt, int length);
void	send_zr_reply (char buff[]);
void	send_gw_reply (char buff[]);
void	send_zr (char buff[]);
void	send_gw (unsigned char buff[]);
int	check_lock (char pkt[], int length);
void	putFifo (int length, char pkt[]);
int	check_block(char buff[], int length);
int	mycall2_check (unsigned char call[]);

struct	ModuleTable	*module_check (char call[]);
struct	ModuleTable	*module_check_ex (char FrameID[]);
struct  ModuleTable     *module_send_frame_check (char FrameID[]);
struct  ModuleTable     *module_recv_frame_check (char FrameID[]);
struct  ModuleTable     *module_zr_frame_check (char FrameID[]);
struct  ModuleTable     *module_skip_frame_check (char FrameID[]);


extern	struct	sockaddr_in	in_sock;
extern	socklen_t	len_in_sock;

int	recv_zr_seq = 0;
unsigned int	send_zr_seq = 0;
unsigned int	send_zr_seq_save = 0;
int	recv_gw_seq = 0;
unsigned int	send_gw_seq = 0;
unsigned int	send_gw_seq_save = 0;
struct	sockaddr_in	zr_in_addr;
struct	sockaddr_in	zr_out_addr;
struct	sockaddr_in	gw_in_addr;
struct	sockaddr_in	gw_out_addr;

char	mon_frame_id[2] = {0x00, 0x00};

union
{
	struct	dstar_packet	d_packet;
	char	zr_buffer[4096];
}	zr_buff;

union
{
	struct  dstar_packet    d_packet;
	char    gw_buffer[4096];
}	gw_buff;

union
{
	struct  dstar_packet    d_packet;
	char    mon_buffer[4096];
}       mon_buff;

void	xchange_zr(void)
{
        int     zr_length;
        socklen_t       zr_in_addr_len;
	struct	ModuleTable	*m_pnt;
	time_t	atime;

        zr_in_addr_len= sizeof(zr_in_addr);
        zr_length = recvfrom(zr_in_sd, &zr_buff, sizeof(zr_buff), 0,
				(struct sockaddr *)&zr_in_addr, &zr_in_addr_len);
	if (zr_length < 0)
	{
		time (&atime);
		fprintf (log_file, "%24.24s zr_in error %s\n", ctime (&atime), strerror(errno));
		fflush (log_file);
		return;
	}
	if (zr_length < 10) return;
	if (memcmp (zr_buff.zr_buffer, "DSTR", 4)) return;
	zr_length = (zr_buff.d_packet.l[0] << 8) | zr_buff.d_packet.l[1];
	zr_length += 10;
	if (zr_buff.zr_buffer[6] == 's')
	{
		zr_in_cnt++;
		send_zr_reply (zr_buff.zr_buffer);
		/* Location information update packet */
		if (zr_length == 26)
		{
			if (zr_buff.zr_buffer[7] == 0x21) 
			{
				if ((zr_buff.zr_buffer[10] != 0x20)
					&& (memcmp (&zr_buff.zr_buffer[10], "CQCQCQ", 6)))
				{
					putFifo (zr_length, zr_buff.zr_buffer);
					zr_posit_in_cnt++;
				}
			}
		}
		else if (zr_length == 58) 
		{
			if (!mycall2_check (zr_buff.d_packet.body.header.mycall_ex)) return;
			if (zr_buff.zr_buffer[27] == 'G')
			{
				m_pnt = module_check (&zr_buff.zr_buffer[28]); 
				if (m_pnt)
				{
					memcpy (m_pnt->SendFrameID, &zr_buff.zr_buffer[14], 2);
					if (zr_buff.zr_buffer[7] == 0x12) m_pnt->zr_dv_in_cnt++;
					else if (zr_buff.zr_buffer[7] == 0x11) m_pnt->zr_dd_in_cnt++;
					if (!m_pnt->block_sw) putFifo (zr_length, (char *)zr_buff.zr_buffer);
				}
			}
		}
		else
		{
			m_pnt = module_send_frame_check (&zr_buff.zr_buffer[14]);
			if (m_pnt)
			{	if (zr_buff.zr_buffer[7] == 0x12) m_pnt->zr_dv_in_cnt++;
				else if (zr_buff.zr_buffer[7] == 0x11) m_pnt->zr_dd_in_cnt++;
				if (!m_pnt->block_sw) 
					putFifo (zr_length, (char *)zr_buff.zr_buffer);
			}
		}
	}
	else if (zr_buff.zr_buffer[6] == 'r')
	{
		send_zr_seq_save = send_zr_seq;
		send_zr_seq = ((zr_buff.zr_buffer[4] & 0xff) << 8) | (zr_buff.zr_buffer[5] & 0xff);
		if (send_zr_seq_save == send_zr_seq) 
		{
			send_zr_seq++;
			zr_reply_recv = TRUE;
		}
		send_zr_seq &= 0xffff;
	}
}

void	send_zr_reply (char pkt[])
{
	char	zr_reply[10];

	memset (zr_reply, 0x00, 10);
	memcpy (zr_reply, pkt, 6);
	zr_reply[6] = 'r';
	sendto (zr_out_sd, zr_reply, 10, 0, zr_out_info->ai_addr, zr_out_info->ai_addrlen);
}

void	send_zr (char pkt[])
{
	int	length;
	int	err;
	time_t	atime;
	struct	ModuleTable	*m_pnt;

	length = ((pkt[8] & 0xff) << 8) | (pkt[9] & 0xff);
	length &= 0xffff;
	length += 10;
	pkt[4] = (send_zr_seq >> 8) & 0xff;
	pkt[5] = send_zr_seq & 0x0ff;

	err = sendto (zr_out_sd, pkt, length, 0, 
		zr_out_info->ai_addr, zr_out_info->ai_addrlen);
	zr_out_cnt++;
        if (err == -1)
        {
                time (&atime);
                fprintf (log_file, "%24.24s sendto (zr out) error:%s\n",
                        ctime(&atime), strerror(errno));
                fflush (log_file);
        }
        if (length == 58)
        {
		//printf ("debug 100 %8.8s\n", &pkt[20]);
        	m_pnt = module_check (&pkt[20]);
                if (m_pnt)
		{
			memcpy (m_pnt->ZrFrameID, &gw_buff.gw_buffer[14], 2);
                	if (gw_buff.gw_buffer[7] == 0x12) m_pnt->zr_dv_out_cnt++;
			else if (gw_buff.gw_buffer[7] == 0x11) m_pnt->zr_dd_out_cnt++;
                }
	}
        //else if ((length == 29) || (length == 32))
        else
        {
        	m_pnt = module_zr_frame_check (&pkt[14]);
                if (m_pnt)
                {
			if (gw_buff.gw_buffer[7] == 0x12) m_pnt->zr_dv_out_cnt++;
			else if (gw_buff.gw_buffer[7] == 0x11) m_pnt->zr_dd_out_cnt++;
                }
       }
}


void	xchange_gw(void)
{
	int	gw_length;
	socklen_t	gw_in_addr_len;
	struct	forward		*pnt;
	int	block_status;
	struct	ModuleTable	*m_pnt;
	unsigned char	temp;
	time_t	atime;

	gw_in_addr_len = sizeof(gw_in_addr);
	gw_length = recvfrom(gw_in_sd, &gw_buff, sizeof(gw_buff), 0, 
			(struct sockaddr *)&gw_in_addr, &gw_in_addr_len);
	if (gw_length < 0)
	{
		time (&atime);
		fprintf (log_file, "%24.24s gw_in error %s\n", ctime(&atime), strerror(errno));
		fflush (log_file);
		return;
	}
	if (gw_length < 10) return;
	if (memcmp (gw_buff.gw_buffer, "DSTR", 4)) return;
	if (gw_buff.gw_buffer[6] == 's')
	{
		send_gw_reply (gw_buff.gw_buffer);
		gw_in_cnt++;
		gw_length = (gw_buff.d_packet.l[0] << 8) | gw_buff.d_packet.l[1];
		gw_length += 10;
//if ((gw_length == 58) || ( gw_length == 28) || (gw_length == 32)) printf ("debug recv %d %2.2x %2.2x\n", gw_length, gw_buff.d_packet.trunk.FrameID[0], gw_buff.d_packet.trunk.FrameID[1]);
       		if (gw_length == 58)
        	{
			//if (module_skip_frame_check (gw_buff.d_packet.trunk.FrameID) == NULL) return;
			if (!mycall2_check (gw_buff.d_packet.body.header.mycall_ex)) return;
			if (module_skip_frame_check(&gw_buff.gw_buffer[14])) return;
                	m_pnt = module_check (&gw_buff.gw_buffer[20]);
                	if (m_pnt)
                	{
				if (gw_buff.gw_buffer[7] == 0x12)
				{
					memcpy (m_pnt->DVRecvFrameID, &gw_buff.gw_buffer[14], 2);
                        		m_pnt->gw_dv_in_cnt++;
				}
				else if (gw_buff.gw_buffer[7] == 0x11)
				{
					memcpy (m_pnt->DDRecvFrameID, &gw_buff.gw_buffer[14], 2);
					m_pnt->gw_dd_in_cnt++;
				}
                	}
        	}
        	//else if ((gw_length == 29) || (gw_length == 32))
        	else if ((gw_length == 29) || (gw_length == 32))
        	{
			//if (module_skip_frame_check (gw_buff.d_packet.trunk.FrameID) == NULL) return;
			if (module_skip_frame_check(&gw_buff.gw_buffer[14])) return;
                	m_pnt = module_recv_frame_check (&gw_buff.gw_buffer[14]);
                	if (m_pnt)
			{
				if (gw_buff.gw_buffer[7] == 0x12)  m_pnt->gw_dv_in_cnt++;
				else if (gw_buff.gw_buffer[7] == 0x11)  m_pnt->gw_dd_in_cnt++;
			}
       		}

		block_status = check_block(gw_buff.gw_buffer, gw_length);
		gw_buff.gw_buffer[7] |= GW_ON;
		if (!module_send_frame_check (&gw_buff.gw_buffer[14]))
		{
        		pnt = forward_pnt;
        		while (pnt)
        		{
				sendto (pnt->fwd_sd, &gw_buff, gw_length, 0,
                        		pnt->fwd_info->ai_addr, pnt->fwd_info->ai_addrlen);
				if (pnt->alive) pnt->out_packets++;
                		pnt = pnt->f_chain;
			}
        	}

		if (!block_status)
		{
			gw_buff.gw_buffer[7] &= 0x3f;
			put_zr_Fifo (gw_length, gw_buff.gw_buffer);
		}
	}
	else if (gw_buff.gw_buffer[6] == 'r')
        {
		send_gw_seq_save = send_gw_seq;
                send_gw_seq = ((gw_buff.gw_buffer[4] & 0xff) << 8) | (gw_buff.gw_buffer[5] & 0xff);
		if (send_gw_seq_save == send_gw_seq)
		{
			gw_reply_recv = TRUE;
			send_gw_seq++;
		}
                send_gw_seq &= 0xffff;
	}
}

void    send_gw_reply (char pkt[])
{
        char    gw_reply[10];
	int	err;
	time_t	atime;

        memset (gw_reply, 0x00, 10);
        memcpy (gw_reply, pkt, 6);
        gw_reply[6] = 'r';

	err = sendto (gw_out_sd, gw_reply, 10, 0, 
		gw_out_info->ai_addr, gw_out_info->ai_addrlen);
        if (err == -1)
        {
                time (&atime);
                fprintf (log_file, "%24.24s sendto (gateway reply) error:%s\n",
                        ctime(&atime), strerror(errno));
                fflush (log_file);
        }
}

void	send_gw (unsigned char pkt[])
{
	int	length;
	int	err;
	time_t	atime;
	struct	ModuleTable	*m_pnt;

	length = ((pkt[8] & 0xff) << 8) | (pkt[9] & 0xff);
	length &= 0xffff;	// length of pay load
	length += 10;
        pkt[4] = (send_gw_seq >> 8) & 0xff;	// new sequence
        pkt[5] = send_gw_seq  & 0xff;		// new sequence
	err = sendto (gw_out_sd, pkt, length, 0, 
		gw_out_info->ai_addr, gw_out_info->ai_addrlen);
	gw_out_cnt++;
	if (err == -1)
	{
		time (&atime);
		fprintf (log_file, "%24.24s sendto (gateway out) error:%s\n",
			ctime(&atime), strerror(errno));
		fflush (log_file);
	}
        if (length == 58)
        {
                m_pnt = module_check (&pkt[28]);
                if (m_pnt)
                {
                        if (pkt[7] == 0x12) m_pnt->gw_dv_out_cnt++;
			else if (pkt[7] == 0x11) m_pnt->gw_dd_out_cnt++;
			memcpy (m_pnt->GWFrameID, &pkt[14], 2);
                }
        }
        else if ((length == 29) || (length == 32))
        {
                m_pnt = module_send_frame_check (&pkt[14]);
                if (m_pnt)
                {
                        if (pkt[7] == 0x12) m_pnt->gw_dv_out_cnt++;
			else if (pkt[7] == 0x11) m_pnt->gw_dd_out_cnt++;
			memcpy (m_pnt->GWFrameID, &pkt[14], 2);
                }
       }
}

int	xchange_mon(void)
{
	struct	ModuleTable	*m_pnt;
	int	length;
	time_t	atime;
	//in_addr_t	ip_temp;
	//in_port_t	port_temp;
	struct	timeval		time_21ms;
	struct	timeval		cur_time;

	len_in_sock = sizeof (in_sock);
    	length = recvfrom(mon_in_sd, &mon_buff, sizeof(mon_buff), 0, (struct sockaddr *)&in_sock, &len_in_sock);
	if (length < 0) {
               	time(&atime);
               	fprintf (log_file, "%24.24s Repeater data Reciv. error\n", ctime(&atime));
        	return FALSE;			// end
    	}

	if (!memcmp(mon_buff.d_packet.id, "DSTR", 4) && (mon_buff.d_packet.sr == 's')) 
	{
		length = (mon_buff.d_packet.l[0] << 8) | mon_buff.d_packet.l[1];
		length += 10;
		mon_in_cnt++;
		if (length == 58)
		{
			if (!mycall2_check (mon_buff.d_packet.body.header.mycall_ex)) return TRUE;
			m_pnt = module_check(mon_buff.d_packet.body.header.rpt1);
			if (m_pnt)
			{
				if (mon_buff.d_packet.c == 0x12) m_pnt->mon_dv_in_cnt++;
				else if (mon_buff.d_packet.c == 0x11) m_pnt->mon_dd_in_cnt++;
				memcpy (&m_pnt->rpt_save, &mon_buff, 58);
				m_pnt->rpt_save_length = 58;
				//rep_send (m_pnt);
				memcpy (m_pnt->FrameID, mon_buff.d_packet.trunk.FrameID, 2);
				gettimeofday (&cur_time, NULL);
				time_21ms.tv_sec = 0;
				time_21ms.tv_usec = 21000;
				timeradd (&cur_time, &time_21ms, &m_pnt->recv_time);
				m_pnt->lost_cnt = 0;
				m_pnt->ZR_on = TRUE;
			}
			if ((zr_out_port == 0) || (mon_buff.d_packet.body.header.rpt2[7] != 'G')) 
					memcpy (mon_frame_id, mon_buff.d_packet.trunk.FrameID, 2);
		}
		else if (length == 29) 
		{
			//memcpy (&ip_temp, &in_sock.sin_addr.s_addr, 4);
			//memcpy (&port_temp, &in_sock.sin_port, 2);
			m_pnt = module_check_ex (mon_buff.d_packet.trunk.FrameID);
			if (m_pnt)
			{
				if (mon_buff.d_packet.c == 0x12) m_pnt->mon_dv_in_cnt++;
				else if (mon_buff.d_packet.c == 0x11) m_pnt->mon_dd_in_cnt++;
				memcpy (&m_pnt->rpt_save, &mon_buff, 29);
				m_pnt->rpt_save_length = 29;
				//rep_send (m_pnt);
				m_pnt->lost_cnt = 0;
				if (mon_buff.d_packet.trunk.FrameSeq & 0x40)
				{
					m_pnt->ZR_on = FALSE;
					m_pnt->ReplySW = TRUE;
				}
			}
		}
		else if (length == 32) // Last Frame ICOM
		{
			m_pnt = module_check_ex (mon_buff.d_packet.trunk.FrameID); 
			if (m_pnt)
			{
				if (mon_buff.d_packet.c == 0x12) m_pnt->mon_dv_in_cnt++;
				else if (mon_buff.d_packet.c == 0x11) m_pnt->mon_dd_in_cnt++;

                        	memcpy (&m_pnt->rpt_save, &mon_buff, 32);
                        	m_pnt->rpt_save_length = 32;
				//rep_send (m_pnt);
				m_pnt->rpt_save_length = 0;
				m_pnt->recv_time.tv_sec = 0;
				m_pnt->recv_time.tv_usec = 0;
				m_pnt->ZR_on = FALSE;
				m_pnt->ReplySW = TRUE;
			}
		}
		else
		{
			m_pnt = module_check_ex (mon_buff.d_packet.trunk.FrameID);
			if (m_pnt)
			{
				if (mon_buff.d_packet.c == 0x12) m_pnt->mon_dv_in_cnt++;
				else if (mon_buff.d_packet.c == 0x11) m_pnt->mon_dd_in_cnt++;
			}
		}
		if (forward_pnt)
		{
			mon_buff.d_packet.c |= ZR_ON;
			forward (mon_buff.d_packet, length);
		}
	}
	return TRUE;
}

int	xchange_init(void)
{
	struct	ifreq	ifr;
	time_t	atime;
	struct  addrinfo        hints;
	char	PORT[8];
	int	err;
	int	yes = 1;

	if ((ZR_NIC[0] != 0x00) && (mon_port > 0))
	{
    		// IPv4 UDP socket
		// monitor port
    		if((mon_in_sd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
		{
                	time(&atime);
                	fprintf (log_file, "%24.24s Zone Repeater socket(Monitor) not open\n", ctime(&atime));
        		return FALSE;	
    		}
                if (setsockopt (mon_in_sd, SOL_SOCKET, SO_REUSEADDR, (const char *)&yes, sizeof(yes)) < 0)
                {
                        time (&atime);
                        fprintf (log_file, "%24.24s Monitor socket (setsockopt) error\n", ctime(&atime));
                }

        	// 待ち受けるIPとポート番号を設定
        	rpt_mon_addr.sin_family = AF_INET;
        	rpt_mon_addr.sin_port = htons(mon_port);
        	rpt_mon_addr.sin_addr.s_addr = INADDR_ANY;

		memset (&ifr, 0x00, sizeof (struct ifreq)); 
		ifr.ifr_addr.sa_family = AF_INET;
		strncpy (ifr.ifr_name, ZR_NIC, strlen(ZR_NIC));
		time (&atime);
		if (ioctl (mon_in_sd, SIOCGIFADDR, &ifr) >= 0)
		{
			rpt_mon_addr.sin_addr.s_addr = 
				((struct sockaddr_in*)&ifr.ifr_addr)->sin_addr.s_addr;
			fprintf (log_file, "%24.24s NIC (%s) Zone Repeater Monitor Port %d open.\n", 
					ctime(&atime), ZR_NIC, mon_port);
			
		}
		else
		{
			fprintf (log_file, "%24.24s NIC (%s) not found\n", ctime(&atime), ZR_NIC);
		}
		fflush (log_file);
	
		FD_SET (mon_in_sd, &fd_save);

    		// Bind
    		if(bind(mon_in_sd, (struct sockaddr *)&rpt_mon_addr, sizeof(rpt_mon_addr)) < 0) {
			time(&atime);
			fprintf (log_file, "%24.24s Zone Repeater Monitor socket not bind %s\n", 
				ctime(&atime), strerror(errno));
        		return FALSE;
    		}
	}

/* ================ GW port ========================================= */

	if ((GW_NIC[0] != 0x00) && (gw_in_port > 0) && (gw_out_port > 0))
	{
        	if((gw_in_sd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
        	{
                	time(&atime);
                	fprintf (log_file, "%24.24s Gateway socket not open\n", ctime(&atime));
                	gw_in_port = 0;
                	return TRUE;
        	}
		if (setsockopt (gw_in_sd, SOL_SOCKET, SO_REUSEADDR, (const char *)&yes, sizeof(yes)) < 0)
		{
			time (&atime);
			fprintf (log_file, "%24.24s Gateway socket (setsockopt) error\n", ctime(&atime));
		}	

        	// watting port for GW
        	gw_in_addr.sin_family = AF_INET;
        	gw_in_addr.sin_port = htons(gw_in_port);
        	gw_in_addr.sin_addr.s_addr = INADDR_ANY;
                memset (&ifr, 0x00, sizeof (struct ifreq));
                ifr.ifr_addr.sa_family = AF_INET;
                strncpy (ifr.ifr_name, GW_NIC, strlen(GW_NIC));
                time (&atime);
                
                if (ioctl (gw_in_sd, SIOCGIFADDR, &ifr) >= 0)
                {
                        gw_in_addr.sin_addr.s_addr =
                                ((struct sockaddr_in*)&ifr.ifr_addr)->sin_addr.s_addr;
                        fprintf (log_file, "%24.24s NIC (%s) Gateway Port in(from dsgwd):%d out(to dsgwd):%d open.\n",
                                        ctime(&atime), GW_NIC, gw_in_port, gw_out_port);

                }
                else
                {
                        fprintf (log_file, "%24.24s NIC (%s) not found\n", ctime(&atime), GW_NIC);
                }


	        FD_SET (gw_in_sd, &fd_save);

        	// Bind
        	
        	if(bind(gw_in_sd, (struct sockaddr *)&gw_in_addr, sizeof(gw_in_addr)) < 0) {
                	time(&atime);
                	fprintf (log_file, "%24.24s Gateway socket not bind %s\n", ctime(&atime), strerror(errno));
                	gw_in_port = 0;
        	}

                if((gw_out_sd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
                {
                        time(&atime);
                        fprintf (log_file, "%24.24s Gateway socket not open\n", ctime(&atime));
                        gw_out_port = 0;
                        return TRUE;
                }

                memset (&hints, 0x00, sizeof(hints));
                hints.ai_socktype = SOCK_DGRAM;
                hints.ai_family = AF_INET;
                sprintf (PORT, "%d", gw_out_port);
                err = getaddrinfo (GW_ADDR, PORT, &hints, &gw_out_info);
		if (err != 0)
                {
                        fprintf (log_file, "%24.24s getaddrinfo error (GW OUT:%s:%0d) %s\n",
                                ctime(&atime), GW_ADDR, gw_out_port, gai_strerror(err));
                }

		fflush (log_file);
		
	}

/* ========== ZR repeater ================================================ */

	if ((ZR_NIC[0] != 0x00) && (zr_in_port > 0) && (zr_out_port > 0))
	{	
        	if((zr_in_sd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
        	{
                	time(&atime);
                	fprintf (log_file, "%24.24s Zone Repeater socket not open\n", ctime(&atime));
			zr_in_port = 0;
                	return TRUE;
        	}
                if (setsockopt (zr_in_sd, SOL_SOCKET, SO_REUSEADDR, (const char *)&yes, sizeof(yes)) < 0)
                {
                        time (&atime);
                        fprintf (log_file, "%24.24s  Zone Repeater socket (setsockopt) error\n", ctime(&atime));
                }

		fprintf (log_file, "%24.24s NIC (%s) Zone Repeater Port in(from ID-RP2C):%d out(to ID-RP2C):%d open.\n",
			ctime(&atime), ZR_NIC, zr_in_port, zr_out_port);
		fflush (log_file);

        	// waitting port for ZR
        	zr_in_addr.sin_family = AF_INET;
        	zr_in_addr.sin_port = htons(zr_in_port);
        	zr_in_addr.sin_addr.s_addr = INADDR_ANY;

                memset (&ifr, 0x00, sizeof (struct ifreq));
                ifr.ifr_addr.sa_family = AF_INET;
                strncpy (ifr.ifr_name, ZR_NIC, strlen(ZR_NIC));
                time (&atime);

                if (ioctl (zr_in_sd, SIOCGIFADDR, &ifr) >= 0)
                {
                        zr_in_addr.sin_addr.s_addr =
                                ((struct sockaddr_in*)&ifr.ifr_addr)->sin_addr.s_addr;
                }
                else
                {
                        fprintf (log_file, "%24.24s NIC (%s) not found\n", ctime(&atime), ZR_NIC);
                }

        	FD_SET (zr_in_sd, &fd_save);

        	// Bind
        	if(bind(zr_in_sd, (struct sockaddr *)&zr_in_addr, sizeof(zr_in_addr)) < 0) {
                	time(&atime);
                	fprintf (log_file, "%24.24s Zone Repeater socket not bind %s\n", ctime(&atime), strerror(errno));
                	zr_in_port = 0;
        	}

		memset (&hints, 0x00, sizeof(hints));
        	hints.ai_socktype = SOCK_DGRAM;
        	hints.ai_family = AF_INET;
        	sprintf (PORT, "%d", zr_in_port);
        	if ((err= getaddrinfo (ZR_ADDR, PORT, &hints, &zr_out_info)) != 0)
        	{
        		fprintf (log_file, "%24.24s getaddrinfo error (ZR OUT:%s:%0d) %s\n",
                		ctime(&atime), ZR_ADDR, zr_in_port, gai_strerror(err));
        	}

                if((zr_out_sd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
                {
                        time(&atime);
                        fprintf (log_file, "%24.24s ZR socket not open\n", ctime(&atime));
                        zr_out_port = 0;
                        return TRUE;
                }
                memset (&hints, 0x00, sizeof(hints));
                hints.ai_socktype = SOCK_DGRAM;
                hints.ai_family = AF_INET;
                sprintf (PORT, "%d", zr_out_port);
                if ((err= getaddrinfo (ZR_ADDR, PORT, &hints, &zr_out_info)) != 0)
                {
                        fprintf (log_file, "%24.24s getaddrinfo error (ZR OUT:%s:%0d) %s\n",
                                ctime(&atime), ZR_ADDR, zr_out_port, gai_strerror(err));
                }
	}	

/* ============================================================ */
	return TRUE;
}

