#include	"xchange.h"

void    module_init(struct ModuleTable *module, char Module[]);
void	forward_init (struct forward *fwd, char Fullname[], 
		int port, char mnemonic[], int gw_on, char gw_pkt_type);

int	read_config(int argc, char **argv)
{
	char	buff[256];
	char	*delmi = "=\n\r\t\0";
	char	*pnt;
	char	*p;
	int	len;
	int	n;
	int	k;
	int	gw_on_sw;
	char	gw_pkt_type;
	int	space_sw;
	char	Module[8];
	struct	ModuleTable	*module_next;
	int	field_sw;
	int	port;
	time_t	atime;
	int	false_ret;
	char	fqdn[128];
	struct	forward		*forward_next;
	char	mnemonic[16];

	FILE	*config_file;
	
	if (argc == 2)
	{
		config_file = fopen (argv[1], "r");
		if (!config_file)
		{
			time(&atime);
			fprintf (log_file, "%24.24s config file not found (%s)\n", ctime(&atime), argv[1]);
			fflush (log_file);
			return FALSE;
		}
	} 
	else
	{
		config_file = fopen (CONFIG_FILE,"r");
		if (!config_file)
		{
			time(&atime);
			fprintf (log_file, "%24.24s config file not found (%s)\n", 
						ctime(&atime), CONFIG_FILE);
			fflush (log_file);
			return FALSE;
		}
	}

	while (fgets (buff, 255, config_file))
	{
		if (buff[0] != '#')
		{
			n = 0;
			while (buff[n] == 0x20) n++;
			p = strtok(&buff[n], delmi);
			if (p != NULL)
			{
				pnt = strtok(NULL, delmi);
	
				if (!memcmp (p, "MON_PORT", 8))
				{
					mon_port = atoi (pnt);
				}
                                else if (!memcmp (p, "ZR_OUT_PORT", 11))
                                {
                                        zr_out_port = atoi(pnt);
                                }
				else if (!memcmp (p, "ZR_IN_PORT", 10))
				{
					zr_in_port = atoi(pnt);
				}
				else if (!memcmp (p, "ZR_ADDR", 7))
				{
					memset (ZR_ADDR, 0x00, 128);
					memcpy (ZR_ADDR, pnt, strlen(pnt));
				}
                                else if (!memcmp (p, "ZR_NIC", 6))
                                {
                                        memset (ZR_NIC, 0x00, 16);
                                        memcpy (ZR_NIC, pnt, strlen(pnt));
                                }
                                else if (!memcmp (p, "ZR_ETHIFNAME", 12))
                                {
                                        memset (ZR_NIC, 0x00, 16);
                                        memcpy (ZR_NIC, pnt, strlen(pnt));
                                }
                                else if (!memcmp (p, "GW_NIC", 6))
                                {
                                        memset (GW_NIC, 0x00, 16);
                                        memcpy (GW_NIC, pnt, strlen(pnt));
                                }
				else if (!memcmp (p, "GW_ETHIFNAME", 12))
				{
					memset (GW_NIC, 0x00, 16);
					memcpy (GW_NIC, pnt, strlen(pnt));
				}
                                else if (!memcmp (p, "GW_IN_PORT", 10))
                                {
                                        gw_in_port = atoi(pnt);
                                }
				else if (!memcmp (p, "GW_OUT_PORT", 11))
				{
					gw_out_port = atoi (pnt);
				}
				else if (!memcmp (p, "GW_ADDR", 7))
				{
					memset (GW_ADDR, 0x00, 128);
					memcpy (GW_ADDR, pnt, strlen(pnt));
				}
				else if (!memcmp (p, "CALLSIGN", 8))
				{
					memset (zr_callsign, 0x20, 8);
					len = strlen(pnt);
					if (len > 7) len = 7;
					memcpy (zr_callsign, pnt, len);
				}
				else if (!memcmp (p, "DEBUG", 5))
				{
					debug_sw = atoi(pnt);
				}
				else if (!memcmp (p, "FORWARD", 7))
				{
                                        n = 0;
					k = 0;
                                        field_sw = 0;
                                        port = 0;
					gw_on_sw = 0;
					gw_pkt_type = 0x00;
                                        memset (fqdn, 0x20, 128);
					memset (mnemonic, 0x20, 16);
                                        while (*pnt)
                                        {
                                                if (*pnt != ',')
                                                {
                                                        if (field_sw == 1)
                                                        {
								if (*pnt == ':') field_sw = 2;
                                                                if (isdigit(*pnt)) port = port * 10 + *pnt - '0';
                                                        }
							else if (field_sw == 2)
							{
								mnemonic[k++] = *pnt;
								if (k > 16) break;
							}
                                                        else if (field_sw == 0)
                                                        {
                                                                if (*pnt == ':') field_sw = 1;
                                                                else
								{
									if (*pnt != 0x20) fqdn[n++] = *pnt;
									if (n > 127) n = 127;
								}
                                                        }
                                                }
                                                else
                                                {
                                                        forward_next = malloc (sizeof (struct forward));
                                                        if (forward_next != NULL)
                                                        {
								fqdn[n] = 0x00;
                                                                forward_init(forward_next, fqdn, port, mnemonic, 
											gw_on_sw, gw_pkt_type);
                                                                if (forward_pnt) forward_last->f_chain = forward_next;
                                                                else forward_pnt = forward_next;
                                                                forward_last = forward_next;
                                                                port = 0;
                                                                n = 0;
                                                                field_sw = 0;
								gw_on_sw = 0;
                                                        }
                                                        else
                                                        {
                                                                time(&atime);
                                                                fprintf (log_file, "%24.24s Memoty not allocate (FORWARD)\n", ctime(&atime));
                                                                fflush (log_file);
                                                        }
                                                }
                                                pnt++;
                                        }
                                        if (n)
                                        {
						fqdn[n] = 0x00;
                                                forward_next = malloc (sizeof (struct forward));
                                                forward_init(forward_next, fqdn, port, mnemonic, gw_on_sw, gw_pkt_type);
                                                if (forward_pnt) forward_last->f_chain = forward_next;
                                                else forward_pnt = forward_next;
                                                forward_last = forward_next;
                                        }
				}
				else if (!memcmp (p, "MODULE_NAME", 11))
				{
					n = 0;
					field_sw = 0;
					space_sw = 0;
					port = 0;
					memset (Module, 0x20, 8);
					while (*pnt)
					{
						if (*pnt != ',')
						{
							if (n < 8) 
							{
								if (n == 0)
								{
									if (*pnt != 0x20) Module[n++] = *pnt;
								}
								else
								{
									if (*pnt == 0x20) space_sw = 1;
									if (space_sw)
									{
										if (*pnt != 0x20)
										{
											Module[7] = *pnt;
										}
									}
									else
									{
										Module[n++] = *pnt;
									}
								}
							}
						}
						else
						{
							if (memcmp (Module, "XX0XXX", 6))
							{
								module_next = malloc (sizeof (struct ModuleTable));
								if (module_next != NULL)
								{
									module_init(module_next, Module);

									if (module_pnt) module_last->f_chain = module_next;
									else module_pnt = module_next;
									module_last = module_next;
								}
								else
								{
									time(&atime);
									fprintf (log_file, "%24.24s Memoty not allocate Module table (%s)\n", ctime(&atime), Module);
									fflush (log_file); 
								}
							}
							else
							{
								time (&atime);
								fprintf (log_file, "%24.24s Skip the invalide Module name (XX0XXX)\n", ctime(&atime));
								fflush (log_file);
							}
							n = 0;
							space_sw = 0;
							module_ctrl_set (Module);
							memset (Module, 0x20, 8);
							gw_on_sw = 0;
						}
						pnt++;	
					}
					if (n)
					{
						if (memcmp (Module, "XX0XXX", 6))
						{
                                                	module_next = malloc (sizeof (struct ModuleTable));
							module_init(module_next, Module);
                                                	if (module_pnt) module_last->f_chain = module_next;
                                                	else module_pnt = module_next;
                                                	module_last = module_next;
							module_ctrl_set (Module);
						}
						else
						{
							time (&atime);
							fprintf (log_file, "%24.24s Skip the invalide Module name (XX0XXX)\n", ctime(&atime));
							fflush (log_file);
						}
					}
				}
				else if (!memcmp (p, "HTTP_PORT", 9))
				{
					http_port = atoi (pnt);
				}
				else if (!memcmp (p, "UPNP", 4))
				{
					upnp_auto = atoi (pnt);
				}
				else
				{
					time (&atime);
					fprintf (log_file, "%24.24s Error on config file : %s\n",ctime(&atime), buff);
					fflush (log_file);
				}
			}
		}
	}

	fclose (config_file);

	false_ret = FALSE;
	time (&atime);
	if (module_pnt == NULL)
	{
		fprintf (log_file, "%24.24s Repeater Module name not assign.\n", ctime(&atime));
		false_ret = TRUE;
		fflush (log_file);
	}

	if (mon_port <= 0)
	{
		fprintf (log_file, "%24.24s Zone Repeater Monitor port not assign.\n", ctime(&atime));
		fflush (log_file);
	}

	if (!memcmp (zr_callsign, "XX0XXX", 6))
	{
		fprintf (log_file, "%24.24s CALLSIGN not define.\n", ctime(&atime));
		false_ret = TRUE;
		fflush (log_file);
	} 
	if (false_ret) return FALSE;
	return TRUE;
}

