#include	"xchange.h"


void	portSet(void)
{
	struct	addrinfo	hints;
	struct	forward		*fwd_pnt;
	int	err;
	int	yes = 1;
	char	PORT[10];

	time_t	atime;

        // forward
        if (forward_pnt)
        {
		fwd_pnt = forward_pnt;
		time (&atime);
		while (fwd_pnt)
		{
			memset (&hints, 0x00, sizeof(hints));
			hints.ai_socktype = SOCK_DGRAM;
			hints.ai_family = AF_INET;
			sprintf (PORT, "%d", fwd_pnt->port);
			if ((err = getaddrinfo (fwd_pnt->fqdn, PORT, &hints, &fwd_pnt->fwd_info)) != 0)
			{
				fprintf (log_file, "%24.24s getaddrinfo error (Forward:%s:%0d) %s\n", 
					ctime(&atime), fwd_pnt->fqdn, fwd_pnt->port, gai_strerror(err));
				fwd_pnt->port = 0;
			}
			else
			{
                        	if((fwd_pnt->fwd_sd = socket(fwd_pnt->fwd_info->ai_family, 
					fwd_pnt->fwd_info->ai_socktype, fwd_pnt->fwd_info->ai_protocol)) < 0)
				{
                                	fprintf (log_file, "%24.24s Forward UDP socket not open (%s)\n",
                                                                ctime(&atime), fwd_pnt->fqdn);
                               		fwd_pnt->port = 0;
					freeaddrinfo (fwd_pnt->fwd_info);
                        	}
				else
				{
					fprintf (log_file, "%24.24s Forward Port %s:%0d open.\n", 
						ctime(&atime), fwd_pnt->fqdn, fwd_pnt->port);
					FD_SET (fwd_pnt->fwd_sd, &fd_save);
				}
                	}
			fwd_pnt = fwd_pnt->f_chain;
			fflush (log_file);
		}
        }

//	httpd
        if (http_port > 0)
        {
                memset (&hints, 0x00, sizeof(hints));
                hints.ai_socktype = SOCK_STREAM;
                hints.ai_family = PF_INET;
                hints.ai_flags = AI_PASSIVE;
                sprintf (PORT, "%d", http_port);
                if ((err = getaddrinfo (NULL, PORT, &hints, &http_serv)) != 0)
                {
                        fprintf (log_file, "%24.24s getaddrinfo error (http port:%d) %s\n",
                                ctime(&atime), http_port, gai_strerror(err));
                        http_port = 0;
                        fflush (log_file);
                }
                else
                {
                        if ((http_sd = socket (http_serv->ai_family, http_serv->ai_socktype, http_serv->ai_protocol)) < 0)
                        {
                                time(&atime);
                                fprintf (log_file, "%24.24s HTTP TCP Socket not open. Already used this port:%d\n", ctime(&atime), http_port);
                                fflush (log_file);
                                http_port = 0;
                                freeaddrinfo (http_serv);
				close (http_sd);
				http_sd = 0;
			}
                        else
                        {
                                if (setsockopt (http_sd, SOL_SOCKET, SO_REUSEADDR, (const char *)&yes, sizeof(yes)))
                                {
                                        time(&atime);
                                        fprintf (log_file, "%24.24s error setsock opt on HTTP_PORT\n", ctime(&atime));
                                        fflush (log_file);
                                        http_port = 0;
                                        freeaddrinfo (http_serv);
                                        close (http_sd);
                                        http_sd = 0;
                                }
                                else
                                {
                                        if (bind (http_sd, http_serv->ai_addr, http_serv->ai_addrlen) != 0)
                                        {
                                                time (&atime);
                                                fprintf (log_file, "%24.24s error bind on HTTP_PORT %s\n", ctime(&atime), strerror(errno));
                                                fflush (log_file);
                                                http_port = 0;
                                        }
                                        else
                                        {
                                                if (listen (http_sd, 5))
                                                {
                                                        time (&atime);
                                                        fprintf (log_file, "%24.24s error listen on HTTP_PORT %s\n",
                                                                                ctime(&atime), strerror(errno));
                                                        http_port = 0;
                                                        freeaddrinfo (http_serv);
                                                        fflush (log_file);
                                                }
                                                else
                                                {
                                                        FD_SET (http_sd, &fd_save);
                                                        fprintf (log_file, "%24.24s HTTP Port %d open.\n",
                                                                        ctime(&atime), http_port);
                                                        fflush (log_file);
                                                }
                                        }
                                }
			}
		}
		/* upnp upd */
		if (upnp_sw)
		{
			if (!getOwnIp()) return;
        		memset (&hints, 0x00, sizeof(hints));
        		hints.ai_socktype = SOCK_DGRAM;
        		hints.ai_family = PF_INET;
                	if ((err = getaddrinfo (inet_ntoa (OwnIP), NULL, &hints, &upnp_bind_sock)) != 0)
                	{
                        	time (&cur_time);
                        	fprintf (log_file, "%24.24s getaddrinfo error(upnp bind sock) %s\n",
                                	ctime(&cur_time), gai_strerror(err));
                        	fprintf (log_file, "%24.24s upnp : %s\n", ctime(&cur_time), inet_ntoa (OwnIP));
                        	fflush (log_file);
                	}
                	if((upnp_udp_sd = socket(upnp_bind_sock->ai_family, upnp_bind_sock->ai_socktype, upnp_bind_sock->ai_protocol)) < 0)
                	{
                        	fprintf (log_file, "%24.24s socket error in upnp bind sock %s\n",
                                	ctime(&cur_time), strerror(errno));
                        	fflush (log_file);
                        	return;
                	}

			if (bind (upnp_udp_sd, upnp_bind_sock->ai_addr, upnp_bind_sock->ai_addrlen) == -1)
			{
				fprintf (log_file, "%24.24s socket error in upnp bind %s\n",
					ctime(&cur_time), strerror(errno));
				fflush (log_file);
				return;
			}

			memset (&hints, 0x00, sizeof(hints));
			hints.ai_socktype = SOCK_DGRAM;
			hints.ai_family = PF_INET;
		
        		if ((err = getaddrinfo ("239.255.255.250", "1900", &hints, &upnp_sock)) != 0)
        		{
                		time (&cur_time);
                		fprintf (log_file, "%24.24s getaddrinfo error(upnp sock) %s\n",
                        		ctime(&cur_time), gai_strerror(err));
                		fprintf (log_file, "%24.24s upnp : 239.255.255.250\n", ctime(&cur_time));
                		fflush (log_file);
        		}
        		FD_SET (upnp_udp_sd, &fd_save);
		}

       
		if (http_port)
		{
			gt = malloc (sizeof (struct tm));
			cpu_fd = open ("/proc/stat", O_RDONLY);
		}
	}
}

