#include	"init.h"
#include	"xchange.h"
#include	"config.h"

void	pselectSet(void);
void	portSet(void);
void    lost_frame(void);
void    forward_recv (struct forward *fwd_pnt);
void	forward_keep_alive (void);
void    xchange_gw(void);
int     xchange_zr(void);
int	xchange_mon(void);
int     xchange_init(void);
int     read_config(int argc, char **argv);
int     handler_init(void);
void	gw_send_check(void);
void	httpd_srv_accept(void);
void	httpd_srv_recv (int i);

extern	void	handler(int sig);

time_t			start_time;


struct	sockaddr_in	in_sock;
socklen_t		len_in_sock;

int main(int argc, char** argv)
{

	int	ret;
	int	i;

	struct	forward	*fwd_pnt;

	time_t	atime;
	time_t	uptime;

	tzset();

        uname(&uname_buf);

	gettimeofday (&tm0, NULL);
	srand (tm0.tv_sec);

	log_file = fopen (LOG_FILE, "a");
	if (log_file == NULL)
	{
		return 1;
	}
	time (&start_time);

	fprintf (log_file, "%24.24s D-STAR X-change (xchange) with ID-RP2C & dsgwd V%5.5s (%s  %s) Start\n", 
			ctime(&start_time), PACKAGE_VERSION, __DATE__, __TIME__);
	fprintf (log_file, "                         %s %s %s\n",
			uname_buf.sysname, uname_buf.release, uname_buf.version);
	fflush (log_file);

	pid_file = fopen(PID_FILE, "r");
	if (pid_file == NULL)
	{
		pid_file = fopen(PID_FILE, "w");
	}
	else
	{
		fprintf (log_file, "%24.24s Already running xchange.\n", ctime(&atime));
		fclose (log_file);
		return -1;
	}
	fprintf (pid_file, "%d", getpid());
	fclose (pid_file); 

	/* default value */
	mon_port = RECV_PORT;
	reload = FALSE;
	sig_term = FALSE;
	debug_sw = FALSE;

	module_pnt = NULL;

	block_pnt = NULL;

	forward_pnt = NULL;

	memset (trust_server, 0x00, sizeof(trust_server));
	memcpy (trust_server, TRUST_SERVER, sizeof(TRUST_SERVER));
	trust_port = TRUST_PORT;
	zr_out_port = 20000;
	zr_in_port = 20000;
	memcpy (ZR_ADDR, "172.16.0.1\0", 11);
	mon_port = 0;
	gw_out_port = 0;
	gw_in_port = 0;

        Rp = malloc (sizeof (struct FifoPkt) - 1024);
        Wp = Rp;
        Rp->next = NULL;
	gw_reply_recv = FALSE;
	gw_Fifo_cnt = 0;

	zr_Rp = malloc (sizeof (struct FifoPkt) - 1024);
        zr_Wp = zr_Rp;
        zr_Rp->next = NULL;
        zr_reply_recv = FALSE;
        zr_Fifo_cnt = 0;

	mon_in_sd = 0;
	gw_in_sd = 0;
	gw_out_sd = 0;
	zr_in_sd = 0;
	zr_out_sd = 0;

	upnp_sw = FALSE;
	upnp_auto = FALSE;

	zr_in_cnt = 0;
	zr_out_cnt = 0;
	gw_in_cnt = 0;
	gw_out_cnt = 0;
	mon_in_cnt = 0;
	zr_posit_in_cnt = 0;
	memset (ZR_NIC, 0x00, 16);
	memset (GW_NIC, 0x00, 16);

	http_port = 0;

	if (!handler_init()) goto end;

	if (!read_config (argc, (char **)argv)) goto end;
	dsgwd_conf_read();

	time (&atime);
	if (debug_sw)
	{
		fprintf (log_file, "%24.24s Word Size : %d\n", ctime(&atime), __WORDSIZE);
		fflush (log_file);
	}

	pselectSet();	// FD & sig init

	if (!xchange_init()) goto end;

	getOwnIp();
	portSet();

	time (&keep_alive_time);

	gateway_init();

	upnp_send_time = 0;

	trust_init();
	send_dscsd();
	
	while (1)
	{
		memcpy (&read_set, &fd_save, sizeof(fd_set));
		memcpy (&sigset, &save_sig, sizeof(save_sig));
		ret = pselect (FD_SETSIZE, &read_set, (fd_set *)NULL, 
				(fd_set *)NULL, &timeout, &sigset);
		time (&atime);
		if (ret < 0) 
		{
                	fprintf (log_file, "%24.24s pselect error %s\n", ctime(&atime), strerror(errno));
                	fflush (log_file);
			break;
		}
		else if (ret > 0)
		{
                	if (FD_ISSET (mon_in_sd, &read_set))
                	{
                        	if (!xchange_mon()) break;
                	}
			
			if (FD_ISSET (gw_in_sd, &read_set))
			{
				xchange_gw();
			}

			if (FD_ISSET (zr_in_sd, &read_set))
			{
				xchange_zr();
			}
			if (FD_ISSET (http_sd, &read_set)) 
			{
				httpd_srv_accept();
			}
                        if (upnp_sw)
                        {
				if (FD_ISSET (upnp_udp_sd, &read_set))
                                {
                                	read_upnp_udp();
                                }
                                if ((upnp_http_sd > 0) && FD_ISSET (upnp_http_sd, &read_set))
                                {
                                	read_upnp_http();
                                }
			}


			fwd_pnt = forward_pnt;
			while (fwd_pnt)
			{
				if ((fwd_pnt->fwd_sd > 0) && FD_ISSET(fwd_pnt->fwd_sd, &read_set))
								forward_recv (fwd_pnt);
				fwd_pnt = fwd_pnt->f_chain;
			}
			if (http_port)
			{
				for (i = 0 ; i < FD_SETSIZE ; i++)
				{
					if ((i == mon_in_sd)
						|| (i == gw_in_sd)
						|| (i == zr_in_sd)
						|| (i == upnp_udp_sd)
						|| (i == upnp_http_sd)
						|| (i == http_sd)) goto skip;
					fwd_pnt = forward_pnt;
					while (fwd_pnt)
					{
						if (i == fwd_pnt->fwd_sd) goto skip;
						fwd_pnt = fwd_pnt->f_chain;
					}
					if (FD_ISSET (i, &read_set)) httpd_srv_recv (i);
					skip: continue;
				}
			}
		}
		else
		{
			lost_frame();
		}

		gw_send_check();
		zr_send_check();
		if (upnp_sw) upnp();

		if ((atime - keep_alive_time) >= 10) 
		{
			forward_keep_alive();
		}
		if ((atime - upnp_send_time) >= 60)
		{
			if (upnp_sw) upnp_msearch_set();
		}
		if ((atime - dscsd_send_time) >= 300)
		{
			send_dscsd();
		}

		if (sig_term) break;
	}

	// socket close
	if (mon_in_sd) close (mon_in_sd);
	if (gw_in_sd) close (gw_in_sd);
	if (gw_out_sd) close (gw_out_sd);
	if (zr_in_sd) close (zr_in_sd);
	if (zr_out_sd) close (zr_out_sd);
end:
	time(&atime);
	uptime = atime - start_time;
	fprintf (log_file, "%24.24s D-STAR X-change (xchange) ID-RP2C Interface terminated (Up : %ldd%2ldh%2ldm%2lds)\n\n",
			ctime(&atime), 
			(uptime / 86400),
			((uptime % 86400) / 3600),
			(((uptime % 86400) % 3600) / 60),
			(((uptime % 86400) % 3600) % 60));
	fclose (log_file);
	if (forward_pnt)
	{
		fwd_pnt = forward_pnt;
		while (fwd_pnt)
		{
		 	close (fwd_pnt->fwd_sd);
			fwd_pnt = fwd_pnt->f_chain;
		}
	}
	if (http_port)
	{
		close (http_sd);
		close (cpu_fd);
	}
	remove (PID_FILE);
    	return 0;
}

