#include	"xchange.h"

struct	ModuleTable	*module_check (unsigned char call[]);
struct	ModuleTable	*module_check_ex (unsigned char FrameID[]);
void	block_SetReset (char temp[]);

union
{
        struct  dstar_packet    d_packet;
        char    fwd_buffer[1024];
}       fwd_buff;

void    send_forward_reply (char pkt[], struct forward *fwd_pnt)
{
        char    forward_reply[10];
        int     err;
        time_t  atime;

        memset (forward_reply, 0x00, 10);
        memcpy (forward_reply, pkt, 6);
        forward_reply[6] = 'r';

        err = sendto (fwd_pnt->fwd_sd, forward_reply, 10, 0,
		fwd_pnt->fwd_info->ai_addr, fwd_pnt->fwd_info->ai_addrlen);
        if (err == -1)
        {
                time (&atime);
                fprintf (log_file, "%24.24s sendto (forward reply) error:%s\n",
                        ctime(&atime), strerror(errno));
                fflush (log_file);
        }
	
}

void	forward_recv (struct forward	*fwd_pnt)
{
	socklen_t	from_len;
	int		length;
	int		sock;
	struct	forward	*pnt;
	struct	sockaddr_storage from;
	int	send_seq_save;
	unsigned char	command;

	sock = fwd_pnt->fwd_sd;
	from_len = sizeof (struct sockaddr_storage);

	length = recvfrom (sock, &fwd_buff, sizeof(fwd_buff),
			0, (struct sockaddr *)&from, &from_len);
        if (length < 10) return;
        if (memcmp (fwd_buff.fwd_buffer, "DSTR", 4)) return;
	time(&fwd_pnt->alive_time);

        if (fwd_buff.fwd_buffer[6] == 's')
	{
		fwd_pnt->in_packets++;
		fwd_pnt->alive = TRUE;
		send_forward_reply ((char *)&fwd_buff, fwd_pnt);
		if ((length == 20) && (fwd_buff.fwd_buffer[7] == 0x08))		/* gw block set/reset */
		{
			block_SetReset ((char *)&fwd_buff);
			return;
		}
		command = fwd_buff.fwd_buffer[7];
		fwd_buff.fwd_buffer[7] &= 0x33;
		if (command & ZR_ON) put_zr_Fifo (length, &fwd_buff);
		if (command & GW_ON) putFifo (length, &fwd_buff);
		if (command & FWD_ON)
		{
			pnt = forward_pnt;
			fwd_buff.fwd_buffer[7] = command;
			fwd_buff.fwd_buffer[7] |= FWD_ON;		/* xxxx x1xx */
			while (pnt)
			{
				if (pnt != fwd_pnt)
				{
               				fwd_buff.fwd_buffer[4] = (pnt->send_seq >> 8) & 0xff;
               				fwd_buff.fwd_buffer[5] = pnt->send_seq & 0xff;
					sendto (pnt->fwd_sd, &fwd_buff, length, 0, 
						pnt->fwd_info->ai_addr, pnt->fwd_info->ai_addrlen);
					if (pnt->alive) pnt->out_packets++;
				}
				pnt = pnt->f_chain;
			}
		}
	}
        else if (fwd_buff.fwd_buffer[6] == 'r')
        {
                send_seq_save = fwd_pnt->send_seq;
                fwd_pnt->send_seq = ((fwd_buff.fwd_buffer[4] & 0xff) << 8) | (fwd_buff.fwd_buffer[5] & 0xff);
                if (send_seq_save == fwd_pnt->send_seq)
                {
                        fwd_pnt->send_seq++;
                }
                fwd_pnt->send_seq &= 0xffff;
        }
}

void	forward (struct dstar_packet ds_pkt, int length)
{
	time_t	atime;
	int	ret;
	struct	forward		*fwd_pnt;

	fwd_pnt = forward_pnt;
	while (fwd_pnt)
	{
		if (fwd_pnt->port)
		{
                       	ds_pkt.m[0] = (fwd_pnt->send_seq >> 8) & 0xff;
                       	ds_pkt.m[1] = fwd_pnt->send_seq & 0xff;
			ret = sendto (fwd_pnt->fwd_sd, &ds_pkt, length, 0,
				fwd_pnt->fwd_info->ai_addr, fwd_pnt->fwd_info->ai_addrlen);
			if (ret < 0)
			{
				time (&atime);
				fprintf (log_file, "%24.24s forward send error %s\n", ctime(&atime), strerror(errno));
				fflush (log_file);
				FD_CLR (fwd_pnt->fwd_sd, &fd_save);
				close (fwd_pnt->fwd_sd);
				fwd_pnt->fwd_sd = 0;
				fwd_pnt->port = 0;
			}
			else
				if (fwd_pnt->alive) fwd_pnt->out_packets++;
		}
		fwd_pnt = fwd_pnt->f_chain;
	}
}
