#include	"rpt_conn.h"

void	rig_write (int length, char buff[]);
int	getFifo (char pkt[]);
void	LastFrameSend (void);
void	rig_led_onoff(void);
void	inet_led_onoff(void);
void	buff_hold_size_write (int n);
void	dummy_last_frame (void);
void	jitter_putFifo (void);
int	send_dest_keep_alive(void);
int     node_usb_init(void);

extern	char	dummy_frame_1[12];
extern	char	dummy_frame_2[12];
extern	char	dummy_frame_3[12];

int	rig_open(void)
{
        struct termios attr;
	int	wrt_len;

	if (rig_type == NODE)
	{
		return node_usb_init();
	}
        rig_fd = open(rig_device, O_RDWR | O_NOCTTY | O_NONBLOCK | O_SYNC);
        if (rig_fd < 0) 
	{
		if (rig_type == ICOM) syslog (LOG_ERR, "USB open error on ICOM rig");
		else if (rig_type == DVAP) syslog (LOG_ERR, "USB open error on DVAP");
		else if (rig_type == DVMEGA) syslog (LOG_ERR, "USB open error on DVMEGA");
                return FALSE;
        }

        tcgetattr(rig_fd, &attr);
        save_attr = attr;

	bzero (&attr, sizeof(attr));
	if (rig_type == ICOM)
	{
        	cfsetispeed(&attr, IDxxPlus_SPEED);
        	cfsetospeed(&attr, IDxxPlus_SPEED);
	}
	else if (rig_type == DVMEGA)
	{
		cfsetispeed(&attr, DVMEGA_SPEED);
		cfsetospeed(&attr, DVMEGA_SPEED);
	}
	else if (rig_type == DVAP)
	{
		cfsetispeed(&attr, DVAP_SPEED);
		cfsetospeed(&attr, DVAP_SPEED);
	}
        cfmakeraw(&attr);
        attr.c_cflag |= CS8 | CLOCAL | CREAD;
        attr.c_iflag = IGNPAR;
        attr.c_oflag = 0;
        attr.c_lflag = 0;
        attr.c_cc[VMIN] = 0;
        attr.c_cc[VTIME] = 0;

        tcsetattr(rig_fd, TCSANOW, &attr);
	ioctl (rig_fd, TCSETS, &attr);

	FD_SET (rig_fd, &fd_save);
	return TRUE;
}

void	rig_close (void)
{
	int	ret;

	tcsetattr (rig_fd, TCSANOW, &save_attr);
	if (rig_type != NODE)
	{
		ret = close (rig_fd);
		FD_CLR (rig_fd, &fd_save);
		rig_fd = 0;
	}
	if (rig_type == ICOM)
	{
		syslog (LOG_INFO, "RIG(ICOM) close.");
	}
	else if (rig_type == DVMEGA)
	{
		syslog (LOG_INFO, "RIG(DVMEGA) close.");
	}
	else if (rig_type == DVAP)
	{
		syslog (LOG_INFO, "DVAP close.");
	}
}

void    pselectSet(void)
{
        FD_ZERO (&fd_save);
        timeout.tv_sec = 0;
        timeout.tv_nsec = 10000000;
}

void    handler (int sig)
{
	sig_term = FALSE;
        if (sig == SIGINT)  sig_term = TRUE;
	else if (sig == SIGTERM) sig_term = TRUE;
	//syslog (LOG_INFO, "signal %d", sig);
}

int     handler_init(void)
{
	sigemptyset (&save_sig);
	sigaddset (&save_sig, SIGUSR1);
	sigaddset (&save_sig, SIGUSR2);
	sigaddset (&save_sig, SIGINT);
	sigaddset (&save_sig, SIGPIPE);
	sigaddset (&save_sig, SIGHUP);
	sigaddset (&save_sig, SIGTERM);

	if (signal(SIGUSR1, handler) == SIG_ERR)
	{
		syslog (LOG_ERR, "signal (SIGUSR1) error");
		return FALSE;
	}	
        if (signal(SIGUSR2, handler) == SIG_ERR)
        {
                syslog (LOG_ERR, "signal (SIGUSR2) error");
                return FALSE;
        }
        if (signal(SIGINT, handler) == SIG_ERR)
        {
		syslog (LOG_ERR, "signal (SIGINT) error");
                return FALSE;
        }
        if (signal(SIGHUP, handler) == SIG_ERR)
        {
                syslog (LOG_ERR, "signal (SIGEPIPE) error");
                return FALSE;
        }
        if (signal(SIGQUIT, handler) == SIG_ERR)
        {
                syslog (LOG_ERR, "signal (SIGQUIT) error");
                return FALSE;
        }
	if (signal(SIGPIPE, handler) == SIG_ERR)
	{
		syslog (LOG_ERR, "signal (SIGPIPE) error");
		return FALSE;
	}
        if (signal(SIGTERM, handler) == SIG_ERR)
        {
                syslog (LOG_ERR, "signal (SIGTERM) error");
                return FALSE;
        }
        return TRUE;
}

