#include "rpt_conn.h"

void	handler (void);
int     handler_init(void);
void    pselectSet(void);
void	rig(void);

void	rig_close (void);

void	dmonitor_close(void);
void	dvap_conf(void);
void	dvap_read(void);
void    wait_disconnect (void);
void	rig_reset (void);
void	dvap_reset(void);
void	send_msg (char msg[], char my2[], unsigned char flag);
void	dvmega_read (void);
void	dvmega_conf (void);
void	node_conf (void);
int	rpt_conn_scan (void);
void	node_close (void);
void    lcd_init (void);
void    lcdPosition (int handle, int x, int y);
void    lcd_write (void);
int	rig_status_check(void);
int	dvap_status_check(void);
int	dvmega_status_check (void);

int     ja_check (unsigned char callsign[])
{
        /* JA-JS,7J-7N,8J-8N */
        if (callsign[7] == 'S') return FALSE;
        if ((callsign[7] == ' ') || ((callsign[7] >= 'A') && (callsign[7] <= 'Z')))
        {
                if (memcmp (callsign, "JA", 2) >= 0  && memcmp (callsign, "JS", 2) <= 0) return TRUE;
                if (memcmp (callsign, "7J", 2) >= 0  && memcmp (callsign, "7N", 2) <= 0) return TRUE;
                if (memcmp (callsign, "8J", 2) >= 0  && memcmp (callsign, "8N", 2) <= 0) return TRUE;
        }
        return FALSE;
}

char	status[6] = {' ', 1, 2, 3, 2, 1};

void	main(void)
{
	int	n;
	time_t	cur_time;
	int	ret;
	int	ret_code;
	char    *bf;
	char	temp[128];

	FILE	*pid_file;
	FILE	*dmonitor_file;
	FILE	*conn_fd;
	FILE	*connCall_fd;

	openlog ("rpt_conn", LOG_CONS | LOG_PID, LOG_LOCAL1);
	syslog (LOG_INFO, "rpt_conn start V%s (Compiled %s %s)\n", 
		PACKAGE_VERSION, __DATE__, __TIME__);

	pid_file = fopen(PID_FILE,"r");
	if(pid_file == NULL)
	{
		pid_file = fopen(PID_FILE,"w");
	}
	else
	{
		syslog (LOG_ERR, "Already running rpt_conn");
		closelog();
		fclose (pid_file);
		return;
	}
	fprintf	(pid_file,"%d",	getpid());
	fclose	(pid_file);

	dmonitor_file = fopen (DMONITOR_FILE, "r");
	if (dmonitor_file == NULL)
	{
		rig_type = ICOM;
		lcd_type = NONE;
	}
	else
	{
		if (fgets (recvBuff, sizeof (recvBuff), dmonitor_file))
		{
			if (!memcmp (recvBuff, "DVAP", 4)) rig_type = DVAP;
			else if (!memcmp (recvBuff, "DVMEGA", 6)) rig_type = DVMEGA;
			else if (!memcmp (recvBuff, "ICOM", 4)) rig_type = ICOM;
			else if (!memcmp (recvBuff, "NODE", 4)) rig_type = NODE;
                	if (fgets (recvBuff, sizeof (recvBuff), dmonitor_file))
                	{
                        	if (!memcmp (recvBuff, "NONE", 4)) lcd_type = NONE;
                        	else if (!memcmp (recvBuff, "G20x4", 5)) lcd_type = LCD_20x4;
                        	else if (!memcmp (recvBuff, "G16x2", 5)) lcd_type = LCD_16x2;
				fgets (ConnectCall, sizeof (ConnectCall), dmonitor_file);
                	}
		}
		fclose (dmonitor_file);
	}

	if (!ja_check (ConnectCall)) 
	{
		syslog (LOG_INFO, "Connect Callsign is wrong. %8.8s", ConnectCall);
		goto end;
	}

	sig_term = FALSE;
	reboot_sw = FALSE;
	shutdown_sw = FALSE;
	handler_init();
	pselectSet();
	ScanTable_top = NULL;
	ScanTable_last = NULL;
	ScanTable_pnt = NULL;
	wiringPiSetupGpio();
	if (lcd_type != NONE) lcd_init();
	lcd_time_save = 0;
	first_time = TRUE;
loop:
        node_VenderID = 0x4d8;
        node_ProductID = 0x300;
        HeaderLength = 0;
        voice_pnt = 0;
        node_tx_inv = 0;
        node_rx_inv = 0;
	scan_sw = FALSE;
	send_msg_sw = FALSE;
	memset (connect_call, 0x00, 8);
	memset (rig_device, 0x00, sizeof(rig_device));
	memcpy (rig_device, RIG_DEVICE, strlen(RIG_DEVICE));
	if (rig_type == DVAP) dvap_conf();
	else if (rig_type == DVMEGA) dvmega_conf();
	else if (rig_type == NODE) node_conf();
	FD_SET (in_addr_sock, &fd_save);
scan_loop:
	if (rig_type == DVAP) dvap_reset();
	rig_reset();
	while (1)
	{
		if (first_time && rig_status_check())
                {
			if ((rig_type == ICOM) || (rig_type == NODE) 
				|| ((rig_type == DVAP) && dvap_status_check())
				|| ((rig_type == DVMEGA) && dvmega_status_check()))
			{
				first_time = FALSE;
				time (&cur_time);
				bf = ctime (&cur_time);
				sprintf (msg_temp, "START UP %8.8s   ", bf+11);
                        	memcpy (mycall2, "RPTC", 4);
                        	flag1 = 0x00;
                        	send_msg_sw = TRUE;
                        	memset (connect_call, 0x00, 8);
                        	scan_sw = FALSE;
                        	lcd_write ();
			}
                }
		time (&cur_time);
		if ((lcd_type != NONE) && (cur_time != lcd_time_save))
		{
			if (lcd_type == LCD_20x4) lcdPosition (lcd, 19, 0);
			else if (lcd_type == LCD_16x2) lcdPosition (lcd, 15, 0);
			lcdPutchar (lcd, status[cur_time % 6]);
			lcd_time_save = cur_time;
		}
		memcpy (&read_set, &fd_save, sizeof(fd_set));
		memcpy (&sigset, &save_sig, sizeof(save_sig));
		ret = pselect (FD_SETSIZE, &read_set, (fd_set *)NULL,
				(fd_set *)NULL, &timeout, &sigset);
		if (ret < 0)
		{
			if ((errno == EAGAIN) || (errno == EINTR)) goto skip;
			syslog (LOG_ERR, "pselect error %s", strerror(errno));
			break;
		}
		else if (ret > 0)
		{
			if ((rig_type == DVAP) || (rig_type == DVMEGA))
			{
				if (FD_ISSET (rig_fd, &read_set))
				{
					if (rig_type == DVAP) dvap_read();
					if (rig_type == DVMEGA) dvmega_read();
				}
			}
		}
		rig ();
skip:
		if (sig_term) break;
		if (connect_call[0] == '/')
		{
			conn_fd = fopen (CONN_FILE, "r");
			memset (temp, 0x00, sizeof(temp));
			while (fgets (temp, sizeof(temp), conn_fd))
			{
				if (!memcmp (&connect_call[1], temp, 6) 
					&& connect_call[7] == temp[7])
				{
					fclose (conn_fd);
					conn_fd = 0;
					if (rig_fd) rig_close();
					if (rig_type == NODE) node_close();
					n = strlen (temp);
					if (temp[n-1] == 0x0a) temp[n-1] = 0x20;
					memcpy (&temp[n], " NO_DAEMON", 10);
					memcpy (temp, "sudo    ", 8);
					syslog (LOG_INFO, "dmonitor start %6.6s %c", &connect_call[1], connect_call[7]);
					ret = system (temp);
					syslog (LOG_INFO, "dmonitor terminated");
					goto loop;
				}
			}
			if (conn_fd) 
			{
				fclose (conn_fd);
				syslog (LOG_INFO, "%6.6s %c not found", &connect_call[1], connect_call[7]);
				sprintf (msg_temp, "NOT FOUND %6.6s %c  ", &connect_call[1], connect_call[7]);
				memcpy (mycall2, "NOCL", 4);
				flag1 = 0x01;
				send_msg_sw = TRUE;
				memset (connect_call, 0x00, 8);
				scan_sw = FALSE;
			}
		}
		if (!memcmp (connect_call, "STATUS", 6))
		{
			memcpy (msg_temp, "RPT CONN RUNNING    ", 20);
			memcpy (mycall2, "RPTC", 4);
			flag1 = 0x00;
			send_msg_sw = TRUE;
			memset (connect_call, 0x00, 8);
			scan_sw = FALSE;
			lcd_write ();
		}
		if (!memcmp (connect_call, "UNLINK", 6) || !memcmp (connect_call, "DISCON", 6))
		{
			memcpy (msg_temp, "NOT UNLINK  RPTC RUN", 20);
			memcpy (mycall2, "RPTC", 4);
			flag1 = 0x00;
			send_msg_sw = TRUE;
			memset (connect_call, 0x00, 8);
			scan_sw = FALSE;
			lcd_write ();
		}
                if (!memcmp (connect_call, "REBOOT", 6))
                {
                        memcpy (msg_temp, "RASPI REBOOT        ", 20);
                        memcpy (mycall2, "RPTC", 4);
                        flag1 = 0x00;
                        send_msg_sw = TRUE;
                        memset (connect_call, 0x00, 8);
                        reboot_sw = TRUE;
			lcd_write ();
                }
                if (!memcmp (connect_call, "SHUTDOWN", 8))
                {
                        memcpy (msg_temp, "RASPI SHUTDOWN      ", 20);
                        memcpy (mycall2, "RPTC", 4);
                        flag1 = 0x00;
                        send_msg_sw = TRUE;
                        memset (connect_call, 0x00, 8);
                        shutdown_sw = TRUE;
			lcd_write ();
                }
		if (!memcmp (connect_call, "SCAN", 4))
		{
			memset (connect_call, 0x00, 8);
			if (!scan_sw)
			{
				scan_sw = TRUE;
			}
			else
			{
				scan_sw = FALSE;
				memcpy (msg_temp, "SCAN STOP           ", 20);
				memcpy (mycall2, "RPTC", 4);
				flag1 = 0x00;
				send_msg_sw = TRUE;
			}
		}
		if (scan_sw)
		{
		        if (rig_fd) rig_close();
               		if (rig_type == NODE) node_close();
			if (rpt_conn_scan())
			{
				scan_sw = FALSE;
                                flag1 = 0x00;
                                send_msg_sw = TRUE;
				goto loop;
			}
			else	
			{
				goto scan_loop;
			}
		}
		if (connect_call[0] != 0x00)
		{
			syslog (LOG_INFO, "%8.8s wrong call", connect_call);
			sprintf (msg_temp, "WRONG CMD %8.8s ", connect_call);
			flag1 = 0x01;
			memcpy (mycall2, "WRCL", 4);
			send_msg_sw = TRUE;
			memset (connect_call, 0x00, 8);
			lcd_write ();
		}
		if (send_msg_sw)
		{
			if (frameID == 0)
			{
				//sleep (1);
				send_msg (msg_temp, mycall2, flag1);
			}
		}
		if (reboot_sw)
		{
			sleep(3);
			ret = system ("sudo reboot");
			return;
		}
		if (shutdown_sw)
		{
			sleep(3);
			ret = system ("sudo shutdown -h now");
			return;
		}
		usleep (10000);
	}
end:
	syslog (LOG_INFO, "rpt_conn end");
	if (rig_fd) rig_close();
	if (udev) node_close();
	closelog();
	remove (PID_FILE);
	usleep (500000);
}

