#include "repeater_mon.h"

#define	LAST_MODIFIED_FILE	"/var/tmp/last_modified.txt"

FILE	*html_fd;
FILE	*html_active_fd;
FILE	*last_mod_fd;
FILE	*conn_fd;
FILE	*connect_fd;
char	area;
char	area_save;
int	col;
int	active_col;
int	json_length;
int	json_cnt;
char	ConnectCall[10];
int	repeater_cnt;
char	temp[256];

int     ja_check (unsigned char callsign[])
{
        int     ret;

        /* JA-JS,7J-7N,8J-8N */
        if (callsign[7] == 'S') return FALSE;
        if ((callsign[7] == ' ') || ((callsign[7] >= 'A') && (callsign[7] <= 'Z')))
        {
                if (memcmp (callsign, "JA", 2) >= 0  && memcmp (callsign, "JS", 2) <= 0) return TRUE;
                if (memcmp (callsign, "7J", 2) >= 0  && memcmp (callsign, "7N", 2) <= 0) return TRUE;
                if (memcmp (callsign, "8J", 2) >= 0  && memcmp (callsign, "8N", 2) <= 0) return TRUE;
        }
	html_fd = fopen (MON_HTML_TEMP, "w");
        fprintf (html_fd, "<!DOCTYPE html>\n");
        fprintf (html_fd, "<HTML>\n");
        fprintf (html_fd, "<title>Multi Forward Scan</title>\n");
        fprintf (html_fd, "<meta http-equiv=\"content-type\" content=\"text/html;charset=UTF-8\">\n");
        fprintf (html_fd, "<meta http-equiv=\"refresh\" content=\"1\">\n");
        fprintf (html_fd, "<meta http-equiv=\"Pragma\" content=\"no-cache\">\n");
        fprintf (html_fd, "<meta http-equiv=\"Cache-Control\" content=\"no-cache\">\n");
        fprintf (html_fd, "<meta name=\"expires\" content=\"0\">\n");
        fprintf (html_fd, "<BODY style=\"background-color:#ffff88;\">\n");
        fprintf (html_fd, "<center>\n");
        fprintf (html_fd, "<table border=\"1\" style=\"font-size:0.9em;\">\n");
        fprintf (html_fd, "<font color=red><b>接続コールサインが日本のコールサインでないか<br>\n");
        fprintf (html_fd, "最初に空白がある等、設定が間違っています。</b></font>\n");
        fprintf (html_fd, "</table>\n");
        fprintf (html_fd, "(C) Copyright 2022 JARL D-STAR Committee</center></BODY></HTML>\n");
        fprintf (html_fd, "\n");
        fclose (html_fd);
        memset (temp, 0x00, sizeof(temp));
        sprintf (temp, "/var/www/cgi-bin/file_check %s %s", MON_HTML_TEMP, MON_HTML);
        ret = system (temp);
        return FALSE;
}

void	prase (char str[])
{
	int	k;
	int	n, m;
	int	len;
	int	l;
	char	callsign[8];
	char	call[64];
	char	ip_addr[20];
	int	port;
	char	rep_temp[128];
	char	ur_call[8];
	char	my_call[8];
	char	rpt1_call[8];
	char	rpt2_call[8];
	char	zr_call[8];
	int	status;

	FILE	*mast_fd;
	len = strlen (str);
	memset (ur_call, 0x20, 8);
	memset (my_call, 0x20, 8);
	memset (rpt1_call, 0x20, 8);
	memset (rpt2_call, 0x20, 8);
	memset (zr_call, 0x20, 8);
	for (k = 0 ; k < len ; k++)
	{
		if (!memcmp (&str[k], "callsign", 8))
		{
			memcpy (callsign, &str[k+11], 8);
		}
		else if (!memcmp (&str[k], "ip_address", 10))
		{
			m = 0;
			for (n = k + 13; n < len ; n++)
			{
				if (str[n] == '"')
				{
					ip_addr[m] = 0x00;
					break;
				}
				ip_addr[m++] = str[n];
			}
		}
		else if (!memcmp (&str[k], "port", 4))
		{
			port = atoi (&str[k+6]);
		}
		else if (!memcmp (&str[k] , "status", 6))
		{
			if (!memcmp (&str[k+9], "on", 2)) status = 1;
			else	status = 0;
		}
		else if (!memcmp (&str[k], "area", 4))
		{
			area = str[k+7];
		}
		else if (!memcmp (&str[k], "ur_call", 7))
		{
			m = 0;
			for (n = k + 10 ; n < len ; n++)
			{
				if (str[n] == '"') break;
				ur_call[m++] = str[n];
			} 
		}
		else if (!memcmp (&str[k], "my_call", 7))
		{
			m = 0;
			for (n = k + 10 ; n < len ; n++)
			{
				if (str[n] == '"') break;
				my_call[m++] = str[n];
				if (m > 7) break;
			}
		}
                else if (!memcmp (&str[k], "rpt1_call", 9))
                {
                        m = 0;
                        for (n = k + 12 ; n < len ; n++)
                        {
                                if (str[n] == '"') break;
                                rpt1_call[m++] = str[n];
				if (m > 7) break;
                        }
                }
                else if (!memcmp (&str[k], "rpt2_call", 9))
                {
                        m = 0;
                        for (n = k + 12 ; n < len ; n++)
                        {
                                if (str[n] == '"') break;
                                rpt2_call[m++] = str[n];
				if (m > 7) break;
                        }
		}
		else if (!memcmp (&str[k], "zr_call", 7))
		{
			m = 0;
			for (n = k + 10 ; n < len ; n++)
			{
				if (str[n] == '"') break;
				zr_call[m++] = str[n];
				if (m > 7) break;
			}

			if (callsign[7] == 0x20) callsign[7] = 'A';
			m = 0;
			memset (call, 0x00, 64);
			for (n = 0 ; n < 8 ; n++)
			{
				if (callsign[n] != 0x20)
				{
					call[m] = callsign[n];
					m++;
				}
				else
				{
					memcpy (&call[m], "&nbsp;", 6);
					m += 6;
				}
			}
			if (area != area_save)
			{
				if (col)
				{
					if (col >  COL)
					{
        					while (col % COL)
        					{
                					fprintf (html_fd, "<td></td><td></td>");
                					col++;
                					if ((col % COL) == 0) fprintf (html_fd, "</tr>");
						}
        				}
					else
						fprintf (html_fd, "<tr>");
        				fprintf (html_fd, "</table>\n");
					col = 0;
				}
				area_save = area;
				fprintf (html_fd, "<a name=\"area%c\"></a>%cエリア<br>\n", area, area);
				fprintf (html_fd, "<table border=\"1\" style=\"font-size:0.9em;\">\n");
			}
			if ((col % COL) == 0) fprintf (html_fd, "<tr>");
			mast_fd = fopen (RPT_MAST, "r");
			while (fgets (rep_temp, sizeof(rep_temp), mast_fd))
			{
			    if (strlen(rep_temp) > 8)
			    {
				if (!memcmp (rep_temp, callsign, 8))
				{
					l = strlen(rep_temp) - 1;
					rep_temp[l] = 0x00;
					if (status)
					{
						fprintf (html_fd, "<td title=\"rpt1:%8.8s rpt2:%8.8s ur:%8.8s my:%8.8s\"<tt><a href=\"/cgi-bin/monitor?ip_addr=%s&port=%d&callsign='%8.8s'&rep_name='%s'&zr_call='%8.8s'\" target=\"cmd1\" style=\"color:red;\">%s</a></tt></td><td>%s</td>\n", 
							rpt1_call, rpt2_call, ur_call, my_call, ip_addr, port, callsign, &rep_temp[8], zr_call, call, &rep_temp[8]);
						if (active_col == 0) 
						{
							fprintf (html_active_fd, "<table border=\"1\" style=\"font-size:1.0em;\">\n");
							fprintf (html_active_fd, "<tr><td><center>Rep. Call</center></td><td><center>Rep. Name</center></td><td><center>GW Call</center></td><td><center>Ur Call</center></td><td><center>My Call</center></td></tr>\n");
						}
						fprintf (html_active_fd, "<tr><td><tt><a href=\"/cgi-bin/monitor?ip_addr=%s&port=%d&callsign='%8.8s'&rep_name='%s'&zr_call='%8.8s'\" target=\"cmd1\" style=\"color:red;\">%s</a></tt></td><td>%s</td><td><tt>%8.8s</tt></td><td><tt>%8.8s</tt></td><td><tt>%8.8s</tt></td></tr>\n",
                                                        ip_addr, port, callsign,
&rep_temp[8], zr_call, call, &rep_temp[8], zr_call, ur_call, my_call);
						active_col++;
					}
					else
						fprintf (html_fd, "<td><tt><a href=\"/cgi-bin/monitor?ip_addr=%s&port=%d&callsign='%8.8s'&rep_name='%s'&zr_call='%8.8s'\" target=\"cmd1\">%s</a></tt></td><td>%s</td>\n", 
							ip_addr, port, callsign, &rep_temp[8], zr_call, call, &rep_temp[8]);
					
					goto mast_close;
				}
			    }
			}
			if (status)
			{
				fprintf (html_fd, "<td title=\"rpt1:%8.8s rpt2:%8.8s ur:%8.8s my:%8.8s\"><tt><a href=\"/cgi-bin/monitor?ip_addr=%s&port=%d&callsign='%8.8s'&zr_call='%8.8s'\" target=\"cmd1\" style=\"color:red;\">%s</a></td></tt><td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>\n", 
					rpt1_call, rpt2_call, ur_call, my_call, ip_addr, port, callsign, zr_call, call);
					if (active_col == 0) 
					{
						fprintf (html_active_fd, "<table border=\"1\" style=\"font-size:0.9em;\">\n");
						fprintf (html_active_fd, "<tr><td><center>Rep. Call</center></td><td><center>Rep. Name</center></td><td><center>GW Call</center></td><td><center>Ur Call</center></td><td><center>My Call</center></td></tr>\n");
					}

				fprintf (html_active_fd, "<tr><td><tt><a href=\"/cgi-bin/monitor?ip_addr=%s&port=%d&callsign='%8.8s'&zr_call='%8.8s'\" target=\"cmd1\" style=\"color:red;\">%s</a></td></tt><td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td><td><tt>%8.8s</tt></td><td><tt>%8.8s</tt></td><td><tt>%8.8s</tt></td></tr>\n",
                                        ip_addr, port, callsign, zr_call, call, zr_call, ur_call, my_call);
					active_col++;
			}
			else
			{
				fprintf (html_fd, "<td><tt><a href=\"/cgi-bin/monitor?ip_addr=%s&port=%d&callsign='%8.8s'&zr_call='%8.8s'\" target=\"cmd1\">%s</a></tt></td><td></td>\n", 
					ip_addr, port, callsign, zr_call, call);
			}
mast_close:
			fprintf (conn_fd, "%8.8sdmonitor '%8.8s' %s %d '%8.8s' '%8.8s'\n", callsign, ConnectCall, ip_addr, port, callsign, zr_call);
			fclose (mast_fd);
			col++;
			if ((col % COL) == 0) fprintf (html_fd, "</tr>");
		}
	}
}

void	down_msg (void)
{
	int	ret;
	char	temp[256];
 
	html_fd = fopen (MON_HTML_TEMP, "w");
        html_active_fd = fopen (ACTIVE_HTML_TEMP, "w");
	conn_fd = fopen (CONN_TEMP, "w");
        fprintf (html_fd, "\n<!DOCTYPE html>\n\n");
	fprintf (html_fd, "<html>\n");
        fprintf (html_fd, "<head>\n");
        fprintf (html_fd, "<title>Multi Forward running Repeater</title>\n");
        fprintf (html_fd, "<meta charset=\"UTF-8\">\n");
	//fprintf (html_fd, "<meta http-equiv=\"Pragma\" content=\"no-cache\">\n");
	//fprintf (html_fd, "<meta http-equiv=\"Cache-Control\" content=\"no-cache\">\n");
	//fprintf (html_fd, "<meta name=\"expires\" content=\"0\">\n");
        fprintf (html_fd, "</head>\n");
        fprintf (html_fd, "<BODY style=\"background-color:#ffffcc;\">\n");
        fprintf (html_fd, "<center>\n");
	fprintf (html_fd, "<font size=+2>\n");
	fprintf (html_fd, "hole_punch サーバは停止しています<br>\n");
	fprintf (html_fd, "詳細は<br>\n");
	fprintf (html_fd, "<a href=https://d-star.at.webry.info>D-STAR技術情報</a><br>もしくは<br><a href=https://blog.goo.ne.jp/jarl_lab2>D-STAR NEWS</a><br>\n");
	fprintf (html_fd, "を見てく下さい</br>\n");
	fprintf (html_fd, "</font>\n</center>\n</body>\n</html>\n\n");
	fclose (html_fd);
        memset (temp, 0x00, sizeof(temp));
        sprintf (temp, "/var/www/cgi-bin/file_check %s %s", MON_HTML_TEMP, MON_HTML);
        ret = system (temp);
}
 
void main(int argc, char** argv)
{
    	int sd;
    	struct sockaddr_in addr;
	char	buff[8192];
	int	len;
	int	length;
	int	k, n;
	int	buff_pnt;
	char	temp[256];
	int	next;
	struct  hostent *host;
	int	ret;
	int	p_cnt;
	char	last_mod[32];
	
	json_length = 0;
	json_cnt = 0;
	repeater_cnt = 0;

	memset (last_mod, 0x20, 32);
	last_mod_fd = fopen (LAST_MODIFIED_FILE, "r");
	if (last_mod_fd)
	{
		fgets (last_mod, 32, last_mod_fd);
		fclose (last_mod_fd);
	}
	
    	if((sd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
        	perror("socket");
        	return;
    	}
 
    	addr.sin_family = AF_INET;
    	addr.sin_port = htons(JSON_PORT);
    	addr.sin_addr.s_addr = inet_addr(HOLE_PUNCHD_SERVER);
        if (addr.sin_addr.s_addr == 0xffffffff)
        {
                host = gethostbyname(HOLE_PUNCHD_SERVER);
                if (host == NULL) return;
                addr.sin_addr.s_addr = *(unsigned int *)host->h_addr_list[0];
        }

	connect_fd = fopen (DMONITOR_FILE, "r");
	fgets (ConnectCall, 10, connect_fd);		// skip 2 lines
	fgets (ConnectCall, 10, connect_fd);
	fgets (ConnectCall, 10, connect_fd);
	fclose (connect_fd);

	if (!ja_check(ConnectCall)) return;

	ret = -1;
	n = 0;
	while (ret == -1)
	{
    		ret = connect(sd, (struct sockaddr *)&addr, sizeof(struct sockaddr_in));
		if (ret == -1)
		{
			if (errno == ECONNREFUSED)
			{
				n++;
				if (n >= 5)
				{
					down_msg();
					return;
				}
			}
		}
		sleep (1);
	}

	if (last_mod[0] == 0x20)
	{ 
    		if(send(sd, "GET /repeater.json HTTP/1.1\r\nHost: hole-punchd.d-star.info:30011\r\nAccept-Language: ja-JP\r\nUser-Agent: dmonitor/" VERSION "\r\n\r\n", 120, 0) < 0) {
        		perror("send");
        		return;
		}
	}
	else
	{
		sprintf (temp, "GET /repeater.json HTTP/1.1\r\nHost: hole-punchd.d-star.info:30011\r\nAccept-Language: ja-JP\r\nUser-Agent: dmonitor/%5.5s\r\nIf-Modified-Since: %29.29s\r\n\r\n", VERSION, last_mod);
		if (send(sd, temp, 170, 0) < 0)
		{
			perror("send");
			return;
		}
    	}
	buff_pnt = 0;
	col = 0;
	active_col = 0;
	area_save = 0x20;
	//printf("Content-type: text/html\n\n");
	html_fd = fopen (MON_HTML_TEMP, "w");
	html_active_fd = fopen (ACTIVE_HTML_TEMP, "w");
	conn_fd = fopen (CONN_TEMP, "w");
	fprintf (html_fd, "\n<!DOCTYPE html>\n\n");
	fprintf (html_fd, "<html>\n");
	fprintf (html_fd, "<head>\n");
	fprintf (html_fd, "<title>Multi Forward running Repeater</title>\n");
	fprintf (html_fd, "<meta charset=\"UTF-8\">\n");
	//fprintf (html_fd, "<meta http-equiv=\"Pragma\" content=\"no-cache\">\n");
	//fprintf (html_fd, "<meta http-equiv=\"Cache-Control\" content=\"no-cache\">\n");
	//fprintf (html_fd, "<meta name=\"expires\" content=\"0\">\n");
	//fprintf (html_fd, "<meta http-equiv=\"refresh\" content=\"5\">\n");
	//fprintf (html_fd, "<meta http-equiv=\"refresh\" content=\"5,url=./repeater_mon\">\n");
	fprintf (html_fd, "<script type=\"text/javascript\">\n");
	fprintf (html_fd, "<!--\n");
	fprintf (html_fd, "setTimeout (function() {location.reload() ;} , 5000) ;\n");
	fprintf (html_fd, "var area;\n");

	fprintf (html_fd, "function area1_set() { setCookie(\"area\", \"area1\"); }\n");
	fprintf (html_fd, "function area2_set() { setCookie(\"area\", \"area2\"); }\n");
	fprintf (html_fd, "function area3_set() { setCookie(\"area\", \"area3\"); }\n");
	fprintf (html_fd, "function area4_set() { setCookie(\"area\", \"area4\"); }\n");
	fprintf (html_fd, "function area5_set() { setCookie(\"area\", \"area5\"); }\n");
	fprintf (html_fd, "function area6_set() { setCookie(\"area\", \"area6\"); }\n");
	fprintf (html_fd, "function area7_set() { setCookie(\"area\", \"area7\"); }\n");
	fprintf (html_fd, "function area8_set() { setCookie(\"area\", \"area8\"); }\n");
	fprintf (html_fd, "function area9_set() { setCookie(\"area\", \"area9\"); }\n");
	fprintf (html_fd, "function area0_set() { setCookie(\"area\", \"area0\"); }\n");

	fprintf (html_fd, "function disp_reload()\n");
	fprintf (html_fd, "{\n");
	//fprintf (html_fd, "window.localtion.bash = \"\";\n");
	fprintf (html_fd, "area = getCookie(\"area\");\n");
	fprintf (html_fd, "if (area == \"\") area = \"area1\";\n");
	fprintf (html_fd, "window.location.hash = area;\n");
	fprintf (html_fd, "}\n");


	fprintf (html_fd, "function getCookie(key,  tmp1, tmp2, xx1, xx2, xx3) {");
    	fprintf (html_fd, "tmp1 = \" \" + document.cookie + \";\";\n");
    	fprintf (html_fd, "xx1 = xx2 = 0;\n");
    	fprintf (html_fd, "len = tmp1.length;\n");
    	fprintf (html_fd, "while (xx1 < len) {\n");
        fprintf (html_fd, "xx2 = tmp1.indexOf(\";\", xx1);\n");
        fprintf (html_fd, "tmp2 = tmp1.substring(xx1 + 1, xx2);\n");
        fprintf (html_fd, "xx3 = tmp2.indexOf(\"=\");\n");
        fprintf (html_fd, "if (tmp2.substring(0, xx3) == key) {\n");
        fprintf (html_fd, "    return(unescape(tmp2.substring(xx3 + 1, xx2 - xx1 - 1)));\n");
        fprintf (html_fd, "}\n");
        fprintf (html_fd, "xx1 = xx2 + 1;\n");
    	fprintf (html_fd, "}\n");
    	fprintf (html_fd, "return(\"\");\n");
	fprintf (html_fd, "}\n");
	fprintf (html_fd, "function setCookie(key, val, tmp) {\n");
    	fprintf (html_fd, "tmp = key + \"=\" + escape(val) + \"; \";\n");
    	fprintf (html_fd, "tmp += \"expires=Tue, 31-Dec-2030 23:59:59; \";\n");
    	fprintf (html_fd, "document.cookie = tmp;\n");
	fprintf (html_fd, "}\n");
	fprintf (html_fd, "function clearCookie(key) {\n");
    	fprintf (html_fd, "document.cookie = key + \"=\" + \"xx; expires=Tue, 1-Jan-1980 00:00:00;\";\n");
	fprintf (html_fd, "}\n"); 

	fprintf (html_fd, "\n");

	fprintf (html_fd, "// -->\n</script>\n");
	fprintf (html_fd, "</head>\n");
	fprintf (html_fd, "<BODY onload=\"disp_reload()\" style=\"background-color:#ffffcc;\">\n");
	fprintf (html_fd, "<center>\n");

        fprintf (html_active_fd, "\n<!DOCTYPE html>\n\n");
	fprintf (html_active_fd, "<html>\n");
        fprintf (html_active_fd, "<head>\n");
        fprintf (html_active_fd, "<title>Multi Forward Active Repeater</title>\n");
        fprintf (html_active_fd, "<meta charset=\"UTF-8\">\n");
        //fprintf (html_active_fd, "<meta http-equiv=\"Pragma\" content=\"no-cache\">\n");
        //fprintf (html_active_fd, "<meta http-equiv=\"Cache-Control\" content=\"no-cache\">\n");
	//fprintf (html_active_fd, "<meta name=\"expires\" content=\"0\">\n");
        fprintf (html_active_fd, "<meta http-equiv=\"refresh\" content=\"5\">\n");
	//fprintf (html_active_fd, "<meta http-equiv=\"refresh\" content=\"5,url=./repeater_active\">\n");
        fprintf (html_active_fd, "<script type=\"text/javascript\">\n");
        fprintf (html_active_fd, "<!--\n");
	//fprintf (html_active_fd, "setTimeout (function() {location.reload() ;} , 5000) ;\n");
	//fprintf (html_active_fd, "<table border=\"1\" style=\"font-size:0.9em;\">\n");
	fprintf (html_active_fd, "self.focus();\n");
        fprintf (html_active_fd, "// -->\n</script>\n");
        fprintf (html_active_fd, "</head>\n");
        fprintf (html_active_fd, "<BODY style=\"background-color:#ffffcc;\">\n");
	fprintf (html_active_fd, "<center>\n");
	//fprintf (html_active_fd, "<table border=\"1\" style=\"font-size:0.9em;\"><tr>\n");
	p_cnt = 0;
	buff_pnt = 0;
	length = 0;
	n = 0;
	while (1)
	{
		len = recv (sd, &buff[buff_pnt], sizeof(buff)-buff_pnt-1, 0);
		if (len <= 0) break;
		length =len + buff_pnt;
		buff[length] = 0x00;
		next = 0;
		for (k = 0 ; k < length ; k++)
		{
			if (json_length == 0)
			{
				if (!memcmp (&buff[k], "403 Forbidden", 13))
				{
					fprintf (html_fd, "<font color=red><b>使用プログラムのバーションが最新ではありません。<br>\n");
					fprintf (html_fd, "アップデートして下さい。</b></font>\n");
					fprintf (html_active_fd, "<font color=red><b>使用プログラムのバーションが最新ではありません。<br>\n");
					fprintf (html_active_fd, "アップデートして下さい。</b></font>\n");
					fprintf (html_fd, "<br><br><a href=\"/cgi-bin/dmonitor_upd\">アップデートをすぐ行う。</a><br>（再起動が行われ、その後アップデートが行われます。）\n");
					fprintf (html_fd, "<br><br>\n");
        				fprintf (html_fd, "</table>\n");
        				fprintf (html_fd, "(C) Copyright 2022 JARL D-STAR Committee</center></BODY></HTML>\n");
        				fprintf (html_fd, "\n");
        				fclose (html_fd);
					close (sd);
					fclose (conn_fd);
					goto end;
				}
				else if (!memcmp (&buff[k], "Content-Length:", 15))
				{
					json_length = atoi(&buff[k+16]);
					//fprintf (html_fd, "length %d\n", json_length);
				}
				else if (!memcmp (&buff[k], "Last-Modified", 13))
				{
					memcpy (last_mod, &buff[k+15], 29);
					//fprintf (html_fd, "%29.29s\n", &buff[k+15]);
					last_mod_fd = fopen (LAST_MODIFIED_FILE, "w");
					fprintf (last_mod_fd, "%29.29s", last_mod);
					fclose (last_mod_fd);
				}
				else if (!memcmp (&buff[k], "304 Not Modified", 16))
				{
					close (sd);
					fclose (html_fd);
					fclose (html_active_fd);
					fclose (conn_fd);
					unlink (MON_HTML_TEMP);
					unlink (ACTIVE_HTML_TEMP);
					unlink (CONN_TEMP);
					return;
				}
					
			}
			else
			{	
				if (buff[k] == '{') p_cnt++;
				if (p_cnt) json_cnt++;
				if ((buff[k] != 0x0a) && (buff[k] != 0x0d))
				{
					if (p_cnt == 2) temp[n++] = buff[k];
					next =  k + 1;
				}
				if (buff[k] == '}')
				{
					if (p_cnt == 2)
					{
						temp[n] = 0x00;
						prase (temp);
						n = 0;
						repeater_cnt++;
					}
					p_cnt--;
					if (p_cnt == 0) goto next;
				}
			}
		}
		if (buff[k-4] == ']') break;
		if (length - next) memmove (buff, &buff[next], length - next + 1);
		buff_pnt = length - next;
		if (buff_pnt < 0) buff_pnt = 0;
	}
next:
	close (sd);
	if (json_length != (json_cnt+1))
	{
		fclose (html_fd);
		fclose (html_active_fd);
		fclose (conn_fd);
		unlink (MON_HTML_TEMP);
		unlink (ACTIVE_HTML_TEMP);
		unlink (CONN_TEMP);
		return;
	}
	if (col > COL)
	{
		while (col % COL)
		{
			fprintf (html_fd, "<td></td><td></td>");
			col++;
			if ((col % COL) == 0) 
				if(col) fprintf (html_fd, "</tr>");
		}
	}
	else
		if (col) fprintf (html_fd, "</tr>");

	fprintf (html_fd, "</table>\n");
	fprintf (html_fd, "(C) Copyright 2022 JARL D-STAR Committee (%d repeaters)</center></BODY></HTML>\n", repeater_cnt);
	fprintf (html_fd, "\n");
	fclose (html_fd);

	if (active_col)
	{
        	fprintf (html_active_fd, "</table>\n");
	}
end:
        fprintf (html_active_fd, "</center></BODY></HTML>\n");
        fprintf (html_active_fd, "\n");

	fclose (html_active_fd);
	memset (temp, 0x00, sizeof(temp));
	sprintf (temp, "/var/www/cgi-bin/file_check %s %s", MON_HTML_TEMP, MON_HTML);
	ret = system (temp);
	memset (temp, 0x00, sizeof(temp));
	sprintf (temp, "/var/www/cgi-bin/file_check %s %s", ACTIVE_HTML_TEMP, ACTIVE_HTML);
	ret = system (temp);
	memset (temp, 0x00, sizeof(temp));
	sprintf (temp, "/var/www/cgi-bin/file_check %s %s", CONN_TEMP, CONN_TXT);
	ret = system (temp);
}

