#include "dmonitor.h"

void    send_keep_alive(void);
int	send_dest_keep_alive(void);
void    inet_read(void);
void	init(void);
void	handler (void);
int     handler_init(void);
void    pselectSet(void);
void    LastFrameSend(void);
void	rig(void);
int	rig_status_check (void);
int	dvap_status_check (void);
int	dvmega_status_check (void);
int	node_status_check (void);
int	rig_read(void);
int	node_space_check (int length);

void	rig_close (void);
void	connected_table_clean(void);

void	dmonitor_close(void);
void	buff_hold_size_write (int n);
int	buff_hold_size_read (void);
void	send_rig_init(void);
int	send_rig(void);
void	dummy_last_frame (void);
void	jitter_buff_init (void);
void	jitter_putFifo (void);
void	dvap_conf(void);
void	dvmega_conf (void);
void	node_conf (void);
void	dvap_read(void);
int	ETagGen (char file_name[], char md5[]);
void	error_msg(char str[]);
void	error_msg_clean(void);
void	short_msg_wrt(void);
void    wait_disconnect (void);
void	send_msg (char str[], char my2[]);
void	dvmega_read(void);
void	node_close (void);
void	send_beep (unsigned char mycall[]);
void	lcd_init (void);
void	lcdPosition (int handle, int x, int y);
void	lcd_write (void);
void	ntpdate(void);
void	dvap_reopen(void);

time_t	send_time;
unsigned char 	*ppp;
struct  timeval rig_send_time_20mSec;
char	status[8] = {'|', '/', 2, 1, '|', '/', 2, 1};

int	main(int argc, char *argv[])
{
	int	length;
	int	i;
	int	k;
	int	len;
	time_t	cur_time;
	time_t	sec;
	int	ret;
	int	ret_code;
	struct	timeval	time_val;
	struct	timeval	fifo_hold_time;
	struct	timeval	time_temp;
	unsigned int	now;
	struct	hostent	*host;
	struct	in_addr	hole_punch_addr;
	struct	timeval	add_time;
	struct	timeval	temp_time;
	char	temp[21];
	char	*bf;

	char	pg_path[256];

	FILE	*pid_file;
	FILE	*dmonitor_file;
	FILE	*model;

	ret = nice (-15);
	send_sw = FALSE;
	scan_sw = FALSE;
	no_daemon = FALSE;
        node_VenderID = 0x4d8;
        node_ProductID = 0x300;
	HeaderLength = 0;
	voice_pnt = 0;
	node_tx_inv = 0;
	node_rx_inv = 0;
	node_tx_delay = 100;
	error_msg_sw = FALSE;
	rig_send_sw = FALSE;
	send_msg_sw = FALSE;
	beep_sw = OFF;
	scan_stop_sw = FALSE;
	lcd_time_save = 0;
	send_header_sw = FALSE;
	unlink_sw = FALSE;

        ntpdate ();

	openlog ("dmonitor", LOG_CONS | LOG_PID, LOG_LOCAL0);

	pid_file = fopen(PID_FILE,"r");
	if(pid_file == NULL)
	{
		pid_file = fopen(PID_FILE,"w");
	}
	else
	{
		syslog (LOG_ERR, "Already running dmonitor");
		closelog();
		fclose (pid_file);
		return	-1;
	}
	fprintf	(pid_file,"%d",	getpid());
	fclose	(pid_file);

	dmonitor_file = fopen (DMONITOR_FILE, "r");
	if (dmonitor_file == NULL)
	{
		rig_type = ICOM;
		lcd_type = NONE;
	}
	else
	{
		if (fgets (recvBuff, sizeof (recvBuff), dmonitor_file))
		{
			if (!memcmp (recvBuff, "DVAP", 4)) rig_type = DVAP;
			else if (!memcmp (recvBuff, "DVMEGA", 6)) rig_type = DVMEGA;
			else if (!memcmp (recvBuff, "NODE", 4)) rig_type = NODE;
			else	rig_type = ICOM;
			if (fgets (recvBuff, sizeof (recvBuff), dmonitor_file))
			{
				if (!memcmp (recvBuff, "NONE", 4)) lcd_type = NONE;
				else if (!memcmp (recvBuff, "G20x4", 5)) lcd_type = LCD_20x4;
				else if (!memcmp (recvBuff, "G16x2", 5)) lcd_type = LCD_16x2;
			}
		}
		fclose (dmonitor_file);
	}
#if 0
	if (rig_type == ICOM)
	{
		syslog (LOG_INFO, "Rig Type : ICOM");
	}
	else if (rig_type == DVAP)
	{
		syslog (LOG_INFO, "Rig Type : DVAP");
	}
	else if (rig_type == DVMEGA)
	{
		syslog (LOG_INFO, "Rig Type : DVMEGA");
	}
	else if (rig_type == NODE)
	{
		syslog (LOG_INFO, "Rig Type : NODE");
	}
#endif
	
	length = readlink ("/proc/self/exe", pg_path, sizeof(pg_path));
	if (length <= 0 ) return -1;
	pg_path[length] = 0x00;
	if (ETagGen (pg_path, MD5_dmonitor) < 0) return 5;
	//memcpy (MD5_dmonitor, "5ebe211107266a57b1af14a7fdcd8480", 32);

	Rp = malloc (sizeof (struct FifoPkt) - 1024);
	Wp = Rp;
	Rp->next = NULL;
	Fifo_cnt = 0;
	fifo_hold = fifo_new_hold = buff_hold_size_read ();
	recv_frame_seq = 0x00;

	memset (connect_call, 0x20, 8);
	if (argc < 5) 
	{
		syslog (LOG_ERR, 
			"Usage dmonitor my_call ip_address port area_call [zone_call]");
		return 5;
	}
	len = strlen(argv[1]);
	if (len > 8) len = 8;
	bf = argv[1] + 7;
	if (!memcmp (argv[1], "XX0XX", 5) 
		|| (*bf == 'I') || (*bf == 'G') || (*bf == 'S'))
	{
		syslog (LOG_ERR, "connect callsing wrong %8.8s", argv[1]);
		return 5;
	}
	memcpy (connect_call, argv[1], len);
	dest_address = argv[2];
	dest_inet_port = (unsigned short)atoi(argv[3]);
	memcpy (area_call, argv[4], strlen(argv[4]));
	memcpy (zone_call, argv[4], strlen(argv[4]));
	zone_call[7] = 'G';
	if (argc == 6)
	{
		if (!memcmp (argv[5], "SCAN", 4)) scan_sw = TRUE;
		else if (!memcmp (argv[5], "NO_DAEMON", 9)) no_daemon = TRUE;
		else 
		{
			memcpy (zone_call, argv[4], strlen(argv[5]));
			zone_call[7] = 'G';
		}
	}
	if (argc == 7)
	{
		if (!memcmp (argv[6], "SCAN", 4)) scan_sw = TRUE;
		else if (!memcmp (argv[6], "NO_DAEMON", 9)) no_daemon = TRUE;
	}

	if (argc >= 5) send_sw = TRUE;
	if (!scan_sw)
	{
		if (!no_daemon) ret = daemon(0, 0);
	}
	else status_fd = fopen ("/var/tmp/status.tmp", "w");

	send_time = 0;
	sig_term = FALSE;

	if (!scan_sw) handler_init();
	pselectSet();
	init();
	time (&rig_alive_recv);

	m_seq = 0;
	now = (unsigned int)time(0);
	srand(now);

	memcpy (hole_punch_server, HOLE_PUNCHD_SERVER, 
		sizeof(HOLE_PUNCHD_SERVER));
	hole_punch_port = HOLE_PUNCHD_PORT;

        model = fopen ("/proc/device-tree/model", "r");
        if (model)
        {
                fgets (pg_path, sizeof(pg_path), model);
                fclose (model);
	}

	if (!scan_sw) 
	{
		syslog (LOG_INFO, "Connected to %8.8s (%s:%d) from %8.8s", 
			area_call, dest_address, dest_inet_port, connect_call);
		syslog (LOG_INFO, "Model : %s", pg_path);
	}
	else 
	{
		fprintf (status_fd, "Connected to %8.8s from %8.8s\n", area_call, connect_call);
		fprintf (status_fd, "Model : %s\n", pg_path);
	}
	memset (inet_frame_id, 0x00, 2);
	frameID = 0;
	gettimeofday (&inet_time, NULL);
	inet_recv_time.tv_sec = 0;
	inet_recv_time.tv_usec = 0;

	add_time.tv_sec = 5;
	add_time.tv_usec = 0;

	rig_send_time_20mSec.tv_sec = 0;
	rig_send_time_20mSec.tv_usec = 20000;

	l_int = (fifo_hold - 10) * 20;
	inet_recv_timeout.tv_sec = l_int / 1000;
	inet_recv_timeout.tv_usec = (l_int % 1000) * 1000;

	rig_send_time.tv_sec = 0;
	rig_send_time.tv_usec = 0;

	if (wiringPiSetupGpio() == -1) return 1;
	pinMode(RIG_LED, OUTPUT);
	pinMode(INET_LED, OUTPUT);
	digitalWrite (RIG_LED, 0);
	digitalWrite (INET_LED, 0);
	inet_led_sw = 0;
	rig_led_sw = 0;
	if (lcd_type != NONE)
	{
		lcd_init();
		lcdPosition (lcd, 0, 0);
        	if (lcd_type == LCD_20x4)
		{
		
        		if (scan_sw) sprintf (temp, "ScnRpt %8.8s ", area_call);
			else sprintf (temp, "Rpt    %8.8s ", area_call);
			temp[16] = 0x00;
		}
		else if (lcd_type == LCD_16x2)
		{
			if (scan_sw) sprintf (temp, "%8.8s   ", area_call);
			else sprintf (temp, "%8.8s    ", area_call);
			temp[12] = 0x00;
		}
        	lcdPuts(lcd, temp);
	}

	connected_fd = NULL;
	hole_punch_send_interval = HOLE_PUNCH_SEND_INTERVAL;
	connected_table_clean();
	error_msg_clean();

	rig_last_frame_send = TRUE;

	jitter_buff_init();

	ptt = 0x00;
	fifo_hold_limit = fifo_hold + 10;

	hole_punch_send_cnt = 0;

	memset (rig_device, 0x00, sizeof(rig_device));
	memcpy (rig_device, RIG_DEVICE, strlen(RIG_DEVICE));
	if (rig_type == DVAP) dvap_conf();
	else if (rig_type == DVMEGA)  dvmega_conf();
	else if (rig_type == NODE) node_conf();
	dvap_first_voice_pkt = FALSE;

	for (k = 0 ;  k < 2 ; k++)
	{
		send_keep_alive();
		usleep (10000);
	}

	dest_keep_alive_cnt= 0;

	memset (short_msg, 0x20, 20);
	memset (used_call, 0x20, 8);
	memset (used_call2, 0x20, 4);
	short_msg_wrt();
	not_clear_error_msg = FALSE;
	memset (alt_header, 0x00, 41);
	alt_header_pnt = 0;
	reboot_sw = FALSE;
	shutdown_sw = FALSE;
	hole_punchd_recvd = FALSE;
	no_cmd_sw = FALSE;
	used_call_sw = FALSE;

	FD_SET (in_addr_sock, &fd_save);

	while (1)
	{
top:
		time (&cur_time);
		if ((lcd_type != NONE) && (cur_time != lcd_time_save))
		{
			if (lcd_type == LCD_20x4) lcdPosition (lcd, 19, 0);
			else if (lcd_type == LCD_16x2) lcdPosition (lcd, 15, 0);
			lcdPutchar (lcd, status[cur_time % 8]);
			lcd_time_save = cur_time;
		}

		memcpy (&read_set, &fd_save, sizeof(fd_set));
		memcpy (&sigset, &save_sig, sizeof(save_sig));
		ret = pselect (FD_SETSIZE, &read_set, (fd_set *)NULL,
				(fd_set *)NULL, &timeout, &sigset);
		if (ret < 0)
		{
			if ((errno == EAGAIN) || (errno == EINTR)) goto skip;
			syslog (LOG_ERR, "pselect error %s", strerror(errno));
			break;
		}
		else if (ret > 0)
		{
			if (FD_ISSET (in_addr_sock, &read_set))
			{
				inet_read ();
			}
			if ((rig_type == DVAP) || (rig_type == DVMEGA))
			{
				if (FD_ISSET (rig_fd, &read_set))
				{
					if (rig_type == DVAP) dvap_read();
					else if (rig_type == DVMEGA) dvmega_read();
					else
						syslog (LOG_DEBUG, "120");
				}
			}
		}
		jitter_putFifo();
		rig ();
		if ((cur_time - hole_punch_send_time) >= hole_punch_send_interval)
		{
			if (hole_punch_send_interval == HOLE_PUNCH_SEND_INTERVAL) 
			{
				hole_punch_send_cnt++;
				if (hole_punch_send_cnt >= 20)
				{
					sprintf (msg_temp, "NOT LINKED %8.8s ", area_call);
                                	memcpy (mycall2, "NOLK", 4);
                                	send_msg_sw = TRUE;
					lcd_write();
					time (&msg_send_set_time);
					syslog (LOG_INFO,
						"Not Connected to %8.8s", area_call);
					error_msg ("ERROR接続できません");
					
					sleep (15);
					break;
				}
				else
				{
					error_msg ("ERROR接続処理中です");
				}
			}
			send_dest_keep_alive();
		}
		if (dest_keep_alive_send_time)
		{
			if ((cur_time - dest_keep_alive_send_time) >= KEEP_ALIVE_INTERVAL)
			{
				dest_keep_alive_cnt++;
				if (dest_keep_alive_cnt >= 10) 
				{
                                        sprintf (msg_temp, "RPT DOWN %8.8s   ", area_call);
                                        memcpy (mycall2, "DOWN", 4);
                                        send_msg_sw = TRUE;
					lcd_write();
					if (scan_sw)
					{
						fprintf (status_fd, "repeater down");
					}
					else
					{
						syslog (LOG_INFO, "repeater down");
					}
					break;
				}
				send_keep_alive();
			}
		}
		if(rig_send_sw)
		{
			gettimeofday (&c_time, NULL);
			timeradd (&rig_send_time, &rig_send_time_20mSec, &temp_time);
			if (timercmp (&c_time, &temp_time, >=)) 
			{
				if (send_rig())
				{
					rig_send_time.tv_sec = temp_time.tv_sec;
					rig_send_time.tv_usec = temp_time.tv_usec;
				}
				else
				{
					syslog (LOG_INFO, "Empty of the jitter buffer");
					send_drop_packet();
					//LastFrameSend();
				}
			}
		}
		if ((inet_frame_id[0] != 0xff) || (inet_frame_id[1] != 0xff))
		{
		   if ((inet_frame_id[0] != 0x00) || (inet_frame_id[1] != 0x00))
		   {
			gettimeofday (&c_time, NULL);
			timeradd (&inet_recv_time, &inet_recv_timeout, &temp_time);
			if (timercmp (&c_time, &temp_time, >))
			{
				syslog (LOG_INFO, "%19.19s:%03ld", ctime(&c_time.tv_sec), c_time.tv_usec/1000);
				syslog (LOG_INFO, "%19.19s:%03ld", ctime(&inet_recv_timeout.tv_sec), inet_recv_timeout.tv_usec/1000);
				syslog (LOG_INFO, "insert dummy_last_frame (main)");
				dummy_last_frame();
				//#ifdef	_SPECIFICATION_CHECK
				timersub (&c_time, &inet_recv_time, &temp_time);
				syslog (LOG_INFO, "long interval %ld.%03ld Sec.", temp_time.tv_sec, temp_time.tv_usec/1000);
				//#endif
				gettimeofday (&inet_recv_time, NULL);
			}
		   }
		}
		else
		{
			fifo_hold = fifo_new_hold;
			l_int = (fifo_hold - 10) * 20;
			inet_recv_timeout.tv_sec = l_int / 1000;
			inet_recv_timeout.tv_usec = (l_int % 1000) * 1000;
		}
		if (scan_sw)
		{
			gettimeofday (&c_time, NULL);
			timeradd (&inet_time, &add_time, &temp_time);
			if (timercmp (&c_time, &temp_time, >)) break;
		}
skip:
		if (rig_fd || udev)
		{
#if 0
			if (beep_sw && !scan_sw && (frameID == 0))
			{
				send_beep (my_call);
				beep_sw = OFF;
			}
#endif
			if (send_msg_sw && (!scan_sw || scan_stop_sw))	/* send replay message for cmd */
			{
				if (((rig_type == ICOM) && rig_status_check())
					|| ((rig_type == DVAP) && dvap_status_check())
					|| ((rig_type == DVMEGA) && dvmega_status_check())
					|| ((rig_type == NODE) && node_status_check()))
				{
					if ((frameID == 0) && (inet_frame_id[0] == 0x00) && (inet_frame_id[1] == 0x00))
					{
						send_msg(msg_temp, mycall2);
						if (reboot_sw)
						{
							sleep(3);
							ret = system("sudo reboot");
							return -1;
						}
						if (shutdown_sw)
						{
							sleep(3);
							ret = system ("sudo shutdown -h now");
							return -1;
						}
						if (unlink_sw)
						{
							sleep(3);
							break;
						}
						if (scan_stop_sw)
						{
							break;
						}
					}
					else
						goto top;
				}
				else
					goto top;
			}
		}
		if (used_call_sw && used_call[0] != 0x20)
		{
			if (lcd_type != NONE)
			{ 
               			lcdPosition (lcd, 0, 1);
				if (lcd_type == LCD_20x4)
				{
               				if (memcmp (used_call2, "    ", 4)) sprintf (temp, "Caller %8.8s/%4.4s", used_call, used_call2);
					else sprintf (temp, "Caller %8.8s     ", used_call);
               				temp[20] = 0x00;
				}
				else if (lcd_type == LCD_16x2)
				{
					if (memcmp (used_call2, "    ", 4)) sprintf (temp, "%8.8s/%4.4s   ", used_call, used_call2);
					else sprintf (temp, "%8.8s        ", used_call);
					temp[16] = 0x00;
				}
               			lcdPuts(lcd, temp);
			}
			used_call_sw = FALSE;
		}
		if (sig_term) break;
	}

	if (send_msg) sleep (3);
	if (!rig_last_frame_send)
	{
		LastFrameSend();
	}
	connected_table_clean();
	if (!not_clear_error_msg) error_msg_clean();
	if (rig_fd) rig_close();
	dmonitor_close();
	wait_disconnect();
	if (!scan_sw)
	{
		syslog (LOG_INFO, "dmonitor end");
	}
	else
	{
		fprintf (status_fd, "dmonitor end");
		fclose (status_fd);
		ret = system ("/var/www/cgi-bin/file_check /var/tmp/status.tmp /var/tmp/status.txt");
	}
	closelog();
	memset (short_msg, 0x20, 20);
	short_msg_wrt();
	close (in_addr_sock);
	if (rig_type == NODE) node_close();
	remove (PID_FILE);
	digitalWrite (RIG_LED, 0);
        digitalWrite (INET_LED, 0);
	if (scan_stop_sw) return -1;
	return 0;
}

void	wait_disconnect (void)
{
	int	k;
	int	length;
	int	cnt;
	int	ret;

	cnt = 0;
	while (1)
	{
		memcpy (&read_set, &fd_save, sizeof(fd_set));
		memcpy (&sigset, &save_sig, sizeof(save_sig));
		ret = pselect (FD_SETSIZE, &read_set, (fd_set *)NULL,
			(fd_set *)NULL, &timeout, &sigset);
		if (ret > 0)
		{
			if (FD_ISSET (in_addr_sock, &read_set))
			{
        			k = sizeof (struct sockaddr);
        			length = recvfrom (in_addr_sock, recvBuff, sizeof(recvBuff), 0,
                			(struct sockaddr *)&in_addr, &k);
				if ((length == 24 ) && !memcmp (recvBuff, "DISCONNECT", 10)) break;
			}
		}
		else
		{
			cnt++;
			if (cnt > 200) 
			{
				dmonitor_close ();
				break;
			}
		}
	}
}
