#include "repeater_mon.h"

#define	TRUE	1
#define	FALSE	0

#define	TableMax 25
char	area;

struct	scan_table
{
	struct	scan_table *next;
	char	call[8];
	char	zr_call[8];
	char	ip_addr[20];
	int	port;
} ScanTable;

struct	scan_table	*ScanTable_top;
struct	scan_table	*ScanTable_last;

int	nn;

FILE	*AccFile;

void    handler (int sig)
{
        if (sig == SIGINT)  sig_term = TRUE;
}

int     handler_init(void)
{
        if (signal(SIGINT, handler) == SIG_ERR)
        {
                return FALSE;
        }
	return TRUE;
}

void	prase (char str[])
{
	int	k;
	int	n, m;
	int	len;
	char	callsign[8];
	char	call[64];
	char	ip_addr[20];
	int	port;
        char    rep_temp[128];
        char    ur_call[8];
        char    my_call[8];
        char    rpt1_call[8];
        char    rpt2_call[8];
        char    zr_call[8];
        int     status;
	int	ret;
	int	nnn;
	int	mm;
	int	kk;
	struct	scan_table	*pnt;

	len = strlen (str);
	for (k = 0 ; k < len ; k++)
	{
		if (!memcmp (&str[k], "callsign", 8))
		{
			memcpy (callsign, &str[k+11], 8);
		}
		else if (!memcmp (&str[k], "ip_address", 10))
		{
			m = 0;
			for (n = k + 13; n < len ; n++)
			{
				if (str[n] == '"')
				{
					ip_addr[m] = 0x00;
					break;
				}
				ip_addr[m++] = str[n];
			}
		}
		else if (!memcmp (&str[k], "port", 4))
		{
			port = atoi (&str[k+6]);
		}
                else if (!memcmp (&str[k] , "status", 6))
                {
                        if (!memcmp (&str[k+9], "on", 2)) status = 1;
                        else    status = 0;
                }
                else if (!memcmp (&str[k], "area", 4))
                {
                        area = str[k+7];
                }
                else if (!memcmp (&str[k], "ur_call", 7))
                {
                        m = 0;
                        for (n = k + 10 ; n < len ; n++)
                        {
                                if (str[n] == '"') break;
                                ur_call[m++] = str[n];
                        }
                }
                else if (!memcmp (&str[k], "my_call", 7))
                {
                        m = 0;
                        for (n = k + 10 ; n < len ; n++)
                        {
                                if (str[n] == '"') break;
                                my_call[m++] = str[n];
                                if (m > 7) break;
                        }
                }
                else if (!memcmp (&str[k], "rpt1_call", 9))
                {
                        m = 0;
                        for (n = k + 12 ; n < len ; n++)
                        {
                                if (str[n] == '"') break;
                                rpt1_call[m++] = str[n];
                                if (m > 7) break;
                        }
                }
                else if (!memcmp (&str[k], "rpt2_call", 9))
                {
                        m = 0;
                        for (n = k + 12 ; n < len ; n++)
                        {
                                if (str[n] == '"') break;
                                rpt2_call[m++] = str[n];
                                if (m > 7) break;
                        }
                }
                else if (!memcmp (&str[k], "zr_call", 7))
                {
                        m = 0;
                        for (n = k + 10 ; n < len ; n++)
                        {
                                if (str[n] == '"') break;
                                zr_call[m++] = str[n];
                                if (m > 7) break;
                        }

                        if (callsign[7] == 0x20) callsign[7] = 'A';
                        m = 0;
                        memset (call, 0x00, 64);
                        for (n = 0 ; n < 8 ; n++)
                        {
                                if (callsign[n] != 0x20)
                                {
                                        call[m] = callsign[n];
                                        m++;
                                }
                                else
                                {
                                        memcpy (&call[m], "&nbsp;", 6);
                                        m += 6;
                                }
                        }
			pnt = malloc (sizeof (struct scan_table));
			if (ScanTable_top == NULL)
			{
				ScanTable_top = pnt;
				ScanTable_last = pnt;
			}
			else
			{
				ScanTable_last->next = pnt;
				ScanTable_last = pnt;
			}
			pnt->next = NULL;
			if (callsign[7] == 0x20) callsign[7] = 'A';
			memcpy (pnt->call, callsign, 8);
			memcpy (pnt->zr_call, zr_call, 8);
			memset (pnt->ip_addr, 0x00, 20);
			memcpy (pnt->ip_addr, ip_addr, strlen(ip_addr));
			pnt->port = port;
		}
			
	}
	return;
}

 
int main(int argc, char** argv)
{
    	int sd;
    	struct sockaddr_in addr;
	char	buff[4096];
	int	len;
	int	length;
	int	k, n;
	int	i, j;
	int	m;
	int	buff_pnt;
	char	temp[256];
	int	next;
	int	ret;
	struct  hostent *host;
	struct	scan_table *pnt;
	struct	scan_table *tmp_pnt;
	char	cmd[128];
	int	col;
	char	tmp_call[64];
	char	rep_temp[128];
	char	connect_call[8];
	FILE	*mast_fd;
	FILE	*call_fd;
	int	p_cnt;

	sig_term = FALSE;
	handler_init();

	ret = daemon (0, 0);
	call_fd = fopen (CALL_FILE, "r");
	ret = fread (connect_call, 8, 1, call_fd);
	fclose (call_fd);
	while (1)
	{
		pnt = ScanTable_top;
		while (pnt)
		{
			tmp_pnt = pnt->next;
			free (pnt);
			pnt = tmp_pnt;
		}
		ScanTable_top = NULL;
		ScanTable_last = NULL;

    		if((sd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
        		perror("socket");
        		return -1;
    		}
 
    		addr.sin_family = AF_INET;
    		addr.sin_port = htons(JSON_PORT);
    		addr.sin_addr.s_addr = inet_addr(HOLE_PUNCHD_SERVER);
        	if (addr.sin_addr.s_addr == 0xffffffff)
        	{
                	host = gethostbyname(HOLE_PUNCHD_SERVER);
                	if (host == NULL) return 1;
                	addr.sin_addr.s_addr = *(unsigned int *)host->h_addr_list[0];
        	}
 
        	ret = -1;
        	while (ret == -1)
        	{
                	ret = connect(sd, (struct sockaddr *)&addr, sizeof(struct sockaddr_in));
                	if (ret == -1)
                	{
                        	if (errno == ECONNREFUSED)
                        	{
                                	sleep (1);
                        	}
                        	else
                                	return -1;
                	}
        	}
		if(send(sd, "GET /repeater.json HTTP/1.1\r\nHost: hole-punchd.d-star.info:30011\r\nAccept-Language: ja-JP\r\nUser-Agent: dmonitor/" VERSION "\r\n\r\n", 120, 0) < 0) {
        	perror("send");
        	return -1;
    		}

		buff_pnt = 0;
		nn = 0;
		p_cnt = 0;
		n = 0;
		while (1)
		{
			len = recv (sd, &buff[buff_pnt], sizeof(buff)-buff_pnt-1, 0);
			if (len <= 0) break;
			length =len + buff_pnt;
			buff[length] = 0x00;
			next = 0;
	                for (k = 0 ; k < length ; k++)
                	{
                                if (!memcmp (&buff[k], "403 Forbidden", 13))
                                {
                        		AccFile = fopen (SCAN_HTML_TEMP, "w");
                        		fprintf (AccFile, "<!DOCTYPE html>\n");
                        		fprintf (AccFile, "<HTML>\n");
                        		fprintf (AccFile, "<title>Multi Forward Scan</title>\n");
                        		fprintf (AccFile, "<meta http-equiv=\"content-type\" content=\"text/html;charset=UTF-8\">\n");
                        		//fprintf (AccFile, "<meta http-equiv=\"refresh\" content=\"1;URL=./repeater_scan.html\">\n");
					fprintf (AccFile, "<meta http-equiv=\"refresh\" content=\"1\">\n");
                        		fprintf (AccFile, "<meta http-equiv=\"Pragma\" content=\"no-cache\">\n");
                        		fprintf (AccFile, "<meta http-equiv=\"Cache-Control\" content=\"no-cache\">\n");
					fprintf (AccFile, "<meta name=\"expires\" content=\"0\">\n");
                        		fprintf (AccFile, "<BODY style=\"background-color:#ffff88;\">\n");
                        		fprintf (AccFile, "<center>\n");
                        		fprintf (AccFile, "<table border=\"1\" style=\"font-size:0.9em;\">\n");
                                        fprintf (AccFile, "<font color=red><b>使用プログラムのバーションが最新ではありません。<br>\n");
                                        fprintf (AccFile, "アップデートして下さい。</b></font>\n");
					fprintf (AccFile, "<br><br><a href=\"./update.html\" target=\"_blank\">アップデートの手順</a>\n");
                        		fprintf (AccFile, "</table>\n");
                        		fprintf (AccFile, "</center></BODY></HTML>\n");
                        		fprintf (AccFile, "\n");
                        		fclose (AccFile);
					close (sd);
                        		sprintf (temp, "mv -f %s %s", SCAN_HTML_TEMP, SCAN_HTML);
                        		ret = system (temp);
                                        return 1;
                                }
                        	if (buff[k] == '{') p_cnt++;
                        	if ((buff[k] != 0x0a) && (buff[k] != 0x0d))
                        	{
                                	if (p_cnt == 2) temp[n++] = buff[k];
                                	next =  k + 1;
                        	}
                        	if (buff[k] == '}')
                        	{
                                	if (p_cnt == 2)
                                	{
                                        	temp[n] = 0x00;
                                        	prase (temp);
                                        	n = 0;
                                	}
                                	p_cnt--;
                                	if (p_cnt == 0) goto close;
                        	}
                	}

			if (length - next) memmove (buff, &buff[next], length - next + 1);
			buff_pnt = length - next;
			if (buff_pnt < 0) buff_pnt = 0;
		}
close:
		close(sd);

		pnt = ScanTable_top;
		col = 0;
		while (pnt)
		{
			AccFile = fopen (SCAN_HTML_TEMP, "w");
			fprintf (AccFile, "<!DOCTYPE html>\n");
        		fprintf (AccFile, "<HTML>\n");
        		fprintf (AccFile, "<title>Multi Forward Scan</title>\n");
        		fprintf (AccFile, "<meta http-equiv=\"content-type\" content=\"text/html;charset=UTF-8\">\n");
			//fprintf (AccFile, "<meta http-equiv=\"refresh\" content=\"1;URL=./repeater_scan.html\">\n");
			fprintf (AccFile, "<meta http-equiv=\"refresh\" content=\"1\">\n");
			fprintf	(AccFile, "<meta http-equiv=\"Pragma\" content=\"no-cache\">\n");
			fprintf	(AccFile, "<meta http-equiv=\"Cache-Control\" content=\"no-cache\">\n");
			fprintf (AccFile, "<meta name=\"expires\" content=\"0\">\n");
        		fprintf (AccFile, "<BODY style=\"background-color:#ffff88;\">\n");
        		fprintf (AccFile, "<center>\n");
        		fprintf (AccFile, "<table border=\"1\" style=\"font-size:0.9em;\">\n");
			tmp_pnt = ScanTable_top;
			m = 0;
			while (tmp_pnt != pnt)
			{
				m++;
				tmp_pnt = tmp_pnt->next;
			}
			tmp_pnt = ScanTable_top;
			m /= COL;
			j = m;	/* dummy instruction */
			m *= COL;
			while (m--) tmp_pnt = tmp_pnt->next;
			while (tmp_pnt)
			{
				mast_fd = fopen (RPT_MAST, "r");
				while (fgets (rep_temp, sizeof(rep_temp), mast_fd))
				{
					if (!memcmp (tmp_pnt->call, rep_temp, 8)) goto next;
				}
				rep_temp[8] = 0x00;
next:
				j = strlen(rep_temp) - 1;
				if (j <  8) j = 8;
				rep_temp[j] = 0x00;
				fclose (mast_fd);
			
				j = 0;
				for (i = 0 ; i < 8 ; i++)
				{
					if (tmp_pnt->call[i] != 0x20) tmp_call[j++] = tmp_pnt->call[i];
					else	
					{
						memcpy (&tmp_call[j], "&nbsp;", 6);
						j += 6;
					}
				}
				tmp_call[j] = 0x00;
				if ((col % COL) == 0) fprintf (AccFile, "<tr>");
				if (tmp_pnt == pnt) fprintf (AccFile, "<td><tt><font color=red><b>%s</b></font></tt></td><td>%s</td>\n", tmp_call, &rep_temp[8]);
				else fprintf (AccFile, "<td><tt>%s</tt></td><td>%s</td>\n", tmp_call, &rep_temp[8]);
				tmp_pnt = tmp_pnt->next;
				col++;
				if ((col % COL) == 0) fprintf (AccFile, "</tr>");
			}
        		while (col % COL)
        		{
                		fprintf (AccFile, "<td></td><td></td>");
                		col++;
                		if ((col % COL) == 0) fprintf (AccFile, "</tr>");
        		}
        		fprintf (AccFile, "</table>\n");
        		fprintf (AccFile, "</center></BODY></HTML>\n");
        		fprintf (AccFile, "\n");
			fclose (AccFile);
			memset (temp, 0x00, sizeof(temp));
			sprintf (temp, "mv -f %s %s", SCAN_HTML_TEMP, SCAN_HTML);
			ret = system (temp);
			ret = system ("rig_port_check");
                        memset (cmd, 0x00, sizeof(cmd));
                        sprintf (cmd, "dmonitor '%8.8s' %s %d '%8.8s' '%8.8s' SCAN",
                              connect_call, pnt->ip_addr, pnt->port, pnt->call, pnt->zr_call);
			ret = system (cmd);
			pnt = pnt->next;
		}
		if (sig_term) break;
	}
}
