#include	"dmonitor.h"

int     node_cos_check(void);
void	node_skip (void);
extern	char	lastframe[];

void	node_header_send (unsigned char header[])
{
	unsigned char	len;
	unsigned short int	tmp;
	ssize_t	wrt_len;
	unsigned char   call_temp[8];

	syslog (LOG_DEBUG,  "from INET RPT2:%8.8s RPT1:%8.8s Ur:%8.8s My:%8.8s/%4.4s", 
			&header[3], &header[11], &header[19], 
			&header[27], &header[35]);

	if (node_cos_check()) return;
	usb_control_msg(udev, 0x40, SET_PTT, OFF, 0, NULL, 0, 200);
	/* Callsign set */
	usb_control_msg(udev, 0x40, SET_MyCALL, 0, 0, &header[27], 8, 100);
	usb_control_msg(udev, 0x40, SET_MyCALL2, 0, 0, &header[35] , 4, 100);
	usb_control_msg(udev, 0x40, SET_YourCALL, 0, 0, &header[19], 8, 100);
	usb_control_msg(udev, 0x40, SET_RPT1CALL, 0, 0, &header[3], 8, 100);
	usb_control_msg(udev, 0x40, SET_RPT2CALL, 0, 0, &header[11], 8, 100);
	header[0] = 0x00;
	header[1] = 0x00;
	header[2] = 0x00;
	usb_control_msg(udev, 0x40, SET_FLAGS, 0, 0, header, 3, 100);
	usb_control_msg(udev, 0x40, SET_PTT, ON, 0, NULL, 0, 100);
}

void	node_voice_send (unsigned char voice[])
{
	int	ret;
	unsigned char	len;

#if 0
syslog (LOG_DEBUG, "%2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x   %2.2x %2.2x %2.2x",
	voice[0], voice[1], voice[2], voice[3], voice[4], voice[5], voice[6], voice[7], voice[8], voice[9], voice[10], voice[11]);
#endif
	ret = usb_control_msg(udev, 0x40, PUT_DATA, 0, 0, voice, 12, 100);
}

void	node_last_send (unsigned char voice[])
{
	int	ret;
	unsigned char	len;

	memcpy (&voice[9], lastframe, 6);
       	ret = usb_control_msg(udev, 0x40, PUT_DATA, 0, 0, voice, 15, 100);
	/* PTT OFF */
	ret = usb_control_msg(udev, 0x40, SET_PTT, OFF, 0, NULL, 0, 100);
	frameID = 0;
}

void	node_write (unsigned char str[], int length)
{
	if (length == 42)
	{
		node_header_send (&str[2]);
	}
	else if (length == 17)
	{
		if ((str[3] & 0x40) 
			|| !memcmp (&str[13], &lastframe[3], 3)
			|| !memcmp (&str[4], &lastframe[3], 3))  node_last_send (&str[4]);
		else node_voice_send (&str[4]);
	}
}

int	node_space_check (int length)
{
	unsigned  char	len;

        usb_control_msg(udev, 0xc0, GET_REMAINSPACE, 0, 0, (char *)&len , 1, 100);
	if (len < length) return FALSE;
	return TRUE;
}

