#include	"rpt_conn.h"

int	htoi (char string[]);
void    header_read_from_node(void);
int	voice_read_from_node(void);
void    node_term (void);
int	node_space_check(int length);

void	node_conf (void)
{
	char	buff[256];
	char	*delmi = "=\n\r\t\0";
	char	*pnt;
	char	*p;
	int	n;
	int	field_sw;
	int	port;

	FILE	*config_file;

	config_file = fopen (NODE_CONF, "r");
	if (!config_file)
	{
		syslog (LOG_ERR, "node config file not found (%s)\n", 
					NODE_CONF);
		return;
	}

	while (fgets (buff, 255, config_file))
	{
		if (buff[0] != '#')
		{
			n = 0;
			while (buff[n] == 0x20) n++;
			p = strtok(&buff[n], delmi);
			if (p != NULL)
			{
				pnt = strtok(NULL, delmi);
	
				if (!memcmp (p, "NODE_VENDERID",  13))
				{
					node_VenderID = htoi (pnt);
				}
				else if (!memcmp (p, "NODE_PRODUCTID", 14))
				{
					node_ProductID = htoi (pnt);
				}
				else if (!memcmp (p, "NODE_TX_DELAY", 13))
				{
					node_tx_delay = atoi (pnt);
				}
				else if (!memcmp (p, "NODE_RX_INVERT", 14))
				{
					node_rx_inv = atoi (pnt);
				}
				else if (!memcmp (p, "NODE_TX_INVERT", 14))
				{
					node_tx_inv = atoi (pnt);
				}
				else
				{
					syslog (LOG_ERR, "Error on node config file : %s", buff);
				}
			}
		}
	}
	fclose (config_file);
}

int     htoi (char *s)
{
        int n;

        if ( *s != '0' || !(*(s+1) != 'x' || *(s+1) != 'X') ) return 0;

        for (n=0,s+=2 ; *s ; s++)
        {
                if ( *s >= '0' && *s <= '9' )
                {
                        n = 16 * n + (*s - '0');
                }
                else if ( *s >= 'a' && *s <= 'f' ) {
                        n = 16 * n + ((*s - 'a') + 10);
                }
                else if ( *s >= 'A' && *s <= 'F' ) {
                        n = 16 * n + ((*s - 'A') + 10);
                }
        }

        return n;
}


void    node_close (void)
{
        usb_reset (udev);
        usb_close (udev);
        node_term();
}

void    node_term (void)
{
//        node_last_frame_sw = FALSE;
//        memset (&node_save_frame_id, 0x00, 2);
        syslog (LOG_INFO,  "Node Adapter close.");
}

int     node_cos_check(void)
{
        if (usb_control_msg(udev, 0xC0, GET_AD_STATUS, 0, 0, &node_status, 1, 100) < 0)
        {
                node_close();      /* node adapter down ? */
                return FALSE;
        }
        if (node_status & COS_OnOff) return TRUE;
        return FALSE;
}

int	node_usb_init(void)
{
	int	ret;
	int	dev_found;

	udev = NULL;
	dev_found = FALSE;
	usb_init();
	usb_find_busses();
	usb_find_devices();

	dev_found = FALSE;
        for (bus = usb_get_busses(); bus && !dev_found; bus = bus->next) {
                for (dev = bus->devices; dev && !dev_found; dev = dev->next) {
                  if ((dev->descriptor.idVendor == node_VenderID) 
			&& (dev->descriptor.idProduct == node_ProductID))
                  {
                        udev = usb_open(dev);
			dev_found = TRUE;
                        break;
                  }
                }
        }

        if (!dev_found)
	{
               	syslog(LOG_ERR,  
			"Please check the USB Cable! or Node Adapter!"); 
		node_term();
                return FALSE;
        }

        if (usb_set_configuration (udev, dev->config->bConfigurationValue) < 0)
	{
		syslog (LOG_ERR,  "Configuratime Error for Node Adapter!");
		node_close();
		return FALSE;
	}

        if (!scan_sw)
        {
                syslog (LOG_INFO, "Node Adapter VenderID:0x%4.4x ProductID:0x%4.4x",
                        node_VenderID, node_ProductID);
        }

	usb_control_msg(udev, 0x40, SET_TX_INVERT, node_tx_inv, 0, NULL, 0, 100);
	usb_control_msg(udev, 0x40, SET_RX_INVERT, node_rx_inv, 0, NULL, 0, 100);
	usb_control_msg(udev, 0x40, SET_DelayTime, node_tx_delay/10, 0, NULL, 0, 100);
	return TRUE;

}

void	node(void)
{
	if (node_cos_check()) gettimeofday(&NodeCosOffTime, NULL);
        if (node_status & (HeaderDecodeDone | COS_OnOff))
        {
        	if (HeaderLength == 0)
                {
                	header_read_from_node ();
                }
                else voice_read_from_node();
	}
        else    /* last frame check */
        {
        	if (HeaderLength)
                {
                	if (voice_read_from_node() == 0)
                        {
                        	//if (last_frame_sw) node_last_frame_send();
                                HeaderLength = 0;
                                voice_pnt = 0;
              		}
            	}
	}
}

char	node_header_save[58];

extern	char	lastframe[];
extern	char	resync[];

void	header_read_from_node(void)         /* read from rig (DV packet) */
{
	int	ret;
	unsigned short int	crc;

        /***  from RIG  ***/
	memset (usb.buffer, 0x20, 41);
	HeaderLength = 0;
        ret = usb_control_msg(udev, 0xC0, GET_HEADER, 0, 0, 
		usb.buffer, 32, 200);
        if (ret > 0)
        {
		if (usb_control_msg(udev, 0xC0, GET_HEADER, 
			0, 0, &usb.buffer[32], 9, 200) < 0)
		{
			return;
		}
		if (node_status & CRC_ERROR)
		{
			syslog (LOG_INFO,  "CRC ERROR of RF header");
			return;
		}
		if (usb.node_hdr.YourCall[0] == 0x20) return;
		memcpy (connect_call, usb.node_hdr.YourCall, 8);
		HeaderLength = 41;
	}
}

int	voice_read_from_node()
{
	int	i;
	int	ret;

	int	read_len;

	read_len = 24 - voice_pnt;

	ret = usb_control_msg(udev, 0xC0, GET_DATA, 0, 0, usb.buffer, read_len, 200);
	if (ret > 0)
	{
		for (i = 0 ; i < ret; i++)
		{
			node_voice_save[voice_pnt] = usb.buffer[i];
			voice_pnt++;
			if (voice_pnt == 24)
			{
				voice_pnt = 12;
				memcpy (node_voice_save, &node_voice_save[12], 12);
			}
			else if (voice_pnt == 15)
			{
				if (!memcmp (&node_voice_save[9], lastframe, 6))
				{				
					memset (inet_frame_id, 0x00, 2);
					frameID = 0;
					HeaderLength = 0;
				}
			}
	
		}
		return ret;
	}
	else if (ret < 0)
	{
		node_close ();
	}
	return 0;
}

void	node_header_send (unsigned char header[])
{
	unsigned char	len;
	unsigned short int	tmp;
	ssize_t	wrt_len;
	unsigned char   call_temp[8];
	while (!node_space_check (95)) usleep (2000);
	/* Callsign set */
	usb_control_msg(udev, 0x40, SET_MyCALL, 0, 0, &header[27], 8, 100);
	usb_control_msg(udev, 0x40, SET_MyCALL2, 0, 0, &header[35] , 4, 100);
	usb_control_msg(udev, 0x40, SET_YourCALL, 0, 0, &header[19], 8, 100);
	usb_control_msg(udev, 0x40, SET_RPT1CALL, 0, 0, &header[3], 8, 100);
	usb_control_msg(udev, 0x40, SET_RPT2CALL, 0, 0, &header[11], 8, 100);
	header[0] = 0x00;
	header[1] = 0x00;
	header[2] = 0x00;
	usb_control_msg(udev, 0x40, SET_FLAGS, 0, 0, header, 3, 100);
	usb_control_msg(udev, 0x40, SET_PTT, ON, 0, NULL, 0, 100);
}

void	node_voice_send (unsigned char voice[])
{
	int	ret;
	unsigned char	len;
	while (!node_space_check (12)) usleep (2000);
	ret = usb_control_msg(udev, 0x40, PUT_DATA, 0, 0, voice, 12, 100);
	while (ret < 0)
	{
		usleep (1000);
		ret = usb_control_msg(udev, 0x40, PUT_DATA, 0, 0, voice, 12, 100);
	}
}

void	node_last_send (unsigned char voice[])
{
	int	ret;
	unsigned char	len;

	while (!node_space_check (27)) usleep (2000);
       	ret = usb_control_msg(udev, 0x40, PUT_DATA, 0, 0, voice, 12, 100);
       	while (ret < 0)
       	{
               	usleep (1000);
               	ret = usb_control_msg(udev, 0x40, PUT_DATA, 0, 0, voice, 15, 100);
       	}
	/* PTT OFF */
	ret = usb_control_msg(udev, 0x40, SET_PTT, OFF, 0, NULL, 0, 100);
	frameID = 0;
	HeaderLength = 0;
}

void	node_write (unsigned char str[], int length)
{
	if (length == 42)
	{
		node_header_send (&str[2]);
	}
	else if (length == 17)
	{
		if (str[3] & 0x40) node_last_send (&str[4]);
		else node_voice_send (&str[4]);
	}
}


int     node_space_check (int length)
{
        unsigned  char  len;

        usb_control_msg(udev, 0xc0, GET_REMAINSPACE, 0, 0, (char *)&len , 1, 100);
        if (len < length) return FALSE;
        return TRUE;
}

