#include "repeater_mon.h"

#define	LAST_MODIFIED_FILE	"/var/tmp/last_modified.txt"

FILE	*last_mod_fd;
FILE	*conn_fd;
FILE	*connect_fd;
int	col;
int	active_col;
int	json_length;
int	json_cnt;
char	ConnectCall[10];

int     ja_check (unsigned char callsign[])
{
        /* JA-JS,7J-7N,8J-8N */
        if (callsign[7] == 'S') return FALSE;
        if ((callsign[7] == ' ') || ((callsign[7] >= 'A') && (callsign[7] <= 'Z')))
        {
                if (memcmp (callsign, "JA", 2) >= 0  && memcmp (callsign, "JS", 2) <= 0) return TRUE;
                if (memcmp (callsign, "7J", 2) >= 0  && memcmp (callsign, "7N", 2) <= 0) return TRUE;
                if (memcmp (callsign, "8J", 2) >= 0  && memcmp (callsign, "8N", 2) <= 0) return TRUE;
        }
	return FALSE;
}

void	prase (char str[])
{
	int	k;
	int	n, m;
	int	len;
	int	l;
	char	callsign[8];
	char	ip_addr[20];
	int	port;
	char	rep_temp[128];
	char	rpt1_call[8];
	char	rpt2_call[8];
	char	zr_call[8];

	len = strlen (str);
	memset (rpt1_call, 0x20, 8);
	memset (rpt2_call, 0x20, 8);
	memset (zr_call, 0x20, 8);
	for (k = 0 ; k < len ; k++)
	{
		if (!memcmp (&str[k], "callsign", 8))
		{
			memcpy (callsign, &str[k+11], 8);
		}
		else if (!memcmp (&str[k], "ip_address", 10))
		{
			m = 0;
			for (n = k + 13; n < len ; n++)
			{
				if (str[n] == '"')
				{
					ip_addr[m] = 0x00;
					break;
				}
				ip_addr[m++] = str[n];
			}
		}
		else if (!memcmp (&str[k], "port", 4))
		{
			port = atoi (&str[k+6]);
		}
                else if (!memcmp (&str[k], "rpt1_call", 9))
                {
                        m = 0;
                        for (n = k + 12 ; n < len ; n++)
                        {
                                if (str[n] == '"') break;
                                rpt1_call[m++] = str[n];
				if (m > 7) break;
                        }
                }
                else if (!memcmp (&str[k], "rpt2_call", 9))
                {
                        m = 0;
                        for (n = k + 12 ; n < len ; n++)
                        {
                                if (str[n] == '"') break;
                                rpt2_call[m++] = str[n];
				if (m > 7) break;
                        }
		}
		else if (!memcmp (&str[k], "zr_call", 7))
		{
			m = 0;
			for (n = k + 10 ; n < len ; n++)
			{
				if (str[n] == '"') break;
				zr_call[m++] = str[n];
				if (m > 7) break;
			}
		}
	}
	if (callsign[7] == 0x20) callsign[7] = 'A';
	fprintf (conn_fd, "%8.8sdmonitor '%8.8s' %s %d '%8.8s' '%8.8s'\n", callsign, ConnectCall, ip_addr, port, callsign, zr_call);
}

void main(int argc, char** argv)
{
    	int sd;
    	struct sockaddr_in addr;
	char	buff[8192];
	int	len;
	int	length;
	int	k, n;
	int	buff_pnt;
	char	temp[256];
	int	next;
	struct  hostent *host;
	int	ret;
	int	p_cnt;
	char	last_mod[32];
	
	json_length = 0;
	json_cnt = 0;

	memset (last_mod, 0x20, 32);
	last_mod_fd = fopen (LAST_MODIFIED_FILE, "r");
	if (last_mod_fd)
	{
		fgets (last_mod, 32, last_mod_fd);
		fclose (last_mod_fd);
	}
	
    	if((sd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
        	perror("socket");
        	return;
    	}
 
    	addr.sin_family = AF_INET;
    	addr.sin_port = htons(JSON_PORT);
    	addr.sin_addr.s_addr = inet_addr(HOLE_PUNCHD_SERVER);
        if (addr.sin_addr.s_addr == 0xffffffff)
        {
                host = gethostbyname(HOLE_PUNCHD_SERVER);
                if (host == NULL) return;
                addr.sin_addr.s_addr = *(unsigned int *)host->h_addr_list[0];
        }

	connect_fd = fopen (DMONITOR_FILE, "r");
	fgets (ConnectCall, 10, connect_fd);	// skip 2 lines
	fgets (ConnectCall, 10, connect_fd);
	fgets (ConnectCall, 10, connect_fd);
	fclose (connect_fd);

	if (!ja_check (ConnectCall)) 
	{
		perror ("Connect Call wrong");
		return;
	}

	ret = -1;
	n = 0;
	while (ret == -1)
	{
    		ret = connect(sd, (struct sockaddr *)&addr, sizeof(struct sockaddr_in));
		if (ret == -1)
		{
			if (errno == ECONNREFUSED)
			{
				n++;
				if (n >= 5)
				{
					return;
				}
			}
		}
		sleep (1);
	}

	if (last_mod[0] == 0x20)
	{ 
    		if(send(sd, "GET /repeater.json HTTP/1.1\r\nHost: hole-punchd.d-star.info:30011\r\nAccept-Language: ja-JP\r\nUser-Agent: dmonitor/" VERSION "\r\n\r\n", 120, 0) < 0) {
        		perror("send");
        		return;
		}
	}
	else
	{
		sprintf (temp, "GET /repeater.json HTTP/1.1\r\nHost: hole-punchd.d-star.info:30011\r\nAccept-Language: ja-JP\r\nUser-Agent: dmonitor/%5.5s\r\nIf-Modified-Since: %29.29s\r\n\r\n", VERSION, last_mod);
		if (send(sd, temp, 170, 0) < 0)
		{
			perror("send");
			return;
		}
    	}
	buff_pnt = 0;
	col = 0;
	active_col = 0;
	conn_fd = fopen (CONN_TEMP, "w");

	p_cnt = 0;
	buff_pnt = 0;
	length = 0;
	n = 0;
	while (1)
	{
		len = recv (sd, &buff[buff_pnt], sizeof(buff)-buff_pnt-1, 0);
		if (len <= 0) break;
		length =len + buff_pnt;
		buff[length] = 0x00;
		next = 0;
		for (k = 0 ; k < length ; k++)
		{
			if (json_length == 0)
			{
				if (!memcmp (&buff[k], "403 Forbidden", 13))
				{
					close (sd);
					goto end;
				}
				else if (!memcmp (&buff[k], "Content-Length:", 15))
				{
					json_length = atoi(&buff[k+16]);
					//fprintf (html_fd, "length %d\n", json_length);
				}
				else if (!memcmp (&buff[k], "Last-Modified", 13))
				{
					memcpy (last_mod, &buff[k+15], 29);
					//fprintf (html_fd, "%29.29s\n", &buff[k+15]);
					last_mod_fd = fopen (LAST_MODIFIED_FILE, "w");
					fprintf (last_mod_fd, "%29.29s", last_mod);
					fclose (last_mod_fd);
				}
				else if (!memcmp (&buff[k], "304 Not Modified", 16))
				{
					close (sd);
					fclose (conn_fd);
					unlink (CONN_TEMP);
					return;
				}
					
			}
			else
			{	
				if (buff[k] == '{') p_cnt++;
				if (p_cnt) json_cnt++;
				if ((buff[k] != 0x0a) && (buff[k] != 0x0d))
				{
					if (p_cnt == 2) temp[n++] = buff[k];
					next =  k + 1;
				}
				if (buff[k] == '}')
				{
					if (p_cnt == 2)
					{
						temp[n] = 0x00;
						prase (temp);
						n = 0;
					}
					p_cnt--;
					if (p_cnt == 0) goto next;
				}
			}
		}
		if (buff[k-4] == ']') break;
		if (length - next) memmove (buff, &buff[next], length - next + 1);
		buff_pnt = length - next;
		if (buff_pnt < 0) buff_pnt = 0;
	}
next:
	close (sd);
	if (json_length != (json_cnt+1))
	{
		fclose (conn_fd);
		unlink (CONN_TEMP);
		return;
	}

end:

	memset (temp, 0x00, sizeof(temp));
	sprintf (temp, "/var/www/cgi-bin/file_check %s %s", CONN_TEMP, CONN_TXT);
	ret = system (temp);
}

