#include	"dmonitor.h"

void	dv_pkt_set(struct dv_packet hdr);
void	putFifo (int len, struct dv_packet pkt);
void	node_close(void);
void	inet_led_onoff (void);
int	inet_send_buff_set (void);
void	short_msg_wrt (void);
void    dstar_data (unsigned char string[], int inet);
void    dstar_alt_header (unsigned char string[], int inet);
unsigned short int	crc_calc (char str[], int length);
int	cmd_check (unsigned char cmd[]);
int	rig_status_check(void);


char	node_header_save[58];

extern	char	lastframe[];
extern	char	resync[];

void	header_read_from_node(void)         /* read from rig (DV packet) */
{
	int	ret;
	unsigned short int	crc;

        /***  from RIG  ***/

	memset (usb.buffer, 0x20, 41);
	HeaderLength = 0;
        ret = usb_control_msg(udev, 0xC0, GET_HEADER, 0, 0, 
		usb.buffer, 32, 200);
        if (ret > 0)
        {
		//gettimeofday(&Node_InTime, NULL);
		if (usb_control_msg(udev, 0xC0, GET_HEADER, 
			0, 0, &usb.buffer[32], 9, 200) < 0)
		{
			
			return;
		}
		if (node_status & CRC_ERROR)
		{
			syslog (LOG_INFO,  "CRC ERROR of RF header");
			return;
		}

		if (usb.node_hdr.YourCall[0] == 0x20) return;
		if (!scan_sw) syslog (LOG_NOTICE, "%8.8s from Rig", usb.node_hdr.MyCall);
		else 
		{
			fprintf (status_fd, "%8.8s from Rig\n", usb.node_hdr.MyCall);
		}
		if (!cmd_check (usb.node_hdr.YourCall)) return;
		if (!rig_status_check()) return;
        	gw_on = FALSE;
        	if (!inet_send_buff_set()) return;
        	inet_send_buff[16] = 0x80;
        	memcpy (&inet_send_buff[17], usb.buffer, 41);
        	memcpy (&inet_send_buff[20], area_call, 8);
        	memcpy (&inet_send_buff[28], area_call, 8);
        	if (memcmp (&inet_send_buff[36], "CQCQCQ  ", 8)) gw_on = TRUE;
        	if (send_sw && !rig_send_sw && !node_voice_send_sw)
        	{
        		memset (inet_frame_id, 0xff, 2);
			node_last_frame_sw = FALSE;
			node_voice_send_sw = TRUE;
                	in_addr.sin_port = htons(dest_inet_port);
                	in_addr.sin_addr.s_addr = inet_addr(dest_address);
                	m_seq++;
                	m_seq &= 0xffff;
                	inet_send_buff[4] = (m_seq >> 8) & 0xff;
                	inet_send_buff[5] = m_seq & 0xff;
                	inet_send_buff[7] |= FWD | ZR;
			crc = crc_calc (&inet_send_buff[17], 39);
			inet_send_buff[56] = (crc >> 8) & 0xff;
			inet_send_buff[57] = crc & 0xff;
                	ret = sendto (in_addr_sock, inet_send_buff, 58, MSG_DONTWAIT,
                		(struct sockaddr *)&in_addr, sizeof(in_addr));
               		m_seq++;
               		m_seq &= 0xffff;
               		inet_send_buff[4] = (m_seq >> 8) & 0xff;
               		inet_send_buff[5] = m_seq & 0xff;
               		sendto (in_addr_sock, inet_send_buff, 58, MSG_DONTWAIT,
               			(struct sockaddr *)&in_addr, sizeof(in_addr));
			memset (short_msg, 0x20, 20);
			memcpy (used_call, &inet_send_buff[44], 8);
			memcpy (used_call2, &inet_send_buff[52], 4);
			short_msg_wrt ();
                	if (gw_on)
                	{
                		memcpy (&inet_send_buff[20], zone_call, 8);
                        	inet_send_buff[27] = 'G';
                        	inet_send_buff[7]  &= 0x33;
                        	inet_send_buff[7] |= GW;
                        	m_seq++;
                        	m_seq &= 0xffff;
                        	inet_send_buff[4] = (m_seq >> 8) & 0xff;
                        	inet_send_buff[5] = m_seq & 0xff;
				crc = crc_calc (&inet_send_buff[17], 39);
                        	inet_send_buff[56] = (crc >> 8) & 0xff;
                        	inet_send_buff[57] = crc & 0xff;
                        	sendto (in_addr_sock, inet_send_buff, 58, MSG_DONTWAIT,
                        		(struct sockaddr *)&in_addr, sizeof(in_addr));
                        	m_seq++;
                        	m_seq &= 0xffff;
                        	inet_send_buff[4] = (m_seq >> 8) & 0xff;
                        	inet_send_buff[5] = m_seq & 0xff;
                        	sendto (in_addr_sock, inet_send_buff, 58, MSG_DONTWAIT,
                        		(struct sockaddr *)&in_addr, sizeof(in_addr));
                        	if ((m_seq % 5) == 0) inet_led_onoff();
			}
		}
		m_seq++;
		m_seq &= 0xffff;
		HeaderLength = 41;
		send_header_sw = TRUE;
		voice_pnt = 12;
		seq = 0;
	}
}

void	header_send_set_from_node(void)
{
	unsigned short int	tmp;

	dv_pkt_set(node_pkt);
	node_pkt.dstar.b_bone.b_b.id = 0x20;	/* voice */
	//node_pkt.pkt_type = 0x10;
	tmp = rand() & 0xffff;
	memcpy (node_pkt.dstar.b_bone.b_b.frame_id, &tmp, 2);
	node_pkt.dstar.b_bone.b_b.seq = 0x80;
	//node_msg.msg_pnt = 0;
	seq = 0;
	//node_last_frame_sw = TRUE;
}

int	voice_read_from_node()
{
	int	i;
	int	ret;

	int	read_len;

	read_len = 24 - voice_pnt;

	ret = usb_control_msg(udev, 0xC0, GET_DATA, 0, 0, usb.buffer, read_len, 200);
	if (ret > 0)
	{
		for (i = 0 ; i < ret; i++)
		{
			node_voice_save[voice_pnt] = usb.buffer[i];
			voice_pnt++;
			if (voice_pnt == 24)
			{
				voice_pnt = 12;
				memcpy (&inet_send_buff[17], &node_voice_save[12], 12);
				memcpy (node_voice_save, &node_voice_save[12], 12);
 				inet_send_buff[9] = 0x13;
        			inet_send_buff[4] = (m_seq >> 8) & 0xff;
        			inet_send_buff[5] = m_seq & 0xff;
        			inet_send_buff[7] &= 0x33;
        			inet_send_buff[7] |= FWD | ZR;
        			if (gw_on)
        			{
        				inet_send_buff[7] |= GW;
                			if ((m_seq % 5) == 0) inet_led_onoff();
        			}
				if (!memcmp (&node_voice_save[9], resync, 3)) seq = 0;
				inet_send_buff[16] = seq;
				seq++;
				if (seq > 20) seq = 0;
        			memcpy (&inet_send_buff[17], node_voice_save, 12);
				if (send_sw && !rig_send_sw && send_header_sw)
        			{
        				in_addr.sin_port = htons(dest_inet_port);
                			in_addr.sin_addr.s_addr = inet_addr(dest_address);
                			sendto (in_addr_sock, inet_send_buff, 29, MSG_DONTWAIT,
                				(struct sockaddr *)&in_addr, sizeof(in_addr));
					dstar_data (inet_send_buff, FALSE);
				}
				else
					dstar_alt_header (inet_send_buff, FALSE);

        			m_seq++;
				m_seq &= 0xffff;
			}
			else if (voice_pnt == 15)
			{
				if (!memcmp (&node_voice_save[9], lastframe, 6))
				{				
					inet_send_buff[4] = (m_seq >> 8) & 0xff;
					inet_send_buff[5] = m_seq & 0xff;
					inet_send_buff[16] = seq | 0x40;
					memcpy (&inet_send_buff[17], &node_voice_save[12], 12);
					if (send_sw && !rig_send_sw && node_voice_send_sw)
                                	{
                                        	in_addr.sin_port = htons(dest_inet_port);
                                        	in_addr.sin_addr.s_addr = inet_addr(dest_address);
                                        	sendto (in_addr_sock, inet_send_buff, 29, MSG_DONTWAIT,
                                                	(struct sockaddr *)&in_addr, sizeof(in_addr));
                                	}	
					memset (inet_frame_id, 0x00, 2);
					frameID = 0;
					HeaderLength = 0;
					send_header_sw = FALSE;
					node_voice_send_sw = FALSE;
					digitalWrite (RIG_LED, 0);
					digitalWrite (INET_LED, 0);
				}
			}
	
		}
		return ret;
	}
	else if (ret < 0)
	{
		node_close ();
	}
	return 0;
}

