#include	"rpt_conn.h"
#include	"dvap.h"
#include	"dvmega.h"

void	rig_close(void);
void	send_rig_init (void);
int	rig_open (void);
void	icom_reinit (void);
void    rig_write (int length, unsigned char buff[]);
int	dvap_open (void);
void	dvap_init(void);
void	dvap (void);
int	rig_read (void);
void    dvap_write (int fd, unsigned char buff[], int length);
int	read_dvmega(void);
void	send_dvmega_status(void);
void    dvmega_write (int fd, unsigned char buff[], int length);
void 	node_write (unsigned char buff[], int length);
void	dvmega (void);
void	node (void);

time_t	rig_alive_send_time;
int	rig_error_cnt;

char	init_pkt[] = {0xff, 0xff, 0xff};
char	alive[] = {0x02, 0x02, 0xff};

void    rig_buff_reset (int length)
{
        rig_buff_pnt -= length;
        memmove (rig_buff, &rig_buff[length], rig_buff_pnt);
}

int	rig_init_recv (void)
{
	int length;
	int	i;
	int	k;

	if (FD_ISSET (rig_fd, &read_set))
	{
		length = read (rig_fd, &rig_buff[rig_buff_pnt], 
			sizeof(rig_buff) - rig_buff_pnt);
		if (length == -1)
		{
			syslog(LOG_ERR, "rig read error %s", strerror(errno));
		} 
		if (length > 0)
		{
			rig_buff_pnt += length;
		}
		if (rig_buff_pnt >= 3)
		{
			for (i = 0 ; i < rig_buff_pnt - 2 ; i++)
			{
				if ((rig_buff[i] == 0xff)
					&& (rig_buff[i+1] == 0xff)
					&& (rig_buff[i+2] == 0xff))
				{
					k = rig_buff_pnt - i - 3;
					if (k > 0) 
					{
						memmove (&rig_buff[0], &rig_buff[i+3], k);
						rig_buff_pnt = k;
					}
					else
						rig_buff_pnt = 0;
					time (&rig_alive_recv);
					return TRUE;
				}
			}
                	memmove (&rig_buff[0], &rig_buff[rig_buff_pnt - 2], 2);
                	rig_buff_pnt  = 2;
			
		}
		if (length < 0)
		{
			if (errno == EAGAIN) return TRUE;
		}
	}
	return FALSE;
}

enum
{
	RIG_CHECK = 0,
	RIG_OPEN,
	ICOM_INIT,
	ICOM_INIT_DONE,
	DVAP_INIT,
	DVAP_INIT_DONE,
	DVMEGA_INIT,
	DVMEGA_INIT_DONE,
	NODE_INIT,
	NODE_INIT_DONE,
	RIG_READ
} rig_state = RIG_CHECK;

void	rig_reset (void)
{
	rig_state = RIG_CHECK;
}

int     dvmega_init (void)
{
        /* get Version */
        unsigned char   dvmega_get_version[3] = {0xe0, 0x03, 0x00};
        time (&rig_init_time);
        return write (rig_fd, dvmega_get_version, 3);
}

int     dvmega_init_recv (void)
{
        int length;

        length = read_dvmega();
        if (length == 0) return FALSE;
        if (rig_buff[2] != DVMEGA_GET_VERSION) return FALSE;
        syslog (LOG_DEBUG, "%6.6s", &rig_buff[4]);
        rig_buff_reset (length);
        send_dvmega_status();
        return TRUE;
}

void	rig(void)
{
	time_t	cur_time;
	char	dummy[42];
	int	length;
	int	n;
	struct	stat	st;

	switch (rig_state)
	{
		case RIG_CHECK:
			rig_state = RIG_OPEN;
			break;

		case RIG_OPEN:
			if (!rig_open()) sig_term = TRUE;
			else
			{
				if (rig_type == ICOM) rig_state = ICOM_INIT;
				else if (rig_type == DVAP) rig_state = DVAP_INIT;
				else if (rig_type == DVMEGA) rig_state = DVMEGA_INIT;
				else if (rig_type == NODE) rig_state = NODE_INIT;
			}
			break;

		case ICOM_INIT:
			send_rig_init();
			rig_state = ICOM_INIT_DONE;
			time (&rig_init_time);
			break;
	
		case ICOM_INIT_DONE:
			if (rig_init_recv())
			{
				rig_state = RIG_READ;
				syslog (LOG_INFO, "RIG(ID-xxPlus) init/re-init done");
			}
			else
			{
				time (&cur_time);
				if ((cur_time - rig_init_time) >= 2)
				{
        				syslog (LOG_INFO, "RIG(ID-xxPlus) no resp.");
					rig_close();
					sig_term = TRUE;
				}
			}
			break;

		case DVAP_INIT:
			dvap_init();
			dvap_check_wait = FALSE;
			rig_state = DVAP_INIT_DONE;
                        length = 1;
			break;
		
		case DVAP_INIT_DONE:
	                if (dvap_check_wait)
			{
				rig_state = RIG_READ;
			}
			else
			{
				time(&cur_time);
				if ((cur_time - rig_init_time) >= 2)
				{
					rig_state = DVAP_INIT;
				}
				if (rig_error_cnt > 3)
				{
					sig_term = TRUE;
				}
			}
			break;

                case DVMEGA_INIT:
                        if (dvmega_init() == 3)
			{
                        	rig_state = DVMEGA_INIT_DONE;
			}
			else
			{
				syslog (LOG_ERR, "RIG(DVMEGA) init error");
				sig_term = TRUE;
			}
                        break;

                case DVMEGA_INIT_DONE:
                        if (dvmega_init_recv())
                        {
                                rig_state = RIG_READ;
                                syslog (LOG_INFO, "RIG(DVMEGA) init/re-init done");
                        }
                        else
                        {
                                time (&cur_time);
                                if ((cur_time - rig_init_time) >= 2)
                                {
                                        syslog (LOG_INFO, "DVMEGA no resp.");
                                        rig_close();
                                        sig_term = TRUE;
                                }
                        }
                        break;

		case NODE_INIT:
			rig_state = NODE_INIT_DONE;
			break;

		case NODE_INIT_DONE:
			rig_state = RIG_READ;
			break;

		case RIG_READ:
			if (rig_type == ICOM)
			{
				if (!rig_read())
				{
					rig_state = RIG_OPEN;
				}
				time (&cur_time);
               		 	if ((cur_time - rig_alive_send_time) >= 1)
                		{
					rig_write (3, alive);
                       			rig_alive_send_time = cur_time;
               			}
                		if ((cur_time - rig_alive_recv) >= 3)
                		{
                        		icom_reinit();
                		}
			}
			else if (rig_type == DVMEGA) dvmega();
			else if (rig_type == DVAP) dvap();
			else if (rig_type == NODE) node();
			break;
	}
}

void	icom_reinit(void)
{
	syslog (LOG_INFO, "rig not terminal/access mode");
	rig_state = ICOM_INIT;
	rig_buff_pnt = 0;
}

int	rig_read (void)
{
	int	length;
	int	len;
	int	k;
	int	ret;
	struct	timeval	cu_time;
	struct	timeval	t_time;
	struct	timeval	ack_timeout;

	if (FD_ISSET (rig_fd, &read_set))
	{
		length = read (rig_fd, &rig_buff[rig_buff_pnt], 
				sizeof(rig_buff) - rig_buff_pnt);
		if (length < 0)
		{
			syslog (LOG_ERR, "Rig read error %s", strerror(errno));
			if (errno == EAGAIN) return TRUE;
			rig_close();
			return FALSE;
		}
		//time (&rig_alive_send_time);
		rig_buff_pnt += length;
		time (&rig_alive_recv);
	}
	while (rig_buff_pnt)
	{
		if (rig_buff[0] != 0xff)
		{
			len = rig_buff[0];
			if (len > rig_buff_pnt) break;

			if (len == 3)
			{
				k = rig_buff_pnt - len;
				if (k > 0) memmove(&rig_buff[0], &rig_buff[len], k);
				rig_buff_pnt = k;
				break;
			}
			else if (len == 4)
			{
				if (rig_buff[1] == 0x23)
				{
					if (rig_buff[2] == seq)
					{
                                		k = rig_buff_pnt - len;
                                		if (k > 0) memmove(&rig_buff[0], &rig_buff[len], k);
                                		rig_buff_pnt = k;
                                		break;
					}
					else
					{
						//seq = rig_buff[2] + 1;
						//seq &= 0xff;
					}
				}
			}
			else if (len == 44)	/* header */
			{
				memcpy (connect_call, &rig_buff[21], 8);
			}
		}
		else
			len = 1;
		k = rig_buff_pnt - len;
		if (k > 0) memmove (&rig_buff[0], &rig_buff[len], k);
		rig_buff_pnt = k;
	}
	return TRUE;
}

void	rig_write (int length, unsigned char buff[])
{
	int ret;
	unsigned char	temp[8];

	if ((length == 42) && (buff[12] =='G'))
	{
		memcpy (temp, &buff[5], 8);
		memcpy (&buff[5], &buff[13], 8);
		memcpy (&buff[13], temp, 8);
	}
	if (rig_type == ICOM)
	{
		if (length == 42) syslog (LOG_DEBUG, "rpt2:%8.8s rpt1:%8.8s ur:%8.8s my:%8.8s my2:%4.4s", &buff[5], &buff[13],&buff[21], &buff[29], &buff[37]);
		ret = write (rig_fd, buff, length);
		if (ret == -1) syslog(LOG_ERR, "rig write error %s", strerror(errno));
		time (&rig_alive_send_time);
	}
        else if (rig_type == DVAP)
        {
                dvap_write (rig_fd, buff, length);
        }
	else if (rig_type == DVMEGA)
	{
		dvmega_write (rig_fd, buff, length);
	}
	else if (rig_type == NODE) node_write (buff, length);
}

void	send_rig_init (void)
{
	int	len;

	rig_write (3, init_pkt);
	time (&rig_init_time);
}

int     rig_status_check (void)
{
        if (rig_state == RIG_READ) return TRUE;
        return FALSE;
}

